"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ifw = require(".");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const database = new aws_cdk_lib_1.aws_timestream.CfnDatabase(stack, 'Database', {
            databaseName: 'FleetWise',
        });
        const table = new aws_cdk_lib_1.aws_timestream.CfnTable(stack, 'Table', {
            databaseName: 'FleetWise',
            tableName: 'FleetWise',
        });
        table.node.addDependency(database);
        const role = new aws_cdk_lib_1.aws_iam.Role(stack, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('iotfleetwise.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess'),
            ],
        });
        const signalCatalog = new ifw.SignalCatalog(stack, 'SignalCatalog', {
            database,
            table,
            role,
            description: 'my signal catalog',
            nodes: [
                new ifw.SignalCatalogBranch('Vehicle', 'Vehicle'),
                new ifw.SignalCatalogSensor('EngineTorque', 'Vehicle.EngineTorque', 'DOUBLE'),
            ],
        });
        const model_a = new ifw.VehicleModel(stack, 'ModelA', {
            signalCatalog,
            name: 'modelA',
            description: 'Model A vehicle',
            networkInterfaces: [new ifw.CanVehicleInterface('1', 'vcan0')],
            signals: [
                new ifw.CanVehicleSignal('EngineTorque', 'Vehicle.EngineTorque', '1', 401, // messageId
                1.0, // factor
                true, // isBigEndian
                false, // isSigned
                8, // length
                0.0, // offset
                9),
            ],
        });
        const vin100 = new ifw.Vehicle(stack, 'vin100', {
            vehicleId: 'vin100',
            vehicleModel: model_a,
            createIotThing: true,
        });
        new cdk.CfnOutput(stack, 'certificateId', { value: vin100.certificateId });
        new ifw.Campaign(stack, 'Campaign1', {
            name: 'FwTimeBasedCampaign1',
            target: vin100,
            collectionScheme: new ifw.TimeBasedCollectionScheme(cdk.Duration.seconds(10)),
            signals: [
                new ifw.CampaignSignal('Vehicle.EngineTorque'),
            ],
            autoApprove: true,
        });
        new ifw.Fleet(stack, 'Fleet2', {
            fleetId: 'fleet2',
            signalCatalog,
            vehicles: [vin100],
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
process.env.GITLAB_REGISTRATION_TOKEN = 'mock';
process.env.CDK_INTEG_REGION = 'eu-central-1';
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLG1DQUFtQztBQUNuQyw2Q0FHcUI7QUFDckIseUJBQXlCO0FBR3pCLE1BQWEsWUFBWTtJQUV2QjtRQUNFLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBRTFCLE1BQU0sR0FBRyxHQUFHO1lBQ1YsTUFBTSxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsZ0JBQWdCLElBQUksT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0IsSUFBSSxXQUFXO1lBQ3JGLE9BQU8sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO1NBQzFFLENBQUM7UUFFRixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLGFBQWEsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7UUFFekQsTUFBTSxRQUFRLEdBQUcsSUFBSSw0QkFBRSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFO1lBQ3JELFlBQVksRUFBRSxXQUFXO1NBQzFCLENBQUMsQ0FBQztRQUVILE1BQU0sS0FBSyxHQUFHLElBQUksNEJBQUUsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRTtZQUM1QyxZQUFZLEVBQUUsV0FBVztZQUN6QixTQUFTLEVBQUUsV0FBVztTQUN2QixDQUFDLENBQUM7UUFFSCxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUVuQyxNQUFNLElBQUksR0FBRyxJQUFJLHFCQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUU7WUFDdkMsU0FBUyxFQUFFLElBQUkscUJBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyw0QkFBNEIsQ0FBQztZQUNqRSxlQUFlLEVBQUU7Z0JBQ2YscUJBQUcsQ0FBQyxhQUFhLENBQUMsd0JBQXdCLENBQUMscUJBQXFCLENBQUM7YUFDbEU7U0FDRixDQUFDLENBQUM7UUFFSCxNQUFNLGFBQWEsR0FBRyxJQUFJLEdBQUcsQ0FBQyxhQUFhLENBQUMsS0FBSyxFQUFFLGVBQWUsRUFBRTtZQUNsRSxRQUFRO1lBQ1IsS0FBSztZQUNMLElBQUk7WUFDSixXQUFXLEVBQUUsbUJBQW1CO1lBQ2hDLEtBQUssRUFBRTtnQkFDTCxJQUFJLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxDQUFDO2dCQUNqRCxJQUFJLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjLEVBQUUsc0JBQXNCLEVBQUUsUUFBUSxDQUFDO2FBQzlFO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxPQUFPLEdBQUcsSUFBSSxHQUFHLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7WUFDcEQsYUFBYTtZQUNiLElBQUksRUFBRSxRQUFRO1lBQ2QsV0FBVyxFQUFFLGlCQUFpQjtZQUM5QixpQkFBaUIsRUFBRSxDQUFDLElBQUksR0FBRyxDQUFDLG1CQUFtQixDQUFDLEdBQUcsRUFBRSxPQUFPLENBQUMsQ0FBQztZQUM5RCxPQUFPLEVBQUU7Z0JBQ1AsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsY0FBYyxFQUFFLHNCQUFzQixFQUFFLEdBQUcsRUFDbEUsR0FBRyxFQUFFLFlBQVk7Z0JBQ2pCLEdBQUcsRUFBRSxTQUFTO2dCQUNkLElBQUksRUFBRSxjQUFjO2dCQUNwQixLQUFLLEVBQUUsV0FBVztnQkFDbEIsQ0FBQyxFQUFFLFNBQVM7Z0JBQ1osR0FBRyxFQUFFLFNBQVM7Z0JBQ2QsQ0FBQyxDQUFDO2FBQ0w7U0FDRixDQUFDLENBQUM7UUFFSCxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRTtZQUM5QyxTQUFTLEVBQUUsUUFBUTtZQUNuQixZQUFZLEVBQUUsT0FBTztZQUNyQixjQUFjLEVBQUUsSUFBSTtTQUNyQixDQUFDLENBQUM7UUFDSCxJQUFJLEdBQUcsQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLGVBQWUsRUFBRSxFQUFFLEtBQUssRUFBRSxNQUFNLENBQUMsYUFBYyxFQUFFLENBQUMsQ0FBQztRQUU1RSxJQUFJLEdBQUcsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRTtZQUNuQyxJQUFJLEVBQUUsc0JBQXNCO1lBQzVCLE1BQU0sRUFBRSxNQUFNO1lBQ2QsZ0JBQWdCLEVBQUUsSUFBSSxHQUFHLENBQUMseUJBQXlCLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7WUFDN0UsT0FBTyxFQUFFO2dCQUNQLElBQUksR0FBRyxDQUFDLGNBQWMsQ0FBQyxzQkFBc0IsQ0FBQzthQUMvQztZQUNELFdBQVcsRUFBRSxJQUFJO1NBQ2xCLENBQUMsQ0FBQztRQUVILElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFO1lBQzdCLE9BQU8sRUFBRSxRQUFRO1lBQ2pCLGFBQWE7WUFDYixRQUFRLEVBQUUsQ0FBQyxNQUFNLENBQUM7U0FDbkIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLEtBQUssR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3ZCLENBQUM7Q0FDRjtBQW5GRCxvQ0FtRkM7QUFFRCxPQUFPLENBQUMsR0FBRyxDQUFDLHlCQUF5QixHQUFDLE1BQU0sQ0FBQztBQUM3QyxPQUFPLENBQUMsR0FBRyxDQUFDLGdCQUFnQixHQUFDLGNBQWMsQ0FBQztBQUU1QyxJQUFJLFlBQVksRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7XG4gIGF3c190aW1lc3RyZWFtIGFzIHRzLFxuICBhd3NfaWFtIGFzIGlhbSxcbn0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgaWZ3IGZyb20gJy4nO1xuXG5cbmV4cG9ydCBjbGFzcyBJbnRlZ1Rlc3Rpbmcge1xuICByZWFkb25seSBzdGFjazogY2RrLlN0YWNrW107XG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIGNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbiAgICBjb25zdCBlbnYgPSB7XG4gICAgICByZWdpb246IHByb2Nlc3MuZW52LkNES19JTlRFR19SRUdJT04gfHwgcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfUkVHSU9OIHx8ICd1cy1lYXN0LTEnLFxuICAgICAgYWNjb3VudDogcHJvY2Vzcy5lbnYuQ0RLX0lOVEVHX0FDQ09VTlQgfHwgcHJvY2Vzcy5lbnYuQ0RLX0RFRkFVTFRfQUNDT1VOVCxcbiAgICB9O1xuXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2ludGVnLXN0YWNrJywgeyBlbnYgfSk7XG5cbiAgICBjb25zdCBkYXRhYmFzZSA9IG5ldyB0cy5DZm5EYXRhYmFzZShzdGFjaywgJ0RhdGFiYXNlJywge1xuICAgICAgZGF0YWJhc2VOYW1lOiAnRmxlZXRXaXNlJyxcbiAgICB9KTtcblxuICAgIGNvbnN0IHRhYmxlID0gbmV3IHRzLkNmblRhYmxlKHN0YWNrLCAnVGFibGUnLCB7XG4gICAgICBkYXRhYmFzZU5hbWU6ICdGbGVldFdpc2UnLFxuICAgICAgdGFibGVOYW1lOiAnRmxlZXRXaXNlJyxcbiAgICB9KTtcblxuICAgIHRhYmxlLm5vZGUuYWRkRGVwZW5kZW5jeShkYXRhYmFzZSk7XG5cbiAgICBjb25zdCByb2xlID0gbmV3IGlhbS5Sb2xlKHN0YWNrLCAnUm9sZScsIHtcbiAgICAgIGFzc3VtZWRCeTogbmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdpb3RmbGVldHdpc2UuYW1hem9uYXdzLmNvbScpLFxuICAgICAgbWFuYWdlZFBvbGljaWVzOiBbXG4gICAgICAgIGlhbS5NYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZSgnQWRtaW5pc3RyYXRvckFjY2VzcycpLFxuICAgICAgXSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHNpZ25hbENhdGFsb2cgPSBuZXcgaWZ3LlNpZ25hbENhdGFsb2coc3RhY2ssICdTaWduYWxDYXRhbG9nJywge1xuICAgICAgZGF0YWJhc2UsXG4gICAgICB0YWJsZSxcbiAgICAgIHJvbGUsXG4gICAgICBkZXNjcmlwdGlvbjogJ215IHNpZ25hbCBjYXRhbG9nJyxcbiAgICAgIG5vZGVzOiBbXG4gICAgICAgIG5ldyBpZncuU2lnbmFsQ2F0YWxvZ0JyYW5jaCgnVmVoaWNsZScsICdWZWhpY2xlJyksXG4gICAgICAgIG5ldyBpZncuU2lnbmFsQ2F0YWxvZ1NlbnNvcignRW5naW5lVG9ycXVlJywgJ1ZlaGljbGUuRW5naW5lVG9ycXVlJywgJ0RPVUJMRScpLFxuICAgICAgXSxcbiAgICB9KTtcblxuICAgIGNvbnN0IG1vZGVsX2EgPSBuZXcgaWZ3LlZlaGljbGVNb2RlbChzdGFjaywgJ01vZGVsQScsIHtcbiAgICAgIHNpZ25hbENhdGFsb2csXG4gICAgICBuYW1lOiAnbW9kZWxBJyxcbiAgICAgIGRlc2NyaXB0aW9uOiAnTW9kZWwgQSB2ZWhpY2xlJyxcbiAgICAgIG5ldHdvcmtJbnRlcmZhY2VzOiBbbmV3IGlmdy5DYW5WZWhpY2xlSW50ZXJmYWNlKCcxJywgJ3ZjYW4wJyldLFxuICAgICAgc2lnbmFsczogW1xuICAgICAgICBuZXcgaWZ3LkNhblZlaGljbGVTaWduYWwoJ0VuZ2luZVRvcnF1ZScsICdWZWhpY2xlLkVuZ2luZVRvcnF1ZScsICcxJyxcbiAgICAgICAgICA0MDEsIC8vIG1lc3NhZ2VJZFxuICAgICAgICAgIDEuMCwgLy8gZmFjdG9yXG4gICAgICAgICAgdHJ1ZSwgLy8gaXNCaWdFbmRpYW5cbiAgICAgICAgICBmYWxzZSwgLy8gaXNTaWduZWRcbiAgICAgICAgICA4LCAvLyBsZW5ndGhcbiAgICAgICAgICAwLjAsIC8vIG9mZnNldFxuICAgICAgICAgIDkpLCAvLyBzdGFydEJpdFxuICAgICAgXSxcbiAgICB9KTtcblxuICAgIGNvbnN0IHZpbjEwMCA9IG5ldyBpZncuVmVoaWNsZShzdGFjaywgJ3ZpbjEwMCcsIHtcbiAgICAgIHZlaGljbGVJZDogJ3ZpbjEwMCcsXG4gICAgICB2ZWhpY2xlTW9kZWw6IG1vZGVsX2EsXG4gICAgICBjcmVhdGVJb3RUaGluZzogdHJ1ZSxcbiAgICB9KTtcbiAgICBuZXcgY2RrLkNmbk91dHB1dChzdGFjaywgJ2NlcnRpZmljYXRlSWQnLCB7IHZhbHVlOiB2aW4xMDAuY2VydGlmaWNhdGVJZCEgfSk7XG5cbiAgICBuZXcgaWZ3LkNhbXBhaWduKHN0YWNrLCAnQ2FtcGFpZ24xJywge1xuICAgICAgbmFtZTogJ0Z3VGltZUJhc2VkQ2FtcGFpZ24xJyxcbiAgICAgIHRhcmdldDogdmluMTAwLFxuICAgICAgY29sbGVjdGlvblNjaGVtZTogbmV3IGlmdy5UaW1lQmFzZWRDb2xsZWN0aW9uU2NoZW1lKGNkay5EdXJhdGlvbi5zZWNvbmRzKDEwKSksXG4gICAgICBzaWduYWxzOiBbXG4gICAgICAgIG5ldyBpZncuQ2FtcGFpZ25TaWduYWwoJ1ZlaGljbGUuRW5naW5lVG9ycXVlJyksXG4gICAgICBdLFxuICAgICAgYXV0b0FwcHJvdmU6IHRydWUsXG4gICAgfSk7XG5cbiAgICBuZXcgaWZ3LkZsZWV0KHN0YWNrLCAnRmxlZXQyJywge1xuICAgICAgZmxlZXRJZDogJ2ZsZWV0MicsXG4gICAgICBzaWduYWxDYXRhbG9nLFxuICAgICAgdmVoaWNsZXM6IFt2aW4xMDBdLFxuICAgIH0pO1xuXG4gICAgdGhpcy5zdGFjayA9IFtzdGFja107XG4gIH1cbn1cblxucHJvY2Vzcy5lbnYuR0lUTEFCX1JFR0lTVFJBVElPTl9UT0tFTj0nbW9jayc7XG5wcm9jZXNzLmVudi5DREtfSU5URUdfUkVHSU9OPSdldS1jZW50cmFsLTEnO1xuXG5uZXcgSW50ZWdUZXN0aW5nKCk7Il19