"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const fs = require("fs");
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ifw = require(".");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION || 'us-east-1',
            account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'integ-stack', { env });
        const database = new aws_cdk_lib_1.aws_timestream.CfnDatabase(stack, 'Database', {
            databaseName: 'FleetWise',
        });
        const table = new aws_cdk_lib_1.aws_timestream.CfnTable(stack, 'Table', {
            databaseName: 'FleetWise',
            tableName: 'FleetWise',
        });
        table.node.addDependency(database);
        const role = new aws_cdk_lib_1.aws_iam.Role(stack, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('iotfleetwise.amazonaws.com'),
            managedPolicies: [
                aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AdministratorAccess'),
            ],
        });
        const canDbc = fs.readFileSync(path.join(__dirname, '/../hscan.dbc'), 'utf8');
        const nodes = [new ifw.SignalCatalogBranch('Vehicle', 'Vehicle')];
        canDbc.split('\n').filter(line => /^\s+SG_\s+\w+/.test(line)).map(line => {
            const signal_name = line.split(/\s+/)[2];
            nodes.push(new ifw.SignalCatalogSensor(signal_name, `Vehicle.${signal_name}`, 'DOUBLE'));
        });
        const signalCatalog = new ifw.SignalCatalog(stack, 'SignalCatalog', {
            database,
            table,
            role,
            description: 'my signal catalog',
            nodes,
        });
        const signalsMap = {};
        canDbc.split('\n').filter(line => /^\s+SG_\s+\w+/.test(line)).map(line => {
            const signal_name = line.split(/\s+/)[2];
            signalsMap[signal_name] = `Vehicle.${signal_name}`;
        });
        const model_a = new ifw.VehicleModel(stack, 'ModelA', {
            signalCatalog,
            name: 'modelA',
            description: 'Model A vehicle',
            networkInterfaces: [new ifw.CanVehicleInterface('1', 'vcan0')],
            networkFileDefinitions: [new ifw.CanDefinition('1', signalsMap, [canDbc])],
        });
        const vin100 = new ifw.Vehicle(stack, 'vin100', {
            vehicleId: 'vin100',
            vehicleModel: model_a,
            createIotThing: true,
        });
        new cdk.CfnOutput(stack, 'certificateId', { value: vin100.certificateId });
        new ifw.Fleet(stack, 'fleet1', {
            fleetId: 'fleet1',
            signalCatalog: signalCatalog,
            description: 'my fleet1',
            vehicles: [vin100],
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
process.env.GITLAB_REGISTRATION_TOKEN = 'mock';
process.env.CDK_INTEG_REGION = 'eu-central-1';
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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