# Generated by Django 3.2 on 2021-06-25 12:10

from django.db import migrations


def to_array(codes: dict):
    return {key: [value] for key, value in codes.items()}


def from_array(codes: dict):
    return {key: value[0] for key, value in codes.items() if value and len(value) > 0}


def forwards_func(apps, schema_editor):
    Division = apps.get_model('wcd_geo_db', 'Division')
    db_alias = schema_editor.connection.alias
    codes = Division.objects.values_list('pk', 'codes')
    Division.objects.using(db_alias).bulk_update(
        [
            Division(pk=pk, codes=to_array(codes))
            for pk, codes in codes
        ],
        fields=('codes',),
        batch_size=1000
    )


def reverse_func(apps, schema_editor):
    Division = apps.get_model('wcd_geo_db', 'Division')
    db_alias = schema_editor.connection.alias
    codes = Division.objects.values_list('pk', 'codes')
    Division.objects.using(db_alias).bulk_update(
        [
            Division(pk=pk, codes=from_array(codes))
            for pk, codes in codes
        ],
        fields=('codes',),
        batch_size=1000
    )


class Migration(migrations.Migration):

    dependencies = [
        ('wcd_geo_db', '0010_codes_import_data'),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func),
    ]
