# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._synapse_management_client_enums import *


class AutoPauseProperties(msrest.serialization.Model):
    """Auto-pausing properties of a Big Data pool powered by Apache Spark.

    :param delay_in_minutes: Number of minutes of idle time before the Big Data pool is
     automatically paused.
    :type delay_in_minutes: int
    :param enabled: Whether auto-pausing is enabled for the Big Data pool.
    :type enabled: bool
    """

    _attribute_map = {
        'delay_in_minutes': {'key': 'delayInMinutes', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        delay_in_minutes: Optional[int] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(AutoPauseProperties, self).__init__(**kwargs)
        self.delay_in_minutes = delay_in_minutes
        self.enabled = enabled


class AutoScaleProperties(msrest.serialization.Model):
    """Auto-scaling properties of a Big Data pool powered by Apache Spark.

    :param min_node_count: The minimum number of nodes the Big Data pool can support.
    :type min_node_count: int
    :param enabled: Whether automatic scaling is enabled for the Big Data pool.
    :type enabled: bool
    :param max_node_count: The maximum number of nodes the Big Data pool can support.
    :type max_node_count: int
    """

    _attribute_map = {
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_node_count: Optional[int] = None,
        enabled: Optional[bool] = None,
        max_node_count: Optional[int] = None,
        **kwargs
    ):
        super(AutoScaleProperties, self).__init__(**kwargs)
        self.min_node_count = min_node_count
        self.enabled = enabled
        self.max_node_count = max_node_count


class AvailableRpOperation(msrest.serialization.Model):
    """An operation that is available in this resource provider.

    :param display: Display properties of the operation.
    :type display: ~azure.mgmt.synapse.models.AvailableRpOperationDisplayInfo
    :param is_data_action: Whether this operation is a data action.
    :type is_data_action: str
    :param name: Operation name.
    :type name: str
    :param origin: Operation origin.
    :type origin: str
    :param service_specification: Operation service specification.
    :type service_specification: ~azure.mgmt.synapse.models.OperationMetaServiceSpecification
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'AvailableRpOperationDisplayInfo'},
        'is_data_action': {'key': 'isDataAction', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationMetaServiceSpecification'},
    }

    def __init__(
        self,
        *,
        display: Optional["AvailableRpOperationDisplayInfo"] = None,
        is_data_action: Optional[str] = None,
        name: Optional[str] = None,
        origin: Optional[str] = None,
        service_specification: Optional["OperationMetaServiceSpecification"] = None,
        **kwargs
    ):
        super(AvailableRpOperation, self).__init__(**kwargs)
        self.display = display
        self.is_data_action = is_data_action
        self.name = name
        self.origin = origin
        self.service_specification = service_specification


class AvailableRpOperationDisplayInfo(msrest.serialization.Model):
    """Description of an available operation.

    :param description: Operation description.
    :type description: str
    :param resource: Resource type.
    :type resource: str
    :param provider: Resource provider name.
    :type provider: str
    :param operation: Operation name.
    :type operation: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        resource: Optional[str] = None,
        provider: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        super(AvailableRpOperationDisplayInfo, self).__init__(**kwargs)
        self.description = description
        self.resource = resource
        self.provider = provider
        self.operation = operation


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for an Azure Resource Manager resource with an etag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class BigDataPoolPatchInfo(msrest.serialization.Model):
    """Properties patch for a Big Data pool.

    :param tags: A set of tags. Updated tags for the Big Data pool.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(BigDataPoolPatchInfo, self).__init__(**kwargs)
        self.tags = tags


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class BigDataPoolResourceInfo(TrackedResource):
    """A Big Data pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param provisioning_state: The state of the Big Data pool.
    :type provisioning_state: str
    :param auto_scale: Auto-scaling properties.
    :type auto_scale: ~azure.mgmt.synapse.models.AutoScaleProperties
    :param creation_date: The time when the Big Data pool was created.
    :type creation_date: ~datetime.datetime
    :param auto_pause: Auto-pausing properties.
    :type auto_pause: ~azure.mgmt.synapse.models.AutoPauseProperties
    :param is_compute_isolation_enabled: Whether compute isolation is required or not.
    :type is_compute_isolation_enabled: bool
    :param have_library_requirements_changed: Whether library requirements changed.
    :type have_library_requirements_changed: bool
    :param session_level_packages_enabled: Whether session level packages enabled.
    :type session_level_packages_enabled: bool
    :param spark_events_folder: The Spark events folder.
    :type spark_events_folder: str
    :param node_count: The number of nodes in the Big Data pool.
    :type node_count: int
    :param library_requirements: Library version requirements.
    :type library_requirements: ~azure.mgmt.synapse.models.LibraryRequirements
    :param spark_config_properties: Spark configuration file to specify additional properties.
    :type spark_config_properties: ~azure.mgmt.synapse.models.LibraryRequirements
    :param spark_version: The Apache Spark version.
    :type spark_version: str
    :param default_spark_log_folder: The default folder where Spark logs will be written.
    :type default_spark_log_folder: str
    :param node_size: The level of compute power that each node in the Big Data pool has. Possible
     values include: "None", "Small", "Medium", "Large", "XLarge", "XXLarge", "XXXLarge".
    :type node_size: str or ~azure.mgmt.synapse.models.NodeSize
    :param node_size_family: The kind of nodes that the Big Data pool provides. Possible values
     include: "None", "MemoryOptimized".
    :type node_size_family: str or ~azure.mgmt.synapse.models.NodeSizeFamily
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'auto_scale': {'key': 'properties.autoScale', 'type': 'AutoScaleProperties'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'auto_pause': {'key': 'properties.autoPause', 'type': 'AutoPauseProperties'},
        'is_compute_isolation_enabled': {'key': 'properties.isComputeIsolationEnabled', 'type': 'bool'},
        'have_library_requirements_changed': {'key': 'properties.haveLibraryRequirementsChanged', 'type': 'bool'},
        'session_level_packages_enabled': {'key': 'properties.sessionLevelPackagesEnabled', 'type': 'bool'},
        'spark_events_folder': {'key': 'properties.sparkEventsFolder', 'type': 'str'},
        'node_count': {'key': 'properties.nodeCount', 'type': 'int'},
        'library_requirements': {'key': 'properties.libraryRequirements', 'type': 'LibraryRequirements'},
        'spark_config_properties': {'key': 'properties.sparkConfigProperties', 'type': 'LibraryRequirements'},
        'spark_version': {'key': 'properties.sparkVersion', 'type': 'str'},
        'default_spark_log_folder': {'key': 'properties.defaultSparkLogFolder', 'type': 'str'},
        'node_size': {'key': 'properties.nodeSize', 'type': 'str'},
        'node_size_family': {'key': 'properties.nodeSizeFamily', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        provisioning_state: Optional[str] = None,
        auto_scale: Optional["AutoScaleProperties"] = None,
        creation_date: Optional[datetime.datetime] = None,
        auto_pause: Optional["AutoPauseProperties"] = None,
        is_compute_isolation_enabled: Optional[bool] = None,
        have_library_requirements_changed: Optional[bool] = None,
        session_level_packages_enabled: Optional[bool] = None,
        spark_events_folder: Optional[str] = None,
        node_count: Optional[int] = None,
        library_requirements: Optional["LibraryRequirements"] = None,
        spark_config_properties: Optional["LibraryRequirements"] = None,
        spark_version: Optional[str] = None,
        default_spark_log_folder: Optional[str] = None,
        node_size: Optional[Union[str, "NodeSize"]] = None,
        node_size_family: Optional[Union[str, "NodeSizeFamily"]] = None,
        **kwargs
    ):
        super(BigDataPoolResourceInfo, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = provisioning_state
        self.auto_scale = auto_scale
        self.creation_date = creation_date
        self.auto_pause = auto_pause
        self.is_compute_isolation_enabled = is_compute_isolation_enabled
        self.have_library_requirements_changed = have_library_requirements_changed
        self.session_level_packages_enabled = session_level_packages_enabled
        self.spark_events_folder = spark_events_folder
        self.node_count = node_count
        self.library_requirements = library_requirements
        self.spark_config_properties = spark_config_properties
        self.spark_version = spark_version
        self.default_spark_log_folder = default_spark_log_folder
        self.node_size = node_size
        self.node_size_family = node_size_family


class BigDataPoolResourceInfoListResult(msrest.serialization.Model):
    """Collection of Big Data pool information.

    :param next_link: Link to the next page of results.
    :type next_link: str
    :param value: List of Big Data pools.
    :type value: list[~azure.mgmt.synapse.models.BigDataPoolResourceInfo]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BigDataPoolResourceInfo]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["BigDataPoolResourceInfo"]] = None,
        **kwargs
    ):
        super(BigDataPoolResourceInfoListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class CheckNameAvailabilityRequest(msrest.serialization.Model):
    """A request about whether a workspace name is available.

    :param name: Workspace name.
    :type name: str
    :param type: Type: workspace.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(msrest.serialization.Model):
    """A response saying whether the workspace name is available.

    :param message: Validation message.
    :type message: str
    :param available: Whether the workspace name is available.
    :type available: bool
    :param reason: Reason the workspace name is or is not available.
    :type reason: str
    :param name: Workspace name.
    :type name: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        available: Optional[bool] = None,
        reason: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self.message = message
        self.available = available
        self.reason = reason
        self.name = name


class CloudError(msrest.serialization.Model):
    """The object that defines the structure of an Azure Synapse error response.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    :param target: Property name/path in request associated with error.
    :type target: str
    :param details: Array with additional error details.
    :type details: list[~azure.mgmt.synapse.models.CloudError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'target': {'key': 'error.target', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[CloudError]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["CloudError"]] = None,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CloudErrorAutoGenerated(msrest.serialization.Model):
    """The object that defines the structure of an Azure Synapse error response.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    :param target: Property name/path in request associated with error.
    :type target: str
    :param details: Array with additional error details.
    :type details: list[~azure.mgmt.synapse.models.CloudErrorAutoGenerated]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
        'target': {'key': 'error.target', 'type': 'str'},
        'details': {'key': 'error.details', 'type': '[CloudErrorAutoGenerated]'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorAutoGenerated"]] = None,
        **kwargs
    ):
        super(CloudErrorAutoGenerated, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class CustomSetupBase(msrest.serialization.Model):
    """The base definition of the custom setup.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CmdkeySetup, ComponentSetup, EnvironmentVariableSetup.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'CmdkeySetup': 'CmdkeySetup', 'ComponentSetup': 'ComponentSetup', 'EnvironmentVariableSetup': 'EnvironmentVariableSetup'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomSetupBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class CmdkeySetup(CustomSetupBase):
    """The custom setup of running cmdkey commands.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param target_name: Required. The server name of data source access.
    :type target_name: object
    :param user_name: Required. The user name of data source access.
    :type user_name: object
    :param password: Required. The password of data source access.
    :type password: ~azure.mgmt.synapse.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'target_name': {'required': True},
        'user_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'target_name': {'key': 'typeProperties.targetName', 'type': 'object'},
        'user_name': {'key': 'typeProperties.userName', 'type': 'object'},
        'password': {'key': 'typeProperties.password', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        target_name: object,
        user_name: object,
        password: "SecretBase",
        **kwargs
    ):
        super(CmdkeySetup, self).__init__(**kwargs)
        self.type = 'CmdkeySetup'  # type: str
        self.target_name = target_name
        self.user_name = user_name
        self.password = password


class ComponentSetup(CustomSetupBase):
    """The custom setup of installing 3rd party components.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param component_name: Required. The name of the 3rd party component.
    :type component_name: str
    :param license_key: The license key to activate the component.
    :type license_key: ~azure.mgmt.synapse.models.SecretBase
    """

    _validation = {
        'type': {'required': True},
        'component_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'component_name': {'key': 'typeProperties.componentName', 'type': 'str'},
        'license_key': {'key': 'typeProperties.licenseKey', 'type': 'SecretBase'},
    }

    def __init__(
        self,
        *,
        component_name: str,
        license_key: Optional["SecretBase"] = None,
        **kwargs
    ):
        super(ComponentSetup, self).__init__(**kwargs)
        self.type = 'ComponentSetup'  # type: str
        self.component_name = component_name
        self.license_key = license_key


class CreateSqlPoolRestorePointDefinition(msrest.serialization.Model):
    """Contains the information necessary to perform a create Sql pool restore point operation.

    All required parameters must be populated in order to send to Azure.

    :param restore_point_label: Required. The restore point label to apply.
    :type restore_point_label: str
    """

    _validation = {
        'restore_point_label': {'required': True},
    }

    _attribute_map = {
        'restore_point_label': {'key': 'restorePointLabel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        restore_point_label: str,
        **kwargs
    ):
        super(CreateSqlPoolRestorePointDefinition, self).__init__(**kwargs)
        self.restore_point_label = restore_point_label


class CustomerManagedKeyDetails(msrest.serialization.Model):
    """Details of the customer managed key associated with the workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The customer managed key status on the workspace.
    :vartype status: str
    :param key: The key object of the workspace.
    :type key: ~azure.mgmt.synapse.models.WorkspaceKeyDetails
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'key': {'key': 'key', 'type': 'WorkspaceKeyDetails'},
    }

    def __init__(
        self,
        *,
        key: Optional["WorkspaceKeyDetails"] = None,
        **kwargs
    ):
        super(CustomerManagedKeyDetails, self).__init__(**kwargs)
        self.status = None
        self.key = key


class DataLakeStorageAccountDetails(msrest.serialization.Model):
    """Details of the data lake storage account associated with the workspace.

    :param account_url: Account URL.
    :type account_url: str
    :param filesystem: Filesystem name.
    :type filesystem: str
    """

    _attribute_map = {
        'account_url': {'key': 'accountUrl', 'type': 'str'},
        'filesystem': {'key': 'filesystem', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        account_url: Optional[str] = None,
        filesystem: Optional[str] = None,
        **kwargs
    ):
        super(DataLakeStorageAccountDetails, self).__init__(**kwargs)
        self.account_url = account_url
        self.filesystem = filesystem


class DataMaskingPolicy(Resource):
    """DataMaskingPolicy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: The location of the data masking policy.
    :vartype location: str
    :ivar kind: The kind of data masking policy. Metadata, used for Azure portal.
    :vartype kind: str
    :ivar managed_by: Fully qualified resource ID of the sql pool.
    :vartype managed_by: str
    :param data_masking_state: The state of the data masking policy. Possible values include:
     "Disabled", "Enabled".
    :type data_masking_state: str or ~azure.mgmt.synapse.models.DataMaskingState
    :param exempt_principals: The list of the exempt principals. Specifies the semicolon-separated
     list of database users for which the data masking policy does not apply. The specified users
     receive data results without masking for all of the database queries.
    :type exempt_principals: str
    :ivar application_principals: The list of the application principals. This is a legacy
     parameter and is no longer used.
    :vartype application_principals: str
    :ivar masking_level: The masking level. This is a legacy parameter and is no longer used.
    :vartype masking_level: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'readonly': True},
        'managed_by': {'readonly': True},
        'application_principals': {'readonly': True},
        'masking_level': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'data_masking_state': {'key': 'properties.dataMaskingState', 'type': 'str'},
        'exempt_principals': {'key': 'properties.exemptPrincipals', 'type': 'str'},
        'application_principals': {'key': 'properties.applicationPrincipals', 'type': 'str'},
        'masking_level': {'key': 'properties.maskingLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        data_masking_state: Optional[Union[str, "DataMaskingState"]] = None,
        exempt_principals: Optional[str] = None,
        **kwargs
    ):
        super(DataMaskingPolicy, self).__init__(**kwargs)
        self.location = None
        self.kind = None
        self.managed_by = None
        self.data_masking_state = data_masking_state
        self.exempt_principals = exempt_principals
        self.application_principals = None
        self.masking_level = None


class DataMaskingRule(Resource):
    """Represents a Sql pool data masking rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: The location of the data masking rule.
    :vartype location: str
    :ivar kind: The kind of Data Masking Rule. Metadata, used for Azure portal.
    :vartype kind: str
    :ivar id_properties_id: The rule Id.
    :vartype id_properties_id: str
    :param alias_name: The alias name. This is a legacy parameter and is no longer used.
    :type alias_name: str
    :param rule_state: The rule state. Used to delete a rule. To delete an existing rule, specify
     the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled.
     However, if the rule doesn't already exist, the rule will be created with ruleState set to
     enabled, regardless of the provided value of ruleState. Possible values include: "Disabled",
     "Enabled".
    :type rule_state: str or ~azure.mgmt.synapse.models.DataMaskingRuleState
    :param schema_name: The schema name on which the data masking rule is applied.
    :type schema_name: str
    :param table_name: The table name on which the data masking rule is applied.
    :type table_name: str
    :param column_name: The column name on which the data masking rule is applied.
    :type column_name: str
    :param masking_function: The masking function that is used for the data masking rule. Possible
     values include: "Default", "CCN", "Email", "Number", "SSN", "Text".
    :type masking_function: str or ~azure.mgmt.synapse.models.DataMaskingFunction
    :param number_from: The numberFrom property of the masking rule. Required if maskingFunction is
     set to Number, otherwise this parameter will be ignored.
    :type number_from: str
    :param number_to: The numberTo property of the data masking rule. Required if maskingFunction
     is set to Number, otherwise this parameter will be ignored.
    :type number_to: str
    :param prefix_size: If maskingFunction is set to Text, the number of characters to show
     unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
    :type prefix_size: str
    :param suffix_size: If maskingFunction is set to Text, the number of characters to show
     unmasked at the end of the string. Otherwise, this parameter will be ignored.
    :type suffix_size: str
    :param replacement_string: If maskingFunction is set to Text, the character to use for masking
     the unexposed part of the string. Otherwise, this parameter will be ignored.
    :type replacement_string: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'readonly': True},
        'id_properties_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'id_properties_id': {'key': 'properties.id', 'type': 'str'},
        'alias_name': {'key': 'properties.aliasName', 'type': 'str'},
        'rule_state': {'key': 'properties.ruleState', 'type': 'str'},
        'schema_name': {'key': 'properties.schemaName', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'column_name': {'key': 'properties.columnName', 'type': 'str'},
        'masking_function': {'key': 'properties.maskingFunction', 'type': 'str'},
        'number_from': {'key': 'properties.numberFrom', 'type': 'str'},
        'number_to': {'key': 'properties.numberTo', 'type': 'str'},
        'prefix_size': {'key': 'properties.prefixSize', 'type': 'str'},
        'suffix_size': {'key': 'properties.suffixSize', 'type': 'str'},
        'replacement_string': {'key': 'properties.replacementString', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alias_name: Optional[str] = None,
        rule_state: Optional[Union[str, "DataMaskingRuleState"]] = None,
        schema_name: Optional[str] = None,
        table_name: Optional[str] = None,
        column_name: Optional[str] = None,
        masking_function: Optional[Union[str, "DataMaskingFunction"]] = None,
        number_from: Optional[str] = None,
        number_to: Optional[str] = None,
        prefix_size: Optional[str] = None,
        suffix_size: Optional[str] = None,
        replacement_string: Optional[str] = None,
        **kwargs
    ):
        super(DataMaskingRule, self).__init__(**kwargs)
        self.location = None
        self.kind = None
        self.id_properties_id = None
        self.alias_name = alias_name
        self.rule_state = rule_state
        self.schema_name = schema_name
        self.table_name = table_name
        self.column_name = column_name
        self.masking_function = masking_function
        self.number_from = number_from
        self.number_to = number_to
        self.prefix_size = prefix_size
        self.suffix_size = suffix_size
        self.replacement_string = replacement_string


class DataMaskingRuleListResult(msrest.serialization.Model):
    """The response to a list data masking rules request.

    :param value: The list of Sql pool data masking rules.
    :type value: list[~azure.mgmt.synapse.models.DataMaskingRule]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataMaskingRule]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DataMaskingRule"]] = None,
        **kwargs
    ):
        super(DataMaskingRuleListResult, self).__init__(**kwargs)
        self.value = value


class DataWarehouseUserActivities(Resource):
    """User activities of a data warehouse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar active_queries_count: Count of running and suspended queries.
    :vartype active_queries_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'active_queries_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'active_queries_count': {'key': 'properties.activeQueriesCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataWarehouseUserActivities, self).__init__(**kwargs)
        self.active_queries_count = None


class EncryptionDetails(msrest.serialization.Model):
    """Details of the encryption associated with the workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar double_encryption_enabled: Double Encryption enabled.
    :vartype double_encryption_enabled: bool
    :param cmk: Customer Managed Key Details.
    :type cmk: ~azure.mgmt.synapse.models.CustomerManagedKeyDetails
    """

    _validation = {
        'double_encryption_enabled': {'readonly': True},
    }

    _attribute_map = {
        'double_encryption_enabled': {'key': 'doubleEncryptionEnabled', 'type': 'bool'},
        'cmk': {'key': 'cmk', 'type': 'CustomerManagedKeyDetails'},
    }

    def __init__(
        self,
        *,
        cmk: Optional["CustomerManagedKeyDetails"] = None,
        **kwargs
    ):
        super(EncryptionDetails, self).__init__(**kwargs)
        self.double_encryption_enabled = None
        self.cmk = cmk


class EntityReference(msrest.serialization.Model):
    """The entity reference.

    :param type: The type of this referenced entity. Possible values include:
     "IntegrationRuntimeReference", "LinkedServiceReference".
    :type type: str or ~azure.mgmt.synapse.models.IntegrationRuntimeEntityReferenceType
    :param reference_name: The name of this referenced entity.
    :type reference_name: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "IntegrationRuntimeEntityReferenceType"]] = None,
        reference_name: Optional[str] = None,
        **kwargs
    ):
        super(EntityReference, self).__init__(**kwargs)
        self.type = type
        self.reference_name = reference_name


class EnvironmentVariableSetup(CustomSetupBase):
    """The custom setup of setting environment variable.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. The type of custom setup.Constant filled by server.
    :type type: str
    :param variable_name: Required. The name of the environment variable.
    :type variable_name: str
    :param variable_value: Required. The value of the environment variable.
    :type variable_value: str
    """

    _validation = {
        'type': {'required': True},
        'variable_name': {'required': True},
        'variable_value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'variable_name': {'key': 'typeProperties.variableName', 'type': 'str'},
        'variable_value': {'key': 'typeProperties.variableValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        variable_name: str,
        variable_value: str,
        **kwargs
    ):
        super(EnvironmentVariableSetup, self).__init__(**kwargs)
        self.type = 'EnvironmentVariableSetup'  # type: str
        self.variable_name = variable_name
        self.variable_value = variable_value


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorContract(msrest.serialization.Model):
    """Contains details when the response code indicates an error.

    :param error: The error details.
    :type error: ~azure.mgmt.synapse.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorResponse"] = None,
        **kwargs
    ):
        super(ErrorContract, self).__init__(**kwargs)
        self.error = error


class ErrorDetail(msrest.serialization.Model):
    """Error details.

    :param message: Error message.
    :type message: str
    :param code: Error code.
    :type code: str
    :param target: Error target.
    :type target: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.message = message
        self.code = code
        self.target = target


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.synapse.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.synapse.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ExtendedServerBlobAuditingPolicy(Resource):
    """An extended server blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param predicate_expression: Specifies condition of where clause when creating an audit.
    :type predicate_expression: str
    :param state: Specifies the state of the policy. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.synapse.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:
    
    
     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
    
     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:
    
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
    
     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.
    
     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
    
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
    
     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.
    
     For more information, see `Database-Level Audit Action Groups <https://docs.microsoft.com/en-
     us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-
     actions#database-level-audit-action-groups>`_.
    
     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
    
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
    
     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
    
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
    
     For more information, see `Database-Level Audit Actions <https://docs.microsoft.com/en-
     us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-
     actions#database-level-audit-actions>`_.
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and
     'isAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-
     version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
     audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :type queue_delay_ms: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'predicate_expression': {'key': 'properties.predicateExpression', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        predicate_expression: Optional[str] = None,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        storage_account_subscription_id: Optional[str] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        **kwargs
    ):
        super(ExtendedServerBlobAuditingPolicy, self).__init__(**kwargs)
        self.predicate_expression = predicate_expression
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.storage_account_subscription_id = storage_account_subscription_id
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms


class ExtendedServerBlobAuditingPolicyListResult(msrest.serialization.Model):
    """A list of server extended auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.ExtendedServerBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExtendedServerBlobAuditingPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedServerBlobAuditingPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExtendedSqlPoolBlobAuditingPolicy(Resource):
    """An extended Sql pool blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param predicate_expression: Specifies condition of where clause when creating an audit.
    :type predicate_expression: str
    :param state: Specifies the state of the policy. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.synapse.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:
    
    
     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
    
     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:
    
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
    
     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.
    
     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
    
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
    
     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.
    
     For more information, see `Database-Level Audit Action Groups <https://docs.microsoft.com/en-
     us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-
     actions#database-level-audit-action-groups>`_.
    
     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
    
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
    
     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
    
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
    
     For more information, see `Database-Level Audit Actions <https://docs.microsoft.com/en-
     us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-
     actions#database-level-audit-actions>`_.
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and
     'isAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-
     version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
     audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :type queue_delay_ms: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'predicate_expression': {'key': 'properties.predicateExpression', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        predicate_expression: Optional[str] = None,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        storage_account_subscription_id: Optional[str] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        **kwargs
    ):
        super(ExtendedSqlPoolBlobAuditingPolicy, self).__init__(**kwargs)
        self.predicate_expression = predicate_expression
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.storage_account_subscription_id = storage_account_subscription_id
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms


class ExtendedSqlPoolBlobAuditingPolicyListResult(msrest.serialization.Model):
    """A list of sql pool extended auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.ExtendedSqlPoolBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExtendedSqlPoolBlobAuditingPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedSqlPoolBlobAuditingPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class GeoBackupPolicy(Resource):
    """A database geo backup policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Kind of geo backup policy.  This is metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar location: Backup policy location.
    :vartype location: str
    :param state: Required. The state of the geo backup policy. Possible values include:
     "Disabled", "Enabled".
    :type state: str or ~azure.mgmt.synapse.models.GeoBackupPolicyState
    :ivar storage_type: The storage type of the geo backup policy.
    :vartype storage_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'state': {'required': True},
        'storage_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        state: Union[str, "GeoBackupPolicyState"],
        **kwargs
    ):
        super(GeoBackupPolicy, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.state = state
        self.storage_type = None


class GeoBackupPolicyListResult(msrest.serialization.Model):
    """The response to a list geo backup policies request.

    :param value: The list of geo backup policies.
    :type value: list[~azure.mgmt.synapse.models.GeoBackupPolicy]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GeoBackupPolicy]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GeoBackupPolicy"]] = None,
        **kwargs
    ):
        super(GeoBackupPolicyListResult, self).__init__(**kwargs)
        self.value = value


class GetSsisObjectMetadataRequest(msrest.serialization.Model):
    """The request payload of get SSIS object metadata.

    :param metadata_path: Metadata path.
    :type metadata_path: str
    """

    _attribute_map = {
        'metadata_path': {'key': 'metadataPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metadata_path: Optional[str] = None,
        **kwargs
    ):
        super(GetSsisObjectMetadataRequest, self).__init__(**kwargs)
        self.metadata_path = metadata_path


class IntegrationRuntime(msrest.serialization.Model):
    """Azure Synapse nested object which serves as a compute resource for activities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ManagedIntegrationRuntime, SelfHostedIntegrationRuntime.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of integration runtime.Constant filled by server.  Possible values
     include: "Managed", "SelfHosted".
    :type type: str or ~azure.mgmt.synapse.models.IntegrationRuntimeType
    :param description: Integration runtime description.
    :type description: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Managed': 'ManagedIntegrationRuntime', 'SelfHosted': 'SelfHostedIntegrationRuntime'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationRuntime, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'IntegrationRuntime'  # type: str
        self.description = description


class IntegrationRuntimeAuthKeys(msrest.serialization.Model):
    """The integration runtime authentication keys.

    :param auth_key1: The primary integration runtime authentication key.
    :type auth_key1: str
    :param auth_key2: The secondary integration runtime authentication key.
    :type auth_key2: str
    """

    _attribute_map = {
        'auth_key1': {'key': 'authKey1', 'type': 'str'},
        'auth_key2': {'key': 'authKey2', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_key1: Optional[str] = None,
        auth_key2: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationRuntimeAuthKeys, self).__init__(**kwargs)
        self.auth_key1 = auth_key1
        self.auth_key2 = auth_key2


class IntegrationRuntimeComputeProperties(msrest.serialization.Model):
    """The compute resource properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param location: The location for managed integration runtime. The supported regions could be
     found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-
     activities.
    :type location: str
    :param node_size: The node size requirement to managed integration runtime.
    :type node_size: str
    :param number_of_nodes: The required number of nodes for managed integration runtime.
    :type number_of_nodes: int
    :param max_parallel_executions_per_node: Maximum parallel executions count per node for managed
     integration runtime.
    :type max_parallel_executions_per_node: int
    :param data_flow_properties: Data flow properties for managed integration runtime.
    :type data_flow_properties: ~azure.mgmt.synapse.models.IntegrationRuntimeDataFlowProperties
    :param v_net_properties: VNet properties for managed integration runtime.
    :type v_net_properties: ~azure.mgmt.synapse.models.IntegrationRuntimeVNetProperties
    """

    _validation = {
        'number_of_nodes': {'minimum': 1},
        'max_parallel_executions_per_node': {'minimum': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'location': {'key': 'location', 'type': 'str'},
        'node_size': {'key': 'nodeSize', 'type': 'str'},
        'number_of_nodes': {'key': 'numberOfNodes', 'type': 'int'},
        'max_parallel_executions_per_node': {'key': 'maxParallelExecutionsPerNode', 'type': 'int'},
        'data_flow_properties': {'key': 'dataFlowProperties', 'type': 'IntegrationRuntimeDataFlowProperties'},
        'v_net_properties': {'key': 'vNetProperties', 'type': 'IntegrationRuntimeVNetProperties'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        location: Optional[str] = None,
        node_size: Optional[str] = None,
        number_of_nodes: Optional[int] = None,
        max_parallel_executions_per_node: Optional[int] = None,
        data_flow_properties: Optional["IntegrationRuntimeDataFlowProperties"] = None,
        v_net_properties: Optional["IntegrationRuntimeVNetProperties"] = None,
        **kwargs
    ):
        super(IntegrationRuntimeComputeProperties, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.location = location
        self.node_size = node_size
        self.number_of_nodes = number_of_nodes
        self.max_parallel_executions_per_node = max_parallel_executions_per_node
        self.data_flow_properties = data_flow_properties
        self.v_net_properties = v_net_properties


class IntegrationRuntimeConnectionInfo(msrest.serialization.Model):
    """Connection information for encrypting the on-premises data source credentials.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar service_token: The token generated in service. Callers use this token to authenticate to
     integration runtime.
    :vartype service_token: str
    :ivar identity_cert_thumbprint: The integration runtime SSL certificate thumbprint. Click-Once
     application uses it to do server validation.
    :vartype identity_cert_thumbprint: str
    :ivar host_service_uri: The on-premises integration runtime host URL.
    :vartype host_service_uri: str
    :ivar version: The integration runtime version.
    :vartype version: str
    :ivar public_key: The public key for encrypting a credential when transferring the credential
     to the integration runtime.
    :vartype public_key: str
    :ivar is_identity_cert_exprired: Whether the identity certificate is expired.
    :vartype is_identity_cert_exprired: bool
    """

    _validation = {
        'service_token': {'readonly': True},
        'identity_cert_thumbprint': {'readonly': True},
        'host_service_uri': {'readonly': True},
        'version': {'readonly': True},
        'public_key': {'readonly': True},
        'is_identity_cert_exprired': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'service_token': {'key': 'serviceToken', 'type': 'str'},
        'identity_cert_thumbprint': {'key': 'identityCertThumbprint', 'type': 'str'},
        'host_service_uri': {'key': 'hostServiceUri', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'public_key': {'key': 'publicKey', 'type': 'str'},
        'is_identity_cert_exprired': {'key': 'isIdentityCertExprired', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeConnectionInfo, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.service_token = None
        self.identity_cert_thumbprint = None
        self.host_service_uri = None
        self.version = None
        self.public_key = None
        self.is_identity_cert_exprired = None


class IntegrationRuntimeCustomSetupScriptProperties(msrest.serialization.Model):
    """Custom setup script properties for a managed dedicated integration runtime.

    :param blob_container_uri: The URI of the Azure blob container that contains the custom setup
     script.
    :type blob_container_uri: str
    :param sas_token: The SAS token of the Azure blob container.
    :type sas_token: ~azure.mgmt.synapse.models.SecureString
    """

    _attribute_map = {
        'blob_container_uri': {'key': 'blobContainerUri', 'type': 'str'},
        'sas_token': {'key': 'sasToken', 'type': 'SecureString'},
    }

    def __init__(
        self,
        *,
        blob_container_uri: Optional[str] = None,
        sas_token: Optional["SecureString"] = None,
        **kwargs
    ):
        super(IntegrationRuntimeCustomSetupScriptProperties, self).__init__(**kwargs)
        self.blob_container_uri = blob_container_uri
        self.sas_token = sas_token


class IntegrationRuntimeDataFlowProperties(msrest.serialization.Model):
    """Data flow properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param compute_type: Compute type of the cluster which will execute data flow job. Possible
     values include: "General", "MemoryOptimized", "ComputeOptimized".
    :type compute_type: str or ~azure.mgmt.synapse.models.DataFlowComputeType
    :param core_count: Core count of the cluster which will execute data flow job. Supported values
     are: 8, 16, 32, 48, 80, 144 and 272.
    :type core_count: int
    :param time_to_live: Time to live (in minutes) setting of the cluster which will execute data
     flow job.
    :type time_to_live: int
    """

    _validation = {
        'time_to_live': {'minimum': 0},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'core_count': {'key': 'coreCount', 'type': 'int'},
        'time_to_live': {'key': 'timeToLive', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        compute_type: Optional[Union[str, "DataFlowComputeType"]] = None,
        core_count: Optional[int] = None,
        time_to_live: Optional[int] = None,
        **kwargs
    ):
        super(IntegrationRuntimeDataFlowProperties, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.compute_type = compute_type
        self.core_count = core_count
        self.time_to_live = time_to_live


class IntegrationRuntimeDataProxyProperties(msrest.serialization.Model):
    """Data proxy properties for a managed dedicated integration runtime.

    :param connect_via: The self-hosted integration runtime reference.
    :type connect_via: ~azure.mgmt.synapse.models.EntityReference
    :param staging_linked_service: The staging linked service reference.
    :type staging_linked_service: ~azure.mgmt.synapse.models.EntityReference
    :param path: The path to contain the staged data in the Blob storage.
    :type path: str
    """

    _attribute_map = {
        'connect_via': {'key': 'connectVia', 'type': 'EntityReference'},
        'staging_linked_service': {'key': 'stagingLinkedService', 'type': 'EntityReference'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connect_via: Optional["EntityReference"] = None,
        staging_linked_service: Optional["EntityReference"] = None,
        path: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationRuntimeDataProxyProperties, self).__init__(**kwargs)
        self.connect_via = connect_via
        self.staging_linked_service = staging_linked_service
        self.path = path


class IntegrationRuntimeListResponse(msrest.serialization.Model):
    """A list of integration runtime resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of integration runtimes.
    :type value: list[~azure.mgmt.synapse.models.IntegrationRuntimeResource]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IntegrationRuntimeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["IntegrationRuntimeResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(IntegrationRuntimeListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class IntegrationRuntimeMonitoringData(msrest.serialization.Model):
    """Get monitoring data response.

    :param name: Integration runtime name.
    :type name: str
    :param nodes: Integration runtime node monitoring data.
    :type nodes: list[~azure.mgmt.synapse.models.IntegrationRuntimeNodeMonitoringData]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'nodes': {'key': 'nodes', 'type': '[IntegrationRuntimeNodeMonitoringData]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        nodes: Optional[List["IntegrationRuntimeNodeMonitoringData"]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeMonitoringData, self).__init__(**kwargs)
        self.name = name
        self.nodes = nodes


class IntegrationRuntimeNodeIpAddress(msrest.serialization.Model):
    """The IP address of self-hosted integration runtime node.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_address: The IP address of self-hosted integration runtime node.
    :vartype ip_address: str
    """

    _validation = {
        'ip_address': {'readonly': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IntegrationRuntimeNodeIpAddress, self).__init__(**kwargs)
        self.ip_address = None


class IntegrationRuntimeNodeMonitoringData(msrest.serialization.Model):
    """Monitoring data for integration runtime node.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar node_name: Name of the integration runtime node.
    :vartype node_name: str
    :ivar available_memory_in_mb: Available memory (MB) on the integration runtime node.
    :vartype available_memory_in_mb: int
    :ivar cpu_utilization: CPU percentage on the integration runtime node.
    :vartype cpu_utilization: int
    :ivar concurrent_jobs_limit: Maximum concurrent jobs on the integration runtime node.
    :vartype concurrent_jobs_limit: int
    :ivar concurrent_jobs_running: The number of jobs currently running on the integration runtime
     node.
    :vartype concurrent_jobs_running: int
    :ivar max_concurrent_jobs: The maximum concurrent jobs in this integration runtime.
    :vartype max_concurrent_jobs: int
    :ivar sent_bytes: Sent bytes on the integration runtime node.
    :vartype sent_bytes: float
    :ivar received_bytes: Received bytes on the integration runtime node.
    :vartype received_bytes: float
    """

    _validation = {
        'node_name': {'readonly': True},
        'available_memory_in_mb': {'readonly': True},
        'cpu_utilization': {'readonly': True},
        'concurrent_jobs_limit': {'readonly': True},
        'concurrent_jobs_running': {'readonly': True},
        'max_concurrent_jobs': {'readonly': True},
        'sent_bytes': {'readonly': True},
        'received_bytes': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'node_name': {'key': 'nodeName', 'type': 'str'},
        'available_memory_in_mb': {'key': 'availableMemoryInMB', 'type': 'int'},
        'cpu_utilization': {'key': 'cpuUtilization', 'type': 'int'},
        'concurrent_jobs_limit': {'key': 'concurrentJobsLimit', 'type': 'int'},
        'concurrent_jobs_running': {'key': 'concurrentJobsRunning', 'type': 'int'},
        'max_concurrent_jobs': {'key': 'maxConcurrentJobs', 'type': 'int'},
        'sent_bytes': {'key': 'sentBytes', 'type': 'float'},
        'received_bytes': {'key': 'receivedBytes', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeNodeMonitoringData, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.node_name = None
        self.available_memory_in_mb = None
        self.cpu_utilization = None
        self.concurrent_jobs_limit = None
        self.concurrent_jobs_running = None
        self.max_concurrent_jobs = None
        self.sent_bytes = None
        self.received_bytes = None


class IntegrationRuntimeRegenerateKeyParameters(msrest.serialization.Model):
    """Parameters to regenerate the authentication key.

    :param key_name: The name of the authentication key to regenerate. Possible values include:
     "authKey1", "authKey2".
    :type key_name: str or ~azure.mgmt.synapse.models.IntegrationRuntimeAuthKeyName
    """

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: Optional[Union[str, "IntegrationRuntimeAuthKeyName"]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = key_name


class IntegrationRuntimeResource(AzureEntityResource):
    """Integration runtime resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param properties: Required. Integration runtime properties.
    :type properties: ~azure.mgmt.synapse.models.IntegrationRuntime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IntegrationRuntime'},
    }

    def __init__(
        self,
        *,
        properties: "IntegrationRuntime",
        **kwargs
    ):
        super(IntegrationRuntimeResource, self).__init__(**kwargs)
        self.properties = properties


class IntegrationRuntimeSsisCatalogInfo(msrest.serialization.Model):
    """Catalog information for managed dedicated integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param catalog_server_endpoint: The catalog database server URL.
    :type catalog_server_endpoint: str
    :param catalog_admin_user_name: The administrator user name of catalog database.
    :type catalog_admin_user_name: str
    :param catalog_admin_password: The password of the administrator user account of the catalog
     database.
    :type catalog_admin_password: ~azure.mgmt.synapse.models.SecureString
    :param catalog_pricing_tier: The pricing tier for the catalog database. The valid values could
     be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/. Possible values
     include: "Basic", "Standard", "Premium", "PremiumRS".
    :type catalog_pricing_tier: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeSsisCatalogPricingTier
    """

    _validation = {
        'catalog_admin_user_name': {'max_length': 128, 'min_length': 1},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'catalog_server_endpoint': {'key': 'catalogServerEndpoint', 'type': 'str'},
        'catalog_admin_user_name': {'key': 'catalogAdminUserName', 'type': 'str'},
        'catalog_admin_password': {'key': 'catalogAdminPassword', 'type': 'SecureString'},
        'catalog_pricing_tier': {'key': 'catalogPricingTier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        catalog_server_endpoint: Optional[str] = None,
        catalog_admin_user_name: Optional[str] = None,
        catalog_admin_password: Optional["SecureString"] = None,
        catalog_pricing_tier: Optional[Union[str, "IntegrationRuntimeSsisCatalogPricingTier"]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeSsisCatalogInfo, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.catalog_server_endpoint = catalog_server_endpoint
        self.catalog_admin_user_name = catalog_admin_user_name
        self.catalog_admin_password = catalog_admin_password
        self.catalog_pricing_tier = catalog_pricing_tier


class IntegrationRuntimeSsisProperties(msrest.serialization.Model):
    """SSIS properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param catalog_info: Catalog information for managed dedicated integration runtime.
    :type catalog_info: ~azure.mgmt.synapse.models.IntegrationRuntimeSsisCatalogInfo
    :param license_type: License type for bringing your own license scenario. Possible values
     include: "BasePrice", "LicenseIncluded".
    :type license_type: str or ~azure.mgmt.synapse.models.IntegrationRuntimeLicenseType
    :param custom_setup_script_properties: Custom setup script properties for a managed dedicated
     integration runtime.
    :type custom_setup_script_properties:
     ~azure.mgmt.synapse.models.IntegrationRuntimeCustomSetupScriptProperties
    :param data_proxy_properties: Data proxy properties for a managed dedicated integration
     runtime.
    :type data_proxy_properties: ~azure.mgmt.synapse.models.IntegrationRuntimeDataProxyProperties
    :param edition: The edition for the SSIS Integration Runtime. Possible values include:
     "Standard", "Enterprise".
    :type edition: str or ~azure.mgmt.synapse.models.IntegrationRuntimeEdition
    :param express_custom_setup_properties: Custom setup without script properties for a SSIS
     integration runtime.
    :type express_custom_setup_properties: list[~azure.mgmt.synapse.models.CustomSetupBase]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'catalog_info': {'key': 'catalogInfo', 'type': 'IntegrationRuntimeSsisCatalogInfo'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'custom_setup_script_properties': {'key': 'customSetupScriptProperties', 'type': 'IntegrationRuntimeCustomSetupScriptProperties'},
        'data_proxy_properties': {'key': 'dataProxyProperties', 'type': 'IntegrationRuntimeDataProxyProperties'},
        'edition': {'key': 'edition', 'type': 'str'},
        'express_custom_setup_properties': {'key': 'expressCustomSetupProperties', 'type': '[CustomSetupBase]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        catalog_info: Optional["IntegrationRuntimeSsisCatalogInfo"] = None,
        license_type: Optional[Union[str, "IntegrationRuntimeLicenseType"]] = None,
        custom_setup_script_properties: Optional["IntegrationRuntimeCustomSetupScriptProperties"] = None,
        data_proxy_properties: Optional["IntegrationRuntimeDataProxyProperties"] = None,
        edition: Optional[Union[str, "IntegrationRuntimeEdition"]] = None,
        express_custom_setup_properties: Optional[List["CustomSetupBase"]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeSsisProperties, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.catalog_info = catalog_info
        self.license_type = license_type
        self.custom_setup_script_properties = custom_setup_script_properties
        self.data_proxy_properties = data_proxy_properties
        self.edition = edition
        self.express_custom_setup_properties = express_custom_setup_properties


class IntegrationRuntimeStatus(msrest.serialization.Model):
    """Integration runtime status.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ManagedIntegrationRuntimeStatus, SelfHostedIntegrationRuntimeStatus.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of integration runtime.Constant filled by server.  Possible values
     include: "Managed", "SelfHosted".
    :type type: str or ~azure.mgmt.synapse.models.IntegrationRuntimeType
    :ivar data_factory_name: The workspace name which the integration runtime belong to.
    :vartype data_factory_name: str
    :ivar state: The state of integration runtime. Possible values include: "Initial", "Stopped",
     "Started", "Starting", "Stopping", "NeedRegistration", "Online", "Limited", "Offline",
     "AccessDenied".
    :vartype state: str or ~azure.mgmt.synapse.models.IntegrationRuntimeState
    """

    _validation = {
        'type': {'required': True},
        'data_factory_name': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Managed': 'ManagedIntegrationRuntimeStatus', 'SelfHosted': 'SelfHostedIntegrationRuntimeStatus'}
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeStatus, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = 'IntegrationRuntimeStatus'  # type: str
        self.data_factory_name = None
        self.state = None


class IntegrationRuntimeStatusResponse(msrest.serialization.Model):
    """Integration runtime status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The integration runtime name.
    :vartype name: str
    :param properties: Required. Integration runtime properties.
    :type properties: ~azure.mgmt.synapse.models.IntegrationRuntimeStatus
    """

    _validation = {
        'name': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IntegrationRuntimeStatus'},
    }

    def __init__(
        self,
        *,
        properties: "IntegrationRuntimeStatus",
        **kwargs
    ):
        super(IntegrationRuntimeStatusResponse, self).__init__(**kwargs)
        self.name = None
        self.properties = properties


class IntegrationRuntimeVNetProperties(msrest.serialization.Model):
    """VNet properties for managed integration runtime.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param v_net_id: The ID of the VNet that this integration runtime will join.
    :type v_net_id: str
    :param subnet: The name of the subnet this integration runtime will join.
    :type subnet: str
    :param public_i_ps: Resource IDs of the public IP addresses that this integration runtime will
     use.
    :type public_i_ps: list[str]
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'v_net_id': {'key': 'vNetId', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
        'public_i_ps': {'key': 'publicIPs', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        v_net_id: Optional[str] = None,
        subnet: Optional[str] = None,
        public_i_ps: Optional[List[str]] = None,
        **kwargs
    ):
        super(IntegrationRuntimeVNetProperties, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.v_net_id = v_net_id
        self.subnet = subnet
        self.public_i_ps = public_i_ps


class IpFirewallRuleInfo(Resource):
    """IP firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param end_ip_address: The end IP address of the firewall rule. Must be IPv4 format. Must be
     greater than or equal to startIpAddress.
    :type end_ip_address: str
    :ivar provisioning_state: Resource provisioning state. Possible values include: "Provisioning",
     "Succeeded", "Deleting", "Failed", "DeleteError".
    :vartype provisioning_state: str or ~azure.mgmt.synapse.models.ProvisioningState
    :param start_ip_address: The start IP address of the firewall rule. Must be IPv4 format.
    :type start_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        end_ip_address: Optional[str] = None,
        start_ip_address: Optional[str] = None,
        **kwargs
    ):
        super(IpFirewallRuleInfo, self).__init__(**kwargs)
        self.end_ip_address = end_ip_address
        self.provisioning_state = None
        self.start_ip_address = start_ip_address


class IpFirewallRuleInfoListResult(msrest.serialization.Model):
    """List of IP firewall rules.

    :param next_link: Link to next page of results.
    :type next_link: str
    :param value: List of IP firewall rules.
    :type value: list[~azure.mgmt.synapse.models.IpFirewallRuleInfo]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[IpFirewallRuleInfo]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["IpFirewallRuleInfo"]] = None,
        **kwargs
    ):
        super(IpFirewallRuleInfoListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class IpFirewallRuleProperties(msrest.serialization.Model):
    """IP firewall rule properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param end_ip_address: The end IP address of the firewall rule. Must be IPv4 format. Must be
     greater than or equal to startIpAddress.
    :type end_ip_address: str
    :ivar provisioning_state: Resource provisioning state. Possible values include: "Provisioning",
     "Succeeded", "Deleting", "Failed", "DeleteError".
    :vartype provisioning_state: str or ~azure.mgmt.synapse.models.ProvisioningState
    :param start_ip_address: The start IP address of the firewall rule. Must be IPv4 format.
    :type start_ip_address: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'end_ip_address': {'key': 'endIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'start_ip_address': {'key': 'startIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        end_ip_address: Optional[str] = None,
        start_ip_address: Optional[str] = None,
        **kwargs
    ):
        super(IpFirewallRuleProperties, self).__init__(**kwargs)
        self.end_ip_address = end_ip_address
        self.provisioning_state = None
        self.start_ip_address = start_ip_address


class Key(Resource):
    """A workspace key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param is_active_cmk: Used to activate the workspace after a customer managed key is provided.
    :type is_active_cmk: bool
    :param key_vault_url: The Key Vault Url of the workspace key.
    :type key_vault_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_active_cmk': {'key': 'properties.isActiveCMK', 'type': 'bool'},
        'key_vault_url': {'key': 'properties.keyVaultUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_active_cmk: Optional[bool] = None,
        key_vault_url: Optional[str] = None,
        **kwargs
    ):
        super(Key, self).__init__(**kwargs)
        self.is_active_cmk = is_active_cmk
        self.key_vault_url = key_vault_url


class KeyInfoListResult(msrest.serialization.Model):
    """List of keys.

    :param next_link: Link to the next page of results.
    :type next_link: str
    :param value: List of keys.
    :type value: list[~azure.mgmt.synapse.models.Key]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Key]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["Key"]] = None,
        **kwargs
    ):
        super(KeyInfoListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class LibraryRequirements(msrest.serialization.Model):
    """Library requirements for a Big Data pool powered by Apache Spark.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: The last update time of the library requirements file.
    :vartype time: ~datetime.datetime
    :param content: The library requirements.
    :type content: str
    :param filename: The filename of the library requirements file.
    :type filename: str
    """

    _validation = {
        'time': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'content': {'key': 'content', 'type': 'str'},
        'filename': {'key': 'filename', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        filename: Optional[str] = None,
        **kwargs
    ):
        super(LibraryRequirements, self).__init__(**kwargs)
        self.time = None
        self.content = content
        self.filename = filename


class LinkedIntegrationRuntime(msrest.serialization.Model):
    """The linked integration runtime information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the linked integration runtime.
    :vartype name: str
    :ivar subscription_id: The subscription ID for which the linked integration runtime belong to.
    :vartype subscription_id: str
    :ivar data_factory_name: The name of the workspace for which the linked integration runtime
     belong to.
    :vartype data_factory_name: str
    :ivar data_factory_location: The location of the workspace for which the linked integration
     runtime belong to.
    :vartype data_factory_location: str
    :ivar create_time: The creating time of the linked integration runtime.
    :vartype create_time: ~datetime.datetime
    """

    _validation = {
        'name': {'readonly': True},
        'subscription_id': {'readonly': True},
        'data_factory_name': {'readonly': True},
        'data_factory_location': {'readonly': True},
        'create_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'data_factory_location': {'key': 'dataFactoryLocation', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedIntegrationRuntime, self).__init__(**kwargs)
        self.name = None
        self.subscription_id = None
        self.data_factory_name = None
        self.data_factory_location = None
        self.create_time = None


class LinkedIntegrationRuntimeType(msrest.serialization.Model):
    """The base definition of a linked integration runtime.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LinkedIntegrationRuntimeKeyAuthorization, LinkedIntegrationRuntimeRbacAuthorization.

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. The authorization type for integration runtime
     sharing.Constant filled by server.
    :type authorization_type: str
    """

    _validation = {
        'authorization_type': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
    }

    _subtype_map = {
        'authorization_type': {'Key': 'LinkedIntegrationRuntimeKeyAuthorization', 'RBAC': 'LinkedIntegrationRuntimeRbacAuthorization'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinkedIntegrationRuntimeType, self).__init__(**kwargs)
        self.authorization_type = None  # type: Optional[str]


class LinkedIntegrationRuntimeKeyAuthorization(LinkedIntegrationRuntimeType):
    """The key authorization type integration runtime.

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. The authorization type for integration runtime
     sharing.Constant filled by server.
    :type authorization_type: str
    :param key: Required. The key used for authorization.
    :type key: ~azure.mgmt.synapse.models.SecureString
    """

    _validation = {
        'authorization_type': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'SecureString'},
    }

    def __init__(
        self,
        *,
        key: "SecureString",
        **kwargs
    ):
        super(LinkedIntegrationRuntimeKeyAuthorization, self).__init__(**kwargs)
        self.authorization_type = 'Key'  # type: str
        self.key = key


class LinkedIntegrationRuntimeRbacAuthorization(LinkedIntegrationRuntimeType):
    """The role based access control (RBAC) authorization type integration runtime.

    All required parameters must be populated in order to send to Azure.

    :param authorization_type: Required. The authorization type for integration runtime
     sharing.Constant filled by server.
    :type authorization_type: str
    :param resource_id: Required. The resource identifier of the integration runtime to be shared.
    :type resource_id: str
    """

    _validation = {
        'authorization_type': {'required': True},
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'authorization_type': {'key': 'authorizationType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        **kwargs
    ):
        super(LinkedIntegrationRuntimeRbacAuthorization, self).__init__(**kwargs)
        self.authorization_type = 'RBAC'  # type: str
        self.resource_id = resource_id


class ListSqlPoolSecurityAlertPolicies(msrest.serialization.Model):
    """A list of SQL pool security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.SqlPoolSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlPoolSecurityAlertPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListSqlPoolSecurityAlertPolicies, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ManagedIdentity(msrest.serialization.Model):
    """The workspace managed identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the workspace managed identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the workspace managed identity.
    :vartype tenant_id: str
    :param type: The type of managed identity for the workspace. Possible values include: "None",
     "SystemAssigned".
    :type type: str or ~azure.mgmt.synapse.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        **kwargs
    ):
        super(ManagedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ManagedIdentitySqlControlSettingsModel(Resource):
    """Sql Control Settings for workspace managed identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param grant_sql_control_to_managed_identity: Grant sql control to managed identity.
    :type grant_sql_control_to_managed_identity:
     ~azure.mgmt.synapse.models.ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'grant_sql_control_to_managed_identity': {'key': 'properties.grantSqlControlToManagedIdentity', 'type': 'ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity'},
    }

    def __init__(
        self,
        *,
        grant_sql_control_to_managed_identity: Optional["ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity"] = None,
        **kwargs
    ):
        super(ManagedIdentitySqlControlSettingsModel, self).__init__(**kwargs)
        self.grant_sql_control_to_managed_identity = grant_sql_control_to_managed_identity


class ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity(msrest.serialization.Model):
    """Grant sql control to managed identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param desired_state: Desired state. Possible values include: "Enabled", "Disabled".
    :type desired_state: str or
     ~azure.mgmt.synapse.models.ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentityDesiredState
    :ivar actual_state: Actual state. Possible values include: "Enabling", "Enabled", "Disabling",
     "Disabled", "Unknown".
    :vartype actual_state: str or
     ~azure.mgmt.synapse.models.ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentityActualState
    """

    _validation = {
        'actual_state': {'readonly': True},
    }

    _attribute_map = {
        'desired_state': {'key': 'desiredState', 'type': 'str'},
        'actual_state': {'key': 'actualState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        desired_state: Optional[Union[str, "ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentityDesiredState"]] = None,
        **kwargs
    ):
        super(ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity, self).__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state = None


class ManagedIntegrationRuntime(IntegrationRuntime):
    """Managed integration runtime, including managed elastic and managed dedicated integration runtimes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of integration runtime.Constant filled by server.  Possible values
     include: "Managed", "SelfHosted".
    :type type: str or ~azure.mgmt.synapse.models.IntegrationRuntimeType
    :param description: Integration runtime description.
    :type description: str
    :ivar state: Integration runtime state, only valid for managed dedicated integration runtime.
     Possible values include: "Initial", "Stopped", "Started", "Starting", "Stopping",
     "NeedRegistration", "Online", "Limited", "Offline", "AccessDenied".
    :vartype state: str or ~azure.mgmt.synapse.models.IntegrationRuntimeState
    :param compute_properties: The compute resource for managed integration runtime.
    :type compute_properties: ~azure.mgmt.synapse.models.IntegrationRuntimeComputeProperties
    :param ssis_properties: SSIS properties for managed integration runtime.
    :type ssis_properties: ~azure.mgmt.synapse.models.IntegrationRuntimeSsisProperties
    """

    _validation = {
        'type': {'required': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'compute_properties': {'key': 'typeProperties.computeProperties', 'type': 'IntegrationRuntimeComputeProperties'},
        'ssis_properties': {'key': 'typeProperties.ssisProperties', 'type': 'IntegrationRuntimeSsisProperties'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        compute_properties: Optional["IntegrationRuntimeComputeProperties"] = None,
        ssis_properties: Optional["IntegrationRuntimeSsisProperties"] = None,
        **kwargs
    ):
        super(ManagedIntegrationRuntime, self).__init__(additional_properties=additional_properties, description=description, **kwargs)
        self.type = 'Managed'  # type: str
        self.state = None
        self.compute_properties = compute_properties
        self.ssis_properties = ssis_properties


class ManagedIntegrationRuntimeError(msrest.serialization.Model):
    """Error definition for managed integration runtime.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar time: The time when the error occurred.
    :vartype time: ~datetime.datetime
    :ivar code: Error code.
    :vartype code: str
    :ivar parameters: Managed integration runtime error parameters.
    :vartype parameters: list[str]
    :ivar message: Error message.
    :vartype message: str
    """

    _validation = {
        'time': {'readonly': True},
        'code': {'readonly': True},
        'parameters': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'code': {'key': 'code', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ManagedIntegrationRuntimeError, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.time = None
        self.code = None
        self.parameters = None
        self.message = None


class ManagedIntegrationRuntimeNode(msrest.serialization.Model):
    """Properties of integration runtime node.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar node_id: The managed integration runtime node id.
    :vartype node_id: str
    :ivar status: The managed integration runtime node status. Possible values include: "Starting",
     "Available", "Recycling", "Unavailable".
    :vartype status: str or ~azure.mgmt.synapse.models.ManagedIntegrationRuntimeNodeStatus
    :param errors: The errors that occurred on this integration runtime node.
    :type errors: list[~azure.mgmt.synapse.models.ManagedIntegrationRuntimeError]
    """

    _validation = {
        'node_id': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ManagedIntegrationRuntimeError]'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        errors: Optional[List["ManagedIntegrationRuntimeError"]] = None,
        **kwargs
    ):
        super(ManagedIntegrationRuntimeNode, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.node_id = None
        self.status = None
        self.errors = errors


class ManagedIntegrationRuntimeOperationResult(msrest.serialization.Model):
    """Properties of managed integration runtime operation result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar type: The operation type. Could be start or stop.
    :vartype type: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar result: The operation result.
    :vartype result: str
    :ivar error_code: The error code.
    :vartype error_code: str
    :ivar parameters: Managed integration runtime error parameters.
    :vartype parameters: list[str]
    :ivar activity_id: The activity id for the operation request.
    :vartype activity_id: str
    """

    _validation = {
        'type': {'readonly': True},
        'start_time': {'readonly': True},
        'result': {'readonly': True},
        'error_code': {'readonly': True},
        'parameters': {'readonly': True},
        'activity_id': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'result': {'key': 'result', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ManagedIntegrationRuntimeOperationResult, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None
        self.start_time = None
        self.result = None
        self.error_code = None
        self.parameters = None
        self.activity_id = None


class ManagedIntegrationRuntimeStatus(IntegrationRuntimeStatus):
    """Managed integration runtime status.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of integration runtime.Constant filled by server.  Possible values
     include: "Managed", "SelfHosted".
    :type type: str or ~azure.mgmt.synapse.models.IntegrationRuntimeType
    :ivar data_factory_name: The workspace name which the integration runtime belong to.
    :vartype data_factory_name: str
    :ivar state: The state of integration runtime. Possible values include: "Initial", "Stopped",
     "Started", "Starting", "Stopping", "NeedRegistration", "Online", "Limited", "Offline",
     "AccessDenied".
    :vartype state: str or ~azure.mgmt.synapse.models.IntegrationRuntimeState
    :ivar create_time: The time at which the integration runtime was created, in ISO8601 format.
    :vartype create_time: ~datetime.datetime
    :ivar nodes: The list of nodes for managed integration runtime.
    :vartype nodes: list[~azure.mgmt.synapse.models.ManagedIntegrationRuntimeNode]
    :ivar other_errors: The errors that occurred on this integration runtime.
    :vartype other_errors: list[~azure.mgmt.synapse.models.ManagedIntegrationRuntimeError]
    :ivar last_operation: The last operation result that occurred on this integration runtime.
    :vartype last_operation: ~azure.mgmt.synapse.models.ManagedIntegrationRuntimeOperationResult
    """

    _validation = {
        'type': {'required': True},
        'data_factory_name': {'readonly': True},
        'state': {'readonly': True},
        'create_time': {'readonly': True},
        'nodes': {'readonly': True},
        'other_errors': {'readonly': True},
        'last_operation': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'create_time': {'key': 'typeProperties.createTime', 'type': 'iso-8601'},
        'nodes': {'key': 'typeProperties.nodes', 'type': '[ManagedIntegrationRuntimeNode]'},
        'other_errors': {'key': 'typeProperties.otherErrors', 'type': '[ManagedIntegrationRuntimeError]'},
        'last_operation': {'key': 'typeProperties.lastOperation', 'type': 'ManagedIntegrationRuntimeOperationResult'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(ManagedIntegrationRuntimeStatus, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'Managed'  # type: str
        self.create_time = None
        self.nodes = None
        self.other_errors = None
        self.last_operation = None


class ManagedVirtualNetworkSettings(msrest.serialization.Model):
    """Managed Virtual Network Settings.

    :param prevent_data_exfiltration: Prevent Data Exfiltration.
    :type prevent_data_exfiltration: bool
    :param linked_access_check_on_target_resource: Linked Access Check On Target Resource.
    :type linked_access_check_on_target_resource: bool
    :param allowed_aad_tenant_ids_for_linking: Allowed Aad Tenant Ids For Linking.
    :type allowed_aad_tenant_ids_for_linking: list[str]
    """

    _attribute_map = {
        'prevent_data_exfiltration': {'key': 'preventDataExfiltration', 'type': 'bool'},
        'linked_access_check_on_target_resource': {'key': 'linkedAccessCheckOnTargetResource', 'type': 'bool'},
        'allowed_aad_tenant_ids_for_linking': {'key': 'allowedAadTenantIdsForLinking', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        prevent_data_exfiltration: Optional[bool] = None,
        linked_access_check_on_target_resource: Optional[bool] = None,
        allowed_aad_tenant_ids_for_linking: Optional[List[str]] = None,
        **kwargs
    ):
        super(ManagedVirtualNetworkSettings, self).__init__(**kwargs)
        self.prevent_data_exfiltration = prevent_data_exfiltration
        self.linked_access_check_on_target_resource = linked_access_check_on_target_resource
        self.allowed_aad_tenant_ids_for_linking = allowed_aad_tenant_ids_for_linking


class MetadataSyncConfig(Resource):
    """Configuration for metadata sync.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param enabled: Indicates whether the metadata sync is enabled or disabled.
    :type enabled: bool
    :param sync_interval_in_minutes: The Sync Interval in minutes.
    :type sync_interval_in_minutes: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'sync_interval_in_minutes': {'key': 'properties.syncIntervalInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        sync_interval_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(MetadataSyncConfig, self).__init__(**kwargs)
        self.enabled = enabled
        self.sync_interval_in_minutes = sync_interval_in_minutes


class OperationMetaLogSpecification(msrest.serialization.Model):
    """What is this?.

    :param display_name: Log display name.
    :type display_name: str
    :param blob_duration: Time range the log covers.
    :type blob_duration: str
    :param name: Log unique name.
    :type name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(OperationMetaLogSpecification, self).__init__(**kwargs)
        self.display_name = display_name
        self.blob_duration = blob_duration
        self.name = name


class OperationMetaMetricDimensionSpecification(msrest.serialization.Model):
    """What is this?.

    :param display_name: Dimension display name.
    :type display_name: str
    :param name: Dimension unique name.
    :type name: str
    :param to_be_exported_for_shoebox: Whether this metric should be exported for Shoebox.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs
    ):
        super(OperationMetaMetricDimensionSpecification, self).__init__(**kwargs)
        self.display_name = display_name
        self.name = name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class OperationMetaMetricSpecification(msrest.serialization.Model):
    """What is this?.

    :param source_mdm_namespace: The source MDM namespace.
    :type source_mdm_namespace: str
    :param display_name: Metric display name.
    :type display_name: str
    :param name: Metric unique name.
    :type name: str
    :param aggregation_type: Metric aggregation type.
    :type aggregation_type: str
    :param display_description: Metric description.
    :type display_description: str
    :param source_mdm_account: The source MDM account.
    :type source_mdm_account: str
    :param enable_regional_mdm_account: Whether the regional MDM account is enabled.
    :type enable_regional_mdm_account: bool
    :param unit: Metric units.
    :type unit: str
    :param dimensions: Metric dimensions.
    :type dimensions: list[~azure.mgmt.synapse.models.OperationMetaMetricDimensionSpecification]
    :param supports_instance_level_aggregation: Whether the metric supports instance-level
     aggregation.
    :type supports_instance_level_aggregation: bool
    :param metric_filter_pattern: Metric filter.
    :type metric_filter_pattern: str
    """

    _attribute_map = {
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[OperationMetaMetricDimensionSpecification]'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_mdm_namespace: Optional[str] = None,
        display_name: Optional[str] = None,
        name: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        display_description: Optional[str] = None,
        source_mdm_account: Optional[str] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        unit: Optional[str] = None,
        dimensions: Optional[List["OperationMetaMetricDimensionSpecification"]] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        metric_filter_pattern: Optional[str] = None,
        **kwargs
    ):
        super(OperationMetaMetricSpecification, self).__init__(**kwargs)
        self.source_mdm_namespace = source_mdm_namespace
        self.display_name = display_name
        self.name = name
        self.aggregation_type = aggregation_type
        self.display_description = display_description
        self.source_mdm_account = source_mdm_account
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.unit = unit
        self.dimensions = dimensions
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.metric_filter_pattern = metric_filter_pattern


class OperationMetaServiceSpecification(msrest.serialization.Model):
    """What is this?.

    :param metric_specifications: Service metric specifications.
    :type metric_specifications: list[~azure.mgmt.synapse.models.OperationMetaMetricSpecification]
    :param log_specifications: Service log specifications.
    :type log_specifications: list[~azure.mgmt.synapse.models.OperationMetaLogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetaMetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[OperationMetaLogSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["OperationMetaMetricSpecification"]] = None,
        log_specifications: Optional[List["OperationMetaLogSpecification"]] = None,
        **kwargs
    ):
        super(OperationMetaServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class OperationResource(msrest.serialization.Model):
    """An operation.

    :param id: Operation ID.
    :type id: str
    :param name: Operation name.
    :type name: str
    :param status: Operation status. Possible values include: "InProgress", "Succeeded", "Failed",
     "Canceled".
    :type status: str or ~azure.mgmt.synapse.models.OperationStatus
    :param properties: Operation properties.
    :type properties: object
    :param error: Errors from the operation.
    :type error: ~azure.mgmt.synapse.models.ErrorDetail
    :param start_time: Operation start time.
    :type start_time: ~datetime.datetime
    :param end_time: Operation start time.
    :type end_time: ~datetime.datetime
    :param percent_complete: Completion percentage of the operation.
    :type percent_complete: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'percentComplete', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "OperationStatus"]] = None,
        properties: Optional[object] = None,
        error: Optional["ErrorDetail"] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        percent_complete: Optional[float] = None,
        **kwargs
    ):
        super(OperationResource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.properties = properties
        self.error = error
        self.start_time = start_time
        self.end_time = end_time
        self.percent_complete = percent_complete


class PrivateEndpoint(msrest.serialization.Model):
    """Private endpoint details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.synapse.models.PrivateEndpoint
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.synapse.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated(msrest.serialization.Model):
    """PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated.

    :param id:
    :type id: str
    :param properties: Properties of a private endpoint connection.
    :type properties: ~azure.mgmt.synapse.models.PrivateEndpointConnectionProperties
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionProperties'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        properties: Optional["PrivateEndpointConnectionProperties"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated, self).__init__(**kwargs)
        self.id = id
        self.properties = properties


class PrivateEndpointConnectionForPrivateLinkHub(PrivateEndpointConnectionForPrivateLinkHubBasicAutoGenerated):
    """PrivateEndpointConnectionForPrivateLinkHub.

    :param id:
    :type id: str
    :param properties: Properties of a private endpoint connection.
    :type properties: ~azure.mgmt.synapse.models.PrivateEndpointConnectionProperties
    :param name:
    :type name: str
    :param type:
    :type type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionProperties'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        properties: Optional["PrivateEndpointConnectionProperties"] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionForPrivateLinkHub, self).__init__(id=id, properties=properties, **kwargs)
        self.name = name
        self.type = type


class PrivateEndpointConnectionForPrivateLinkHubBasic(msrest.serialization.Model):
    """Private Endpoint Connection For Private Link Hub - Basic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: identifier.
    :vartype id: str
    :param private_endpoint: The private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.synapse.models.PrivateEndpoint
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.synapse.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionForPrivateLinkHubBasic, self).__init__(**kwargs)
        self.id = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse(msrest.serialization.Model):
    """PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse.

    :param value:
    :type value: list[~azure.mgmt.synapse.models.PrivateEndpointConnectionForPrivateLinkHub]
    :param next_link:
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnectionForPrivateLinkHub]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnectionForPrivateLinkHub"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateEndpointConnectionList(msrest.serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointConnectionProperties(msrest.serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param private_endpoint: The private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.synapse.models.PrivateEndpoint
    :param private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.synapse.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: Provisioning state of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateLinkHub(TrackedResource):
    """A privateLinkHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param provisioning_state: PrivateLinkHub provisioning state.
    :type provisioning_state: str
    :ivar private_endpoint_connections: List of private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.synapse.models.PrivateEndpointConnectionForPrivateLinkHubBasic]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnectionForPrivateLinkHubBasic]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkHub, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = provisioning_state
        self.private_endpoint_connections = None


class PrivateLinkHubInfoListResult(msrest.serialization.Model):
    """List of privateLinkHubs.

    :param next_link: Link to the next page of results.
    :type next_link: str
    :param value: List of privateLinkHubs.
    :type value: list[~azure.mgmt.synapse.models.PrivateLinkHub]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[PrivateLinkHub]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["PrivateLinkHub"]] = None,
        **kwargs
    ):
        super(PrivateLinkHubInfoListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class PrivateLinkHubPatchInfo(msrest.serialization.Model):
    """PrivateLinkHub patch details.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PrivateLinkHubPatchInfo, self).__init__(**kwargs)
        self.tags = tags


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: The private link resource properties.
    :vartype properties: ~azure.mgmt.synapse.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = None


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """Connection state details of the private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param status: The private link service connection status.
    :type status: str
    :param description: The private link service connection description.
    :type description: str
    :ivar actions_required: The actions required for private link service connection.
    :vartype actions_required: str
    """

    _validation = {
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class PurviewConfiguration(msrest.serialization.Model):
    """Purview Configuration.

    :param purview_resource_id: Purview Resource ID.
    :type purview_resource_id: str
    """

    _attribute_map = {
        'purview_resource_id': {'key': 'purviewResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        purview_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(PurviewConfiguration, self).__init__(**kwargs)
        self.purview_resource_id = purview_resource_id


class QueryInterval(msrest.serialization.Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar interval_start_time: The start time of the measurement interval (ISO8601 format).
    :vartype interval_start_time: ~datetime.datetime
    :ivar execution_count: The number of times the query was executed during this interval.
    :vartype execution_count: int
    :ivar metrics: The list of query metrics during this interval.
    :vartype metrics: list[~azure.mgmt.synapse.models.QueryMetric]
    """

    _validation = {
        'interval_start_time': {'readonly': True},
        'execution_count': {'readonly': True},
        'metrics': {'readonly': True},
    }

    _attribute_map = {
        'interval_start_time': {'key': 'intervalStartTime', 'type': 'iso-8601'},
        'execution_count': {'key': 'executionCount', 'type': 'int'},
        'metrics': {'key': 'metrics', 'type': '[QueryMetric]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryInterval, self).__init__(**kwargs)
        self.interval_start_time = None
        self.execution_count = None
        self.metrics = None


class QueryMetric(msrest.serialization.Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the metric.
    :vartype name: str
    :ivar display_name: The name of the metric for display in user interface.
    :vartype display_name: str
    :ivar unit: The unit of measurement. Possible values include: "percentage", "KB",
     "microseconds".
    :vartype unit: str or ~azure.mgmt.synapse.models.QueryMetricUnit
    :ivar value: The measured value.
    :vartype value: float
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'unit': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryMetric, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.unit = None
        self.value = None


class QueryStatistic(msrest.serialization.Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar query_id: The id of the query.
    :vartype query_id: str
    :ivar intervals: The list of query intervals.
    :vartype intervals: list[~azure.mgmt.synapse.models.QueryInterval]
    """

    _validation = {
        'query_id': {'readonly': True},
        'intervals': {'readonly': True},
    }

    _attribute_map = {
        'query_id': {'key': 'queryId', 'type': 'str'},
        'intervals': {'key': 'intervals', 'type': '[QueryInterval]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryStatistic, self).__init__(**kwargs)
        self.query_id = None
        self.intervals = None


class RecoverableSqlPool(Resource):
    """A recoverable sql pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar edition: The edition of the database.
    :vartype edition: str
    :ivar service_level_objective: The service level objective name of the database.
    :vartype service_level_objective: str
    :ivar elastic_pool_name: The elastic pool name of the database.
    :vartype elastic_pool_name: str
    :ivar last_available_backup_date: The last available backup date of the database (ISO8601
     format).
    :vartype last_available_backup_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'edition': {'readonly': True},
        'service_level_objective': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'last_available_backup_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'service_level_objective': {'key': 'properties.serviceLevelObjective', 'type': 'str'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'last_available_backup_date': {'key': 'properties.lastAvailableBackupDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoverableSqlPool, self).__init__(**kwargs)
        self.edition = None
        self.service_level_objective = None
        self.elastic_pool_name = None
        self.last_available_backup_date = None


class RecoverableSqlPoolListResult(msrest.serialization.Model):
    """The response to a list recoverable sql pools request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of recoverable sql pool.
    :vartype value: list[~azure.mgmt.synapse.models.RecoverableSqlPool]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RecoverableSqlPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoverableSqlPoolListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ReplaceAllFirewallRulesOperationResponse(msrest.serialization.Model):
    """An existing operation for replacing the firewall rules.

    :param operation_id: The operation ID.
    :type operation_id: str
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation_id: Optional[str] = None,
        **kwargs
    ):
        super(ReplaceAllFirewallRulesOperationResponse, self).__init__(**kwargs)
        self.operation_id = operation_id


class ReplaceAllIpFirewallRulesRequest(msrest.serialization.Model):
    """Replace all IP firewall rules request.

    :param ip_firewall_rules: IP firewall rule properties.
    :type ip_firewall_rules: dict[str, ~azure.mgmt.synapse.models.IpFirewallRuleProperties]
    """

    _attribute_map = {
        'ip_firewall_rules': {'key': 'ipFirewallRules', 'type': '{IpFirewallRuleProperties}'},
    }

    def __init__(
        self,
        *,
        ip_firewall_rules: Optional[Dict[str, "IpFirewallRuleProperties"]] = None,
        **kwargs
    ):
        super(ReplaceAllIpFirewallRulesRequest, self).__init__(**kwargs)
        self.ip_firewall_rules = ip_firewall_rules


class ReplicationLink(Resource):
    """Represents a Sql pool replication link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Location of the workspace that contains this firewall rule.
    :vartype location: str
    :ivar is_termination_allowed: Legacy value indicating whether termination is allowed.
     Currently always returns true.
    :vartype is_termination_allowed: bool
    :ivar replication_mode: Replication mode of this replication link.
    :vartype replication_mode: str
    :ivar partner_server: The name of the workspace hosting the partner Sql pool.
    :vartype partner_server: str
    :ivar partner_database: The name of the partner Sql pool.
    :vartype partner_database: str
    :ivar partner_location: The Azure Region of the partner Sql pool.
    :vartype partner_location: str
    :ivar role: The role of the Sql pool in the replication link. Possible values include:
     "Primary", "Secondary", "NonReadableSecondary", "Source", "Copy".
    :vartype role: str or ~azure.mgmt.synapse.models.ReplicationRole
    :ivar partner_role: The role of the partner Sql pool in the replication link. Possible values
     include: "Primary", "Secondary", "NonReadableSecondary", "Source", "Copy".
    :vartype partner_role: str or ~azure.mgmt.synapse.models.ReplicationRole
    :ivar start_time: The start time for the replication link.
    :vartype start_time: ~datetime.datetime
    :ivar percent_complete: The percentage of seeding complete for the replication link.
    :vartype percent_complete: int
    :ivar replication_state: The replication state for the replication link. Possible values
     include: "PENDING", "SEEDING", "CATCH_UP", "SUSPENDED".
    :vartype replication_state: str or ~azure.mgmt.synapse.models.ReplicationState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'is_termination_allowed': {'readonly': True},
        'replication_mode': {'readonly': True},
        'partner_server': {'readonly': True},
        'partner_database': {'readonly': True},
        'partner_location': {'readonly': True},
        'role': {'readonly': True},
        'partner_role': {'readonly': True},
        'start_time': {'readonly': True},
        'percent_complete': {'readonly': True},
        'replication_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'is_termination_allowed': {'key': 'properties.isTerminationAllowed', 'type': 'bool'},
        'replication_mode': {'key': 'properties.replicationMode', 'type': 'str'},
        'partner_server': {'key': 'properties.partnerServer', 'type': 'str'},
        'partner_database': {'key': 'properties.partnerDatabase', 'type': 'str'},
        'partner_location': {'key': 'properties.partnerLocation', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'str'},
        'partner_role': {'key': 'properties.partnerRole', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReplicationLink, self).__init__(**kwargs)
        self.location = None
        self.is_termination_allowed = None
        self.replication_mode = None
        self.partner_server = None
        self.partner_database = None
        self.partner_location = None
        self.role = None
        self.partner_role = None
        self.start_time = None
        self.percent_complete = None
        self.replication_state = None


class ReplicationLinkListResult(msrest.serialization.Model):
    """Represents the response to a List Sql pool replication link request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of Sql pool replication links housed in the Sql pool.
    :type value: list[~azure.mgmt.synapse.models.ReplicationLink]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReplicationLink]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ReplicationLink"]] = None,
        **kwargs
    ):
        super(ReplicationLinkListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class RestorableDroppedSqlPool(Resource):
    """A restorable dropped Sql pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar edition: The edition of the database.
    :vartype edition: str
    :ivar max_size_bytes: The max size in bytes of the database.
    :vartype max_size_bytes: str
    :ivar service_level_objective: The service level objective name of the database.
    :vartype service_level_objective: str
    :ivar elastic_pool_name: The elastic pool name of the database.
    :vartype elastic_pool_name: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar deletion_date: The deletion date of the database (ISO8601 format).
    :vartype deletion_date: ~datetime.datetime
    :ivar earliest_restore_date: The earliest restore date of the database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'database_name': {'readonly': True},
        'edition': {'readonly': True},
        'max_size_bytes': {'readonly': True},
        'service_level_objective': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'creation_date': {'readonly': True},
        'deletion_date': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'str'},
        'service_level_objective': {'key': 'properties.serviceLevelObjective', 'type': 'str'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'deletion_date': {'key': 'properties.deletionDate', 'type': 'iso-8601'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorableDroppedSqlPool, self).__init__(**kwargs)
        self.location = None
        self.database_name = None
        self.edition = None
        self.max_size_bytes = None
        self.service_level_objective = None
        self.elastic_pool_name = None
        self.creation_date = None
        self.deletion_date = None
        self.earliest_restore_date = None


class RestorableDroppedSqlPoolListResult(msrest.serialization.Model):
    """The response to a list restorable dropped Sql pools request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of restorable dropped Sql pools.
    :type value: list[~azure.mgmt.synapse.models.RestorableDroppedSqlPool]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RestorableDroppedSqlPool]'},
    }

    def __init__(
        self,
        *,
        value: List["RestorableDroppedSqlPool"],
        **kwargs
    ):
        super(RestorableDroppedSqlPoolListResult, self).__init__(**kwargs)
        self.value = value


class RestorePoint(Resource):
    """Database restore points.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar restore_point_type: The type of restore point. Possible values include: "CONTINUOUS",
     "DISCRETE".
    :vartype restore_point_type: str or ~azure.mgmt.synapse.models.RestorePointType
    :ivar earliest_restore_date: The earliest time to which this database can be restored.
    :vartype earliest_restore_date: ~datetime.datetime
    :ivar restore_point_creation_date: The time the backup was taken.
    :vartype restore_point_creation_date: ~datetime.datetime
    :ivar restore_point_label: The label of restore point for backup request by user.
    :vartype restore_point_label: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'restore_point_type': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'restore_point_creation_date': {'readonly': True},
        'restore_point_label': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'restore_point_type': {'key': 'properties.restorePointType', 'type': 'str'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'restore_point_creation_date': {'key': 'properties.restorePointCreationDate', 'type': 'iso-8601'},
        'restore_point_label': {'key': 'properties.restorePointLabel', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorePoint, self).__init__(**kwargs)
        self.location = None
        self.restore_point_type = None
        self.earliest_restore_date = None
        self.restore_point_creation_date = None
        self.restore_point_label = None


class RestorePointListResult(msrest.serialization.Model):
    """A list of long term retention backups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.RestorePoint]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RestorePoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorePointListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecretBase(msrest.serialization.Model):
    """The base definition of a secret type.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecureString.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'SecureString': 'SecureString'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretBase, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]


class SecureString(SecretBase):
    """Azure Synapse secure string definition. The string value will be masked with asterisks '*' during Get or List API calls.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the secret.Constant filled by server.
    :type type: str
    :param value: Required. Value of secure string.
    :type value: str
    """

    _validation = {
        'type': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(SecureString, self).__init__(**kwargs)
        self.type = 'SecureString'  # type: str
        self.value = value


class SelfHostedIntegrationRuntime(IntegrationRuntime):
    """Self-hosted integration runtime.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of integration runtime.Constant filled by server.  Possible values
     include: "Managed", "SelfHosted".
    :type type: str or ~azure.mgmt.synapse.models.IntegrationRuntimeType
    :param description: Integration runtime description.
    :type description: str
    :param linked_info: Linked integration runtime type from data factory.
    :type linked_info: ~azure.mgmt.synapse.models.LinkedIntegrationRuntimeType
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'linked_info': {'key': 'typeProperties.linkedInfo', 'type': 'LinkedIntegrationRuntimeType'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        description: Optional[str] = None,
        linked_info: Optional["LinkedIntegrationRuntimeType"] = None,
        **kwargs
    ):
        super(SelfHostedIntegrationRuntime, self).__init__(additional_properties=additional_properties, description=description, **kwargs)
        self.type = 'SelfHosted'  # type: str
        self.linked_info = linked_info


class SelfHostedIntegrationRuntimeNode(msrest.serialization.Model):
    """Properties of Self-hosted integration runtime node.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :ivar node_name: Name of the integration runtime node.
    :vartype node_name: str
    :ivar machine_name: Machine name of the integration runtime node.
    :vartype machine_name: str
    :ivar host_service_uri: URI for the host machine of the integration runtime.
    :vartype host_service_uri: str
    :ivar status: Status of the integration runtime node. Possible values include:
     "NeedRegistration", "Online", "Limited", "Offline", "Upgrading", "Initializing",
     "InitializeFailed".
    :vartype status: str or ~azure.mgmt.synapse.models.SelfHostedIntegrationRuntimeNodeStatus
    :ivar capabilities: The integration runtime capabilities dictionary.
    :vartype capabilities: dict[str, str]
    :ivar version_status: Status of the integration runtime node version.
    :vartype version_status: str
    :ivar version: Version of the integration runtime node.
    :vartype version: str
    :ivar register_time: The time at which the integration runtime node was registered in ISO8601
     format.
    :vartype register_time: ~datetime.datetime
    :ivar last_connect_time: The most recent time at which the integration runtime was connected in
     ISO8601 format.
    :vartype last_connect_time: ~datetime.datetime
    :ivar expiry_time: The time at which the integration runtime will expire in ISO8601 format.
    :vartype expiry_time: ~datetime.datetime
    :ivar last_start_time: The time the node last started up.
    :vartype last_start_time: ~datetime.datetime
    :ivar last_stop_time: The integration runtime node last stop time.
    :vartype last_stop_time: ~datetime.datetime
    :ivar last_update_result: The result of the last integration runtime node update. Possible
     values include: "None", "Succeed", "Fail".
    :vartype last_update_result: str or ~azure.mgmt.synapse.models.IntegrationRuntimeUpdateResult
    :ivar last_start_update_time: The last time for the integration runtime node update start.
    :vartype last_start_update_time: ~datetime.datetime
    :ivar last_end_update_time: The last time for the integration runtime node update end.
    :vartype last_end_update_time: ~datetime.datetime
    :ivar is_active_dispatcher: Indicates whether this node is the active dispatcher for
     integration runtime requests.
    :vartype is_active_dispatcher: bool
    :ivar concurrent_jobs_limit: Maximum concurrent jobs on the integration runtime node.
    :vartype concurrent_jobs_limit: int
    :ivar max_concurrent_jobs: The maximum concurrent jobs in this integration runtime.
    :vartype max_concurrent_jobs: int
    """

    _validation = {
        'node_name': {'readonly': True},
        'machine_name': {'readonly': True},
        'host_service_uri': {'readonly': True},
        'status': {'readonly': True},
        'capabilities': {'readonly': True},
        'version_status': {'readonly': True},
        'version': {'readonly': True},
        'register_time': {'readonly': True},
        'last_connect_time': {'readonly': True},
        'expiry_time': {'readonly': True},
        'last_start_time': {'readonly': True},
        'last_stop_time': {'readonly': True},
        'last_update_result': {'readonly': True},
        'last_start_update_time': {'readonly': True},
        'last_end_update_time': {'readonly': True},
        'is_active_dispatcher': {'readonly': True},
        'concurrent_jobs_limit': {'readonly': True},
        'max_concurrent_jobs': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'node_name': {'key': 'nodeName', 'type': 'str'},
        'machine_name': {'key': 'machineName', 'type': 'str'},
        'host_service_uri': {'key': 'hostServiceUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': '{str}'},
        'version_status': {'key': 'versionStatus', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'register_time': {'key': 'registerTime', 'type': 'iso-8601'},
        'last_connect_time': {'key': 'lastConnectTime', 'type': 'iso-8601'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'last_start_time': {'key': 'lastStartTime', 'type': 'iso-8601'},
        'last_stop_time': {'key': 'lastStopTime', 'type': 'iso-8601'},
        'last_update_result': {'key': 'lastUpdateResult', 'type': 'str'},
        'last_start_update_time': {'key': 'lastStartUpdateTime', 'type': 'iso-8601'},
        'last_end_update_time': {'key': 'lastEndUpdateTime', 'type': 'iso-8601'},
        'is_active_dispatcher': {'key': 'isActiveDispatcher', 'type': 'bool'},
        'concurrent_jobs_limit': {'key': 'concurrentJobsLimit', 'type': 'int'},
        'max_concurrent_jobs': {'key': 'maxConcurrentJobs', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        **kwargs
    ):
        super(SelfHostedIntegrationRuntimeNode, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.node_name = None
        self.machine_name = None
        self.host_service_uri = None
        self.status = None
        self.capabilities = None
        self.version_status = None
        self.version = None
        self.register_time = None
        self.last_connect_time = None
        self.expiry_time = None
        self.last_start_time = None
        self.last_stop_time = None
        self.last_update_result = None
        self.last_start_update_time = None
        self.last_end_update_time = None
        self.is_active_dispatcher = None
        self.concurrent_jobs_limit = None
        self.max_concurrent_jobs = None


class SelfHostedIntegrationRuntimeStatus(IntegrationRuntimeStatus):
    """Self-hosted integration runtime status.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :type additional_properties: dict[str, object]
    :param type: Required. Type of integration runtime.Constant filled by server.  Possible values
     include: "Managed", "SelfHosted".
    :type type: str or ~azure.mgmt.synapse.models.IntegrationRuntimeType
    :ivar data_factory_name: The workspace name which the integration runtime belong to.
    :vartype data_factory_name: str
    :ivar state: The state of integration runtime. Possible values include: "Initial", "Stopped",
     "Started", "Starting", "Stopping", "NeedRegistration", "Online", "Limited", "Offline",
     "AccessDenied".
    :vartype state: str or ~azure.mgmt.synapse.models.IntegrationRuntimeState
    :ivar create_time: The time at which the integration runtime was created, in ISO8601 format.
    :vartype create_time: ~datetime.datetime
    :ivar task_queue_id: The task queue id of the integration runtime.
    :vartype task_queue_id: str
    :ivar node_communication_channel_encryption_mode: The node communication Channel encryption
     mode.
    :vartype node_communication_channel_encryption_mode: str
    :ivar internal_channel_encryption: It is used to set the encryption mode for node-node
     communication channel (when more than 2 self-hosted integration runtime nodes exist). Possible
     values include: "NotSet", "SslEncrypted", "NotEncrypted".
    :vartype internal_channel_encryption: str or
     ~azure.mgmt.synapse.models.IntegrationRuntimeInternalChannelEncryptionMode
    :ivar version: Version of the integration runtime.
    :vartype version: str
    :param nodes: The list of nodes for this integration runtime.
    :type nodes: list[~azure.mgmt.synapse.models.SelfHostedIntegrationRuntimeNode]
    :ivar scheduled_update_date: The date at which the integration runtime will be scheduled to
     update, in ISO8601 format.
    :vartype scheduled_update_date: ~datetime.datetime
    :ivar update_delay_offset: The time in the date scheduled by service to update the integration
     runtime, e.g., PT03H is 3 hours.
    :vartype update_delay_offset: str
    :ivar local_time_zone_offset: The local time zone offset in hours.
    :vartype local_time_zone_offset: str
    :ivar capabilities: Object with additional information about integration runtime capabilities.
    :vartype capabilities: dict[str, str]
    :ivar service_urls: The URLs for the services used in integration runtime backend service.
    :vartype service_urls: list[str]
    :ivar auto_update: Whether Self-hosted integration runtime auto update has been turned on.
     Possible values include: "On", "Off".
    :vartype auto_update: str or ~azure.mgmt.synapse.models.IntegrationRuntimeAutoUpdate
    :ivar version_status: Status of the integration runtime version.
    :vartype version_status: str
    :param links: The list of linked integration runtimes that are created to share with this
     integration runtime.
    :type links: list[~azure.mgmt.synapse.models.LinkedIntegrationRuntime]
    :ivar pushed_version: The version that the integration runtime is going to update to.
    :vartype pushed_version: str
    :ivar latest_version: The latest version on download center.
    :vartype latest_version: str
    :ivar auto_update_eta: The estimated time when the self-hosted integration runtime will be
     updated.
    :vartype auto_update_eta: ~datetime.datetime
    """

    _validation = {
        'type': {'required': True},
        'data_factory_name': {'readonly': True},
        'state': {'readonly': True},
        'create_time': {'readonly': True},
        'task_queue_id': {'readonly': True},
        'node_communication_channel_encryption_mode': {'readonly': True},
        'internal_channel_encryption': {'readonly': True},
        'version': {'readonly': True},
        'scheduled_update_date': {'readonly': True},
        'update_delay_offset': {'readonly': True},
        'local_time_zone_offset': {'readonly': True},
        'capabilities': {'readonly': True},
        'service_urls': {'readonly': True},
        'auto_update': {'readonly': True},
        'version_status': {'readonly': True},
        'pushed_version': {'readonly': True},
        'latest_version': {'readonly': True},
        'auto_update_eta': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'create_time': {'key': 'typeProperties.createTime', 'type': 'iso-8601'},
        'task_queue_id': {'key': 'typeProperties.taskQueueId', 'type': 'str'},
        'node_communication_channel_encryption_mode': {'key': 'typeProperties.nodeCommunicationChannelEncryptionMode', 'type': 'str'},
        'internal_channel_encryption': {'key': 'typeProperties.internalChannelEncryption', 'type': 'str'},
        'version': {'key': 'typeProperties.version', 'type': 'str'},
        'nodes': {'key': 'typeProperties.nodes', 'type': '[SelfHostedIntegrationRuntimeNode]'},
        'scheduled_update_date': {'key': 'typeProperties.scheduledUpdateDate', 'type': 'iso-8601'},
        'update_delay_offset': {'key': 'typeProperties.updateDelayOffset', 'type': 'str'},
        'local_time_zone_offset': {'key': 'typeProperties.localTimeZoneOffset', 'type': 'str'},
        'capabilities': {'key': 'typeProperties.capabilities', 'type': '{str}'},
        'service_urls': {'key': 'typeProperties.serviceUrls', 'type': '[str]'},
        'auto_update': {'key': 'typeProperties.autoUpdate', 'type': 'str'},
        'version_status': {'key': 'typeProperties.versionStatus', 'type': 'str'},
        'links': {'key': 'typeProperties.links', 'type': '[LinkedIntegrationRuntime]'},
        'pushed_version': {'key': 'typeProperties.pushedVersion', 'type': 'str'},
        'latest_version': {'key': 'typeProperties.latestVersion', 'type': 'str'},
        'auto_update_eta': {'key': 'typeProperties.autoUpdateETA', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, object]] = None,
        nodes: Optional[List["SelfHostedIntegrationRuntimeNode"]] = None,
        links: Optional[List["LinkedIntegrationRuntime"]] = None,
        **kwargs
    ):
        super(SelfHostedIntegrationRuntimeStatus, self).__init__(additional_properties=additional_properties, **kwargs)
        self.type = 'SelfHosted'  # type: str
        self.create_time = None
        self.task_queue_id = None
        self.node_communication_channel_encryption_mode = None
        self.internal_channel_encryption = None
        self.version = None
        self.nodes = nodes
        self.scheduled_update_date = None
        self.update_delay_offset = None
        self.local_time_zone_offset = None
        self.capabilities = None
        self.service_urls = None
        self.auto_update = None
        self.version_status = None
        self.links = links
        self.pushed_version = None
        self.latest_version = None
        self.auto_update_eta = None


class SensitivityLabel(Resource):
    """A sensitivity label.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param label_name: The label name.
    :type label_name: str
    :param label_id: The label ID.
    :type label_id: str
    :param information_type: The information type.
    :type information_type: str
    :param information_type_id: The information type ID.
    :type information_type_id: str
    :ivar is_disabled: Is sensitivity recommendation disabled. Applicable for recommended
     sensitivity label only. Specifies whether the sensitivity recommendation on this column is
     disabled (dismissed) or not.
    :vartype is_disabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_disabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'label_name': {'key': 'properties.labelName', 'type': 'str'},
        'label_id': {'key': 'properties.labelId', 'type': 'str'},
        'information_type': {'key': 'properties.informationType', 'type': 'str'},
        'information_type_id': {'key': 'properties.informationTypeId', 'type': 'str'},
        'is_disabled': {'key': 'properties.isDisabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        label_name: Optional[str] = None,
        label_id: Optional[str] = None,
        information_type: Optional[str] = None,
        information_type_id: Optional[str] = None,
        **kwargs
    ):
        super(SensitivityLabel, self).__init__(**kwargs)
        self.label_name = label_name
        self.label_id = label_id
        self.information_type = information_type
        self.information_type_id = information_type_id
        self.is_disabled = None


class SensitivityLabelListResult(msrest.serialization.Model):
    """A list of sensitivity labels.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.SensitivityLabel]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SensitivityLabel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SensitivityLabelListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerBlobAuditingPolicy(Resource):
    """A server blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param state: Specifies the state of the policy. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.synapse.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:
    
    
     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
    
     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:
    
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
    
     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.
    
     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
    
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
    
     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.
    
     For more information, see `Database-Level Audit Action Groups <https://docs.microsoft.com/en-
     us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-
     actions#database-level-audit-action-groups>`_.
    
     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
    
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
    
     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
    
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
    
     For more information, see `Database-Level Audit Actions <https://docs.microsoft.com/en-
     us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-
     actions#database-level-audit-actions>`_.
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and
     'isAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-
     version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
     audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :type queue_delay_ms: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        storage_account_subscription_id: Optional[str] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        **kwargs
    ):
        super(ServerBlobAuditingPolicy, self).__init__(**kwargs)
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.storage_account_subscription_id = storage_account_subscription_id
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms


class ServerBlobAuditingPolicyListResult(msrest.serialization.Model):
    """A list of server auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.ServerBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerBlobAuditingPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerBlobAuditingPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerSecurityAlertPolicy(Resource):
    """Workspace managed Sql server security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific server. Possible values include: "New", "Enabled",
     "Disabled".
    :type state: str or ~azure.mgmt.synapse.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action.
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "SecurityAlertPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        super(ServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time = None


class ServerSecurityAlertPolicyListResult(msrest.serialization.Model):
    """A list of the workspace managed sql server's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.ServerSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerSecurityAlertPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerSecurityAlertPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ServerUsage(msrest.serialization.Model):
    """Represents server metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the server usage metric.
    :vartype name: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar display_name: The metric display name.
    :vartype display_name: str
    :ivar current_value: The current value of the metric.
    :vartype current_value: float
    :ivar limit: The current limit of the metric.
    :vartype limit: float
    :ivar unit: The units of the metric.
    :vartype unit: str
    :ivar next_reset_time: The next reset time for the metric (ISO8601 format).
    :vartype next_reset_time: ~datetime.datetime
    """

    _validation = {
        'name': {'readonly': True},
        'resource_name': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'next_reset_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerUsage, self).__init__(**kwargs)
        self.name = None
        self.resource_name = None
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None
        self.next_reset_time = None


class ServerUsageListResult(msrest.serialization.Model):
    """Represents the response to a list server metrics request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of server metrics for the server.
    :type value: list[~azure.mgmt.synapse.models.ServerUsage]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ServerUsage"],
        **kwargs
    ):
        super(ServerUsageListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServerVulnerabilityAssessment(Resource):
    """A server vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param storage_container_path: A blob storage container path to hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that has read and write
     access to the blob container specified in 'storageContainerPath' parameter. If
     'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the storage account for
     vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
     storageAccountAccessKey is required.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings.
    :type recurring_scans:
     ~azure.mgmt.synapse.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(
        self,
        *,
        storage_container_path: Optional[str] = None,
        storage_container_sas_key: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        recurring_scans: Optional["VulnerabilityAssessmentRecurringScansProperties"] = None,
        **kwargs
    ):
        super(ServerVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.storage_account_access_key = storage_account_access_key
        self.recurring_scans = recurring_scans


class ServerVulnerabilityAssessmentListResult(msrest.serialization.Model):
    """A list of the server's vulnerability assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.ServerVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerVulnerabilityAssessment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerVulnerabilityAssessmentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Sku(msrest.serialization.Model):
    """SQL pool SKU.

    :param tier: The service tier.
    :type tier: str
    :param name: The SKU name.
    :type name: str
    :param capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :type capacity: int
    """

    _attribute_map = {
        'tier': {'key': 'tier', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        tier: Optional[str] = None,
        name: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.tier = tier
        self.name = name
        self.capacity = capacity


class SqlPool(TrackedResource):
    """A SQL Analytics pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param sku: SQL pool SKU.
    :type sku: ~azure.mgmt.synapse.models.Sku
    :param max_size_bytes: Maximum size in bytes.
    :type max_size_bytes: long
    :param collation: Collation mode.
    :type collation: str
    :param source_database_id: Source database to create from.
    :type source_database_id: str
    :param recoverable_database_id: Backup database to restore from.
    :type recoverable_database_id: str
    :param provisioning_state: Resource state.
    :type provisioning_state: str
    :param status: Resource status.
    :type status: str
    :param restore_point_in_time: Snapshot time to restore.
    :type restore_point_in_time: str
    :param create_mode: What is this?.
    :type create_mode: str
    :param creation_date: Date the SQL pool was created.
    :type creation_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        max_size_bytes: Optional[int] = None,
        collation: Optional[str] = None,
        source_database_id: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        status: Optional[str] = None,
        restore_point_in_time: Optional[str] = None,
        create_mode: Optional[str] = None,
        creation_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SqlPool, self).__init__(tags=tags, location=location, **kwargs)
        self.sku = sku
        self.max_size_bytes = max_size_bytes
        self.collation = collation
        self.source_database_id = source_database_id
        self.recoverable_database_id = recoverable_database_id
        self.provisioning_state = provisioning_state
        self.status = status
        self.restore_point_in_time = restore_point_in_time
        self.create_mode = create_mode
        self.creation_date = creation_date


class SqlPoolBlobAuditingPolicy(Resource):
    """A Sql pool blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :param state: Specifies the state of the policy. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Possible values include: "Enabled", "Disabled".
    :type state: str or ~azure.mgmt.synapse.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the auditing storage
     account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey is
     required.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.
    
     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:
    
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
    
     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.
    
     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
    
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
    
     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.
    
     For more information, see `Database-Level Audit Action Groups <https://docs.microsoft.com/en-
     us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-
     actions#database-level-audit-action-groups>`_.
    
     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
    
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
    
     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
    
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
    
     For more information, see `Database-Level Audit Actions <https://docs.microsoft.com/en-
     us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-
     actions#database-level-audit-actions>`_.
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and
     'isAzureMonitorTargetEnabled' as true.
    
     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.
    
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-
     version=2017-05-01-preview
    
     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :type is_azure_monitor_target_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        storage_account_subscription_id: Optional[str] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(SqlPoolBlobAuditingPolicy, self).__init__(**kwargs)
        self.kind = None
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.storage_account_subscription_id = storage_account_subscription_id
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled


class SqlPoolBlobAuditingPolicyListResult(msrest.serialization.Model):
    """A list of Sql pool auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.SqlPoolBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlPoolBlobAuditingPolicy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolBlobAuditingPolicyListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlPoolBlobAuditingPolicySqlPoolOperationListResult(msrest.serialization.Model):
    """The response to a list Sql pool operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.SqlPoolOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlPoolOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolBlobAuditingPolicySqlPoolOperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlPoolColumn(Resource):
    """A Sql pool column resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param column_type: The column data type. Possible values include: "image", "text",
     "uniqueidentifier", "date", "time", "datetime2", "datetimeoffset", "tinyint", "smallint",
     "int", "smalldatetime", "real", "money", "datetime", "float", "sql_variant", "ntext", "bit",
     "decimal", "numeric", "smallmoney", "bigint", "hierarchyid", "geometry", "geography",
     "varbinary", "varchar", "binary", "char", "timestamp", "nvarchar", "nchar", "xml", "sysname".
    :type column_type: str or ~azure.mgmt.synapse.models.ColumnDataType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'column_type': {'key': 'properties.columnType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        column_type: Optional[Union[str, "ColumnDataType"]] = None,
        **kwargs
    ):
        super(SqlPoolColumn, self).__init__(**kwargs)
        self.column_type = column_type


class SqlPoolColumnListResult(msrest.serialization.Model):
    """A list of Sql pool columns.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.SqlPoolColumn]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlPoolColumn]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolColumnListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlPoolConnectionPolicy(Resource):
    """A Sql pool connection policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :param security_enabled_access: The state of security access.
    :type security_enabled_access: str
    :param proxy_dns_name: The fully qualified host name of the auditing proxy.
    :type proxy_dns_name: str
    :param proxy_port: The port number of the auditing proxy.
    :type proxy_port: str
    :param visibility: The visibility of the auditing proxy.
    :type visibility: str
    :param use_server_default: Whether server default is enabled or disabled.
    :type use_server_default: str
    :param redirection_state: The state of proxy redirection.
    :type redirection_state: str
    :param state: The connection policy state.
    :type state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'security_enabled_access': {'key': 'properties.securityEnabledAccess', 'type': 'str'},
        'proxy_dns_name': {'key': 'properties.proxyDnsName', 'type': 'str'},
        'proxy_port': {'key': 'properties.proxyPort', 'type': 'str'},
        'visibility': {'key': 'properties.visibility', 'type': 'str'},
        'use_server_default': {'key': 'properties.useServerDefault', 'type': 'str'},
        'redirection_state': {'key': 'properties.redirectionState', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        security_enabled_access: Optional[str] = None,
        proxy_dns_name: Optional[str] = None,
        proxy_port: Optional[str] = None,
        visibility: Optional[str] = None,
        use_server_default: Optional[str] = None,
        redirection_state: Optional[str] = None,
        state: Optional[str] = None,
        **kwargs
    ):
        super(SqlPoolConnectionPolicy, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.security_enabled_access = security_enabled_access
        self.proxy_dns_name = proxy_dns_name
        self.proxy_port = proxy_port
        self.visibility = visibility
        self.use_server_default = use_server_default
        self.redirection_state = redirection_state
        self.state = state


class SqlPoolInfoListResult(msrest.serialization.Model):
    """List of SQL pools.

    :param next_link: Link to the next page of results.
    :type next_link: str
    :param value: List of SQL pools.
    :type value: list[~azure.mgmt.synapse.models.SqlPool]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[SqlPool]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["SqlPool"]] = None,
        **kwargs
    ):
        super(SqlPoolInfoListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SqlPoolOperation(Resource):
    """A Sql pool operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar database_name: The name of the Sql pool the operation is being performed on.
    :vartype database_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Possible values include: "Pending", "InProgress",
     "Succeeded", "Failed", "CancelInProgress", "Cancelled".
    :vartype state: str or ~azure.mgmt.synapse.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolOperation, self).__init__(**kwargs)
        self.database_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None


class SqlPoolPatchInfo(msrest.serialization.Model):
    """A SQL Analytics pool patch info.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: The geo-location where the resource lives.
    :type location: str
    :param sku: SQL pool SKU.
    :type sku: ~azure.mgmt.synapse.models.Sku
    :param max_size_bytes: Maximum size in bytes.
    :type max_size_bytes: long
    :param collation: Collation mode.
    :type collation: str
    :param source_database_id: Source database to create from.
    :type source_database_id: str
    :param recoverable_database_id: Backup database to restore from.
    :type recoverable_database_id: str
    :param provisioning_state: Resource state.
    :type provisioning_state: str
    :param status: Resource status.
    :type status: str
    :param restore_point_in_time: Snapshot time to restore.
    :type restore_point_in_time: str
    :param create_mode: What is this?.
    :type create_mode: str
    :param creation_date: Date the SQL pool was created.
    :type creation_date: ~datetime.datetime
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        sku: Optional["Sku"] = None,
        max_size_bytes: Optional[int] = None,
        collation: Optional[str] = None,
        source_database_id: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        status: Optional[str] = None,
        restore_point_in_time: Optional[str] = None,
        create_mode: Optional[str] = None,
        creation_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SqlPoolPatchInfo, self).__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.sku = sku
        self.max_size_bytes = max_size_bytes
        self.collation = collation
        self.source_database_id = source_database_id
        self.recoverable_database_id = recoverable_database_id
        self.provisioning_state = provisioning_state
        self.status = status
        self.restore_point_in_time = restore_point_in_time
        self.create_mode = create_mode
        self.creation_date = creation_date


class SqlPoolSchema(Resource):
    """A Sql pool schema resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolSchema, self).__init__(**kwargs)


class SqlPoolSchemaListResult(msrest.serialization.Model):
    """A list of Sql pool schemas.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.Resource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Resource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolSchemaListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlPoolSecurityAlertPolicy(Resource):
    """A Sql pool security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific Sql pool. Possible values include: "New", "Enabled",
     "Disabled".
    :type state: str or ~azure.mgmt.synapse.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action.
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "SecurityAlertPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs
    ):
        super(SqlPoolSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time = None


class SqlPoolTable(Resource):
    """A Sql pool table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolTable, self).__init__(**kwargs)


class SqlPoolTableListResult(msrest.serialization.Model):
    """A list of Sql pool tables.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.Resource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Resource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolTableListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlPoolUsage(msrest.serialization.Model):
    """The Sql pool usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the usage metric.
    :vartype name: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar display_name: The usage metric display name.
    :vartype display_name: str
    :ivar current_value: The current value of the usage metric.
    :vartype current_value: float
    :ivar limit: The current limit of the usage metric.
    :vartype limit: float
    :ivar unit: The units of the usage metric.
    :vartype unit: str
    :ivar next_reset_time: The next reset time for the usage metric (ISO8601 format).
    :vartype next_reset_time: ~datetime.datetime
    """

    _validation = {
        'name': {'readonly': True},
        'resource_name': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'next_reset_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolUsage, self).__init__(**kwargs)
        self.name = None
        self.resource_name = None
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None
        self.next_reset_time = None


class SqlPoolUsageListResult(msrest.serialization.Model):
    """The response to a list Sql pool usages request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of usages for the Sql pool.
    :type value: list[~azure.mgmt.synapse.models.SqlPoolUsage]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlPoolUsage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SqlPoolUsage"],
        **kwargs
    ):
        super(SqlPoolUsageListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SqlPoolVulnerabilityAssessment(Resource):
    """A Sql pool vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param storage_container_path: A blob storage container path to hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level
     vulnerability assessment policy doesn't set.
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that has write access to
     the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey'
     isn't specified, StorageContainerSasKey is required.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the storage account for
     vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
     storageAccountAccessKey is required.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings.
    :type recurring_scans:
     ~azure.mgmt.synapse.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(
        self,
        *,
        storage_container_path: Optional[str] = None,
        storage_container_sas_key: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        recurring_scans: Optional["VulnerabilityAssessmentRecurringScansProperties"] = None,
        **kwargs
    ):
        super(SqlPoolVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.storage_account_access_key = storage_account_access_key
        self.recurring_scans = recurring_scans


class SqlPoolVulnerabilityAssessmentListResult(msrest.serialization.Model):
    """A list of the Sql pool's vulnerability assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.SqlPoolVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SqlPoolVulnerabilityAssessment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolVulnerabilityAssessmentListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SqlPoolVulnerabilityAssessmentRuleBaseline(Resource):
    """A Sql pool vulnerability assessment rule baseline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param baseline_results: The rule baseline result.
    :type baseline_results:
     list[~azure.mgmt.synapse.models.SqlPoolVulnerabilityAssessmentRuleBaselineItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'baseline_results': {'key': 'properties.baselineResults', 'type': '[SqlPoolVulnerabilityAssessmentRuleBaselineItem]'},
    }

    def __init__(
        self,
        *,
        baseline_results: Optional[List["SqlPoolVulnerabilityAssessmentRuleBaselineItem"]] = None,
        **kwargs
    ):
        super(SqlPoolVulnerabilityAssessmentRuleBaseline, self).__init__(**kwargs)
        self.baseline_results = baseline_results


class SqlPoolVulnerabilityAssessmentRuleBaselineItem(msrest.serialization.Model):
    """Properties for an Sql pool vulnerability assessment rule baseline's result.

    All required parameters must be populated in order to send to Azure.

    :param result: Required. The rule baseline result.
    :type result: list[str]
    """

    _validation = {
        'result': {'required': True},
    }

    _attribute_map = {
        'result': {'key': 'result', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        result: List[str],
        **kwargs
    ):
        super(SqlPoolVulnerabilityAssessmentRuleBaselineItem, self).__init__(**kwargs)
        self.result = result


class SqlPoolVulnerabilityAssessmentScansExport(Resource):
    """A Sql pool Vulnerability Assessment scan export resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar exported_report_location: Location of the exported report (e.g.
     https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
    :vartype exported_report_location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'exported_report_location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'exported_report_location': {'key': 'properties.exportedReportLocation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlPoolVulnerabilityAssessmentScansExport, self).__init__(**kwargs)
        self.exported_report_location = None


class SsisObjectMetadata(msrest.serialization.Model):
    """SSIS object metadata.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SsisEnvironment, SsisFolder, SsisPackage, SsisProject.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of metadata.Constant filled by server.  Possible values include:
     "Folder", "Project", "Package", "Environment".
    :type type: str or ~azure.mgmt.synapse.models.SsisObjectMetadataType
    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Environment': 'SsisEnvironment', 'Folder': 'SsisFolder', 'Package': 'SsisPackage', 'Project': 'SsisProject'}
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(SsisObjectMetadata, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.id = id
        self.name = name
        self.description = description


class SsisEnvironment(SsisObjectMetadata):
    """Ssis environment.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of metadata.Constant filled by server.  Possible values include:
     "Folder", "Project", "Package", "Environment".
    :type type: str or ~azure.mgmt.synapse.models.SsisObjectMetadataType
    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param folder_id: Folder id which contains environment.
    :type folder_id: long
    :param variables: Variable in environment.
    :type variables: list[~azure.mgmt.synapse.models.SsisVariable]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'folder_id': {'key': 'folderId', 'type': 'long'},
        'variables': {'key': 'variables', 'type': '[SsisVariable]'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        folder_id: Optional[int] = None,
        variables: Optional[List["SsisVariable"]] = None,
        **kwargs
    ):
        super(SsisEnvironment, self).__init__(id=id, name=name, description=description, **kwargs)
        self.type = 'Environment'  # type: str
        self.folder_id = folder_id
        self.variables = variables


class SsisEnvironmentReference(msrest.serialization.Model):
    """Ssis environment reference.

    :param id: Environment reference id.
    :type id: long
    :param environment_folder_name: Environment folder name.
    :type environment_folder_name: str
    :param environment_name: Environment name.
    :type environment_name: str
    :param reference_type: Reference type.
    :type reference_type: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'environment_folder_name': {'key': 'environmentFolderName', 'type': 'str'},
        'environment_name': {'key': 'environmentName', 'type': 'str'},
        'reference_type': {'key': 'referenceType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        environment_folder_name: Optional[str] = None,
        environment_name: Optional[str] = None,
        reference_type: Optional[str] = None,
        **kwargs
    ):
        super(SsisEnvironmentReference, self).__init__(**kwargs)
        self.id = id
        self.environment_folder_name = environment_folder_name
        self.environment_name = environment_name
        self.reference_type = reference_type


class SsisFolder(SsisObjectMetadata):
    """Ssis folder.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of metadata.Constant filled by server.  Possible values include:
     "Folder", "Project", "Package", "Environment".
    :type type: str or ~azure.mgmt.synapse.models.SsisObjectMetadataType
    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(SsisFolder, self).__init__(id=id, name=name, description=description, **kwargs)
        self.type = 'Folder'  # type: str


class SsisObjectMetadataListResponse(msrest.serialization.Model):
    """A list of SSIS object metadata.

    :param value: List of SSIS object metadata.
    :type value: list[~azure.mgmt.synapse.models.SsisObjectMetadata]
    :param next_link: The link to the next page of results, if any remaining results exist.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SsisObjectMetadata]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SsisObjectMetadata"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SsisObjectMetadataListResponse, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SsisObjectMetadataStatusResponse(msrest.serialization.Model):
    """The status of the operation.

    :param status: The status of the operation.
    :type status: str
    :param name: The operation name.
    :type name: str
    :param properties: The operation properties.
    :type properties: str
    :param error: The operation error message.
    :type error: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        name: Optional[str] = None,
        properties: Optional[str] = None,
        error: Optional[str] = None,
        **kwargs
    ):
        super(SsisObjectMetadataStatusResponse, self).__init__(**kwargs)
        self.status = status
        self.name = name
        self.properties = properties
        self.error = error


class SsisPackage(SsisObjectMetadata):
    """Ssis Package.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of metadata.Constant filled by server.  Possible values include:
     "Folder", "Project", "Package", "Environment".
    :type type: str or ~azure.mgmt.synapse.models.SsisObjectMetadataType
    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param folder_id: Folder id which contains package.
    :type folder_id: long
    :param project_version: Project version which contains package.
    :type project_version: long
    :param project_id: Project id which contains package.
    :type project_id: long
    :param parameters: Parameters in package.
    :type parameters: list[~azure.mgmt.synapse.models.SsisParameter]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'folder_id': {'key': 'folderId', 'type': 'long'},
        'project_version': {'key': 'projectVersion', 'type': 'long'},
        'project_id': {'key': 'projectId', 'type': 'long'},
        'parameters': {'key': 'parameters', 'type': '[SsisParameter]'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        folder_id: Optional[int] = None,
        project_version: Optional[int] = None,
        project_id: Optional[int] = None,
        parameters: Optional[List["SsisParameter"]] = None,
        **kwargs
    ):
        super(SsisPackage, self).__init__(id=id, name=name, description=description, **kwargs)
        self.type = 'Package'  # type: str
        self.folder_id = folder_id
        self.project_version = project_version
        self.project_id = project_id
        self.parameters = parameters


class SsisParameter(msrest.serialization.Model):
    """Ssis parameter.

    :param id: Parameter id.
    :type id: long
    :param name: Parameter name.
    :type name: str
    :param description: Parameter description.
    :type description: str
    :param data_type: Parameter type.
    :type data_type: str
    :param required: Whether parameter is required.
    :type required: bool
    :param sensitive: Whether parameter is sensitive.
    :type sensitive: bool
    :param design_default_value: Design default value of parameter.
    :type design_default_value: str
    :param default_value: Default value of parameter.
    :type default_value: str
    :param sensitive_default_value: Default sensitive value of parameter.
    :type sensitive_default_value: str
    :param value_type: Parameter value type.
    :type value_type: str
    :param value_set: Parameter value set.
    :type value_set: bool
    :param variable: Parameter reference variable.
    :type variable: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
        'sensitive': {'key': 'sensitive', 'type': 'bool'},
        'design_default_value': {'key': 'designDefaultValue', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'sensitive_default_value': {'key': 'sensitiveDefaultValue', 'type': 'str'},
        'value_type': {'key': 'valueType', 'type': 'str'},
        'value_set': {'key': 'valueSet', 'type': 'bool'},
        'variable': {'key': 'variable', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        data_type: Optional[str] = None,
        required: Optional[bool] = None,
        sensitive: Optional[bool] = None,
        design_default_value: Optional[str] = None,
        default_value: Optional[str] = None,
        sensitive_default_value: Optional[str] = None,
        value_type: Optional[str] = None,
        value_set: Optional[bool] = None,
        variable: Optional[str] = None,
        **kwargs
    ):
        super(SsisParameter, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.data_type = data_type
        self.required = required
        self.sensitive = sensitive
        self.design_default_value = design_default_value
        self.default_value = default_value
        self.sensitive_default_value = sensitive_default_value
        self.value_type = value_type
        self.value_set = value_set
        self.variable = variable


class SsisProject(SsisObjectMetadata):
    """Ssis project.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of metadata.Constant filled by server.  Possible values include:
     "Folder", "Project", "Package", "Environment".
    :type type: str or ~azure.mgmt.synapse.models.SsisObjectMetadataType
    :param id: Metadata id.
    :type id: long
    :param name: Metadata name.
    :type name: str
    :param description: Metadata description.
    :type description: str
    :param folder_id: Folder id which contains project.
    :type folder_id: long
    :param version: Project version.
    :type version: long
    :param environment_refs: Environment reference in project.
    :type environment_refs: list[~azure.mgmt.synapse.models.SsisEnvironmentReference]
    :param parameters: Parameters in project.
    :type parameters: list[~azure.mgmt.synapse.models.SsisParameter]
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'folder_id': {'key': 'folderId', 'type': 'long'},
        'version': {'key': 'version', 'type': 'long'},
        'environment_refs': {'key': 'environmentRefs', 'type': '[SsisEnvironmentReference]'},
        'parameters': {'key': 'parameters', 'type': '[SsisParameter]'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        folder_id: Optional[int] = None,
        version: Optional[int] = None,
        environment_refs: Optional[List["SsisEnvironmentReference"]] = None,
        parameters: Optional[List["SsisParameter"]] = None,
        **kwargs
    ):
        super(SsisProject, self).__init__(id=id, name=name, description=description, **kwargs)
        self.type = 'Project'  # type: str
        self.folder_id = folder_id
        self.version = version
        self.environment_refs = environment_refs
        self.parameters = parameters


class SsisVariable(msrest.serialization.Model):
    """Ssis variable.

    :param id: Variable id.
    :type id: long
    :param name: Variable name.
    :type name: str
    :param description: Variable description.
    :type description: str
    :param data_type: Variable type.
    :type data_type: str
    :param sensitive: Whether variable is sensitive.
    :type sensitive: bool
    :param value: Variable value.
    :type value: str
    :param sensitive_value: Variable sensitive value.
    :type sensitive_value: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'sensitive': {'key': 'sensitive', 'type': 'bool'},
        'value': {'key': 'value', 'type': 'str'},
        'sensitive_value': {'key': 'sensitiveValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        data_type: Optional[str] = None,
        sensitive: Optional[bool] = None,
        value: Optional[str] = None,
        sensitive_value: Optional[str] = None,
        **kwargs
    ):
        super(SsisVariable, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.data_type = data_type
        self.sensitive = sensitive
        self.value = value
        self.sensitive_value = sensitive_value


class SubResource(AzureEntityResource):
    """Azure Synapse nested resource, which belongs to a workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)


class TopQueries(msrest.serialization.Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregation_function: The function that is used to aggregate each query's metrics.
     Possible values include: "min", "max", "avg", "sum".
    :vartype aggregation_function: str or ~azure.mgmt.synapse.models.QueryAggregationFunction
    :ivar execution_type: The execution type that is used to filter the query instances that are
     returned. Possible values include: "any", "regular", "irregular", "aborted", "exception".
    :vartype execution_type: str or ~azure.mgmt.synapse.models.QueryExecutionType
    :ivar interval_type: The duration of the interval (ISO8601 duration format).
    :vartype interval_type: str
    :ivar number_of_top_queries: The number of requested queries.
    :vartype number_of_top_queries: int
    :ivar observation_start_time: The start time for queries that are returned (ISO8601 format).
    :vartype observation_start_time: ~datetime.datetime
    :ivar observation_end_time: The end time for queries that are returned (ISO8601 format).
    :vartype observation_end_time: ~datetime.datetime
    :ivar observed_metric: The type of metric to use for ordering the top metrics. Possible values
     include: "cpu", "io", "logio", "duration", "executionCount".
    :vartype observed_metric: str or ~azure.mgmt.synapse.models.QueryObservedMetricType
    :ivar queries: The list of queries.
    :vartype queries: list[~azure.mgmt.synapse.models.QueryStatistic]
    """

    _validation = {
        'aggregation_function': {'readonly': True},
        'execution_type': {'readonly': True},
        'interval_type': {'readonly': True},
        'number_of_top_queries': {'readonly': True},
        'observation_start_time': {'readonly': True},
        'observation_end_time': {'readonly': True},
        'observed_metric': {'readonly': True},
        'queries': {'readonly': True},
    }

    _attribute_map = {
        'aggregation_function': {'key': 'aggregationFunction', 'type': 'str'},
        'execution_type': {'key': 'executionType', 'type': 'str'},
        'interval_type': {'key': 'intervalType', 'type': 'str'},
        'number_of_top_queries': {'key': 'numberOfTopQueries', 'type': 'int'},
        'observation_start_time': {'key': 'observationStartTime', 'type': 'iso-8601'},
        'observation_end_time': {'key': 'observationEndTime', 'type': 'iso-8601'},
        'observed_metric': {'key': 'observedMetric', 'type': 'str'},
        'queries': {'key': 'queries', 'type': '[QueryStatistic]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopQueries, self).__init__(**kwargs)
        self.aggregation_function = None
        self.execution_type = None
        self.interval_type = None
        self.number_of_top_queries = None
        self.observation_start_time = None
        self.observation_end_time = None
        self.observed_metric = None
        self.queries = None


class TopQueriesListResult(msrest.serialization.Model):
    """Represents the response to a get top queries request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of top queries.
    :type value: list[~azure.mgmt.synapse.models.TopQueries]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopQueries]'},
    }

    def __init__(
        self,
        *,
        value: List["TopQueries"],
        **kwargs
    ):
        super(TopQueriesListResult, self).__init__(**kwargs)
        self.value = value


class TransparentDataEncryption(Resource):
    """Represents a Sql pool transparent data encryption configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param status: The status of the database transparent data encryption. Possible values include:
     "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.synapse.models.TransparentDataEncryptionStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "TransparentDataEncryptionStatus"]] = None,
        **kwargs
    ):
        super(TransparentDataEncryption, self).__init__(**kwargs)
        self.location = None
        self.status = status


class TransparentDataEncryptionListResult(msrest.serialization.Model):
    """A list of transparent data encryption configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.TransparentDataEncryption]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TransparentDataEncryption]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TransparentDataEncryptionListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class UpdateIntegrationRuntimeNodeRequest(msrest.serialization.Model):
    """Update integration runtime node request.

    :param concurrent_jobs_limit: The number of concurrent jobs permitted to run on the integration
     runtime node. Values between 1 and maxConcurrentJobs(inclusive) are allowed.
    :type concurrent_jobs_limit: int
    """

    _validation = {
        'concurrent_jobs_limit': {'minimum': 1},
    }

    _attribute_map = {
        'concurrent_jobs_limit': {'key': 'concurrentJobsLimit', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        concurrent_jobs_limit: Optional[int] = None,
        **kwargs
    ):
        super(UpdateIntegrationRuntimeNodeRequest, self).__init__(**kwargs)
        self.concurrent_jobs_limit = concurrent_jobs_limit


class UpdateIntegrationRuntimeRequest(msrest.serialization.Model):
    """Update integration runtime request.

    :param auto_update: Enables or disables the auto-update feature of the self-hosted integration
     runtime. See https://go.microsoft.com/fwlink/?linkid=854189. Possible values include: "On",
     "Off".
    :type auto_update: str or ~azure.mgmt.synapse.models.IntegrationRuntimeAutoUpdate
    :param update_delay_offset: The time offset (in hours) in the day, e.g., PT03H is 3 hours. The
     integration runtime auto update will happen on that time.
    :type update_delay_offset: str
    """

    _attribute_map = {
        'auto_update': {'key': 'autoUpdate', 'type': 'str'},
        'update_delay_offset': {'key': 'updateDelayOffset', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auto_update: Optional[Union[str, "IntegrationRuntimeAutoUpdate"]] = None,
        update_delay_offset: Optional[str] = None,
        **kwargs
    ):
        super(UpdateIntegrationRuntimeRequest, self).__init__(**kwargs)
        self.auto_update = auto_update
        self.update_delay_offset = update_delay_offset


class VirtualNetworkProfile(msrest.serialization.Model):
    """Virtual Network Profile.

    :param compute_subnet_id: Subnet ID used for computes in workspace.
    :type compute_subnet_id: str
    """

    _attribute_map = {
        'compute_subnet_id': {'key': 'computeSubnetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        compute_subnet_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkProfile, self).__init__(**kwargs)
        self.compute_subnet_id = compute_subnet_id


class VulnerabilityAssessmentRecurringScansProperties(msrest.serialization.Model):
    """Properties of a Vulnerability Assessment recurring scans.

    :param is_enabled: Recurring scans state.
    :type is_enabled: bool
    :param email_subscription_admins: Specifies that the schedule scan notification will be is sent
     to the subscription administrators.
    :type email_subscription_admins: bool
    :param emails: Specifies an array of e-mail addresses to which the scan notification is sent.
    :type emails: list[str]
    """

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'email_subscription_admins': {'key': 'emailSubscriptionAdmins', 'type': 'bool'},
        'emails': {'key': 'emails', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        email_subscription_admins: Optional[bool] = True,
        emails: Optional[List[str]] = None,
        **kwargs
    ):
        super(VulnerabilityAssessmentRecurringScansProperties, self).__init__(**kwargs)
        self.is_enabled = is_enabled
        self.email_subscription_admins = email_subscription_admins
        self.emails = emails


class VulnerabilityAssessmentScanError(msrest.serialization.Model):
    """Properties of a vulnerability assessment scan error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VulnerabilityAssessmentScanError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class VulnerabilityAssessmentScanRecord(Resource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar scan_id: The scan ID.
    :vartype scan_id: str
    :ivar trigger_type: The scan trigger type. Possible values include: "OnDemand", "Recurring".
    :vartype trigger_type: str or ~azure.mgmt.synapse.models.VulnerabilityAssessmentScanTriggerType
    :ivar state: The scan status. Possible values include: "Passed", "Failed", "FailedToRun",
     "InProgress".
    :vartype state: str or ~azure.mgmt.synapse.models.VulnerabilityAssessmentScanState
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The scan end time (UTC).
    :vartype end_time: ~datetime.datetime
    :ivar errors: The scan errors.
    :vartype errors: list[~azure.mgmt.synapse.models.VulnerabilityAssessmentScanError]
    :ivar storage_container_path: The scan results storage container path.
    :vartype storage_container_path: str
    :ivar number_of_failed_security_checks: The number of failed security checks.
    :vartype number_of_failed_security_checks: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scan_id': {'readonly': True},
        'trigger_type': {'readonly': True},
        'state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'errors': {'readonly': True},
        'storage_container_path': {'readonly': True},
        'number_of_failed_security_checks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scan_id': {'key': 'properties.scanId', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'errors': {'key': 'properties.errors', 'type': '[VulnerabilityAssessmentScanError]'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'number_of_failed_security_checks': {'key': 'properties.numberOfFailedSecurityChecks', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VulnerabilityAssessmentScanRecord, self).__init__(**kwargs)
        self.scan_id = None
        self.trigger_type = None
        self.state = None
        self.start_time = None
        self.end_time = None
        self.errors = None
        self.storage_container_path = None
        self.number_of_failed_security_checks = None


class VulnerabilityAssessmentScanRecordListResult(msrest.serialization.Model):
    """A list of vulnerability assessment scan records.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.VulnerabilityAssessmentScanRecord]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VulnerabilityAssessmentScanRecord]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VulnerabilityAssessmentScanRecordListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadClassifier(Resource):
    """Workload classifier operations for a data warehouse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param member_name: The workload classifier member name.
    :type member_name: str
    :param label: The workload classifier label.
    :type label: str
    :param context: The workload classifier context.
    :type context: str
    :param start_time: The workload classifier start time for classification.
    :type start_time: str
    :param end_time: The workload classifier end time for classification.
    :type end_time: str
    :param importance: The workload classifier importance.
    :type importance: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'member_name': {'key': 'properties.memberName', 'type': 'str'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'context': {'key': 'properties.context', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'str'},
        'importance': {'key': 'properties.importance', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        member_name: Optional[str] = None,
        label: Optional[str] = None,
        context: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        importance: Optional[str] = None,
        **kwargs
    ):
        super(WorkloadClassifier, self).__init__(**kwargs)
        self.member_name = member_name
        self.label = label
        self.context = context
        self.start_time = start_time
        self.end_time = end_time
        self.importance = importance


class WorkloadClassifierListResult(msrest.serialization.Model):
    """A list of workload classifiers for a workload group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.WorkloadClassifier]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadClassifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadClassifierListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class WorkloadGroup(Resource):
    """Workload group operations for a sql pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param min_resource_percent: The workload group minimum percentage resource.
    :type min_resource_percent: int
    :param max_resource_percent: The workload group cap percentage resource.
    :type max_resource_percent: int
    :param min_resource_percent_per_request: The workload group request minimum grant percentage.
    :type min_resource_percent_per_request: float
    :param max_resource_percent_per_request: The workload group request maximum grant percentage.
    :type max_resource_percent_per_request: float
    :param importance: The workload group importance level.
    :type importance: str
    :param query_execution_timeout: The workload group query execution timeout.
    :type query_execution_timeout: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'min_resource_percent': {'key': 'properties.minResourcePercent', 'type': 'int'},
        'max_resource_percent': {'key': 'properties.maxResourcePercent', 'type': 'int'},
        'min_resource_percent_per_request': {'key': 'properties.minResourcePercentPerRequest', 'type': 'float'},
        'max_resource_percent_per_request': {'key': 'properties.maxResourcePercentPerRequest', 'type': 'float'},
        'importance': {'key': 'properties.importance', 'type': 'str'},
        'query_execution_timeout': {'key': 'properties.queryExecutionTimeout', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min_resource_percent: Optional[int] = None,
        max_resource_percent: Optional[int] = None,
        min_resource_percent_per_request: Optional[float] = None,
        max_resource_percent_per_request: Optional[float] = None,
        importance: Optional[str] = None,
        query_execution_timeout: Optional[int] = None,
        **kwargs
    ):
        super(WorkloadGroup, self).__init__(**kwargs)
        self.min_resource_percent = min_resource_percent
        self.max_resource_percent = max_resource_percent
        self.min_resource_percent_per_request = min_resource_percent_per_request
        self.max_resource_percent_per_request = max_resource_percent_per_request
        self.importance = importance
        self.query_execution_timeout = query_execution_timeout


class WorkloadGroupListResult(msrest.serialization.Model):
    """A list of workload groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.synapse.models.WorkloadGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkloadGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkloadGroupListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Workspace(TrackedResource):
    """A workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: Identity of the workspace.
    :type identity: ~azure.mgmt.synapse.models.ManagedIdentity
    :param default_data_lake_storage: Workspace default data lake storage account details.
    :type default_data_lake_storage: ~azure.mgmt.synapse.models.DataLakeStorageAccountDetails
    :param sql_administrator_login_password: SQL administrator login password.
    :type sql_administrator_login_password: str
    :param managed_resource_group_name: Workspace managed resource group. The resource group name
     uniquely identifies the resource group within the user subscriptionId. The resource group name
     must be no longer than 90 characters long, and must be alphanumeric characters
     (Char.IsLetterOrDigit()) and '-', '_', '(', ')' and'.'. Note that the name cannot end with '.'.
    :type managed_resource_group_name: str
    :ivar provisioning_state: Resource provisioning state.
    :vartype provisioning_state: str
    :param sql_administrator_login: Login for workspace SQL active directory administrator.
    :type sql_administrator_login: str
    :param virtual_network_profile: Virtual Network profile.
    :type virtual_network_profile: ~azure.mgmt.synapse.models.VirtualNetworkProfile
    :param connectivity_endpoints: Connectivity endpoints.
    :type connectivity_endpoints: dict[str, str]
    :param managed_virtual_network: Setting this to 'default' will ensure that all compute for this
     workspace is in a virtual network managed on behalf of the user.
    :type managed_virtual_network: str
    :param private_endpoint_connections: Private endpoint connections to the workspace.
    :type private_endpoint_connections: list[~azure.mgmt.synapse.models.PrivateEndpointConnection]
    :param encryption: The encryption details of the workspace.
    :type encryption: ~azure.mgmt.synapse.models.EncryptionDetails
    :ivar workspace_uid: The workspace unique identifier.
    :vartype workspace_uid: str
    :ivar extra_properties: Workspace level configs and feature flags.
    :vartype extra_properties: dict[str, object]
    :param managed_virtual_network_settings: Managed Virtual Network Settings.
    :type managed_virtual_network_settings:
     ~azure.mgmt.synapse.models.ManagedVirtualNetworkSettings
    :param workspace_repository_configuration: Git integration settings.
    :type workspace_repository_configuration:
     ~azure.mgmt.synapse.models.WorkspaceRepositoryConfiguration
    :param purview_configuration: Purview Configuration.
    :type purview_configuration: ~azure.mgmt.synapse.models.PurviewConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'workspace_uid': {'readonly': True},
        'extra_properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'default_data_lake_storage': {'key': 'properties.defaultDataLakeStorage', 'type': 'DataLakeStorageAccountDetails'},
        'sql_administrator_login_password': {'key': 'properties.sqlAdministratorLoginPassword', 'type': 'str'},
        'managed_resource_group_name': {'key': 'properties.managedResourceGroupName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sql_administrator_login': {'key': 'properties.sqlAdministratorLogin', 'type': 'str'},
        'virtual_network_profile': {'key': 'properties.virtualNetworkProfile', 'type': 'VirtualNetworkProfile'},
        'connectivity_endpoints': {'key': 'properties.connectivityEndpoints', 'type': '{str}'},
        'managed_virtual_network': {'key': 'properties.managedVirtualNetwork', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionDetails'},
        'workspace_uid': {'key': 'properties.workspaceUID', 'type': 'str'},
        'extra_properties': {'key': 'properties.extraProperties', 'type': '{object}'},
        'managed_virtual_network_settings': {'key': 'properties.managedVirtualNetworkSettings', 'type': 'ManagedVirtualNetworkSettings'},
        'workspace_repository_configuration': {'key': 'properties.workspaceRepositoryConfiguration', 'type': 'WorkspaceRepositoryConfiguration'},
        'purview_configuration': {'key': 'properties.purviewConfiguration', 'type': 'PurviewConfiguration'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedIdentity"] = None,
        default_data_lake_storage: Optional["DataLakeStorageAccountDetails"] = None,
        sql_administrator_login_password: Optional[str] = None,
        managed_resource_group_name: Optional[str] = None,
        sql_administrator_login: Optional[str] = None,
        virtual_network_profile: Optional["VirtualNetworkProfile"] = None,
        connectivity_endpoints: Optional[Dict[str, str]] = None,
        managed_virtual_network: Optional[str] = None,
        private_endpoint_connections: Optional[List["PrivateEndpointConnection"]] = None,
        encryption: Optional["EncryptionDetails"] = None,
        managed_virtual_network_settings: Optional["ManagedVirtualNetworkSettings"] = None,
        workspace_repository_configuration: Optional["WorkspaceRepositoryConfiguration"] = None,
        purview_configuration: Optional["PurviewConfiguration"] = None,
        **kwargs
    ):
        super(Workspace, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.default_data_lake_storage = default_data_lake_storage
        self.sql_administrator_login_password = sql_administrator_login_password
        self.managed_resource_group_name = managed_resource_group_name
        self.provisioning_state = None
        self.sql_administrator_login = sql_administrator_login
        self.virtual_network_profile = virtual_network_profile
        self.connectivity_endpoints = connectivity_endpoints
        self.managed_virtual_network = managed_virtual_network
        self.private_endpoint_connections = private_endpoint_connections
        self.encryption = encryption
        self.workspace_uid = None
        self.extra_properties = None
        self.managed_virtual_network_settings = managed_virtual_network_settings
        self.workspace_repository_configuration = workspace_repository_configuration
        self.purview_configuration = purview_configuration


class WorkspaceAadAdminInfo(Resource):
    """Workspace active directory administrator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tenant_id: Tenant ID of the workspace active directory administrator.
    :type tenant_id: str
    :param login: Login of the workspace active directory administrator.
    :type login: str
    :param administrator_type: Workspace active directory administrator type.
    :type administrator_type: str
    :param sid: Object ID of the workspace active directory administrator.
    :type sid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        login: Optional[str] = None,
        administrator_type: Optional[str] = None,
        sid: Optional[str] = None,
        **kwargs
    ):
        super(WorkspaceAadAdminInfo, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.login = login
        self.administrator_type = administrator_type
        self.sid = sid


class WorkspaceInfoListResult(msrest.serialization.Model):
    """List of workspaces.

    :param next_link: Link to the next page of results.
    :type next_link: str
    :param value: List of workspaces.
    :type value: list[~azure.mgmt.synapse.models.Workspace]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Workspace]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["Workspace"]] = None,
        **kwargs
    ):
        super(WorkspaceInfoListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class WorkspaceKeyDetails(msrest.serialization.Model):
    """Details of the customer managed key associated with the workspace.

    :param name: Workspace Key sub-resource name.
    :type name: str
    :param key_vault_url: Workspace Key sub-resource key vault url.
    :type key_vault_url: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'key_vault_url': {'key': 'keyVaultUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        key_vault_url: Optional[str] = None,
        **kwargs
    ):
        super(WorkspaceKeyDetails, self).__init__(**kwargs)
        self.name = name
        self.key_vault_url = key_vault_url


class WorkspacePatchInfo(msrest.serialization.Model):
    """Workspace patch details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The identity of the workspace.
    :type identity: ~azure.mgmt.synapse.models.ManagedIdentity
    :param sql_administrator_login_password: SQL administrator login password.
    :type sql_administrator_login_password: str
    :param managed_virtual_network_settings: Managed Virtual Network Settings.
    :type managed_virtual_network_settings:
     ~azure.mgmt.synapse.models.ManagedVirtualNetworkSettings
    :param workspace_repository_configuration: Git integration settings.
    :type workspace_repository_configuration:
     ~azure.mgmt.synapse.models.WorkspaceRepositoryConfiguration
    :param purview_configuration: Purview Configuration.
    :type purview_configuration: ~azure.mgmt.synapse.models.PurviewConfiguration
    :ivar provisioning_state: Resource provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'sql_administrator_login_password': {'key': 'properties.sqlAdministratorLoginPassword', 'type': 'str'},
        'managed_virtual_network_settings': {'key': 'properties.managedVirtualNetworkSettings', 'type': 'ManagedVirtualNetworkSettings'},
        'workspace_repository_configuration': {'key': 'properties.workspaceRepositoryConfiguration', 'type': 'WorkspaceRepositoryConfiguration'},
        'purview_configuration': {'key': 'properties.purviewConfiguration', 'type': 'PurviewConfiguration'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ManagedIdentity"] = None,
        sql_administrator_login_password: Optional[str] = None,
        managed_virtual_network_settings: Optional["ManagedVirtualNetworkSettings"] = None,
        workspace_repository_configuration: Optional["WorkspaceRepositoryConfiguration"] = None,
        purview_configuration: Optional["PurviewConfiguration"] = None,
        **kwargs
    ):
        super(WorkspacePatchInfo, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.sql_administrator_login_password = sql_administrator_login_password
        self.managed_virtual_network_settings = managed_virtual_network_settings
        self.workspace_repository_configuration = workspace_repository_configuration
        self.purview_configuration = purview_configuration
        self.provisioning_state = None


class WorkspaceRepositoryConfiguration(msrest.serialization.Model):
    """Git integration settings.

    :param type: Type of workspace repositoryID configuration. Example WorkspaceVSTSConfiguration,
     WorkspaceGitHubConfiguration.
    :type type: str
    :param host_name: GitHub Enterprise host name. For example: https://github.mydomain.com.
    :type host_name: str
    :param account_name: Account name.
    :type account_name: str
    :param project_name: VSTS project name.
    :type project_name: str
    :param repository_name: Repository name.
    :type repository_name: str
    :param collaboration_branch: Collaboration branch.
    :type collaboration_branch: str
    :param root_folder: Root folder to use in the repository.
    :type root_folder: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'project_name': {'key': 'projectName', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'collaboration_branch': {'key': 'collaborationBranch', 'type': 'str'},
        'root_folder': {'key': 'rootFolder', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        host_name: Optional[str] = None,
        account_name: Optional[str] = None,
        project_name: Optional[str] = None,
        repository_name: Optional[str] = None,
        collaboration_branch: Optional[str] = None,
        root_folder: Optional[str] = None,
        **kwargs
    ):
        super(WorkspaceRepositoryConfiguration, self).__init__(**kwargs)
        self.type = type
        self.host_name = host_name
        self.account_name = account_name
        self.project_name = project_name
        self.repository_name = repository_name
        self.collaboration_branch = collaboration_branch
        self.root_folder = root_folder
