# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import unittest

import swagger_client
from swagger_client.api.users_api import UsersApi  # noqa: E501
from swagger_client.rest import ApiException


class TestUsersApi(unittest.TestCase):
    """UsersApi unit test stubs"""

    def setUp(self):
        self.api = UsersApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_accept_container_invite(self):
        """Test case for accept_container_invite

        AcceptContainerInvite  # noqa: E501
        """
        pass

    def test_assign_user_role(self):
        """Test case for assign_user_role

        AssignUserRole  # noqa: E501
        """
        pass

    def test_delete_user(self):
        """Test case for delete_user

        DeleteUser  # noqa: E501
        """
        pass

    def test_invite_user_to_container(self):
        """Test case for invite_user_to_container

        InviteUserToContainer  # noqa: E501
        """
        pass

    def test_list_invited_users_for_container(self):
        """Test case for list_invited_users_for_container

        ListInvitedUsersForContainer  # noqa: E501
        """
        pass

    def test_list_outstanding_invites(self):
        """Test case for list_outstanding_invites

        ListOutstandingInvites  # noqa: E501
        """
        pass

    def test_list_user_permissions(self):
        """Test case for list_user_permissions

        ListUserPermissions  # noqa: E501
        """
        pass

    def test_list_users(self):
        """Test case for list_users

        ListUsers  # noqa: E501
        """
        pass

    def test_list_users_for_container(self):
        """Test case for list_users_for_container

        ListUsersForContainer  # noqa: E501
        """
        pass

    def test_list_users_roles(self):
        """Test case for list_users_roles

        ListUsersRoles  # noqa: E501
        """
        pass

    def test_retrieve_user(self):
        """Test case for retrieve_user

        RetrieveUser  # noqa: E501
        """
        pass

    def test_update_user(self):
        """Test case for update_user

        UpdateUser  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
