# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TypeMapping(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'active': 'bool',
        'id': 'str',
        'container_id': 'str',
        'data_source_id': 'str',
        'shape_hash': 'str',
        'created_at': 'str',
        'modified_at': 'str',
        'sample_payload': 'object',
        'created_by': 'str',
        'modified_by': 'str',
        'transformations': 'list[Transformation]',
        'resulting_metatype_name': 'str',
        'resulting_metatype_relationship_name': 'str'
    }

    attribute_map = {
        'active': 'active',
        'id': 'id',
        'container_id': 'container_id',
        'data_source_id': 'data_source_id',
        'shape_hash': 'shape_hash',
        'created_at': 'created_at',
        'modified_at': 'modified_at',
        'sample_payload': 'sample_payload',
        'created_by': 'created_by',
        'modified_by': 'modified_by',
        'transformations': 'transformations',
        'resulting_metatype_name': 'resulting_metatype_name',
        'resulting_metatype_relationship_name': 'resulting_metatype_relationship_name'
    }

    def __init__(self, active=None, id=None, container_id=None, data_source_id=None, shape_hash=None, created_at=None, modified_at=None, sample_payload=None, created_by=None, modified_by=None, transformations=None, resulting_metatype_name=None, resulting_metatype_relationship_name=None):  # noqa: E501
        """TypeMapping - a model defined in Swagger"""  # noqa: E501
        self._active = None
        self._id = None
        self._container_id = None
        self._data_source_id = None
        self._shape_hash = None
        self._created_at = None
        self._modified_at = None
        self._sample_payload = None
        self._created_by = None
        self._modified_by = None
        self._transformations = None
        self._resulting_metatype_name = None
        self._resulting_metatype_relationship_name = None
        self.discriminator = None
        self.active = active
        if id is not None:
            self.id = id
        if container_id is not None:
            self.container_id = container_id
        if data_source_id is not None:
            self.data_source_id = data_source_id
        self.shape_hash = shape_hash
        if created_at is not None:
            self.created_at = created_at
        if modified_at is not None:
            self.modified_at = modified_at
        self.sample_payload = sample_payload
        if created_by is not None:
            self.created_by = created_by
        if modified_by is not None:
            self.modified_by = modified_by
        if transformations is not None:
            self.transformations = transformations
        if resulting_metatype_name is not None:
            self.resulting_metatype_name = resulting_metatype_name
        if resulting_metatype_relationship_name is not None:
            self.resulting_metatype_relationship_name = resulting_metatype_relationship_name

    @property
    def active(self):
        """Gets the active of this TypeMapping.  # noqa: E501


        :return: The active of this TypeMapping.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this TypeMapping.


        :param active: The active of this TypeMapping.  # noqa: E501
        :type: bool
        """
        if active is None:
            raise ValueError("Invalid value for `active`, must not be `None`")  # noqa: E501

        self._active = active

    @property
    def id(self):
        """Gets the id of this TypeMapping.  # noqa: E501


        :return: The id of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TypeMapping.


        :param id: The id of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def container_id(self):
        """Gets the container_id of this TypeMapping.  # noqa: E501


        :return: The container_id of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this TypeMapping.


        :param container_id: The container_id of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._container_id = container_id

    @property
    def data_source_id(self):
        """Gets the data_source_id of this TypeMapping.  # noqa: E501


        :return: The data_source_id of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this TypeMapping.


        :param data_source_id: The data_source_id of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._data_source_id = data_source_id

    @property
    def shape_hash(self):
        """Gets the shape_hash of this TypeMapping.  # noqa: E501


        :return: The shape_hash of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._shape_hash

    @shape_hash.setter
    def shape_hash(self, shape_hash):
        """Sets the shape_hash of this TypeMapping.


        :param shape_hash: The shape_hash of this TypeMapping.  # noqa: E501
        :type: str
        """
        if shape_hash is None:
            raise ValueError("Invalid value for `shape_hash`, must not be `None`")  # noqa: E501

        self._shape_hash = shape_hash

    @property
    def created_at(self):
        """Gets the created_at of this TypeMapping.  # noqa: E501


        :return: The created_at of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this TypeMapping.


        :param created_at: The created_at of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this TypeMapping.  # noqa: E501


        :return: The modified_at of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this TypeMapping.


        :param modified_at: The modified_at of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._modified_at = modified_at

    @property
    def sample_payload(self):
        """Gets the sample_payload of this TypeMapping.  # noqa: E501


        :return: The sample_payload of this TypeMapping.  # noqa: E501
        :rtype: object
        """
        return self._sample_payload

    @sample_payload.setter
    def sample_payload(self, sample_payload):
        """Sets the sample_payload of this TypeMapping.


        :param sample_payload: The sample_payload of this TypeMapping.  # noqa: E501
        :type: object
        """
        if sample_payload is None:
            raise ValueError("Invalid value for `sample_payload`, must not be `None`")  # noqa: E501

        self._sample_payload = sample_payload

    @property
    def created_by(self):
        """Gets the created_by of this TypeMapping.  # noqa: E501


        :return: The created_by of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this TypeMapping.


        :param created_by: The created_by of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def modified_by(self):
        """Gets the modified_by of this TypeMapping.  # noqa: E501


        :return: The modified_by of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """Sets the modified_by of this TypeMapping.


        :param modified_by: The modified_by of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._modified_by = modified_by

    @property
    def transformations(self):
        """Gets the transformations of this TypeMapping.  # noqa: E501


        :return: The transformations of this TypeMapping.  # noqa: E501
        :rtype: list[Transformation]
        """
        return self._transformations

    @transformations.setter
    def transformations(self, transformations):
        """Sets the transformations of this TypeMapping.


        :param transformations: The transformations of this TypeMapping.  # noqa: E501
        :type: list[Transformation]
        """

        self._transformations = transformations

    @property
    def resulting_metatype_name(self):
        """Gets the resulting_metatype_name of this TypeMapping.  # noqa: E501


        :return: The resulting_metatype_name of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._resulting_metatype_name

    @resulting_metatype_name.setter
    def resulting_metatype_name(self, resulting_metatype_name):
        """Sets the resulting_metatype_name of this TypeMapping.


        :param resulting_metatype_name: The resulting_metatype_name of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._resulting_metatype_name = resulting_metatype_name

    @property
    def resulting_metatype_relationship_name(self):
        """Gets the resulting_metatype_relationship_name of this TypeMapping.  # noqa: E501


        :return: The resulting_metatype_relationship_name of this TypeMapping.  # noqa: E501
        :rtype: str
        """
        return self._resulting_metatype_relationship_name

    @resulting_metatype_relationship_name.setter
    def resulting_metatype_relationship_name(self, resulting_metatype_relationship_name):
        """Sets the resulting_metatype_relationship_name of this TypeMapping.


        :param resulting_metatype_relationship_name: The resulting_metatype_relationship_name of this TypeMapping.  # noqa: E501
        :type: str
        """

        self._resulting_metatype_relationship_name = resulting_metatype_relationship_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TypeMapping, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TypeMapping):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
