# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Transformation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'conditions': 'list[TransformationCondition]',
        'keys': 'list[TransformationKey]',
        'id': 'str',
        'type_mapping_id': 'str',
        'metatype_id': 'str',
        'metatype_relationship_pair_id': 'str',
        'origin_id_key': 'str',
        'destination_id_key': 'str',
        'unique_identifier_key': 'str',
        'root_array': 'str',
        'created_at': 'str',
        'modified_at': 'str',
        'created_by': 'str',
        'modified_by': 'str',
        'archived': 'bool',
        'metatype_name': 'str',
        'metatype_relationship_pair_name': 'str',
        'container_id': 'str',
        'shape_hash': 'str',
        'data_source_id': 'str'
    }

    attribute_map = {
        'conditions': 'conditions',
        'keys': 'keys',
        'id': 'id',
        'type_mapping_id': 'type_mapping_id',
        'metatype_id': 'metatype_id',
        'metatype_relationship_pair_id': 'metatype_relationship_pair_id',
        'origin_id_key': 'origin_id_key',
        'destination_id_key': 'destination_id_key',
        'unique_identifier_key': 'unique_identifier_key',
        'root_array': 'root_array',
        'created_at': 'created_at',
        'modified_at': 'modified_at',
        'created_by': 'created_by',
        'modified_by': 'modified_by',
        'archived': 'archived',
        'metatype_name': 'metatype_name',
        'metatype_relationship_pair_name': 'metatype_relationship_pair_name',
        'container_id': 'container_id',
        'shape_hash': 'shape_hash',
        'data_source_id': 'data_source_id'
    }

    def __init__(self, conditions=None, keys=None, id=None, type_mapping_id=None, metatype_id=None, metatype_relationship_pair_id=None, origin_id_key=None, destination_id_key=None, unique_identifier_key=None, root_array=None, created_at=None, modified_at=None, created_by=None, modified_by=None, archived=None, metatype_name=None, metatype_relationship_pair_name=None, container_id=None, shape_hash=None, data_source_id=None):  # noqa: E501
        """Transformation - a model defined in Swagger"""  # noqa: E501
        self._conditions = None
        self._keys = None
        self._id = None
        self._type_mapping_id = None
        self._metatype_id = None
        self._metatype_relationship_pair_id = None
        self._origin_id_key = None
        self._destination_id_key = None
        self._unique_identifier_key = None
        self._root_array = None
        self._created_at = None
        self._modified_at = None
        self._created_by = None
        self._modified_by = None
        self._archived = None
        self._metatype_name = None
        self._metatype_relationship_pair_name = None
        self._container_id = None
        self._shape_hash = None
        self._data_source_id = None
        self.discriminator = None
        self.conditions = conditions
        self.keys = keys
        if id is not None:
            self.id = id
        if type_mapping_id is not None:
            self.type_mapping_id = type_mapping_id
        if metatype_id is not None:
            self.metatype_id = metatype_id
        if metatype_relationship_pair_id is not None:
            self.metatype_relationship_pair_id = metatype_relationship_pair_id
        if origin_id_key is not None:
            self.origin_id_key = origin_id_key
        if destination_id_key is not None:
            self.destination_id_key = destination_id_key
        if unique_identifier_key is not None:
            self.unique_identifier_key = unique_identifier_key
        if root_array is not None:
            self.root_array = root_array
        if created_at is not None:
            self.created_at = created_at
        if modified_at is not None:
            self.modified_at = modified_at
        if created_by is not None:
            self.created_by = created_by
        if modified_by is not None:
            self.modified_by = modified_by
        self.archived = archived
        if metatype_name is not None:
            self.metatype_name = metatype_name
        if metatype_relationship_pair_name is not None:
            self.metatype_relationship_pair_name = metatype_relationship_pair_name
        if container_id is not None:
            self.container_id = container_id
        if shape_hash is not None:
            self.shape_hash = shape_hash
        if data_source_id is not None:
            self.data_source_id = data_source_id

    @property
    def conditions(self):
        """Gets the conditions of this Transformation.  # noqa: E501


        :return: The conditions of this Transformation.  # noqa: E501
        :rtype: list[TransformationCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """Sets the conditions of this Transformation.


        :param conditions: The conditions of this Transformation.  # noqa: E501
        :type: list[TransformationCondition]
        """
        if conditions is None:
            raise ValueError("Invalid value for `conditions`, must not be `None`")  # noqa: E501

        self._conditions = conditions

    @property
    def keys(self):
        """Gets the keys of this Transformation.  # noqa: E501


        :return: The keys of this Transformation.  # noqa: E501
        :rtype: list[TransformationKey]
        """
        return self._keys

    @keys.setter
    def keys(self, keys):
        """Sets the keys of this Transformation.


        :param keys: The keys of this Transformation.  # noqa: E501
        :type: list[TransformationKey]
        """
        if keys is None:
            raise ValueError("Invalid value for `keys`, must not be `None`")  # noqa: E501

        self._keys = keys

    @property
    def id(self):
        """Gets the id of this Transformation.  # noqa: E501


        :return: The id of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Transformation.


        :param id: The id of this Transformation.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def type_mapping_id(self):
        """Gets the type_mapping_id of this Transformation.  # noqa: E501


        :return: The type_mapping_id of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._type_mapping_id

    @type_mapping_id.setter
    def type_mapping_id(self, type_mapping_id):
        """Sets the type_mapping_id of this Transformation.


        :param type_mapping_id: The type_mapping_id of this Transformation.  # noqa: E501
        :type: str
        """

        self._type_mapping_id = type_mapping_id

    @property
    def metatype_id(self):
        """Gets the metatype_id of this Transformation.  # noqa: E501


        :return: The metatype_id of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._metatype_id

    @metatype_id.setter
    def metatype_id(self, metatype_id):
        """Sets the metatype_id of this Transformation.


        :param metatype_id: The metatype_id of this Transformation.  # noqa: E501
        :type: str
        """

        self._metatype_id = metatype_id

    @property
    def metatype_relationship_pair_id(self):
        """Gets the metatype_relationship_pair_id of this Transformation.  # noqa: E501


        :return: The metatype_relationship_pair_id of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._metatype_relationship_pair_id

    @metatype_relationship_pair_id.setter
    def metatype_relationship_pair_id(self, metatype_relationship_pair_id):
        """Sets the metatype_relationship_pair_id of this Transformation.


        :param metatype_relationship_pair_id: The metatype_relationship_pair_id of this Transformation.  # noqa: E501
        :type: str
        """

        self._metatype_relationship_pair_id = metatype_relationship_pair_id

    @property
    def origin_id_key(self):
        """Gets the origin_id_key of this Transformation.  # noqa: E501


        :return: The origin_id_key of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._origin_id_key

    @origin_id_key.setter
    def origin_id_key(self, origin_id_key):
        """Sets the origin_id_key of this Transformation.


        :param origin_id_key: The origin_id_key of this Transformation.  # noqa: E501
        :type: str
        """

        self._origin_id_key = origin_id_key

    @property
    def destination_id_key(self):
        """Gets the destination_id_key of this Transformation.  # noqa: E501


        :return: The destination_id_key of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._destination_id_key

    @destination_id_key.setter
    def destination_id_key(self, destination_id_key):
        """Sets the destination_id_key of this Transformation.


        :param destination_id_key: The destination_id_key of this Transformation.  # noqa: E501
        :type: str
        """

        self._destination_id_key = destination_id_key

    @property
    def unique_identifier_key(self):
        """Gets the unique_identifier_key of this Transformation.  # noqa: E501


        :return: The unique_identifier_key of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._unique_identifier_key

    @unique_identifier_key.setter
    def unique_identifier_key(self, unique_identifier_key):
        """Sets the unique_identifier_key of this Transformation.


        :param unique_identifier_key: The unique_identifier_key of this Transformation.  # noqa: E501
        :type: str
        """

        self._unique_identifier_key = unique_identifier_key

    @property
    def root_array(self):
        """Gets the root_array of this Transformation.  # noqa: E501


        :return: The root_array of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._root_array

    @root_array.setter
    def root_array(self, root_array):
        """Sets the root_array of this Transformation.


        :param root_array: The root_array of this Transformation.  # noqa: E501
        :type: str
        """

        self._root_array = root_array

    @property
    def created_at(self):
        """Gets the created_at of this Transformation.  # noqa: E501


        :return: The created_at of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Transformation.


        :param created_at: The created_at of this Transformation.  # noqa: E501
        :type: str
        """

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this Transformation.  # noqa: E501


        :return: The modified_at of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this Transformation.


        :param modified_at: The modified_at of this Transformation.  # noqa: E501
        :type: str
        """

        self._modified_at = modified_at

    @property
    def created_by(self):
        """Gets the created_by of this Transformation.  # noqa: E501


        :return: The created_by of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Transformation.


        :param created_by: The created_by of this Transformation.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def modified_by(self):
        """Gets the modified_by of this Transformation.  # noqa: E501


        :return: The modified_by of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """Sets the modified_by of this Transformation.


        :param modified_by: The modified_by of this Transformation.  # noqa: E501
        :type: str
        """

        self._modified_by = modified_by

    @property
    def archived(self):
        """Gets the archived of this Transformation.  # noqa: E501


        :return: The archived of this Transformation.  # noqa: E501
        :rtype: bool
        """
        return self._archived

    @archived.setter
    def archived(self, archived):
        """Sets the archived of this Transformation.


        :param archived: The archived of this Transformation.  # noqa: E501
        :type: bool
        """
        if archived is None:
            raise ValueError("Invalid value for `archived`, must not be `None`")  # noqa: E501

        self._archived = archived

    @property
    def metatype_name(self):
        """Gets the metatype_name of this Transformation.  # noqa: E501


        :return: The metatype_name of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._metatype_name

    @metatype_name.setter
    def metatype_name(self, metatype_name):
        """Sets the metatype_name of this Transformation.


        :param metatype_name: The metatype_name of this Transformation.  # noqa: E501
        :type: str
        """

        self._metatype_name = metatype_name

    @property
    def metatype_relationship_pair_name(self):
        """Gets the metatype_relationship_pair_name of this Transformation.  # noqa: E501


        :return: The metatype_relationship_pair_name of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._metatype_relationship_pair_name

    @metatype_relationship_pair_name.setter
    def metatype_relationship_pair_name(self, metatype_relationship_pair_name):
        """Sets the metatype_relationship_pair_name of this Transformation.


        :param metatype_relationship_pair_name: The metatype_relationship_pair_name of this Transformation.  # noqa: E501
        :type: str
        """

        self._metatype_relationship_pair_name = metatype_relationship_pair_name

    @property
    def container_id(self):
        """Gets the container_id of this Transformation.  # noqa: E501


        :return: The container_id of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this Transformation.


        :param container_id: The container_id of this Transformation.  # noqa: E501
        :type: str
        """

        self._container_id = container_id

    @property
    def shape_hash(self):
        """Gets the shape_hash of this Transformation.  # noqa: E501


        :return: The shape_hash of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._shape_hash

    @shape_hash.setter
    def shape_hash(self, shape_hash):
        """Sets the shape_hash of this Transformation.


        :param shape_hash: The shape_hash of this Transformation.  # noqa: E501
        :type: str
        """

        self._shape_hash = shape_hash

    @property
    def data_source_id(self):
        """Gets the data_source_id of this Transformation.  # noqa: E501


        :return: The data_source_id of this Transformation.  # noqa: E501
        :rtype: str
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this Transformation.


        :param data_source_id: The data_source_id of this Transformation.  # noqa: E501
        :type: str
        """

        self._data_source_id = data_source_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Transformation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Transformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
