# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class StoragepoolTier(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'children': 'list[str]',
        'name': 'str',
        'transfer_limit_pct': 'int',
        'transfer_limit_state': 'str'
    }

    attribute_map = {
        'children': 'children',
        'name': 'name',
        'transfer_limit_pct': 'transfer_limit_pct',
        'transfer_limit_state': 'transfer_limit_state'
    }

    def __init__(self, children=None, name=None, transfer_limit_pct=None, transfer_limit_state=None):  # noqa: E501
        """StoragepoolTier - a model defined in Swagger"""  # noqa: E501

        self._children = None
        self._name = None
        self._transfer_limit_pct = None
        self._transfer_limit_state = None
        self.discriminator = None

        if children is not None:
            self.children = children
        if name is not None:
            self.name = name
        if transfer_limit_pct is not None:
            self.transfer_limit_pct = transfer_limit_pct
        if transfer_limit_state is not None:
            self.transfer_limit_state = transfer_limit_state

    @property
    def children(self):
        """Gets the children of this StoragepoolTier.  # noqa: E501

        The names or IDs of the tier's children.  # noqa: E501

        :return: The children of this StoragepoolTier.  # noqa: E501
        :rtype: list[str]
        """
        return self._children

    @children.setter
    def children(self, children):
        """Sets the children of this StoragepoolTier.

        The names or IDs of the tier's children.  # noqa: E501

        :param children: The children of this StoragepoolTier.  # noqa: E501
        :type: list[str]
        """

        self._children = children

    @property
    def name(self):
        """Gets the name of this StoragepoolTier.  # noqa: E501

        The tier name.  # noqa: E501

        :return: The name of this StoragepoolTier.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this StoragepoolTier.

        The tier name.  # noqa: E501

        :param name: The name of this StoragepoolTier.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def transfer_limit_pct(self):
        """Gets the transfer_limit_pct of this StoragepoolTier.  # noqa: E501

        Stop moving files to this tier when this limit is met  # noqa: E501

        :return: The transfer_limit_pct of this StoragepoolTier.  # noqa: E501
        :rtype: int
        """
        return self._transfer_limit_pct

    @transfer_limit_pct.setter
    def transfer_limit_pct(self, transfer_limit_pct):
        """Sets the transfer_limit_pct of this StoragepoolTier.

        Stop moving files to this tier when this limit is met  # noqa: E501

        :param transfer_limit_pct: The transfer_limit_pct of this StoragepoolTier.  # noqa: E501
        :type: int
        """
        if transfer_limit_pct is not None and transfer_limit_pct > 100:  # noqa: E501
            raise ValueError("Invalid value for `transfer_limit_pct`, must be a value less than or equal to `100`")  # noqa: E501
        if transfer_limit_pct is not None and transfer_limit_pct < 0:  # noqa: E501
            raise ValueError("Invalid value for `transfer_limit_pct`, must be a value greater than or equal to `0`")  # noqa: E501

        self._transfer_limit_pct = transfer_limit_pct

    @property
    def transfer_limit_state(self):
        """Gets the transfer_limit_state of this StoragepoolTier.  # noqa: E501

        How the transfer limit value is being applied  # noqa: E501

        :return: The transfer_limit_state of this StoragepoolTier.  # noqa: E501
        :rtype: str
        """
        return self._transfer_limit_state

    @transfer_limit_state.setter
    def transfer_limit_state(self, transfer_limit_state):
        """Sets the transfer_limit_state of this StoragepoolTier.

        How the transfer limit value is being applied  # noqa: E501

        :param transfer_limit_state: The transfer_limit_state of this StoragepoolTier.  # noqa: E501
        :type: str
        """
        allowed_values = ["disabled", "default"]  # noqa: E501
        if transfer_limit_state not in allowed_values:
            raise ValueError(
                "Invalid value for `transfer_limit_state` ({0}), must be one of {1}"  # noqa: E501
                .format(transfer_limit_state, allowed_values)
            )

        self._transfer_limit_state = transfer_limit_state

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StoragepoolTier):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
