# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SnapshotWritableItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'dst_path': 'str',
        'src_snap': 'str'
    }

    attribute_map = {
        'dst_path': 'dst_path',
        'src_snap': 'src_snap'
    }

    def __init__(self, dst_path=None, src_snap=None):  # noqa: E501
        """SnapshotWritableItem - a model defined in Swagger"""  # noqa: E501

        self._dst_path = None
        self._src_snap = None
        self.discriminator = None

        self.dst_path = dst_path
        self.src_snap = src_snap

    @property
    def dst_path(self):
        """Gets the dst_path of this SnapshotWritableItem.  # noqa: E501

        The user supplied /ifs path of writable snapshot.  # noqa: E501

        :return: The dst_path of this SnapshotWritableItem.  # noqa: E501
        :rtype: str
        """
        return self._dst_path

    @dst_path.setter
    def dst_path(self, dst_path):
        """Sets the dst_path of this SnapshotWritableItem.

        The user supplied /ifs path of writable snapshot.  # noqa: E501

        :param dst_path: The dst_path of this SnapshotWritableItem.  # noqa: E501
        :type: str
        """
        if dst_path is None:
            raise ValueError("Invalid value for `dst_path`, must not be `None`")  # noqa: E501
        if dst_path is not None and len(dst_path) > 4096:
            raise ValueError("Invalid value for `dst_path`, length must be less than or equal to `4096`")  # noqa: E501
        if dst_path is not None and len(dst_path) < 4:
            raise ValueError("Invalid value for `dst_path`, length must be greater than or equal to `4`")  # noqa: E501
        if dst_path is not None and not re.search('^\/ifs$|^\/ifs\/', dst_path):  # noqa: E501
            raise ValueError("Invalid value for `dst_path`, must be a follow pattern or equal to `/^\/ifs$|^\/ifs\//`")  # noqa: E501

        self._dst_path = dst_path

    @property
    def src_snap(self):
        """Gets the src_snap of this SnapshotWritableItem.  # noqa: E501

        The user supplied source snapshot name or ID. This will be null for writable snapshots pending delete.  # noqa: E501

        :return: The src_snap of this SnapshotWritableItem.  # noqa: E501
        :rtype: str
        """
        return self._src_snap

    @src_snap.setter
    def src_snap(self, src_snap):
        """Sets the src_snap of this SnapshotWritableItem.

        The user supplied source snapshot name or ID. This will be null for writable snapshots pending delete.  # noqa: E501

        :param src_snap: The src_snap of this SnapshotWritableItem.  # noqa: E501
        :type: str
        """
        if src_snap is None:
            raise ValueError("Invalid value for `src_snap`, must not be `None`")  # noqa: E501
        if src_snap is not None and len(src_snap) < 0:
            raise ValueError("Invalid value for `src_snap`, length must be greater than or equal to `0`")  # noqa: E501

        self._src_snap = src_snap

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotWritableItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
