# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SedStatusNode(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'error_msg': 'str',
        'id': 'int',
        'key_timestamp': 'int',
        'lnn': 'int',
        'location': 'str',
        'remote_key_id': 'str',
        'status': 'str'
    }

    attribute_map = {
        'error_msg': 'error_msg',
        'id': 'id',
        'key_timestamp': 'key_timestamp',
        'lnn': 'lnn',
        'location': 'location',
        'remote_key_id': 'remote_key_id',
        'status': 'status'
    }

    def __init__(self, error_msg=None, id=None, key_timestamp=None, lnn=None, location=None, remote_key_id=None, status=None):  # noqa: E501
        """SedStatusNode - a model defined in Swagger"""  # noqa: E501

        self._error_msg = None
        self._id = None
        self._key_timestamp = None
        self._lnn = None
        self._location = None
        self._remote_key_id = None
        self._status = None
        self.discriminator = None

        if error_msg is not None:
            self.error_msg = error_msg
        if id is not None:
            self.id = id
        if key_timestamp is not None:
            self.key_timestamp = key_timestamp
        if lnn is not None:
            self.lnn = lnn
        if location is not None:
            self.location = location
        if remote_key_id is not None:
            self.remote_key_id = remote_key_id
        if status is not None:
            self.status = status

    @property
    def error_msg(self):
        """Gets the error_msg of this SedStatusNode.  # noqa: E501

        information of the error if there is an error status. Empty if no error occurred.  # noqa: E501

        :return: The error_msg of this SedStatusNode.  # noqa: E501
        :rtype: str
        """
        return self._error_msg

    @error_msg.setter
    def error_msg(self, error_msg):
        """Sets the error_msg of this SedStatusNode.

        information of the error if there is an error status. Empty if no error occurred.  # noqa: E501

        :param error_msg: The error_msg of this SedStatusNode.  # noqa: E501
        :type: str
        """
        if error_msg is not None and len(error_msg) > 255:
            raise ValueError("Invalid value for `error_msg`, length must be less than or equal to `255`")  # noqa: E501
        if error_msg is not None and len(error_msg) < 0:
            raise ValueError("Invalid value for `error_msg`, length must be greater than or equal to `0`")  # noqa: E501

        self._error_msg = error_msg

    @property
    def id(self):
        """Gets the id of this SedStatusNode.  # noqa: E501

        Node ID (Device Number) of a node.  # noqa: E501

        :return: The id of this SedStatusNode.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SedStatusNode.

        Node ID (Device Number) of a node.  # noqa: E501

        :param id: The id of this SedStatusNode.  # noqa: E501
        :type: int
        """
        if id is not None and id > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if id is not None and id < 0:  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._id = id

    @property
    def key_timestamp(self):
        """Gets the key_timestamp of this SedStatusNode.  # noqa: E501

        Creation time of the key  # noqa: E501

        :return: The key_timestamp of this SedStatusNode.  # noqa: E501
        :rtype: int
        """
        return self._key_timestamp

    @key_timestamp.setter
    def key_timestamp(self, key_timestamp):
        """Sets the key_timestamp of this SedStatusNode.

        Creation time of the key  # noqa: E501

        :param key_timestamp: The key_timestamp of this SedStatusNode.  # noqa: E501
        :type: int
        """
        if key_timestamp is not None and key_timestamp > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `key_timestamp`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if key_timestamp is not None and key_timestamp < 0:  # noqa: E501
            raise ValueError("Invalid value for `key_timestamp`, must be a value greater than or equal to `0`")  # noqa: E501

        self._key_timestamp = key_timestamp

    @property
    def lnn(self):
        """Gets the lnn of this SedStatusNode.  # noqa: E501

        Logical Node Number (LNN) of a node.  # noqa: E501

        :return: The lnn of this SedStatusNode.  # noqa: E501
        :rtype: int
        """
        return self._lnn

    @lnn.setter
    def lnn(self, lnn):
        """Sets the lnn of this SedStatusNode.

        Logical Node Number (LNN) of a node.  # noqa: E501

        :param lnn: The lnn of this SedStatusNode.  # noqa: E501
        :type: int
        """
        if lnn is not None and lnn > 65535:  # noqa: E501
            raise ValueError("Invalid value for `lnn`, must be a value less than or equal to `65535`")  # noqa: E501
        if lnn is not None and lnn < 1:  # noqa: E501
            raise ValueError("Invalid value for `lnn`, must be a value greater than or equal to `1`")  # noqa: E501

        self._lnn = lnn

    @property
    def location(self):
        """Gets the location of this SedStatusNode.  # noqa: E501

        Current location of the key.  # noqa: E501

        :return: The location of this SedStatusNode.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this SedStatusNode.

        Current location of the key.  # noqa: E501

        :param location: The location of this SedStatusNode.  # noqa: E501
        :type: str
        """
        if location is not None and len(location) > 255:
            raise ValueError("Invalid value for `location`, length must be less than or equal to `255`")  # noqa: E501
        if location is not None and len(location) < 0:
            raise ValueError("Invalid value for `location`, length must be greater than or equal to `0`")  # noqa: E501

        self._location = location

    @property
    def remote_key_id(self):
        """Gets the remote_key_id of this SedStatusNode.  # noqa: E501

        Key ID in the remote KMIP server.  # noqa: E501

        :return: The remote_key_id of this SedStatusNode.  # noqa: E501
        :rtype: str
        """
        return self._remote_key_id

    @remote_key_id.setter
    def remote_key_id(self, remote_key_id):
        """Sets the remote_key_id of this SedStatusNode.

        Key ID in the remote KMIP server.  # noqa: E501

        :param remote_key_id: The remote_key_id of this SedStatusNode.  # noqa: E501
        :type: str
        """
        if remote_key_id is not None and len(remote_key_id) > 255:
            raise ValueError("Invalid value for `remote_key_id`, length must be less than or equal to `255`")  # noqa: E501
        if remote_key_id is not None and len(remote_key_id) < 0:
            raise ValueError("Invalid value for `remote_key_id`, length must be greater than or equal to `0`")  # noqa: E501

        self._remote_key_id = remote_key_id

    @property
    def status(self):
        """Gets the status of this SedStatusNode.  # noqa: E501

        Current key migration status. If no SEDs are avaiable and KMIP is not supported, it will show OFFLINE status.  # noqa: E501

        :return: The status of this SedStatusNode.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SedStatusNode.

        Current key migration status. If no SEDs are avaiable and KMIP is not supported, it will show OFFLINE status.  # noqa: E501

        :param status: The status of this SedStatusNode.  # noqa: E501
        :type: str
        """
        if status is not None and len(status) > 255:
            raise ValueError("Invalid value for `status`, length must be less than or equal to `255`")  # noqa: E501
        if status is not None and len(status) < 1:
            raise ValueError("Invalid value for `status`, length must be greater than or equal to `1`")  # noqa: E501

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SedStatusNode):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
