# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SecurityCheckItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'str',
        'exclude_list': 'list[str]',
        'mode': 'str',
        'name': 'str',
        'node_lnn': 'list[int]'
    }

    attribute_map = {
        'action': 'action',
        'exclude_list': 'exclude_list',
        'mode': 'mode',
        'name': 'name',
        'node_lnn': 'node_lnn'
    }

    def __init__(self, action=None, exclude_list=None, mode=None, name=None, node_lnn=None):  # noqa: E501
        """SecurityCheckItem - a model defined in Swagger"""  # noqa: E501

        self._action = None
        self._exclude_list = None
        self._mode = None
        self._name = None
        self._node_lnn = None
        self.discriminator = None

        if action is not None:
            self.action = action
        if exclude_list is not None:
            self.exclude_list = exclude_list
        if mode is not None:
            self.mode = mode
        if name is not None:
            self.name = name
        if node_lnn is not None:
            self.node_lnn = node_lnn

    @property
    def action(self):
        """Gets the action of this SecurityCheckItem.  # noqa: E501

        Action to be taken on encountering security anomalies  # noqa: E501

        :return: The action of this SecurityCheckItem.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this SecurityCheckItem.

        Action to be taken on encountering security anomalies  # noqa: E501

        :param action: The action of this SecurityCheckItem.  # noqa: E501
        :type: str
        """
        allowed_values = ["celog", "reboot", "shutdown"]  # noqa: E501
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def exclude_list(self):
        """Gets the exclude_list of this SecurityCheckItem.  # noqa: E501

        Comma separated security check names to exclude from the run  # noqa: E501

        :return: The exclude_list of this SecurityCheckItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._exclude_list

    @exclude_list.setter
    def exclude_list(self, exclude_list):
        """Sets the exclude_list of this SecurityCheckItem.

        Comma separated security check names to exclude from the run  # noqa: E501

        :param exclude_list: The exclude_list of this SecurityCheckItem.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["ClusterHealthCheck", "PeriodicSecurityCheck", "StigComplianceCheck"]  # noqa: E501
        if not set(exclude_list).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `exclude_list` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(exclude_list) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._exclude_list = exclude_list

    @property
    def mode(self):
        """Gets the mode of this SecurityCheckItem.  # noqa: E501

        Mode of running security check: cluster, or node  # noqa: E501

        :return: The mode of this SecurityCheckItem.  # noqa: E501
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this SecurityCheckItem.

        Mode of running security check: cluster, or node  # noqa: E501

        :param mode: The mode of this SecurityCheckItem.  # noqa: E501
        :type: str
        """
        allowed_values = ["cluster", "node"]  # noqa: E501
        if mode not in allowed_values:
            raise ValueError(
                "Invalid value for `mode` ({0}), must be one of {1}"  # noqa: E501
                .format(mode, allowed_values)
            )

        self._mode = mode

    @property
    def name(self):
        """Gets the name of this SecurityCheckItem.  # noqa: E501

        Name of specific security check to run  # noqa: E501

        :return: The name of this SecurityCheckItem.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SecurityCheckItem.

        Name of specific security check to run  # noqa: E501

        :param name: The name of this SecurityCheckItem.  # noqa: E501
        :type: str
        """
        allowed_values = ["ClusterHealthCheck", "PeriodicSecurityCheck", "StigComplianceCheck"]  # noqa: E501
        if name not in allowed_values:
            raise ValueError(
                "Invalid value for `name` ({0}), must be one of {1}"  # noqa: E501
                .format(name, allowed_values)
            )

        self._name = name

    @property
    def node_lnn(self):
        """Gets the node_lnn of this SecurityCheckItem.  # noqa: E501

        Comma separated node numbers (LNN) to run security checks  # noqa: E501

        :return: The node_lnn of this SecurityCheckItem.  # noqa: E501
        :rtype: list[int]
        """
        return self._node_lnn

    @node_lnn.setter
    def node_lnn(self, node_lnn):
        """Sets the node_lnn of this SecurityCheckItem.

        Comma separated node numbers (LNN) to run security checks  # noqa: E501

        :param node_lnn: The node_lnn of this SecurityCheckItem.  # noqa: E501
        :type: list[int]
        """

        self._node_lnn = node_lnn

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SecurityCheckItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
