# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ProvidersSamlServicesSpExtended(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'email': 'str',
        'entity_id': 'str',
        'first_name': 'str',
        'hostname': 'str',
        'last_name': 'str',
        'signing_enabled': 'bool',
        'user_id': 'str'
    }

    attribute_map = {
        'email': 'email',
        'entity_id': 'entity_id',
        'first_name': 'first_name',
        'hostname': 'hostname',
        'last_name': 'last_name',
        'signing_enabled': 'signing_enabled',
        'user_id': 'user_id'
    }

    def __init__(self, email=None, entity_id=None, first_name=None, hostname=None, last_name=None, signing_enabled=None, user_id=None):  # noqa: E501
        """ProvidersSamlServicesSpExtended - a model defined in Swagger"""  # noqa: E501

        self._email = None
        self._entity_id = None
        self._first_name = None
        self._hostname = None
        self._last_name = None
        self._signing_enabled = None
        self._user_id = None
        self.discriminator = None

        if email is not None:
            self.email = email
        if entity_id is not None:
            self.entity_id = entity_id
        if first_name is not None:
            self.first_name = first_name
        if hostname is not None:
            self.hostname = hostname
        if last_name is not None:
            self.last_name = last_name
        if signing_enabled is not None:
            self.signing_enabled = signing_enabled
        if user_id is not None:
            self.user_id = user_id

    @property
    def email(self):
        """Gets the email of this ProvidersSamlServicesSpExtended.  # noqa: E501

        Email address of SP maintainer.  # noqa: E501

        :return: The email of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this ProvidersSamlServicesSpExtended.

        Email address of SP maintainer.  # noqa: E501

        :param email: The email of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :type: str
        """
        if email is not None and len(email) > 254:
            raise ValueError("Invalid value for `email`, length must be less than or equal to `254`")  # noqa: E501
        if email is not None and len(email) < 3:
            raise ValueError("Invalid value for `email`, length must be greater than or equal to `3`")  # noqa: E501
        if email is not None and not re.search('[a-zA-Z0-9._%+-]{1,64}@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,63}', email):  # noqa: E501
            raise ValueError("Invalid value for `email`, must be a follow pattern or equal to `/[a-zA-Z0-9._%+-]{1,64}@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,63}/`")  # noqa: E501

        self._email = email

    @property
    def entity_id(self):
        """Gets the entity_id of this ProvidersSamlServicesSpExtended.  # noqa: E501

        Unique identifier of the client (product).  # noqa: E501

        :return: The entity_id of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :rtype: str
        """
        return self._entity_id

    @entity_id.setter
    def entity_id(self, entity_id):
        """Sets the entity_id of this ProvidersSamlServicesSpExtended.

        Unique identifier of the client (product).  # noqa: E501

        :param entity_id: The entity_id of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :type: str
        """
        if entity_id is not None and len(entity_id) > 1024:
            raise ValueError("Invalid value for `entity_id`, length must be less than or equal to `1024`")  # noqa: E501
        if entity_id is not None and len(entity_id) < 0:
            raise ValueError("Invalid value for `entity_id`, length must be greater than or equal to `0`")  # noqa: E501

        self._entity_id = entity_id

    @property
    def first_name(self):
        """Gets the first_name of this ProvidersSamlServicesSpExtended.  # noqa: E501

        First name of SP maintainer.  # noqa: E501

        :return: The first_name of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this ProvidersSamlServicesSpExtended.

        First name of SP maintainer.  # noqa: E501

        :param first_name: The first_name of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :type: str
        """
        if first_name is not None and len(first_name) > 255:
            raise ValueError("Invalid value for `first_name`, length must be less than or equal to `255`")  # noqa: E501
        if first_name is not None and len(first_name) < 0:
            raise ValueError("Invalid value for `first_name`, length must be greater than or equal to `0`")  # noqa: E501

        self._first_name = first_name

    @property
    def hostname(self):
        """Gets the hostname of this ProvidersSamlServicesSpExtended.  # noqa: E501

        Resolvable hostname of the SP in an access zone.  # noqa: E501

        :return: The hostname of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this ProvidersSamlServicesSpExtended.

        Resolvable hostname of the SP in an access zone.  # noqa: E501

        :param hostname: The hostname of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :type: str
        """
        if hostname is not None and len(hostname) > 2048:
            raise ValueError("Invalid value for `hostname`, length must be less than or equal to `2048`")  # noqa: E501
        if hostname is not None and len(hostname) < 0:
            raise ValueError("Invalid value for `hostname`, length must be greater than or equal to `0`")  # noqa: E501

        self._hostname = hostname

    @property
    def last_name(self):
        """Gets the last_name of this ProvidersSamlServicesSpExtended.  # noqa: E501

        Last name of SP maintainer.  # noqa: E501

        :return: The last_name of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this ProvidersSamlServicesSpExtended.

        Last name of SP maintainer.  # noqa: E501

        :param last_name: The last_name of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :type: str
        """
        if last_name is not None and len(last_name) > 255:
            raise ValueError("Invalid value for `last_name`, length must be less than or equal to `255`")  # noqa: E501
        if last_name is not None and len(last_name) < 0:
            raise ValueError("Invalid value for `last_name`, length must be greater than or equal to `0`")  # noqa: E501

        self._last_name = last_name

    @property
    def signing_enabled(self):
        """Gets the signing_enabled of this ProvidersSamlServicesSpExtended.  # noqa: E501

        Indicates whether signing of requests is enabled for the SP.  # noqa: E501

        :return: The signing_enabled of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :rtype: bool
        """
        return self._signing_enabled

    @signing_enabled.setter
    def signing_enabled(self, signing_enabled):
        """Sets the signing_enabled of this ProvidersSamlServicesSpExtended.

        Indicates whether signing of requests is enabled for the SP.  # noqa: E501

        :param signing_enabled: The signing_enabled of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :type: bool
        """

        self._signing_enabled = signing_enabled

    @property
    def user_id(self):
        """Gets the user_id of this ProvidersSamlServicesSpExtended.  # noqa: E501

        ID of SP maintainer.  # noqa: E501

        :return: The user_id of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this ProvidersSamlServicesSpExtended.

        ID of SP maintainer.  # noqa: E501

        :param user_id: The user_id of this ProvidersSamlServicesSpExtended.  # noqa: E501
        :type: str
        """
        if user_id is not None and len(user_id) > 256:
            raise ValueError("Invalid value for `user_id`, length must be less than or equal to `256`")  # noqa: E501
        if user_id is not None and len(user_id) < 0:
            raise ValueError("Invalid value for `user_id`, length must be greater than or equal to `0`")  # noqa: E501

        self._user_id = user_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProvidersSamlServicesSpExtended):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
