# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_5_0.models.pools_pool_status_status_node_interface_status import PoolsPoolStatusStatusNodeInterfaceStatus  # noqa: F401,E501


class PoolsPoolStatusStatusNode(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'devid': 'int',
        'interface_status': 'PoolsPoolStatusStatusNodeInterfaceStatus',
        'ip_status': 'str',
        'lnn': 'int',
        'node_state': 'str',
        'protocols_running': 'bool',
        'sc_dns_resolvable': 'bool',
        'suspended': 'bool'
    }

    attribute_map = {
        'devid': 'devid',
        'interface_status': 'interface_status',
        'ip_status': 'ip_status',
        'lnn': 'lnn',
        'node_state': 'node_state',
        'protocols_running': 'protocols_running',
        'sc_dns_resolvable': 'sc_dns_resolvable',
        'suspended': 'suspended'
    }

    def __init__(self, devid=None, interface_status=None, ip_status=None, lnn=None, node_state=None, protocols_running=None, sc_dns_resolvable=None, suspended=None):  # noqa: E501
        """PoolsPoolStatusStatusNode - a model defined in Swagger"""  # noqa: E501

        self._devid = None
        self._interface_status = None
        self._ip_status = None
        self._lnn = None
        self._node_state = None
        self._protocols_running = None
        self._sc_dns_resolvable = None
        self._suspended = None
        self.discriminator = None

        if devid is not None:
            self.devid = devid
        if interface_status is not None:
            self.interface_status = interface_status
        if ip_status is not None:
            self.ip_status = ip_status
        if lnn is not None:
            self.lnn = lnn
        if node_state is not None:
            self.node_state = node_state
        if protocols_running is not None:
            self.protocols_running = protocols_running
        if sc_dns_resolvable is not None:
            self.sc_dns_resolvable = sc_dns_resolvable
        if suspended is not None:
            self.suspended = suspended

    @property
    def devid(self):
        """Gets the devid of this PoolsPoolStatusStatusNode.  # noqa: E501

        Node ID (Device Number) of a node.  # noqa: E501

        :return: The devid of this PoolsPoolStatusStatusNode.  # noqa: E501
        :rtype: int
        """
        return self._devid

    @devid.setter
    def devid(self, devid):
        """Sets the devid of this PoolsPoolStatusStatusNode.

        Node ID (Device Number) of a node.  # noqa: E501

        :param devid: The devid of this PoolsPoolStatusStatusNode.  # noqa: E501
        :type: int
        """
        if devid is not None and devid > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `devid`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if devid is not None and devid < 0:  # noqa: E501
            raise ValueError("Invalid value for `devid`, must be a value greater than or equal to `0`")  # noqa: E501

        self._devid = devid

    @property
    def interface_status(self):
        """Gets the interface_status of this PoolsPoolStatusStatusNode.  # noqa: E501

          # noqa: E501

        :return: The interface_status of this PoolsPoolStatusStatusNode.  # noqa: E501
        :rtype: PoolsPoolStatusStatusNodeInterfaceStatus
        """
        return self._interface_status

    @interface_status.setter
    def interface_status(self, interface_status):
        """Sets the interface_status of this PoolsPoolStatusStatusNode.

          # noqa: E501

        :param interface_status: The interface_status of this PoolsPoolStatusStatusNode.  # noqa: E501
        :type: PoolsPoolStatusStatusNodeInterfaceStatus
        """

        self._interface_status = interface_status

    @property
    def ip_status(self):
        """Gets the ip_status of this PoolsPoolStatusStatusNode.  # noqa: E501

        Summary of the status of the IPs currently configured on this node. usable: The node has IPs allocated that are usable. none_usable: The node has IPs configured, but they are currently not in a usable state. This can occur for a variety of reasons. For static IPs, this can occur if the node is down, or if the interfaces are down. For dynamic IPs, this can occur if all of the IPs are about to move to a different node. none_configured: The node has no IPs from the Network Pool configured currently.  # noqa: E501

        :return: The ip_status of this PoolsPoolStatusStatusNode.  # noqa: E501
        :rtype: str
        """
        return self._ip_status

    @ip_status.setter
    def ip_status(self, ip_status):
        """Sets the ip_status of this PoolsPoolStatusStatusNode.

        Summary of the status of the IPs currently configured on this node. usable: The node has IPs allocated that are usable. none_usable: The node has IPs configured, but they are currently not in a usable state. This can occur for a variety of reasons. For static IPs, this can occur if the node is down, or if the interfaces are down. For dynamic IPs, this can occur if all of the IPs are about to move to a different node. none_configured: The node has no IPs from the Network Pool configured currently.  # noqa: E501

        :param ip_status: The ip_status of this PoolsPoolStatusStatusNode.  # noqa: E501
        :type: str
        """
        allowed_values = ["usable", "none_usable", "none_configured"]  # noqa: E501
        if ip_status not in allowed_values:
            raise ValueError(
                "Invalid value for `ip_status` ({0}), must be one of {1}"  # noqa: E501
                .format(ip_status, allowed_values)
            )

        self._ip_status = ip_status

    @property
    def lnn(self):
        """Gets the lnn of this PoolsPoolStatusStatusNode.  # noqa: E501

        Logical Node Number (LNN) of a node.  # noqa: E501

        :return: The lnn of this PoolsPoolStatusStatusNode.  # noqa: E501
        :rtype: int
        """
        return self._lnn

    @lnn.setter
    def lnn(self, lnn):
        """Sets the lnn of this PoolsPoolStatusStatusNode.

        Logical Node Number (LNN) of a node.  # noqa: E501

        :param lnn: The lnn of this PoolsPoolStatusStatusNode.  # noqa: E501
        :type: int
        """
        if lnn is not None and lnn > 65535:  # noqa: E501
            raise ValueError("Invalid value for `lnn`, must be a value less than or equal to `65535`")  # noqa: E501
        if lnn is not None and lnn < 1:  # noqa: E501
            raise ValueError("Invalid value for `lnn`, must be a value greater than or equal to `1`")  # noqa: E501

        self._lnn = lnn

    @property
    def node_state(self):
        """Gets the node_state of this PoolsPoolStatusStatusNode.  # noqa: E501

        The node's current state within the cluster.  # noqa: E501

        :return: The node_state of this PoolsPoolStatusStatusNode.  # noqa: E501
        :rtype: str
        """
        return self._node_state

    @node_state.setter
    def node_state(self, node_state):
        """Sets the node_state of this PoolsPoolStatusStatusNode.

        The node's current state within the cluster.  # noqa: E501

        :param node_state: The node_state of this PoolsPoolStatusStatusNode.  # noqa: E501
        :type: str
        """
        allowed_values = ["up", "draining", "smartfailing", "shutting_down", "down"]  # noqa: E501
        if node_state not in allowed_values:
            raise ValueError(
                "Invalid value for `node_state` ({0}), must be one of {1}"  # noqa: E501
                .format(node_state, allowed_values)
            )

        self._node_state = node_state

    @property
    def protocols_running(self):
        """Gets the protocols_running of this PoolsPoolStatusStatusNode.  # noqa: E501

        Indicates if the node has the required protocols to be resolvable via DNS.  # noqa: E501

        :return: The protocols_running of this PoolsPoolStatusStatusNode.  # noqa: E501
        :rtype: bool
        """
        return self._protocols_running

    @protocols_running.setter
    def protocols_running(self, protocols_running):
        """Sets the protocols_running of this PoolsPoolStatusStatusNode.

        Indicates if the node has the required protocols to be resolvable via DNS.  # noqa: E501

        :param protocols_running: The protocols_running of this PoolsPoolStatusStatusNode.  # noqa: E501
        :type: bool
        """

        self._protocols_running = protocols_running

    @property
    def sc_dns_resolvable(self):
        """Gets the sc_dns_resolvable of this PoolsPoolStatusStatusNode.  # noqa: E501

        Indicates if the node can be resolved via SmartConnect DNS or not.  # noqa: E501

        :return: The sc_dns_resolvable of this PoolsPoolStatusStatusNode.  # noqa: E501
        :rtype: bool
        """
        return self._sc_dns_resolvable

    @sc_dns_resolvable.setter
    def sc_dns_resolvable(self, sc_dns_resolvable):
        """Sets the sc_dns_resolvable of this PoolsPoolStatusStatusNode.

        Indicates if the node can be resolved via SmartConnect DNS or not.  # noqa: E501

        :param sc_dns_resolvable: The sc_dns_resolvable of this PoolsPoolStatusStatusNode.  # noqa: E501
        :type: bool
        """

        self._sc_dns_resolvable = sc_dns_resolvable

    @property
    def suspended(self):
        """Gets the suspended of this PoolsPoolStatusStatusNode.  # noqa: E501

        Indicates if the node has been suspended within the Network Pool.  # noqa: E501

        :return: The suspended of this PoolsPoolStatusStatusNode.  # noqa: E501
        :rtype: bool
        """
        return self._suspended

    @suspended.setter
    def suspended(self, suspended):
        """Sets the suspended of this PoolsPoolStatusStatusNode.

        Indicates if the node has been suspended within the Network Pool.  # noqa: E501

        :param suspended: The suspended of this PoolsPoolStatusStatusNode.  # noqa: E501
        :type: bool
        """

        self._suspended = suspended

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PoolsPoolStatusStatusNode):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
