# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class LicenseGenerateHardwareItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'drive_capacity': 'int',
        'node_count': 'int',
        'nodes_with_seds_count': 'int',
        'tier': 'str'
    }

    attribute_map = {
        'drive_capacity': 'drive_capacity',
        'node_count': 'node_count',
        'nodes_with_seds_count': 'nodes_with_seds_count',
        'tier': 'tier'
    }

    def __init__(self, drive_capacity=None, node_count=None, nodes_with_seds_count=None, tier=None):  # noqa: E501
        """LicenseGenerateHardwareItem - a model defined in Swagger"""  # noqa: E501

        self._drive_capacity = None
        self._node_count = None
        self._nodes_with_seds_count = None
        self._tier = None
        self.discriminator = None

        if drive_capacity is not None:
            self.drive_capacity = drive_capacity
        if node_count is not None:
            self.node_count = node_count
        if nodes_with_seds_count is not None:
            self.nodes_with_seds_count = nodes_with_seds_count
        if tier is not None:
            self.tier = tier

    @property
    def drive_capacity(self):
        """Gets the drive_capacity of this LicenseGenerateHardwareItem.  # noqa: E501

        Licensed terabyte (TB, 10^12 bytes) drive capacity allocated as storage associated with tier. Included if tier is not NONINF and license is not a base only license.  # noqa: E501

        :return: The drive_capacity of this LicenseGenerateHardwareItem.  # noqa: E501
        :rtype: int
        """
        return self._drive_capacity

    @drive_capacity.setter
    def drive_capacity(self, drive_capacity):
        """Sets the drive_capacity of this LicenseGenerateHardwareItem.

        Licensed terabyte (TB, 10^12 bytes) drive capacity allocated as storage associated with tier. Included if tier is not NONINF and license is not a base only license.  # noqa: E501

        :param drive_capacity: The drive_capacity of this LicenseGenerateHardwareItem.  # noqa: E501
        :type: int
        """
        if drive_capacity is not None and drive_capacity > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `drive_capacity`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if drive_capacity is not None and drive_capacity < 0:  # noqa: E501
            raise ValueError("Invalid value for `drive_capacity`, must be a value greater than or equal to `0`")  # noqa: E501

        self._drive_capacity = drive_capacity

    @property
    def node_count(self):
        """Gets the node_count of this LicenseGenerateHardwareItem.  # noqa: E501

        Licensed number of nodes in this tier.  # noqa: E501

        :return: The node_count of this LicenseGenerateHardwareItem.  # noqa: E501
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """Sets the node_count of this LicenseGenerateHardwareItem.

        Licensed number of nodes in this tier.  # noqa: E501

        :param node_count: The node_count of this LicenseGenerateHardwareItem.  # noqa: E501
        :type: int
        """
        if node_count is not None and node_count > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `node_count`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if node_count is not None and node_count < 0:  # noqa: E501
            raise ValueError("Invalid value for `node_count`, must be a value greater than or equal to `0`")  # noqa: E501

        self._node_count = node_count

    @property
    def nodes_with_seds_count(self):
        """Gets the nodes_with_seds_count of this LicenseGenerateHardwareItem.  # noqa: E501

        Licensed number of nodes of this tier that contain self-encrypting drives. Included only if license is ONEFS and tier is not NONINF.  # noqa: E501

        :return: The nodes_with_seds_count of this LicenseGenerateHardwareItem.  # noqa: E501
        :rtype: int
        """
        return self._nodes_with_seds_count

    @nodes_with_seds_count.setter
    def nodes_with_seds_count(self, nodes_with_seds_count):
        """Sets the nodes_with_seds_count of this LicenseGenerateHardwareItem.

        Licensed number of nodes of this tier that contain self-encrypting drives. Included only if license is ONEFS and tier is not NONINF.  # noqa: E501

        :param nodes_with_seds_count: The nodes_with_seds_count of this LicenseGenerateHardwareItem.  # noqa: E501
        :type: int
        """
        if nodes_with_seds_count is not None and nodes_with_seds_count > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `nodes_with_seds_count`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if nodes_with_seds_count is not None and nodes_with_seds_count < 0:  # noqa: E501
            raise ValueError("Invalid value for `nodes_with_seds_count`, must be a value greater than or equal to `0`")  # noqa: E501

        self._nodes_with_seds_count = nodes_with_seds_count

    @property
    def tier(self):
        """Gets the tier of this LicenseGenerateHardwareItem.  # noqa: E501

        OneFS hardware tier. Tier is a number, NONINF, or NO_TIER. NONINF indicates a non infinity tier. NO_TIER indicates a license that is not tier based.  # noqa: E501

        :return: The tier of this LicenseGenerateHardwareItem.  # noqa: E501
        :rtype: str
        """
        return self._tier

    @tier.setter
    def tier(self, tier):
        """Sets the tier of this LicenseGenerateHardwareItem.

        OneFS hardware tier. Tier is a number, NONINF, or NO_TIER. NONINF indicates a non infinity tier. NO_TIER indicates a license that is not tier based.  # noqa: E501

        :param tier: The tier of this LicenseGenerateHardwareItem.  # noqa: E501
        :type: str
        """
        if tier is not None and len(tier) > 50:
            raise ValueError("Invalid value for `tier`, length must be less than or equal to `50`")  # noqa: E501
        if tier is not None and len(tier) < 1:
            raise ValueError("Invalid value for `tier`, length must be greater than or equal to `1`")  # noqa: E501
        if tier is not None and not re.search('^NONINF$|^NO_TIER$|^\\d+$', tier):  # noqa: E501
            raise ValueError("Invalid value for `tier`, must be a follow pattern or equal to `/^NONINF$|^NO_TIER$|^\\d+$/`")  # noqa: E501

        self._tier = tier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LicenseGenerateHardwareItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
