# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class HttpSettingsExtended(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_control': 'bool',
        'basic_authentication': 'bool',
        'dav': 'bool',
        'enable_access_log': 'bool',
        'httpd_controlpath_redirect': 'bool',
        'https': 'bool',
        'inactive_timeout': 'int',
        'integrated_authentication': 'bool',
        'server_root': 'str',
        'service': 'str',
        'service_timeout': 'int',
        'session_max_age': 'int',
        'webhdfs_ran_https_port': 'int'
    }

    attribute_map = {
        'access_control': 'access_control',
        'basic_authentication': 'basic_authentication',
        'dav': 'dav',
        'enable_access_log': 'enable_access_log',
        'httpd_controlpath_redirect': 'httpd_controlpath_redirect',
        'https': 'https',
        'inactive_timeout': 'inactive_timeout',
        'integrated_authentication': 'integrated_authentication',
        'server_root': 'server_root',
        'service': 'service',
        'service_timeout': 'service_timeout',
        'session_max_age': 'session_max_age',
        'webhdfs_ran_https_port': 'webhdfs_ran_https_port'
    }

    def __init__(self, access_control=None, basic_authentication=None, dav=None, enable_access_log=None, httpd_controlpath_redirect=None, https=None, inactive_timeout=None, integrated_authentication=None, server_root=None, service=None, service_timeout=None, session_max_age=None, webhdfs_ran_https_port=None):  # noqa: E501
        """HttpSettingsExtended - a model defined in Swagger"""  # noqa: E501

        self._access_control = None
        self._basic_authentication = None
        self._dav = None
        self._enable_access_log = None
        self._httpd_controlpath_redirect = None
        self._https = None
        self._inactive_timeout = None
        self._integrated_authentication = None
        self._server_root = None
        self._service = None
        self._service_timeout = None
        self._session_max_age = None
        self._webhdfs_ran_https_port = None
        self.discriminator = None

        if access_control is not None:
            self.access_control = access_control
        if basic_authentication is not None:
            self.basic_authentication = basic_authentication
        if dav is not None:
            self.dav = dav
        if enable_access_log is not None:
            self.enable_access_log = enable_access_log
        if httpd_controlpath_redirect is not None:
            self.httpd_controlpath_redirect = httpd_controlpath_redirect
        if https is not None:
            self.https = https
        if inactive_timeout is not None:
            self.inactive_timeout = inactive_timeout
        if integrated_authentication is not None:
            self.integrated_authentication = integrated_authentication
        if server_root is not None:
            self.server_root = server_root
        if service is not None:
            self.service = service
        if service_timeout is not None:
            self.service_timeout = service_timeout
        if session_max_age is not None:
            self.session_max_age = session_max_age
        if webhdfs_ran_https_port is not None:
            self.webhdfs_ran_https_port = webhdfs_ran_https_port

    @property
    def access_control(self):
        """Gets the access_control of this HttpSettingsExtended.  # noqa: E501

        Enable Access Control Authentication for HTTP service.  # noqa: E501

        :return: The access_control of this HttpSettingsExtended.  # noqa: E501
        :rtype: bool
        """
        return self._access_control

    @access_control.setter
    def access_control(self, access_control):
        """Sets the access_control of this HttpSettingsExtended.

        Enable Access Control Authentication for HTTP service.  # noqa: E501

        :param access_control: The access_control of this HttpSettingsExtended.  # noqa: E501
        :type: bool
        """

        self._access_control = access_control

    @property
    def basic_authentication(self):
        """Gets the basic_authentication of this HttpSettingsExtended.  # noqa: E501

        Enable Basic Authentication for HTTP service.  # noqa: E501

        :return: The basic_authentication of this HttpSettingsExtended.  # noqa: E501
        :rtype: bool
        """
        return self._basic_authentication

    @basic_authentication.setter
    def basic_authentication(self, basic_authentication):
        """Sets the basic_authentication of this HttpSettingsExtended.

        Enable Basic Authentication for HTTP service.  # noqa: E501

        :param basic_authentication: The basic_authentication of this HttpSettingsExtended.  # noqa: E501
        :type: bool
        """

        self._basic_authentication = basic_authentication

    @property
    def dav(self):
        """Gets the dav of this HttpSettingsExtended.  # noqa: E501

        Enable DAV specification for HTTP service.  # noqa: E501

        :return: The dav of this HttpSettingsExtended.  # noqa: E501
        :rtype: bool
        """
        return self._dav

    @dav.setter
    def dav(self, dav):
        """Sets the dav of this HttpSettingsExtended.

        Enable DAV specification for HTTP service.  # noqa: E501

        :param dav: The dav of this HttpSettingsExtended.  # noqa: E501
        :type: bool
        """

        self._dav = dav

    @property
    def enable_access_log(self):
        """Gets the enable_access_log of this HttpSettingsExtended.  # noqa: E501

        Enable HTTP access logging for HTTP service.  # noqa: E501

        :return: The enable_access_log of this HttpSettingsExtended.  # noqa: E501
        :rtype: bool
        """
        return self._enable_access_log

    @enable_access_log.setter
    def enable_access_log(self, enable_access_log):
        """Sets the enable_access_log of this HttpSettingsExtended.

        Enable HTTP access logging for HTTP service.  # noqa: E501

        :param enable_access_log: The enable_access_log of this HttpSettingsExtended.  # noqa: E501
        :type: bool
        """

        self._enable_access_log = enable_access_log

    @property
    def httpd_controlpath_redirect(self):
        """Gets the httpd_controlpath_redirect of this HttpSettingsExtended.  # noqa: E501

        Enable or disable WebUI redirect to HTTP service.  # noqa: E501

        :return: The httpd_controlpath_redirect of this HttpSettingsExtended.  # noqa: E501
        :rtype: bool
        """
        return self._httpd_controlpath_redirect

    @httpd_controlpath_redirect.setter
    def httpd_controlpath_redirect(self, httpd_controlpath_redirect):
        """Sets the httpd_controlpath_redirect of this HttpSettingsExtended.

        Enable or disable WebUI redirect to HTTP service.  # noqa: E501

        :param httpd_controlpath_redirect: The httpd_controlpath_redirect of this HttpSettingsExtended.  # noqa: E501
        :type: bool
        """

        self._httpd_controlpath_redirect = httpd_controlpath_redirect

    @property
    def https(self):
        """Gets the https of this HttpSettingsExtended.  # noqa: E501

        Use HTTPS transport for HTTP service.  # noqa: E501

        :return: The https of this HttpSettingsExtended.  # noqa: E501
        :rtype: bool
        """
        return self._https

    @https.setter
    def https(self, https):
        """Sets the https of this HttpSettingsExtended.

        Use HTTPS transport for HTTP service.  # noqa: E501

        :param https: The https of this HttpSettingsExtended.  # noqa: E501
        :type: bool
        """

        self._https = https

    @property
    def inactive_timeout(self):
        """Gets the inactive_timeout of this HttpSettingsExtended.  # noqa: E501

        Get the HTTP RequestReadTimeout directive from both WebUI and HTTP service.  # noqa: E501

        :return: The inactive_timeout of this HttpSettingsExtended.  # noqa: E501
        :rtype: int
        """
        return self._inactive_timeout

    @inactive_timeout.setter
    def inactive_timeout(self, inactive_timeout):
        """Sets the inactive_timeout of this HttpSettingsExtended.

        Get the HTTP RequestReadTimeout directive from both WebUI and HTTP service.  # noqa: E501

        :param inactive_timeout: The inactive_timeout of this HttpSettingsExtended.  # noqa: E501
        :type: int
        """
        if inactive_timeout is not None and inactive_timeout > 31536000:  # noqa: E501
            raise ValueError("Invalid value for `inactive_timeout`, must be a value less than or equal to `31536000`")  # noqa: E501
        if inactive_timeout is not None and inactive_timeout < 60:  # noqa: E501
            raise ValueError("Invalid value for `inactive_timeout`, must be a value greater than or equal to `60`")  # noqa: E501

        self._inactive_timeout = inactive_timeout

    @property
    def integrated_authentication(self):
        """Gets the integrated_authentication of this HttpSettingsExtended.  # noqa: E501

        Enable Integrated Authentication for HTTP service.  # noqa: E501

        :return: The integrated_authentication of this HttpSettingsExtended.  # noqa: E501
        :rtype: bool
        """
        return self._integrated_authentication

    @integrated_authentication.setter
    def integrated_authentication(self, integrated_authentication):
        """Sets the integrated_authentication of this HttpSettingsExtended.

        Enable Integrated Authentication for HTTP service.  # noqa: E501

        :param integrated_authentication: The integrated_authentication of this HttpSettingsExtended.  # noqa: E501
        :type: bool
        """

        self._integrated_authentication = integrated_authentication

    @property
    def server_root(self):
        """Gets the server_root of this HttpSettingsExtended.  # noqa: E501

        Document root directory for HTTP service. Must be within /ifs.  # noqa: E501

        :return: The server_root of this HttpSettingsExtended.  # noqa: E501
        :rtype: str
        """
        return self._server_root

    @server_root.setter
    def server_root(self, server_root):
        """Sets the server_root of this HttpSettingsExtended.

        Document root directory for HTTP service. Must be within /ifs.  # noqa: E501

        :param server_root: The server_root of this HttpSettingsExtended.  # noqa: E501
        :type: str
        """
        if server_root is not None and len(server_root) > 4096:
            raise ValueError("Invalid value for `server_root`, length must be less than or equal to `4096`")  # noqa: E501
        if server_root is not None and len(server_root) < 4:
            raise ValueError("Invalid value for `server_root`, length must be greater than or equal to `4`")  # noqa: E501

        self._server_root = server_root

    @property
    def service(self):
        """Gets the service of this HttpSettingsExtended.  # noqa: E501

        Enable/disable the HTTP service or redirect to WebUI or disabled BasicFileAccess.  # noqa: E501

        :return: The service of this HttpSettingsExtended.  # noqa: E501
        :rtype: str
        """
        return self._service

    @service.setter
    def service(self, service):
        """Sets the service of this HttpSettingsExtended.

        Enable/disable the HTTP service or redirect to WebUI or disabled BasicFileAccess.  # noqa: E501

        :param service: The service of this HttpSettingsExtended.  # noqa: E501
        :type: str
        """
        allowed_values = ["enabled", "disabled", "redirect", "disabled_basicfile"]  # noqa: E501
        if service not in allowed_values:
            raise ValueError(
                "Invalid value for `service` ({0}), must be one of {1}"  # noqa: E501
                .format(service, allowed_values)
            )

        self._service = service

    @property
    def service_timeout(self):
        """Gets the service_timeout of this HttpSettingsExtended.  # noqa: E501

        Get the HTTP Timeout directive from Apache. Value 0 means service timeout is disabled.  # noqa: E501

        :return: The service_timeout of this HttpSettingsExtended.  # noqa: E501
        :rtype: int
        """
        return self._service_timeout

    @service_timeout.setter
    def service_timeout(self, service_timeout):
        """Sets the service_timeout of this HttpSettingsExtended.

        Get the HTTP Timeout directive from Apache. Value 0 means service timeout is disabled.  # noqa: E501

        :param service_timeout: The service_timeout of this HttpSettingsExtended.  # noqa: E501
        :type: int
        """
        if service_timeout is not None and service_timeout > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `service_timeout`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if service_timeout is not None and service_timeout < 0:  # noqa: E501
            raise ValueError("Invalid value for `service_timeout`, must be a value greater than or equal to `0`")  # noqa: E501

        self._service_timeout = service_timeout

    @property
    def session_max_age(self):
        """Gets the session_max_age of this HttpSettingsExtended.  # noqa: E501

        Get the HTTP SessionMaxAge directive from both WebUI and HTTP service.  # noqa: E501

        :return: The session_max_age of this HttpSettingsExtended.  # noqa: E501
        :rtype: int
        """
        return self._session_max_age

    @session_max_age.setter
    def session_max_age(self, session_max_age):
        """Sets the session_max_age of this HttpSettingsExtended.

        Get the HTTP SessionMaxAge directive from both WebUI and HTTP service.  # noqa: E501

        :param session_max_age: The session_max_age of this HttpSettingsExtended.  # noqa: E501
        :type: int
        """
        if session_max_age is not None and session_max_age > 31536000:  # noqa: E501
            raise ValueError("Invalid value for `session_max_age`, must be a value less than or equal to `31536000`")  # noqa: E501
        if session_max_age is not None and session_max_age < 60:  # noqa: E501
            raise ValueError("Invalid value for `session_max_age`, must be a value greater than or equal to `60`")  # noqa: E501

        self._session_max_age = session_max_age

    @property
    def webhdfs_ran_https_port(self):
        """Gets the webhdfs_ran_https_port of this HttpSettingsExtended.  # noqa: E501

        Configure Data Services Port for HTTP service.  # noqa: E501

        :return: The webhdfs_ran_https_port of this HttpSettingsExtended.  # noqa: E501
        :rtype: int
        """
        return self._webhdfs_ran_https_port

    @webhdfs_ran_https_port.setter
    def webhdfs_ran_https_port(self, webhdfs_ran_https_port):
        """Sets the webhdfs_ran_https_port of this HttpSettingsExtended.

        Configure Data Services Port for HTTP service.  # noqa: E501

        :param webhdfs_ran_https_port: The webhdfs_ran_https_port of this HttpSettingsExtended.  # noqa: E501
        :type: int
        """
        if webhdfs_ran_https_port is not None and webhdfs_ran_https_port > 65535:  # noqa: E501
            raise ValueError("Invalid value for `webhdfs_ran_https_port`, must be a value less than or equal to `65535`")  # noqa: E501
        if webhdfs_ran_https_port is not None and webhdfs_ran_https_port < 1025:  # noqa: E501
            raise ValueError("Invalid value for `webhdfs_ran_https_port`, must be a value greater than or equal to `1025`")  # noqa: E501

        self._webhdfs_ran_https_port = webhdfs_ran_https_port

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HttpSettingsExtended):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
