# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class FirewallService(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aliases': 'list[str]',
        'port': 'int',
        'protocol': 'list[str]',
        'service_name': 'str'
    }

    attribute_map = {
        'aliases': 'aliases',
        'port': 'port',
        'protocol': 'protocol',
        'service_name': 'service_name'
    }

    def __init__(self, aliases=None, port=None, protocol=None, service_name=None):  # noqa: E501
        """FirewallService - a model defined in Swagger"""  # noqa: E501

        self._aliases = None
        self._port = None
        self._protocol = None
        self._service_name = None
        self.discriminator = None

        self.aliases = aliases
        self.port = port
        self.protocol = protocol
        self.service_name = service_name

    @property
    def aliases(self):
        """Gets the aliases of this FirewallService.  # noqa: E501

        Aliases of the service name  # noqa: E501

        :return: The aliases of this FirewallService.  # noqa: E501
        :rtype: list[str]
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """Sets the aliases of this FirewallService.

        Aliases of the service name  # noqa: E501

        :param aliases: The aliases of this FirewallService.  # noqa: E501
        :type: list[str]
        """
        if aliases is None:
            raise ValueError("Invalid value for `aliases`, must not be `None`")  # noqa: E501

        self._aliases = aliases

    @property
    def port(self):
        """Gets the port of this FirewallService.  # noqa: E501

        Port number of the service  # noqa: E501

        :return: The port of this FirewallService.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this FirewallService.

        Port number of the service  # noqa: E501

        :param port: The port of this FirewallService.  # noqa: E501
        :type: int
        """
        if port is None:
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501
        if port is not None and port > 65535:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value less than or equal to `65535`")  # noqa: E501
        if port is not None and port < 0:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value greater than or equal to `0`")  # noqa: E501

        self._port = port

    @property
    def protocol(self):
        """Gets the protocol of this FirewallService.  # noqa: E501

        Protocol associated with the service  # noqa: E501

        :return: The protocol of this FirewallService.  # noqa: E501
        :rtype: list[str]
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this FirewallService.

        Protocol associated with the service  # noqa: E501

        :param protocol: The protocol of this FirewallService.  # noqa: E501
        :type: list[str]
        """
        if protocol is None:
            raise ValueError("Invalid value for `protocol`, must not be `None`")  # noqa: E501
        allowed_values = ["ALL", "TCP", "UDP", "ICMP", "ICMP6"]  # noqa: E501
        if not set(protocol).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `protocol` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(protocol) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._protocol = protocol

    @property
    def service_name(self):
        """Gets the service_name of this FirewallService.  # noqa: E501

        The name of the firewall service.  # noqa: E501

        :return: The service_name of this FirewallService.  # noqa: E501
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """Sets the service_name of this FirewallService.

        The name of the firewall service.  # noqa: E501

        :param service_name: The service_name of this FirewallService.  # noqa: E501
        :type: str
        """
        if service_name is None:
            raise ValueError("Invalid value for `service_name`, must not be `None`")  # noqa: E501
        if service_name is not None and len(service_name) > 32:
            raise ValueError("Invalid value for `service_name`, length must be less than or equal to `32`")  # noqa: E501
        if service_name is not None and len(service_name) < 1:
            raise ValueError("Invalid value for `service_name`, length must be greater than or equal to `1`")  # noqa: E501
        if service_name is not None and not re.search('^[^-][0-9a-zA-Z_-]*[^-]$', service_name):  # noqa: E501
            raise ValueError("Invalid value for `service_name`, must be a follow pattern or equal to `/^[^-][0-9a-zA-Z_-]*[^-]$/`")  # noqa: E501

        self._service_name = service_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FirewallService):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
