# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_5_0.models.datamover_base_policy_schedule import DatamoverBasePolicySchedule  # noqa: F401,E501
from isilon_sdk.v9_5_0.models.datamover_policy_policy_specific_attr import DatamoverPolicyPolicySpecificAttr  # noqa: F401,E501


class DatamoverPolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'base_policy_id': 'int',
        'briefcase': 'str',
        'enabled': 'bool',
        'name': 'str',
        'parent_exec_policy_id': 'int',
        'policy_specific_attr': 'DatamoverPolicyPolicySpecificAttr',
        'priority': 'str',
        'run_now': 'bool',
        'schedule': 'DatamoverBasePolicySchedule',
        'version': 'int'
    }

    attribute_map = {
        'base_policy_id': 'base_policy_id',
        'briefcase': 'briefcase',
        'enabled': 'enabled',
        'name': 'name',
        'parent_exec_policy_id': 'parent_exec_policy_id',
        'policy_specific_attr': 'policy_specific_attr',
        'priority': 'priority',
        'run_now': 'run_now',
        'schedule': 'schedule',
        'version': 'version'
    }

    def __init__(self, base_policy_id=None, briefcase=None, enabled=None, name=None, parent_exec_policy_id=None, policy_specific_attr=None, priority=None, run_now=None, schedule=None, version=None):  # noqa: E501
        """DatamoverPolicy - a model defined in Swagger"""  # noqa: E501

        self._base_policy_id = None
        self._briefcase = None
        self._enabled = None
        self._name = None
        self._parent_exec_policy_id = None
        self._policy_specific_attr = None
        self._priority = None
        self._run_now = None
        self._schedule = None
        self._version = None
        self.discriminator = None

        if base_policy_id is not None:
            self.base_policy_id = base_policy_id
        if briefcase is not None:
            self.briefcase = briefcase
        if enabled is not None:
            self.enabled = enabled
        if name is not None:
            self.name = name
        if parent_exec_policy_id is not None:
            self.parent_exec_policy_id = parent_exec_policy_id
        if policy_specific_attr is not None:
            self.policy_specific_attr = policy_specific_attr
        if priority is not None:
            self.priority = priority
        if run_now is not None:
            self.run_now = run_now
        if schedule is not None:
            self.schedule = schedule
        if version is not None:
            self.version = version

    @property
    def base_policy_id(self):
        """Gets the base_policy_id of this DatamoverPolicy.  # noqa: E501

        Policy ID associated with this job.  # noqa: E501

        :return: The base_policy_id of this DatamoverPolicy.  # noqa: E501
        :rtype: int
        """
        return self._base_policy_id

    @base_policy_id.setter
    def base_policy_id(self, base_policy_id):
        """Sets the base_policy_id of this DatamoverPolicy.

        Policy ID associated with this job.  # noqa: E501

        :param base_policy_id: The base_policy_id of this DatamoverPolicy.  # noqa: E501
        :type: int
        """
        if base_policy_id is not None and base_policy_id > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `base_policy_id`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if base_policy_id is not None and base_policy_id < 0:  # noqa: E501
            raise ValueError("Invalid value for `base_policy_id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._base_policy_id = base_policy_id

    @property
    def briefcase(self):
        """Gets the briefcase of this DatamoverPolicy.  # noqa: E501

        An opaque container for storing additional data in this object, e.g. key-value pairs  # noqa: E501

        :return: The briefcase of this DatamoverPolicy.  # noqa: E501
        :rtype: str
        """
        return self._briefcase

    @briefcase.setter
    def briefcase(self, briefcase):
        """Sets the briefcase of this DatamoverPolicy.

        An opaque container for storing additional data in this object, e.g. key-value pairs  # noqa: E501

        :param briefcase: The briefcase of this DatamoverPolicy.  # noqa: E501
        :type: str
        """
        if briefcase is not None and len(briefcase) > 512:
            raise ValueError("Invalid value for `briefcase`, length must be less than or equal to `512`")  # noqa: E501
        if briefcase is not None and len(briefcase) < 0:
            raise ValueError("Invalid value for `briefcase`, length must be greater than or equal to `0`")  # noqa: E501

        self._briefcase = briefcase

    @property
    def enabled(self):
        """Gets the enabled of this DatamoverPolicy.  # noqa: E501

        True: policy is enabled, False: otherwise.  # noqa: E501

        :return: The enabled of this DatamoverPolicy.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this DatamoverPolicy.

        True: policy is enabled, False: otherwise.  # noqa: E501

        :param enabled: The enabled of this DatamoverPolicy.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def name(self):
        """Gets the name of this DatamoverPolicy.  # noqa: E501

        A user provided policy name.  # noqa: E501

        :return: The name of this DatamoverPolicy.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DatamoverPolicy.

        A user provided policy name.  # noqa: E501

        :param name: The name of this DatamoverPolicy.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def parent_exec_policy_id(self):
        """Gets the parent_exec_policy_id of this DatamoverPolicy.  # noqa: E501

        If a valid policy ID, then a job for this policy will be scheduled immediately after the parent policy job completes. This is optional field  # noqa: E501

        :return: The parent_exec_policy_id of this DatamoverPolicy.  # noqa: E501
        :rtype: int
        """
        return self._parent_exec_policy_id

    @parent_exec_policy_id.setter
    def parent_exec_policy_id(self, parent_exec_policy_id):
        """Sets the parent_exec_policy_id of this DatamoverPolicy.

        If a valid policy ID, then a job for this policy will be scheduled immediately after the parent policy job completes. This is optional field  # noqa: E501

        :param parent_exec_policy_id: The parent_exec_policy_id of this DatamoverPolicy.  # noqa: E501
        :type: int
        """
        if parent_exec_policy_id is not None and parent_exec_policy_id > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `parent_exec_policy_id`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if parent_exec_policy_id is not None and parent_exec_policy_id < 0:  # noqa: E501
            raise ValueError("Invalid value for `parent_exec_policy_id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._parent_exec_policy_id = parent_exec_policy_id

    @property
    def policy_specific_attr(self):
        """Gets the policy_specific_attr of this DatamoverPolicy.  # noqa: E501

          # noqa: E501

        :return: The policy_specific_attr of this DatamoverPolicy.  # noqa: E501
        :rtype: DatamoverPolicyPolicySpecificAttr
        """
        return self._policy_specific_attr

    @policy_specific_attr.setter
    def policy_specific_attr(self, policy_specific_attr):
        """Sets the policy_specific_attr of this DatamoverPolicy.

          # noqa: E501

        :param policy_specific_attr: The policy_specific_attr of this DatamoverPolicy.  # noqa: E501
        :type: DatamoverPolicyPolicySpecificAttr
        """

        self._policy_specific_attr = policy_specific_attr

    @property
    def priority(self):
        """Gets the priority of this DatamoverPolicy.  # noqa: E501

        The relative priority of the policy.  # noqa: E501

        :return: The priority of this DatamoverPolicy.  # noqa: E501
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this DatamoverPolicy.

        The relative priority of the policy.  # noqa: E501

        :param priority: The priority of this DatamoverPolicy.  # noqa: E501
        :type: str
        """
        allowed_values = ["LOW", "NORMAL", "HIGH"]  # noqa: E501
        if priority not in allowed_values:
            raise ValueError(
                "Invalid value for `priority` ({0}), must be one of {1}"  # noqa: E501
                .format(priority, allowed_values)
            )

        self._priority = priority

    @property
    def run_now(self):
        """Gets the run_now of this DatamoverPolicy.  # noqa: E501

        Execute the policy immediately instead of waiting for it to run as scheduled.  # noqa: E501

        :return: The run_now of this DatamoverPolicy.  # noqa: E501
        :rtype: bool
        """
        return self._run_now

    @run_now.setter
    def run_now(self, run_now):
        """Sets the run_now of this DatamoverPolicy.

        Execute the policy immediately instead of waiting for it to run as scheduled.  # noqa: E501

        :param run_now: The run_now of this DatamoverPolicy.  # noqa: E501
        :type: bool
        """

        self._run_now = run_now

    @property
    def schedule(self):
        """Gets the schedule of this DatamoverPolicy.  # noqa: E501

        The schedule of the policy- start time, recurrence, specific date-times.  # noqa: E501

        :return: The schedule of this DatamoverPolicy.  # noqa: E501
        :rtype: DatamoverBasePolicySchedule
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """Sets the schedule of this DatamoverPolicy.

        The schedule of the policy- start time, recurrence, specific date-times.  # noqa: E501

        :param schedule: The schedule of this DatamoverPolicy.  # noqa: E501
        :type: DatamoverBasePolicySchedule
        """

        self._schedule = schedule

    @property
    def version(self):
        """Gets the version of this DatamoverPolicy.  # noqa: E501

        Version number of the config store when this object was edited.  # noqa: E501

        :return: The version of this DatamoverPolicy.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this DatamoverPolicy.

        Version number of the config store when this object was edited.  # noqa: E501

        :param version: The version of this DatamoverPolicy.  # noqa: E501
        :type: int
        """
        if version is not None and version > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `version`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if version is not None and version < 0:  # noqa: E501
            raise ValueError("Invalid value for `version`, must be a value greater than or equal to `0`")  # noqa: E501

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatamoverPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
