# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_5_0.models.datamover_base_policy import DatamoverBasePolicy  # noqa: F401,E501
from isilon_sdk.v9_5_0.models.datamover_base_policy_schedule import DatamoverBasePolicySchedule  # noqa: F401,E501
from isilon_sdk.v9_5_0.models.datamover_base_policy_src_dataset_retention import DatamoverBasePolicySrcDatasetRetention  # noqa: F401,E501


class DatamoverBasePolicyCreateParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'base_account_id': 'str',
        'briefcase': 'str',
        'enabled': 'bool',
        'name': 'str',
        'new_tasks_account': 'str',
        'override_list': 'list[str]',
        'priority': 'str',
        'schedule': 'DatamoverBasePolicySchedule',
        'source_account_id': 'str',
        'source_base_path': 'str',
        'source_subpaths': 'list[str]',
        'src_dataset_retention': 'DatamoverBasePolicySrcDatasetRetention',
        'target_account_id': 'str',
        'target_base_path': 'str',
        'tgt_dataset_retention': 'DatamoverBasePolicySrcDatasetRetention',
        'version': 'int',
        'id': 'int'
    }

    attribute_map = {
        'base_account_id': 'base_account_id',
        'briefcase': 'briefcase',
        'enabled': 'enabled',
        'name': 'name',
        'new_tasks_account': 'new_tasks_account',
        'override_list': 'override_list',
        'priority': 'priority',
        'schedule': 'schedule',
        'source_account_id': 'source_account_id',
        'source_base_path': 'source_base_path',
        'source_subpaths': 'source_subpaths',
        'src_dataset_retention': 'src_dataset_retention',
        'target_account_id': 'target_account_id',
        'target_base_path': 'target_base_path',
        'tgt_dataset_retention': 'tgt_dataset_retention',
        'version': 'version',
        'id': 'id'
    }

    def __init__(self, base_account_id=None, briefcase=None, enabled=None, name=None, new_tasks_account=None, override_list=None, priority=None, schedule=None, source_account_id=None, source_base_path=None, source_subpaths=None, src_dataset_retention=None, target_account_id=None, target_base_path=None, tgt_dataset_retention=None, version=None, id=None):  # noqa: E501
        """DatamoverBasePolicyCreateParams - a model defined in Swagger"""  # noqa: E501

        self._base_account_id = None
        self._briefcase = None
        self._enabled = None
        self._name = None
        self._new_tasks_account = None
        self._override_list = None
        self._priority = None
        self._schedule = None
        self._source_account_id = None
        self._source_base_path = None
        self._source_subpaths = None
        self._src_dataset_retention = None
        self._target_account_id = None
        self._target_base_path = None
        self._tgt_dataset_retention = None
        self._version = None
        self._id = None
        self.discriminator = None

        if base_account_id is not None:
            self.base_account_id = base_account_id
        if briefcase is not None:
            self.briefcase = briefcase
        if enabled is not None:
            self.enabled = enabled
        self.name = name
        if new_tasks_account is not None:
            self.new_tasks_account = new_tasks_account
        self.override_list = override_list
        if priority is not None:
            self.priority = priority
        if schedule is not None:
            self.schedule = schedule
        if source_account_id is not None:
            self.source_account_id = source_account_id
        if source_base_path is not None:
            self.source_base_path = source_base_path
        if source_subpaths is not None:
            self.source_subpaths = source_subpaths
        if src_dataset_retention is not None:
            self.src_dataset_retention = src_dataset_retention
        if target_account_id is not None:
            self.target_account_id = target_account_id
        if target_base_path is not None:
            self.target_base_path = target_base_path
        if tgt_dataset_retention is not None:
            self.tgt_dataset_retention = tgt_dataset_retention
        if version is not None:
            self.version = version
        if id is not None:
            self.id = id

    @property
    def base_account_id(self):
        """Gets the base_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501

        Account ID (local or remote DM system) where the policy should be created.  # noqa: E501

        :return: The base_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._base_account_id

    @base_account_id.setter
    def base_account_id(self, base_account_id):
        """Sets the base_account_id of this DatamoverBasePolicyCreateParams.

        Account ID (local or remote DM system) where the policy should be created.  # noqa: E501

        :param base_account_id: The base_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if base_account_id is not None and len(base_account_id) > 48:
            raise ValueError("Invalid value for `base_account_id`, length must be less than or equal to `48`")  # noqa: E501
        if base_account_id is not None and len(base_account_id) < 2:
            raise ValueError("Invalid value for `base_account_id`, length must be greater than or equal to `2`")  # noqa: E501

        self._base_account_id = base_account_id

    @property
    def briefcase(self):
        """Gets the briefcase of this DatamoverBasePolicyCreateParams.  # noqa: E501

        An opaque container for storing additional data in this object, e.g. key-value pairs  # noqa: E501

        :return: The briefcase of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._briefcase

    @briefcase.setter
    def briefcase(self, briefcase):
        """Sets the briefcase of this DatamoverBasePolicyCreateParams.

        An opaque container for storing additional data in this object, e.g. key-value pairs  # noqa: E501

        :param briefcase: The briefcase of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if briefcase is not None and len(briefcase) > 512:
            raise ValueError("Invalid value for `briefcase`, length must be less than or equal to `512`")  # noqa: E501
        if briefcase is not None and len(briefcase) < 0:
            raise ValueError("Invalid value for `briefcase`, length must be greater than or equal to `0`")  # noqa: E501

        self._briefcase = briefcase

    @property
    def enabled(self):
        """Gets the enabled of this DatamoverBasePolicyCreateParams.  # noqa: E501

        True: policy is enabled, False: otherwise.  # noqa: E501

        :return: The enabled of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this DatamoverBasePolicyCreateParams.

        True: policy is enabled, False: otherwise.  # noqa: E501

        :param enabled: The enabled of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: bool
        """

        self._enabled = enabled

    @property
    def name(self):
        """Gets the name of this DatamoverBasePolicyCreateParams.  # noqa: E501

        A user provided base policy name.  # noqa: E501

        :return: The name of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DatamoverBasePolicyCreateParams.

        A user provided base policy name.  # noqa: E501

        :param name: The name of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def new_tasks_account(self):
        """Gets the new_tasks_account of this DatamoverBasePolicyCreateParams.  # noqa: E501

        Account of the system to create tasks on. This overrides the default task affinity.  # noqa: E501

        :return: The new_tasks_account of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._new_tasks_account

    @new_tasks_account.setter
    def new_tasks_account(self, new_tasks_account):
        """Sets the new_tasks_account of this DatamoverBasePolicyCreateParams.

        Account of the system to create tasks on. This overrides the default task affinity.  # noqa: E501

        :param new_tasks_account: The new_tasks_account of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if new_tasks_account is not None and len(new_tasks_account) > 48:
            raise ValueError("Invalid value for `new_tasks_account`, length must be less than or equal to `48`")  # noqa: E501
        if new_tasks_account is not None and len(new_tasks_account) < 2:
            raise ValueError("Invalid value for `new_tasks_account`, length must be greater than or equal to `2`")  # noqa: E501

        self._new_tasks_account = new_tasks_account

    @property
    def override_list(self):
        """Gets the override_list of this DatamoverBasePolicyCreateParams.  # noqa: E501

        The list of fields which will override a concrete policy.  # noqa: E501

        :return: The override_list of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._override_list

    @override_list.setter
    def override_list(self, override_list):
        """Sets the override_list of this DatamoverBasePolicyCreateParams.

        The list of fields which will override a concrete policy.  # noqa: E501

        :param override_list: The override_list of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: list[str]
        """
        if override_list is None:
            raise ValueError("Invalid value for `override_list`, must not be `None`")  # noqa: E501
        allowed_values = ["ENABLED", "PRIORITY", "SCHEDULE", "BRIEFCASE", "SOURCE_ACCOUNT_ID", "TARGET_ACCOUNT_ID", "BASE_ACCOUNT_ID", "TASK_ACCOUNT_ID", "SUBPATHS", "SOURCE_BASE_PATH", "TARGET_BASE_PATH", "SRC_DATASET_RETENTION", "TGT_DATASET_RETENTION"]  # noqa: E501
        if not set(override_list).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `override_list` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(override_list) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._override_list = override_list

    @property
    def priority(self):
        """Gets the priority of this DatamoverBasePolicyCreateParams.  # noqa: E501

        The relative priority of the policy.  # noqa: E501

        :return: The priority of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this DatamoverBasePolicyCreateParams.

        The relative priority of the policy.  # noqa: E501

        :param priority: The priority of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        allowed_values = ["LOW", "NORMAL", "HIGH"]  # noqa: E501
        if priority not in allowed_values:
            raise ValueError(
                "Invalid value for `priority` ({0}), must be one of {1}"  # noqa: E501
                .format(priority, allowed_values)
            )

        self._priority = priority

    @property
    def schedule(self):
        """Gets the schedule of this DatamoverBasePolicyCreateParams.  # noqa: E501

        The schedule of the policy- start time, recurrence, specific date-times.  # noqa: E501

        :return: The schedule of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: DatamoverBasePolicySchedule
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """Sets the schedule of this DatamoverBasePolicyCreateParams.

        The schedule of the policy- start time, recurrence, specific date-times.  # noqa: E501

        :param schedule: The schedule of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: DatamoverBasePolicySchedule
        """

        self._schedule = schedule

    @property
    def source_account_id(self):
        """Gets the source_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501

        Account ID of the source data storage.  # noqa: E501

        :return: The source_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._source_account_id

    @source_account_id.setter
    def source_account_id(self, source_account_id):
        """Sets the source_account_id of this DatamoverBasePolicyCreateParams.

        Account ID of the source data storage.  # noqa: E501

        :param source_account_id: The source_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if source_account_id is not None and len(source_account_id) > 48:
            raise ValueError("Invalid value for `source_account_id`, length must be less than or equal to `48`")  # noqa: E501
        if source_account_id is not None and len(source_account_id) < 2:
            raise ValueError("Invalid value for `source_account_id`, length must be greater than or equal to `2`")  # noqa: E501

        self._source_account_id = source_account_id

    @property
    def source_base_path(self):
        """Gets the source_base_path of this DatamoverBasePolicyCreateParams.  # noqa: E501

        Filesystem base path on source DM system which has the directories/files for which dataset has to be created.  # noqa: E501

        :return: The source_base_path of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._source_base_path

    @source_base_path.setter
    def source_base_path(self, source_base_path):
        """Sets the source_base_path of this DatamoverBasePolicyCreateParams.

        Filesystem base path on source DM system which has the directories/files for which dataset has to be created.  # noqa: E501

        :param source_base_path: The source_base_path of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if source_base_path is not None and len(source_base_path) > 4096:
            raise ValueError("Invalid value for `source_base_path`, length must be less than or equal to `4096`")  # noqa: E501
        if source_base_path is not None and len(source_base_path) < 1:
            raise ValueError("Invalid value for `source_base_path`, length must be greater than or equal to `1`")  # noqa: E501

        self._source_base_path = source_base_path

    @property
    def source_subpaths(self):
        """Gets the source_subpaths of this DatamoverBasePolicyCreateParams.  # noqa: E501

        Set of filesystem paths relative to base path.  # noqa: E501

        :return: The source_subpaths of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._source_subpaths

    @source_subpaths.setter
    def source_subpaths(self, source_subpaths):
        """Sets the source_subpaths of this DatamoverBasePolicyCreateParams.

        Set of filesystem paths relative to base path.  # noqa: E501

        :param source_subpaths: The source_subpaths of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: list[str]
        """

        self._source_subpaths = source_subpaths

    @property
    def src_dataset_retention(self):
        """Gets the src_dataset_retention of this DatamoverBasePolicyCreateParams.  # noqa: E501

          # noqa: E501

        :return: The src_dataset_retention of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: DatamoverBasePolicySrcDatasetRetention
        """
        return self._src_dataset_retention

    @src_dataset_retention.setter
    def src_dataset_retention(self, src_dataset_retention):
        """Sets the src_dataset_retention of this DatamoverBasePolicyCreateParams.

          # noqa: E501

        :param src_dataset_retention: The src_dataset_retention of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: DatamoverBasePolicySrcDatasetRetention
        """

        self._src_dataset_retention = src_dataset_retention

    @property
    def target_account_id(self):
        """Gets the target_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501

        Account ID of the target data storage.  # noqa: E501

        :return: The target_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_account_id

    @target_account_id.setter
    def target_account_id(self, target_account_id):
        """Sets the target_account_id of this DatamoverBasePolicyCreateParams.

        Account ID of the target data storage.  # noqa: E501

        :param target_account_id: The target_account_id of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if target_account_id is not None and len(target_account_id) > 48:
            raise ValueError("Invalid value for `target_account_id`, length must be less than or equal to `48`")  # noqa: E501
        if target_account_id is not None and len(target_account_id) < 2:
            raise ValueError("Invalid value for `target_account_id`, length must be greater than or equal to `2`")  # noqa: E501

        self._target_account_id = target_account_id

    @property
    def target_base_path(self):
        """Gets the target_base_path of this DatamoverBasePolicyCreateParams.  # noqa: E501

        Filesystem base path on target DM syestem which has the directories/files for which dataset has to be created.  # noqa: E501

        :return: The target_base_path of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._target_base_path

    @target_base_path.setter
    def target_base_path(self, target_base_path):
        """Sets the target_base_path of this DatamoverBasePolicyCreateParams.

        Filesystem base path on target DM syestem which has the directories/files for which dataset has to be created.  # noqa: E501

        :param target_base_path: The target_base_path of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: str
        """
        if target_base_path is not None and len(target_base_path) > 4096:
            raise ValueError("Invalid value for `target_base_path`, length must be less than or equal to `4096`")  # noqa: E501
        if target_base_path is not None and len(target_base_path) < 1:
            raise ValueError("Invalid value for `target_base_path`, length must be greater than or equal to `1`")  # noqa: E501

        self._target_base_path = target_base_path

    @property
    def tgt_dataset_retention(self):
        """Gets the tgt_dataset_retention of this DatamoverBasePolicyCreateParams.  # noqa: E501

          # noqa: E501

        :return: The tgt_dataset_retention of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: DatamoverBasePolicySrcDatasetRetention
        """
        return self._tgt_dataset_retention

    @tgt_dataset_retention.setter
    def tgt_dataset_retention(self, tgt_dataset_retention):
        """Sets the tgt_dataset_retention of this DatamoverBasePolicyCreateParams.

          # noqa: E501

        :param tgt_dataset_retention: The tgt_dataset_retention of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: DatamoverBasePolicySrcDatasetRetention
        """

        self._tgt_dataset_retention = tgt_dataset_retention

    @property
    def version(self):
        """Gets the version of this DatamoverBasePolicyCreateParams.  # noqa: E501

        Version number of the config store when this object was edited.  # noqa: E501

        :return: The version of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this DatamoverBasePolicyCreateParams.

        Version number of the config store when this object was edited.  # noqa: E501

        :param version: The version of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if version is not None and version > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `version`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if version is not None and version < 0:  # noqa: E501
            raise ValueError("Invalid value for `version`, must be a value greater than or equal to `0`")  # noqa: E501

        self._version = version

    @property
    def id(self):
        """Gets the id of this DatamoverBasePolicyCreateParams.  # noqa: E501

        The unique policy identifier.  # noqa: E501

        :return: The id of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DatamoverBasePolicyCreateParams.

        The unique policy identifier.  # noqa: E501

        :param id: The id of this DatamoverBasePolicyCreateParams.  # noqa: E501
        :type: int
        """
        if id is not None and id > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if id is not None and id < 0:  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._id = id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatamoverBasePolicyCreateParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
