# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_5_0.models.cloud_job_files_name import CloudJobFilesName  # noqa: F401,E501
from isilon_sdk.v9_5_0.models.empty import Empty  # noqa: F401,E501


class CloudJobFiles(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'file_matching_pattern': 'Empty',
        'names': 'list[CloudJobFilesName]',
        'total': 'int',
        'total_canceled': 'int',
        'total_failed': 'int',
        'total_pending': 'int',
        'total_processing': 'int',
        'total_succeeded': 'int'
    }

    attribute_map = {
        'file_matching_pattern': 'file_matching_pattern',
        'names': 'names',
        'total': 'total',
        'total_canceled': 'total_canceled',
        'total_failed': 'total_failed',
        'total_pending': 'total_pending',
        'total_processing': 'total_processing',
        'total_succeeded': 'total_succeeded'
    }

    def __init__(self, file_matching_pattern=None, names=None, total=None, total_canceled=None, total_failed=None, total_pending=None, total_processing=None, total_succeeded=None):  # noqa: E501
        """CloudJobFiles - a model defined in Swagger"""  # noqa: E501

        self._file_matching_pattern = None
        self._names = None
        self._total = None
        self._total_canceled = None
        self._total_failed = None
        self._total_pending = None
        self._total_processing = None
        self._total_succeeded = None
        self.discriminator = None

        if file_matching_pattern is not None:
            self.file_matching_pattern = file_matching_pattern
        if names is not None:
            self.names = names
        if total is not None:
            self.total = total
        if total_canceled is not None:
            self.total_canceled = total_canceled
        if total_failed is not None:
            self.total_failed = total_failed
        if total_pending is not None:
            self.total_pending = total_pending
        if total_processing is not None:
            self.total_processing = total_processing
        if total_succeeded is not None:
            self.total_succeeded = total_succeeded

    @property
    def file_matching_pattern(self):
        """Gets the file_matching_pattern of this CloudJobFiles.  # noqa: E501

        The file filtering logic to find files for this job  # noqa: E501

        :return: The file_matching_pattern of this CloudJobFiles.  # noqa: E501
        :rtype: Empty
        """
        return self._file_matching_pattern

    @file_matching_pattern.setter
    def file_matching_pattern(self, file_matching_pattern):
        """Sets the file_matching_pattern of this CloudJobFiles.

        The file filtering logic to find files for this job  # noqa: E501

        :param file_matching_pattern: The file_matching_pattern of this CloudJobFiles.  # noqa: E501
        :type: Empty
        """

        self._file_matching_pattern = file_matching_pattern

    @property
    def names(self):
        """Gets the names of this CloudJobFiles.  # noqa: E501

        A list of files to be addressed by this job.  (Note* these are only reported when audit_level is 'high'  # noqa: E501

        :return: The names of this CloudJobFiles.  # noqa: E501
        :rtype: list[CloudJobFilesName]
        """
        return self._names

    @names.setter
    def names(self, names):
        """Sets the names of this CloudJobFiles.

        A list of files to be addressed by this job.  (Note* these are only reported when audit_level is 'high'  # noqa: E501

        :param names: The names of this CloudJobFiles.  # noqa: E501
        :type: list[CloudJobFilesName]
        """

        self._names = names

    @property
    def total(self):
        """Gets the total of this CloudJobFiles.  # noqa: E501

        The total number of files addressed by this job  # noqa: E501

        :return: The total of this CloudJobFiles.  # noqa: E501
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this CloudJobFiles.

        The total number of files addressed by this job  # noqa: E501

        :param total: The total of this CloudJobFiles.  # noqa: E501
        :type: int
        """

        self._total = total

    @property
    def total_canceled(self):
        """Gets the total_canceled of this CloudJobFiles.  # noqa: E501

        The number of canceled files  # noqa: E501

        :return: The total_canceled of this CloudJobFiles.  # noqa: E501
        :rtype: int
        """
        return self._total_canceled

    @total_canceled.setter
    def total_canceled(self, total_canceled):
        """Sets the total_canceled of this CloudJobFiles.

        The number of canceled files  # noqa: E501

        :param total_canceled: The total_canceled of this CloudJobFiles.  # noqa: E501
        :type: int
        """

        self._total_canceled = total_canceled

    @property
    def total_failed(self):
        """Gets the total_failed of this CloudJobFiles.  # noqa: E501

        The number of files which failed  # noqa: E501

        :return: The total_failed of this CloudJobFiles.  # noqa: E501
        :rtype: int
        """
        return self._total_failed

    @total_failed.setter
    def total_failed(self, total_failed):
        """Sets the total_failed of this CloudJobFiles.

        The number of files which failed  # noqa: E501

        :param total_failed: The total_failed of this CloudJobFiles.  # noqa: E501
        :type: int
        """

        self._total_failed = total_failed

    @property
    def total_pending(self):
        """Gets the total_pending of this CloudJobFiles.  # noqa: E501

        The number of files pending action  # noqa: E501

        :return: The total_pending of this CloudJobFiles.  # noqa: E501
        :rtype: int
        """
        return self._total_pending

    @total_pending.setter
    def total_pending(self, total_pending):
        """Sets the total_pending of this CloudJobFiles.

        The number of files pending action  # noqa: E501

        :param total_pending: The total_pending of this CloudJobFiles.  # noqa: E501
        :type: int
        """

        self._total_pending = total_pending

    @property
    def total_processing(self):
        """Gets the total_processing of this CloudJobFiles.  # noqa: E501

        The number of files currently being processed  # noqa: E501

        :return: The total_processing of this CloudJobFiles.  # noqa: E501
        :rtype: int
        """
        return self._total_processing

    @total_processing.setter
    def total_processing(self, total_processing):
        """Sets the total_processing of this CloudJobFiles.

        The number of files currently being processed  # noqa: E501

        :param total_processing: The total_processing of this CloudJobFiles.  # noqa: E501
        :type: int
        """

        self._total_processing = total_processing

    @property
    def total_succeeded(self):
        """Gets the total_succeeded of this CloudJobFiles.  # noqa: E501

        The total number of files successfully completed  # noqa: E501

        :return: The total_succeeded of this CloudJobFiles.  # noqa: E501
        :rtype: int
        """
        return self._total_succeeded

    @total_succeeded.setter
    def total_succeeded(self, total_succeeded):
        """Sets the total_succeeded of this CloudJobFiles.

        The total number of files successfully completed  # noqa: E501

        :param total_succeeded: The total_succeeded of this CloudJobFiles.  # noqa: E501
        :type: int
        """

        self._total_succeeded = total_succeeded

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CloudJobFiles):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
