# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CertificatesSettingsSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enable_encryption': 'bool',
        'ocsp_uri': 'str',
        'revocation_setting': 'str',
        'strict_hostname_check': 'bool'
    }

    attribute_map = {
        'enable_encryption': 'enable_encryption',
        'ocsp_uri': 'ocsp_uri',
        'revocation_setting': 'revocation_setting',
        'strict_hostname_check': 'strict_hostname_check'
    }

    def __init__(self, enable_encryption=None, ocsp_uri=None, revocation_setting=None, strict_hostname_check=None):  # noqa: E501
        """CertificatesSettingsSettings - a model defined in Swagger"""  # noqa: E501

        self._enable_encryption = None
        self._ocsp_uri = None
        self._revocation_setting = None
        self._strict_hostname_check = None
        self.discriminator = None

        if enable_encryption is not None:
            self.enable_encryption = enable_encryption
        if ocsp_uri is not None:
            self.ocsp_uri = ocsp_uri
        if revocation_setting is not None:
            self.revocation_setting = revocation_setting
        if strict_hostname_check is not None:
            self.strict_hostname_check = strict_hostname_check

    @property
    def enable_encryption(self):
        """Gets the enable_encryption of this CertificatesSettingsSettings.  # noqa: E501

        Enables encryption. If disabled, TLS handshakes still must succeed, but once successful, traffic is left unencrypted.  # noqa: E501

        :return: The enable_encryption of this CertificatesSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._enable_encryption

    @enable_encryption.setter
    def enable_encryption(self, enable_encryption):
        """Sets the enable_encryption of this CertificatesSettingsSettings.

        Enables encryption. If disabled, TLS handshakes still must succeed, but once successful, traffic is left unencrypted.  # noqa: E501

        :param enable_encryption: The enable_encryption of this CertificatesSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._enable_encryption = enable_encryption

    @property
    def ocsp_uri(self):
        """Gets the ocsp_uri of this CertificatesSettingsSettings.  # noqa: E501

        The URI of the server to check revocation status against if the received certificate does not contain an AIA extension.  # noqa: E501

        :return: The ocsp_uri of this CertificatesSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._ocsp_uri

    @ocsp_uri.setter
    def ocsp_uri(self, ocsp_uri):
        """Sets the ocsp_uri of this CertificatesSettingsSettings.

        The URI of the server to check revocation status against if the received certificate does not contain an AIA extension.  # noqa: E501

        :param ocsp_uri: The ocsp_uri of this CertificatesSettingsSettings.  # noqa: E501
        :type: str
        """
        if ocsp_uri is not None and len(ocsp_uri) > 1024:
            raise ValueError("Invalid value for `ocsp_uri`, length must be less than or equal to `1024`")  # noqa: E501
        if ocsp_uri is not None and len(ocsp_uri) < 0:
            raise ValueError("Invalid value for `ocsp_uri`, length must be greater than or equal to `0`")  # noqa: E501

        self._ocsp_uri = ocsp_uri

    @property
    def revocation_setting(self):
        """Gets the revocation_setting of this CertificatesSettingsSettings.  # noqa: E501

        The strictness of revocation checking to use.NONE:  Don't check for revoked certificates.STRICT: Check for revoked certificates and fail the handshake if any certificate in the chain is revoked, or if revocation status data cannot be obtained.ALLOW_NO_REVOKE_SRC: Allow handshakes to proceed if a certificate does not contain information on where to check for revocation (e.g. no OCSP responder field).ALLOW_REVOKE_DATA_UNAVAILABLE: Attempt to check each certificate for revocation status, but proceed if revocation status information is unavailable.  # noqa: E501

        :return: The revocation_setting of this CertificatesSettingsSettings.  # noqa: E501
        :rtype: str
        """
        return self._revocation_setting

    @revocation_setting.setter
    def revocation_setting(self, revocation_setting):
        """Sets the revocation_setting of this CertificatesSettingsSettings.

        The strictness of revocation checking to use.NONE:  Don't check for revoked certificates.STRICT: Check for revoked certificates and fail the handshake if any certificate in the chain is revoked, or if revocation status data cannot be obtained.ALLOW_NO_REVOKE_SRC: Allow handshakes to proceed if a certificate does not contain information on where to check for revocation (e.g. no OCSP responder field).ALLOW_REVOKE_DATA_UNAVAILABLE: Attempt to check each certificate for revocation status, but proceed if revocation status information is unavailable.  # noqa: E501

        :param revocation_setting: The revocation_setting of this CertificatesSettingsSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["NONE", "STRICT", "ALLOW_NO_REVOKE_SRC", "ALLOW_REVOKE_DATA_UNAVAILABLE"]  # noqa: E501
        if revocation_setting not in allowed_values:
            raise ValueError(
                "Invalid value for `revocation_setting` ({0}), must be one of {1}"  # noqa: E501
                .format(revocation_setting, allowed_values)
            )

        self._revocation_setting = revocation_setting

    @property
    def strict_hostname_check(self):
        """Gets the strict_hostname_check of this CertificatesSettingsSettings.  # noqa: E501

        If enabled, the CN in the certificate presented by the remote host must match the CN used to connect to that host for the handshake to succeed.  # noqa: E501

        :return: The strict_hostname_check of this CertificatesSettingsSettings.  # noqa: E501
        :rtype: bool
        """
        return self._strict_hostname_check

    @strict_hostname_check.setter
    def strict_hostname_check(self, strict_hostname_check):
        """Sets the strict_hostname_check of this CertificatesSettingsSettings.

        If enabled, the CN in the certificate presented by the remote host must match the CN used to connect to that host for the handshake to succeed.  # noqa: E501

        :param strict_hostname_check: The strict_hostname_check of this CertificatesSettingsSettings.  # noqa: E501
        :type: bool
        """

        self._strict_hostname_check = strict_hostname_check

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CertificatesSettingsSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
