# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_5_0.api_client import ApiClient


class SnapshotApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_snapshot_alias(self, snapshot_alias, **kwargs):  # noqa: E501
        """create_snapshot_alias  # noqa: E501

        Create a new snapshot alias.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_alias(snapshot_alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotAliasCreateParams snapshot_alias: (required)
        :return: CreateSnapshotAliasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_snapshot_alias_with_http_info(snapshot_alias, **kwargs)  # noqa: E501
        else:
            (data) = self.create_snapshot_alias_with_http_info(snapshot_alias, **kwargs)  # noqa: E501
            return data

    def create_snapshot_alias_with_http_info(self, snapshot_alias, **kwargs):  # noqa: E501
        """create_snapshot_alias  # noqa: E501

        Create a new snapshot alias.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_alias_with_http_info(snapshot_alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotAliasCreateParams snapshot_alias: (required)
        :return: CreateSnapshotAliasResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_snapshot_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_alias' is set
        if ('snapshot_alias' not in params or
                params['snapshot_alias'] is None):
            raise ValueError("Missing the required parameter `snapshot_alias` when calling `create_snapshot_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snapshot_alias' in params:
            body_params = params['snapshot_alias']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/aliases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSnapshotAliasResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_snapshot_schedule(self, snapshot_schedule, **kwargs):  # noqa: E501
        """create_snapshot_schedule  # noqa: E501

        Create a new schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_schedule(snapshot_schedule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotScheduleCreateParams snapshot_schedule: (required)
        :return: CreateSnapshotScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_snapshot_schedule_with_http_info(snapshot_schedule, **kwargs)  # noqa: E501
        else:
            (data) = self.create_snapshot_schedule_with_http_info(snapshot_schedule, **kwargs)  # noqa: E501
            return data

    def create_snapshot_schedule_with_http_info(self, snapshot_schedule, **kwargs):  # noqa: E501
        """create_snapshot_schedule  # noqa: E501

        Create a new schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_schedule_with_http_info(snapshot_schedule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotScheduleCreateParams snapshot_schedule: (required)
        :return: CreateSnapshotScheduleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_schedule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_snapshot_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_schedule' is set
        if ('snapshot_schedule' not in params or
                params['snapshot_schedule'] is None):
            raise ValueError("Missing the required parameter `snapshot_schedule` when calling `create_snapshot_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snapshot_schedule' in params:
            body_params = params['snapshot_schedule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/snapshot/schedules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSnapshotScheduleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_snapshot_snapshot(self, snapshot_snapshot, **kwargs):  # noqa: E501
        """create_snapshot_snapshot  # noqa: E501

        Create a new snapshot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_snapshot(snapshot_snapshot, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotSnapshotCreateParams snapshot_snapshot: (required)
        :return: SnapshotSnapshotExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_snapshot_snapshot_with_http_info(snapshot_snapshot, **kwargs)  # noqa: E501
        else:
            (data) = self.create_snapshot_snapshot_with_http_info(snapshot_snapshot, **kwargs)  # noqa: E501
            return data

    def create_snapshot_snapshot_with_http_info(self, snapshot_snapshot, **kwargs):  # noqa: E501
        """create_snapshot_snapshot  # noqa: E501

        Create a new snapshot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_snapshot_with_http_info(snapshot_snapshot, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotSnapshotCreateParams snapshot_snapshot: (required)
        :return: SnapshotSnapshotExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_snapshot']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_snapshot_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_snapshot' is set
        if ('snapshot_snapshot' not in params or
                params['snapshot_snapshot'] is None):
            raise ValueError("Missing the required parameter `snapshot_snapshot` when calling `create_snapshot_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snapshot_snapshot' in params:
            body_params = params['snapshot_snapshot']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/snapshots', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotSnapshotExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_snapshot_writable_item(self, snapshot_writable_item, **kwargs):  # noqa: E501
        """create_snapshot_writable_item  # noqa: E501

        Create a new writable snapshot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_writable_item(snapshot_writable_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotWritableItem snapshot_writable_item: (required)
        :return: SnapshotWritableWritableItem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_snapshot_writable_item_with_http_info(snapshot_writable_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_snapshot_writable_item_with_http_info(snapshot_writable_item, **kwargs)  # noqa: E501
            return data

    def create_snapshot_writable_item_with_http_info(self, snapshot_writable_item, **kwargs):  # noqa: E501
        """create_snapshot_writable_item  # noqa: E501

        Create a new writable snapshot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_snapshot_writable_item_with_http_info(snapshot_writable_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotWritableItem snapshot_writable_item: (required)
        :return: SnapshotWritableWritableItem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_writable_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_snapshot_writable_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_writable_item' is set
        if ('snapshot_writable_item' not in params or
                params['snapshot_writable_item'] is None):
            raise ValueError("Missing the required parameter `snapshot_writable_item` when calling `create_snapshot_writable_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snapshot_writable_item' in params:
            body_params = params['snapshot_writable_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/14/snapshot/writable', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotWritableWritableItem',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_alias(self, snapshot_alias_id, **kwargs):  # noqa: E501
        """delete_snapshot_alias  # noqa: E501

        Delete the snapshot alias  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_alias(snapshot_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_alias_id: Delete the snapshot alias (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_alias_with_http_info(snapshot_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_alias_with_http_info(snapshot_alias_id, **kwargs)  # noqa: E501
            return data

    def delete_snapshot_alias_with_http_info(self, snapshot_alias_id, **kwargs):  # noqa: E501
        """delete_snapshot_alias  # noqa: E501

        Delete the snapshot alias  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_alias_with_http_info(snapshot_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_alias_id: Delete the snapshot alias (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_alias_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_alias_id' is set
        if ('snapshot_alias_id' not in params or
                params['snapshot_alias_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_alias_id` when calling `delete_snapshot_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_alias_id' in params:
            path_params['SnapshotAliasId'] = params['snapshot_alias_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/aliases/{SnapshotAliasId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_aliases(self, **kwargs):  # noqa: E501
        """delete_snapshot_aliases  # noqa: E501

        Delete all or matching snapshot aliases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_aliases(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_aliases_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_aliases_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_snapshot_aliases_with_http_info(self, **kwargs):  # noqa: E501
        """delete_snapshot_aliases  # noqa: E501

        Delete all or matching snapshot aliases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_aliases_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_aliases" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/aliases', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_changelist(self, snapshot_changelist_id, **kwargs):  # noqa: E501
        """delete_snapshot_changelist  # noqa: E501

        Delete the specified changelist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_changelist(snapshot_changelist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_changelist_id: Delete the specified changelist. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_changelist_with_http_info(snapshot_changelist_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_changelist_with_http_info(snapshot_changelist_id, **kwargs)  # noqa: E501
            return data

    def delete_snapshot_changelist_with_http_info(self, snapshot_changelist_id, **kwargs):  # noqa: E501
        """delete_snapshot_changelist  # noqa: E501

        Delete the specified changelist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_changelist_with_http_info(snapshot_changelist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_changelist_id: Delete the specified changelist. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_changelist_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_changelist" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_changelist_id' is set
        if ('snapshot_changelist_id' not in params or
                params['snapshot_changelist_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_changelist_id` when calling `delete_snapshot_changelist`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_changelist_id' in params:
            path_params['SnapshotChangelistId'] = params['snapshot_changelist_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/changelists/{SnapshotChangelistId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_repstate(self, snapshot_repstate_id, **kwargs):  # noqa: E501
        """delete_snapshot_repstate  # noqa: E501

        Delete the specified repstate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_repstate(snapshot_repstate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_repstate_id: Delete the specified repstate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_repstate_with_http_info(snapshot_repstate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_repstate_with_http_info(snapshot_repstate_id, **kwargs)  # noqa: E501
            return data

    def delete_snapshot_repstate_with_http_info(self, snapshot_repstate_id, **kwargs):  # noqa: E501
        """delete_snapshot_repstate  # noqa: E501

        Delete the specified repstate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_repstate_with_http_info(snapshot_repstate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_repstate_id: Delete the specified repstate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_repstate_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_repstate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_repstate_id' is set
        if ('snapshot_repstate_id' not in params or
                params['snapshot_repstate_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_repstate_id` when calling `delete_snapshot_repstate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_repstate_id' in params:
            path_params['SnapshotRepstateId'] = params['snapshot_repstate_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/repstates/{SnapshotRepstateId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_schedule(self, snapshot_schedule_id, **kwargs):  # noqa: E501
        """delete_snapshot_schedule  # noqa: E501

        Delete the schedule. This does not affect already created snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_schedule(snapshot_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_schedule_id: Delete the schedule. This does not affect already created snapshots. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_schedule_with_http_info(snapshot_schedule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_schedule_with_http_info(snapshot_schedule_id, **kwargs)  # noqa: E501
            return data

    def delete_snapshot_schedule_with_http_info(self, snapshot_schedule_id, **kwargs):  # noqa: E501
        """delete_snapshot_schedule  # noqa: E501

        Delete the schedule. This does not affect already created snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_schedule_with_http_info(snapshot_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_schedule_id: Delete the schedule. This does not affect already created snapshots. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_schedule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_schedule_id' is set
        if ('snapshot_schedule_id' not in params or
                params['snapshot_schedule_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_schedule_id` when calling `delete_snapshot_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_schedule_id' in params:
            path_params['SnapshotScheduleId'] = params['snapshot_schedule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/snapshot/schedules/{SnapshotScheduleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_schedules(self, **kwargs):  # noqa: E501
        """delete_snapshot_schedules  # noqa: E501

        Delete all snapshot schedules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_schedules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_schedules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_schedules_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_snapshot_schedules_with_http_info(self, **kwargs):  # noqa: E501
        """delete_snapshot_schedules  # noqa: E501

        Delete all snapshot schedules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_schedules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/snapshot/schedules', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_snapshot(self, snapshot_snapshot_id, **kwargs):  # noqa: E501
        """delete_snapshot_snapshot  # noqa: E501

        Delete the snapshot. Deleted snapshots will be placed into a deleting state until the system can reclaim the space used by the snapshot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_snapshot(snapshot_snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_snapshot_id: Delete the snapshot. Deleted snapshots will be placed into a deleting state until the system can reclaim the space used by the snapshot. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_snapshot_with_http_info(snapshot_snapshot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_snapshot_with_http_info(snapshot_snapshot_id, **kwargs)  # noqa: E501
            return data

    def delete_snapshot_snapshot_with_http_info(self, snapshot_snapshot_id, **kwargs):  # noqa: E501
        """delete_snapshot_snapshot  # noqa: E501

        Delete the snapshot. Deleted snapshots will be placed into a deleting state until the system can reclaim the space used by the snapshot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_snapshot_with_http_info(snapshot_snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_snapshot_id: Delete the snapshot. Deleted snapshots will be placed into a deleting state until the system can reclaim the space used by the snapshot. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_snapshot_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_snapshot_id' is set
        if ('snapshot_snapshot_id' not in params or
                params['snapshot_snapshot_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_snapshot_id` when calling `delete_snapshot_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_snapshot_id' in params:
            path_params['SnapshotSnapshotId'] = params['snapshot_snapshot_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/snapshots/{SnapshotSnapshotId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_snapshots(self, **kwargs):  # noqa: E501
        """delete_snapshot_snapshots  # noqa: E501

        Delete all or matching snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_snapshots(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str schedule: Only list snapshots created by this schedule.
        :param str type: Only list snapshots matching this type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_snapshots_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_snapshots_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_snapshot_snapshots_with_http_info(self, **kwargs):  # noqa: E501
        """delete_snapshot_snapshots  # noqa: E501

        Delete all or matching snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_snapshots_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str schedule: Only list snapshots created by this schedule.
        :param str type: Only list snapshots matching this type.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_snapshots" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'schedule' in params:
            query_params.append(('schedule', params['schedule']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/snapshots', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_writable(self, **kwargs):  # noqa: E501
        """delete_snapshot_writable  # noqa: E501

        Delete all or matching writable snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_writable(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_writable_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_writable_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_snapshot_writable_with_http_info(self, **kwargs):  # noqa: E501
        """delete_snapshot_writable  # noqa: E501

        Delete all or matching writable snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_writable_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_writable" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/14/snapshot/writable', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_snapshot_writable_wspath(self, snapshot_writable_wspath, **kwargs):  # noqa: E501
        """delete_snapshot_writable_wspath  # noqa: E501

        Delete the writable snapshot. Deleted writable snapshots    will be placed into a deleting state until the system can reclaim the    space used by the writable snapshot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_writable_wspath(snapshot_writable_wspath, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_writable_wspath: Delete the writable snapshot. Deleted writable snapshots    will be placed into a deleting state until the system can reclaim the    space used by the writable snapshot. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_snapshot_writable_wspath_with_http_info(snapshot_writable_wspath, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_snapshot_writable_wspath_with_http_info(snapshot_writable_wspath, **kwargs)  # noqa: E501
            return data

    def delete_snapshot_writable_wspath_with_http_info(self, snapshot_writable_wspath, **kwargs):  # noqa: E501
        """delete_snapshot_writable_wspath  # noqa: E501

        Delete the writable snapshot. Deleted writable snapshots    will be placed into a deleting state until the system can reclaim the    space used by the writable snapshot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_snapshot_writable_wspath_with_http_info(snapshot_writable_wspath, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_writable_wspath: Delete the writable snapshot. Deleted writable snapshots    will be placed into a deleting state until the system can reclaim the    space used by the writable snapshot. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_writable_wspath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_snapshot_writable_wspath" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_writable_wspath' is set
        if ('snapshot_writable_wspath' not in params or
                params['snapshot_writable_wspath'] is None):
            raise ValueError("Missing the required parameter `snapshot_writable_wspath` when calling `delete_snapshot_writable_wspath`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_writable_wspath' in params:
            path_params['SnapshotWritableWspath'] = params['snapshot_writable_wspath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/14/snapshot/writable/{SnapshotWritableWspath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_changelists_changelist_diff_region(self, changelists_changelist_diff_region_id, changelist, **kwargs):  # noqa: E501
        """get_changelists_changelist_diff_region  # noqa: E501

        Get snap diff regions of a file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_changelists_changelist_diff_region(changelists_changelist_diff_region_id, changelist, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int changelists_changelist_diff_region_id: Get snap diff regions of a file. (required)
        :param str changelist: (required)
        :param int limit: Return no more than this many results at once (see resume).
        :param int offset:
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: ChangelistsChangelistDiffRegions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_changelists_changelist_diff_region_with_http_info(changelists_changelist_diff_region_id, changelist, **kwargs)  # noqa: E501
        else:
            (data) = self.get_changelists_changelist_diff_region_with_http_info(changelists_changelist_diff_region_id, changelist, **kwargs)  # noqa: E501
            return data

    def get_changelists_changelist_diff_region_with_http_info(self, changelists_changelist_diff_region_id, changelist, **kwargs):  # noqa: E501
        """get_changelists_changelist_diff_region  # noqa: E501

        Get snap diff regions of a file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_changelists_changelist_diff_region_with_http_info(changelists_changelist_diff_region_id, changelist, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int changelists_changelist_diff_region_id: Get snap diff regions of a file. (required)
        :param str changelist: (required)
        :param int limit: Return no more than this many results at once (see resume).
        :param int offset:
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: ChangelistsChangelistDiffRegions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['changelists_changelist_diff_region_id', 'changelist', 'limit', 'offset', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_changelists_changelist_diff_region" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'changelists_changelist_diff_region_id' is set
        if ('changelists_changelist_diff_region_id' not in params or
                params['changelists_changelist_diff_region_id'] is None):
            raise ValueError("Missing the required parameter `changelists_changelist_diff_region_id` when calling `get_changelists_changelist_diff_region`")  # noqa: E501
        # verify the required parameter 'changelist' is set
        if ('changelist' not in params or
                params['changelist'] is None):
            raise ValueError("Missing the required parameter `changelist` when calling `get_changelists_changelist_diff_region`")  # noqa: E501

        if 'limit' in params and params['limit'] > 100000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_changelists_changelist_diff_region`, must be a value less than or equal to `100000`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_changelists_changelist_diff_region`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'offset' in params and params['offset'] > -1:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_changelists_changelist_diff_region`, must be a value less than or equal to `-1`")  # noqa: E501
        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_changelists_changelist_diff_region`, must be a value greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_changelists_changelist_diff_region`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_changelists_changelist_diff_region`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'changelists_changelist_diff_region_id' in params:
            path_params['ChangelistsChangelistDiffRegionId'] = params['changelists_changelist_diff_region_id']  # noqa: E501
        if 'changelist' in params:
            path_params['Changelist'] = params['changelist']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/snapshot/changelists/{Changelist}/diff-regions/{ChangelistsChangelistDiffRegionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChangelistsChangelistDiffRegions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_alias(self, snapshot_alias_id, **kwargs):  # noqa: E501
        """get_snapshot_alias  # noqa: E501

        Retrieve snapshot alias information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_alias(snapshot_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_alias_id: Retrieve snapshot alias information. (required)
        :return: SnapshotAliases
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_alias_with_http_info(snapshot_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_alias_with_http_info(snapshot_alias_id, **kwargs)  # noqa: E501
            return data

    def get_snapshot_alias_with_http_info(self, snapshot_alias_id, **kwargs):  # noqa: E501
        """get_snapshot_alias  # noqa: E501

        Retrieve snapshot alias information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_alias_with_http_info(snapshot_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_alias_id: Retrieve snapshot alias information. (required)
        :return: SnapshotAliases
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_alias_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_alias_id' is set
        if ('snapshot_alias_id' not in params or
                params['snapshot_alias_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_alias_id` when calling `get_snapshot_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_alias_id' in params:
            path_params['SnapshotAliasId'] = params['snapshot_alias_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/aliases/{SnapshotAliasId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotAliases',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_changelist(self, snapshot_changelist_id, **kwargs):  # noqa: E501
        """get_snapshot_changelist  # noqa: E501

        Retrieve basic information on a changelist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_changelist(snapshot_changelist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_changelist_id: Retrieve basic information on a changelist. (required)
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SnapshotChangelists
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_changelist_with_http_info(snapshot_changelist_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_changelist_with_http_info(snapshot_changelist_id, **kwargs)  # noqa: E501
            return data

    def get_snapshot_changelist_with_http_info(self, snapshot_changelist_id, **kwargs):  # noqa: E501
        """get_snapshot_changelist  # noqa: E501

        Retrieve basic information on a changelist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_changelist_with_http_info(snapshot_changelist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_changelist_id: Retrieve basic information on a changelist. (required)
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SnapshotChangelists
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_changelist_id', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_changelist" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_changelist_id' is set
        if ('snapshot_changelist_id' not in params or
                params['snapshot_changelist_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_changelist_id` when calling `get_snapshot_changelist`")  # noqa: E501

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_snapshot_changelist`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_snapshot_changelist`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_changelist`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_changelist`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'snapshot_changelist_id' in params:
            path_params['SnapshotChangelistId'] = params['snapshot_changelist_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/changelists/{SnapshotChangelistId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotChangelists',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_changelists(self, **kwargs):  # noqa: E501
        """get_snapshot_changelists  # noqa: E501

        List all changelists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_changelists(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SnapshotChangelistsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_changelists_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_changelists_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_snapshot_changelists_with_http_info(self, **kwargs):  # noqa: E501
        """get_snapshot_changelists  # noqa: E501

        List all changelists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_changelists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SnapshotChangelistsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_changelists" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_snapshot_changelists`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_snapshot_changelists`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_changelists`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_changelists`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/changelists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotChangelistsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_license(self, **kwargs):  # noqa: E501
        """get_snapshot_license  # noqa: E501

        Retrieve license information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_license(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LicenseLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_license_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_license_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_snapshot_license_with_http_info(self, **kwargs):  # noqa: E501
        """get_snapshot_license  # noqa: E501

        Retrieve license information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_license_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LicenseLicense
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_license" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/snapshot/license', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseLicense',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_pending(self, **kwargs):  # noqa: E501
        """get_snapshot_pending  # noqa: E501

        Return list of snapshots to be taken.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_pending(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Unix Epoch time to start generating matches. Default is now.
        :param int end: Unix Epoch time to end generating matches. Default is forever.
        :param int limit: Return no more than this many result at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str schedule: Limit output only to the named schedule.
        :return: SnapshotPending
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_pending_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_pending_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_snapshot_pending_with_http_info(self, **kwargs):  # noqa: E501
        """get_snapshot_pending  # noqa: E501

        Return list of snapshots to be taken.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_pending_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Unix Epoch time to start generating matches. Default is now.
        :param int end: Unix Epoch time to end generating matches. Default is forever.
        :param int limit: Return no more than this many result at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str schedule: Limit output only to the named schedule.
        :return: SnapshotPending
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'end', 'limit', 'resume', 'schedule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_pending" % key
                )
            params[key] = val
        del params['kwargs']

        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_pending`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_pending`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'schedule' in params:
            query_params.append(('schedule', params['schedule']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/pending', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotPending',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_repstate(self, snapshot_repstate_id, **kwargs):  # noqa: E501
        """get_snapshot_repstate  # noqa: E501

        Retrieve basic information on a repstate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_repstate(snapshot_repstate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_repstate_id: Retrieve basic information on a repstate. (required)
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SnapshotRepstates
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_repstate_with_http_info(snapshot_repstate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_repstate_with_http_info(snapshot_repstate_id, **kwargs)  # noqa: E501
            return data

    def get_snapshot_repstate_with_http_info(self, snapshot_repstate_id, **kwargs):  # noqa: E501
        """get_snapshot_repstate  # noqa: E501

        Retrieve basic information on a repstate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_repstate_with_http_info(snapshot_repstate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_repstate_id: Retrieve basic information on a repstate. (required)
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SnapshotRepstates
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_repstate_id', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_repstate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_repstate_id' is set
        if ('snapshot_repstate_id' not in params or
                params['snapshot_repstate_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_repstate_id` when calling `get_snapshot_repstate`")  # noqa: E501

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_snapshot_repstate`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_snapshot_repstate`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_repstate`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_repstate`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'snapshot_repstate_id' in params:
            path_params['SnapshotRepstateId'] = params['snapshot_repstate_id']  # noqa: E501

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/repstates/{SnapshotRepstateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotRepstates',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_repstates(self, **kwargs):  # noqa: E501
        """get_snapshot_repstates  # noqa: E501

        List all repstates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_repstates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SnapshotRepstatesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_repstates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_repstates_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_snapshot_repstates_with_http_info(self, **kwargs):  # noqa: E501
        """get_snapshot_repstates  # noqa: E501

        List all repstates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_repstates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: SnapshotRepstatesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_repstates" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_snapshot_repstates`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_snapshot_repstates`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_repstates`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_snapshot_repstates`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/repstates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotRepstatesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_schedule(self, snapshot_schedule_id, **kwargs):  # noqa: E501
        """get_snapshot_schedule  # noqa: E501

        Retrieve the schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_schedule(snapshot_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_schedule_id: Retrieve the schedule. (required)
        :return: SnapshotSchedules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_schedule_with_http_info(snapshot_schedule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_schedule_with_http_info(snapshot_schedule_id, **kwargs)  # noqa: E501
            return data

    def get_snapshot_schedule_with_http_info(self, snapshot_schedule_id, **kwargs):  # noqa: E501
        """get_snapshot_schedule  # noqa: E501

        Retrieve the schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_schedule_with_http_info(snapshot_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_schedule_id: Retrieve the schedule. (required)
        :return: SnapshotSchedules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_schedule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_schedule_id' is set
        if ('snapshot_schedule_id' not in params or
                params['snapshot_schedule_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_schedule_id` when calling `get_snapshot_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_schedule_id' in params:
            path_params['SnapshotScheduleId'] = params['snapshot_schedule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/snapshot/schedules/{SnapshotScheduleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotSchedules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_settings(self, **kwargs):  # noqa: E501
        """get_snapshot_settings  # noqa: E501

        List all settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SnapshotSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_snapshot_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_snapshot_settings  # noqa: E501

        List all settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SnapshotSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_snapshot(self, snapshot_snapshot_id, **kwargs):  # noqa: E501
        """get_snapshot_snapshot  # noqa: E501

        Retrieve snapshot information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_snapshot(snapshot_snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_snapshot_id: Retrieve snapshot information. (required)
        :return: SnapshotSnapshots
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_snapshot_with_http_info(snapshot_snapshot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_snapshot_with_http_info(snapshot_snapshot_id, **kwargs)  # noqa: E501
            return data

    def get_snapshot_snapshot_with_http_info(self, snapshot_snapshot_id, **kwargs):  # noqa: E501
        """get_snapshot_snapshot  # noqa: E501

        Retrieve snapshot information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_snapshot_with_http_info(snapshot_snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_snapshot_id: Retrieve snapshot information. (required)
        :return: SnapshotSnapshots
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_snapshot_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_snapshot_id' is set
        if ('snapshot_snapshot_id' not in params or
                params['snapshot_snapshot_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_snapshot_id` when calling `get_snapshot_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_snapshot_id' in params:
            path_params['SnapshotSnapshotId'] = params['snapshot_snapshot_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/snapshots/{SnapshotSnapshotId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotSnapshots',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_snapshots_summary(self, **kwargs):  # noqa: E501
        """get_snapshot_snapshots_summary  # noqa: E501

        Return summary information about snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_snapshots_summary(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SnapshotSnapshotsSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_snapshots_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_snapshots_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_snapshot_snapshots_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_snapshot_snapshots_summary  # noqa: E501

        Return summary information about snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_snapshots_summary_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SnapshotSnapshotsSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_snapshots_summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/snapshots-summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotSnapshotsSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_writable_snapshot_summary(self, **kwargs):  # noqa: E501
        """get_snapshot_writable_snapshot_summary  # noqa: E501

        Return summary information about writable snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_writable_snapshot_summary(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SnapshotWritableSnapshotSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_writable_snapshot_summary_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_writable_snapshot_summary_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_snapshot_writable_snapshot_summary_with_http_info(self, **kwargs):  # noqa: E501
        """get_snapshot_writable_snapshot_summary  # noqa: E501

        Return summary information about writable snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_writable_snapshot_summary_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SnapshotWritableSnapshotSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_writable_snapshot_summary" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/14/snapshot/writable-snapshot-summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotWritableSnapshotSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_snapshot_writable_wspath(self, snapshot_writable_wspath, **kwargs):  # noqa: E501
        """get_snapshot_writable_wspath  # noqa: E501

        Retrieve writable snapshot information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_writable_wspath(snapshot_writable_wspath, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_writable_wspath: Retrieve writable snapshot information. (required)
        :return: SnapshotWritable
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_snapshot_writable_wspath_with_http_info(snapshot_writable_wspath, **kwargs)  # noqa: E501
        else:
            (data) = self.get_snapshot_writable_wspath_with_http_info(snapshot_writable_wspath, **kwargs)  # noqa: E501
            return data

    def get_snapshot_writable_wspath_with_http_info(self, snapshot_writable_wspath, **kwargs):  # noqa: E501
        """get_snapshot_writable_wspath  # noqa: E501

        Retrieve writable snapshot information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_snapshot_writable_wspath_with_http_info(snapshot_writable_wspath, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str snapshot_writable_wspath: Retrieve writable snapshot information. (required)
        :return: SnapshotWritable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_writable_wspath']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_snapshot_writable_wspath" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_writable_wspath' is set
        if ('snapshot_writable_wspath' not in params or
                params['snapshot_writable_wspath'] is None):
            raise ValueError("Missing the required parameter `snapshot_writable_wspath` when calling `get_snapshot_writable_wspath`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_writable_wspath' in params:
            path_params['SnapshotWritableWspath'] = params['snapshot_writable_wspath']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/14/snapshot/writable/{SnapshotWritableWspath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotWritable',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_snapshot_aliases(self, **kwargs):  # noqa: E501
        """list_snapshot_aliases  # noqa: E501

        List all or matching snapshot aliases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_snapshot_aliases(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.  Choices are id, name, snapshot, and created.  Default is id.
        :return: SnapshotAliasesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_snapshot_aliases_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_snapshot_aliases_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_snapshot_aliases_with_http_info(self, **kwargs):  # noqa: E501
        """list_snapshot_aliases  # noqa: E501

        List all or matching snapshot aliases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_snapshot_aliases_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.  Choices are id, name, snapshot, and created.  Default is id.
        :return: SnapshotAliasesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_snapshot_aliases" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_snapshot_aliases`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_snapshot_aliases`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_snapshot_aliases`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_snapshot_aliases`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_snapshot_aliases`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/aliases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotAliasesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_snapshot_schedules(self, **kwargs):  # noqa: E501
        """list_snapshot_schedules  # noqa: E501

        List all or matching schedules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_snapshot_schedules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.  Choices are id, name, path, pattern, schedule, duration, alias, next_run, and next_snapshot.  Default is id.
        :return: SnapshotSchedulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_snapshot_schedules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_snapshot_schedules_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_snapshot_schedules_with_http_info(self, **kwargs):  # noqa: E501
        """list_snapshot_schedules  # noqa: E501

        List all or matching schedules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_snapshot_schedules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.  Choices are id, name, path, pattern, schedule, duration, alias, next_run, and next_snapshot.  Default is id.
        :return: SnapshotSchedulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_snapshot_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_snapshot_schedules`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_snapshot_schedules`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_snapshot_schedules`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_snapshot_schedules`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_snapshot_schedules`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/snapshot/schedules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotSchedulesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_snapshot_snapshots(self, **kwargs):  # noqa: E501
        """list_snapshot_snapshots  # noqa: E501

        List all or matching snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_snapshot_snapshots(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str schedule: Only list snapshots created by this schedule.
        :param str sort: The field that will be used for sorting.  Choices are id, name, path, created, expires, size, has_locks, schedule, alias_target, alias_target_name, pct_filesystem, pct_reserve, and state.  Default is id.
        :param str state: Only list snapshots matching this state.
        :param str type: Only list snapshots matching this type.
        :return: SnapshotSnapshotsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_snapshot_snapshots_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_snapshot_snapshots_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_snapshot_snapshots_with_http_info(self, **kwargs):  # noqa: E501
        """list_snapshot_snapshots  # noqa: E501

        List all or matching snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_snapshot_snapshots_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str schedule: Only list snapshots created by this schedule.
        :param str sort: The field that will be used for sorting.  Choices are id, name, path, created, expires, size, has_locks, schedule, alias_target, alias_target_name, pct_filesystem, pct_reserve, and state.  Default is id.
        :param str state: Only list snapshots matching this state.
        :param str type: Only list snapshots matching this type.
        :return: SnapshotSnapshotsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'schedule', 'sort', 'state', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_snapshot_snapshots" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_snapshot_snapshots`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_snapshot_snapshots`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_snapshot_snapshots`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_snapshot_snapshots`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_snapshot_snapshots`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'schedule' in params:
            query_params.append(('schedule', params['schedule']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/snapshots', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotSnapshotsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_snapshot_writable(self, **kwargs):  # noqa: E501
        """list_snapshot_writable  # noqa: E501

        List all or matching writable snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_snapshot_writable(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.  Choices are path, src name, src path, created, size and state. Default is created.
        :param str state: Only list writable snapshots matching this state.
        :return: SnapshotWritableExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_snapshot_writable_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_snapshot_writable_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_snapshot_writable_with_http_info(self, **kwargs):  # noqa: E501
        """list_snapshot_writable  # noqa: E501

        List all or matching writable snapshots.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_snapshot_writable_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.  Choices are path, src name, src path, created, size and state. Default is created.
        :param str state: Only list writable snapshots matching this state.
        :return: SnapshotWritableExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort', 'state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_snapshot_writable" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_snapshot_writable`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_snapshot_writable`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_snapshot_writable`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_snapshot_writable`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_snapshot_writable`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/14/snapshot/writable', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SnapshotWritableExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snapshot_alias(self, snapshot_alias, snapshot_alias_id, **kwargs):  # noqa: E501
        """update_snapshot_alias  # noqa: E501

        Modify snapshot alias. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_alias(snapshot_alias, snapshot_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotAlias snapshot_alias: (required)
        :param str snapshot_alias_id: Modify snapshot alias. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snapshot_alias_with_http_info(snapshot_alias, snapshot_alias_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snapshot_alias_with_http_info(snapshot_alias, snapshot_alias_id, **kwargs)  # noqa: E501
            return data

    def update_snapshot_alias_with_http_info(self, snapshot_alias, snapshot_alias_id, **kwargs):  # noqa: E501
        """update_snapshot_alias  # noqa: E501

        Modify snapshot alias. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_alias_with_http_info(snapshot_alias, snapshot_alias_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotAlias snapshot_alias: (required)
        :param str snapshot_alias_id: Modify snapshot alias. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_alias', 'snapshot_alias_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snapshot_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_alias' is set
        if ('snapshot_alias' not in params or
                params['snapshot_alias'] is None):
            raise ValueError("Missing the required parameter `snapshot_alias` when calling `update_snapshot_alias`")  # noqa: E501
        # verify the required parameter 'snapshot_alias_id' is set
        if ('snapshot_alias_id' not in params or
                params['snapshot_alias_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_alias_id` when calling `update_snapshot_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_alias_id' in params:
            path_params['SnapshotAliasId'] = params['snapshot_alias_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snapshot_alias' in params:
            body_params = params['snapshot_alias']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/aliases/{SnapshotAliasId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snapshot_schedule(self, snapshot_schedule, snapshot_schedule_id, **kwargs):  # noqa: E501
        """update_snapshot_schedule  # noqa: E501

        Modify the schedule. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_schedule(snapshot_schedule, snapshot_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotSchedule snapshot_schedule: (required)
        :param str snapshot_schedule_id: Modify the schedule. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snapshot_schedule_with_http_info(snapshot_schedule, snapshot_schedule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snapshot_schedule_with_http_info(snapshot_schedule, snapshot_schedule_id, **kwargs)  # noqa: E501
            return data

    def update_snapshot_schedule_with_http_info(self, snapshot_schedule, snapshot_schedule_id, **kwargs):  # noqa: E501
        """update_snapshot_schedule  # noqa: E501

        Modify the schedule. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_schedule_with_http_info(snapshot_schedule, snapshot_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotSchedule snapshot_schedule: (required)
        :param str snapshot_schedule_id: Modify the schedule. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_schedule', 'snapshot_schedule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snapshot_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_schedule' is set
        if ('snapshot_schedule' not in params or
                params['snapshot_schedule'] is None):
            raise ValueError("Missing the required parameter `snapshot_schedule` when calling `update_snapshot_schedule`")  # noqa: E501
        # verify the required parameter 'snapshot_schedule_id' is set
        if ('snapshot_schedule_id' not in params or
                params['snapshot_schedule_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_schedule_id` when calling `update_snapshot_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_schedule_id' in params:
            path_params['SnapshotScheduleId'] = params['snapshot_schedule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snapshot_schedule' in params:
            body_params = params['snapshot_schedule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/snapshot/schedules/{SnapshotScheduleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snapshot_settings(self, snapshot_settings, **kwargs):  # noqa: E501
        """update_snapshot_settings  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_settings(snapshot_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotSettingsExtended snapshot_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snapshot_settings_with_http_info(snapshot_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snapshot_settings_with_http_info(snapshot_settings, **kwargs)  # noqa: E501
            return data

    def update_snapshot_settings_with_http_info(self, snapshot_settings, **kwargs):  # noqa: E501
        """update_snapshot_settings  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_settings_with_http_info(snapshot_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotSettingsExtended snapshot_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snapshot_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_settings' is set
        if ('snapshot_settings' not in params or
                params['snapshot_settings'] is None):
            raise ValueError("Missing the required parameter `snapshot_settings` when calling `update_snapshot_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snapshot_settings' in params:
            body_params = params['snapshot_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_snapshot_snapshot(self, snapshot_snapshot, snapshot_snapshot_id, **kwargs):  # noqa: E501
        """update_snapshot_snapshot  # noqa: E501

        Modify snapshot. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_snapshot(snapshot_snapshot, snapshot_snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotSnapshot snapshot_snapshot: (required)
        :param str snapshot_snapshot_id: Modify snapshot. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_snapshot_snapshot_with_http_info(snapshot_snapshot, snapshot_snapshot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_snapshot_snapshot_with_http_info(snapshot_snapshot, snapshot_snapshot_id, **kwargs)  # noqa: E501
            return data

    def update_snapshot_snapshot_with_http_info(self, snapshot_snapshot, snapshot_snapshot_id, **kwargs):  # noqa: E501
        """update_snapshot_snapshot  # noqa: E501

        Modify snapshot. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_snapshot_snapshot_with_http_info(snapshot_snapshot, snapshot_snapshot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SnapshotSnapshot snapshot_snapshot: (required)
        :param str snapshot_snapshot_id: Modify snapshot. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['snapshot_snapshot', 'snapshot_snapshot_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_snapshot_snapshot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'snapshot_snapshot' is set
        if ('snapshot_snapshot' not in params or
                params['snapshot_snapshot'] is None):
            raise ValueError("Missing the required parameter `snapshot_snapshot` when calling `update_snapshot_snapshot`")  # noqa: E501
        # verify the required parameter 'snapshot_snapshot_id' is set
        if ('snapshot_snapshot_id' not in params or
                params['snapshot_snapshot_id'] is None):
            raise ValueError("Missing the required parameter `snapshot_snapshot_id` when calling `update_snapshot_snapshot`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'snapshot_snapshot_id' in params:
            path_params['SnapshotSnapshotId'] = params['snapshot_snapshot_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'snapshot_snapshot' in params:
            body_params = params['snapshot_snapshot']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/snapshot/snapshots/{SnapshotSnapshotId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
