# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 16
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_5_0.api_client import ApiClient


class NetworkFirewallApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_policies_policy_rule(self, policies_policy_rule, policy, **kwargs):  # noqa: E501
        """create_policies_policy_rule  # noqa: E501

        Create a new network firewall rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_policies_policy_rule(policies_policy_rule, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoliciesPolicyRuleCreateParams policies_policy_rule: (required)
        :param str policy: (required)
        :param bool allow_renumbering: Indicates whether to allow renumbering of other rules when an index already exists
        :param bool live: Live flag can only be used with active rules. Update will take effect immediately on all related network pools.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_policies_policy_rule_with_http_info(policies_policy_rule, policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_policies_policy_rule_with_http_info(policies_policy_rule, policy, **kwargs)  # noqa: E501
            return data

    def create_policies_policy_rule_with_http_info(self, policies_policy_rule, policy, **kwargs):  # noqa: E501
        """create_policies_policy_rule  # noqa: E501

        Create a new network firewall rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_policies_policy_rule_with_http_info(policies_policy_rule, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoliciesPolicyRuleCreateParams policies_policy_rule: (required)
        :param str policy: (required)
        :param bool allow_renumbering: Indicates whether to allow renumbering of other rules when an index already exists
        :param bool live: Live flag can only be used with active rules. Update will take effect immediately on all related network pools.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policies_policy_rule', 'policy', 'allow_renumbering', 'live']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_policies_policy_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policies_policy_rule' is set
        if ('policies_policy_rule' not in params or
                params['policies_policy_rule'] is None):
            raise ValueError("Missing the required parameter `policies_policy_rule` when calling `create_policies_policy_rule`")  # noqa: E501
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `create_policies_policy_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policy' in params:
            path_params['Policy'] = params['policy']  # noqa: E501

        query_params = []
        if 'allow_renumbering' in params:
            query_params.append(('allow_renumbering', params['allow_renumbering']))  # noqa: E501
        if 'live' in params:
            query_params.append(('live', params['live']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policies_policy_rule' in params:
            body_params = params['policies_policy_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/16/network/firewall/policies/{Policy}/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_policies_policy_rule(self, policies_policy_rule_id, policy, **kwargs):  # noqa: E501
        """delete_policies_policy_rule  # noqa: E501

        Delete a network firewall rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_policies_policy_rule(policies_policy_rule_id, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policies_policy_rule_id: Delete a network firewall rule. (required)
        :param str policy: (required)
        :param bool live: Live flag can only be used with active rules. Update will take effect immediately on all related network pools.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_policies_policy_rule_with_http_info(policies_policy_rule_id, policy, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_policies_policy_rule_with_http_info(policies_policy_rule_id, policy, **kwargs)  # noqa: E501
            return data

    def delete_policies_policy_rule_with_http_info(self, policies_policy_rule_id, policy, **kwargs):  # noqa: E501
        """delete_policies_policy_rule  # noqa: E501

        Delete a network firewall rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_policies_policy_rule_with_http_info(policies_policy_rule_id, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policies_policy_rule_id: Delete a network firewall rule. (required)
        :param str policy: (required)
        :param bool live: Live flag can only be used with active rules. Update will take effect immediately on all related network pools.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policies_policy_rule_id', 'policy', 'live']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policies_policy_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policies_policy_rule_id' is set
        if ('policies_policy_rule_id' not in params or
                params['policies_policy_rule_id'] is None):
            raise ValueError("Missing the required parameter `policies_policy_rule_id` when calling `delete_policies_policy_rule`")  # noqa: E501
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `delete_policies_policy_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policies_policy_rule_id' in params:
            path_params['PoliciesPolicyRuleId'] = params['policies_policy_rule_id']  # noqa: E501
        if 'policy' in params:
            path_params['Policy'] = params['policy']  # noqa: E501

        query_params = []
        if 'live' in params:
            query_params.append(('live', params['live']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/16/network/firewall/policies/{Policy}/rules/{PoliciesPolicyRuleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_policies_policy_rule(self, policies_policy_rule_id, policy, **kwargs):  # noqa: E501
        """get_policies_policy_rule  # noqa: E501

        View a network firewall rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_policies_policy_rule(policies_policy_rule_id, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policies_policy_rule_id: View a network firewall rule. (required)
        :param str policy: (required)
        :return: PoliciesPolicyRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_policies_policy_rule_with_http_info(policies_policy_rule_id, policy, **kwargs)  # noqa: E501
        else:
            (data) = self.get_policies_policy_rule_with_http_info(policies_policy_rule_id, policy, **kwargs)  # noqa: E501
            return data

    def get_policies_policy_rule_with_http_info(self, policies_policy_rule_id, policy, **kwargs):  # noqa: E501
        """get_policies_policy_rule  # noqa: E501

        View a network firewall rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_policies_policy_rule_with_http_info(policies_policy_rule_id, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policies_policy_rule_id: View a network firewall rule. (required)
        :param str policy: (required)
        :return: PoliciesPolicyRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policies_policy_rule_id', 'policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_policies_policy_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policies_policy_rule_id' is set
        if ('policies_policy_rule_id' not in params or
                params['policies_policy_rule_id'] is None):
            raise ValueError("Missing the required parameter `policies_policy_rule_id` when calling `get_policies_policy_rule`")  # noqa: E501
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `get_policies_policy_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policies_policy_rule_id' in params:
            path_params['PoliciesPolicyRuleId'] = params['policies_policy_rule_id']  # noqa: E501
        if 'policy' in params:
            path_params['Policy'] = params['policy']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/16/network/firewall/policies/{Policy}/rules/{PoliciesPolicyRuleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PoliciesPolicyRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_policies_policy_rules(self, policy, **kwargs):  # noqa: E501
        """list_policies_policy_rules  # noqa: E501

        Get a list of network firewall rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_policies_policy_rules(policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policy: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: PoliciesPolicyRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_policies_policy_rules_with_http_info(policy, **kwargs)  # noqa: E501
        else:
            (data) = self.list_policies_policy_rules_with_http_info(policy, **kwargs)  # noqa: E501
            return data

    def list_policies_policy_rules_with_http_info(self, policy, **kwargs):  # noqa: E501
        """list_policies_policy_rules  # noqa: E501

        Get a list of network firewall rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_policies_policy_rules_with_http_info(policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str policy: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: PoliciesPolicyRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy', 'dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policies_policy_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `list_policies_policy_rules`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_policies_policy_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_policies_policy_rules`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_policies_policy_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_policies_policy_rules`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_policies_policy_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_policies_policy_rules`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_policies_policy_rules`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'policy' in params:
            path_params['Policy'] = params['policy']  # noqa: E501

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/16/network/firewall/policies/{Policy}/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PoliciesPolicyRulesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_policies_policy_rule(self, policies_policy_rule, policies_policy_rule_id, policy, **kwargs):  # noqa: E501
        """update_policies_policy_rule  # noqa: E501

        Modify a network firewall rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_policies_policy_rule(policies_policy_rule, policies_policy_rule_id, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoliciesPolicyRule policies_policy_rule: (required)
        :param str policies_policy_rule_id: Modify a network firewall rule. (required)
        :param str policy: (required)
        :param bool allow_renumbering: Indicates whether to allow renumbering of other rules when an index already exists
        :param bool live: Live flag can only be used with active rules. Update will take effect immediately on all related network pools.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_policies_policy_rule_with_http_info(policies_policy_rule, policies_policy_rule_id, policy, **kwargs)  # noqa: E501
        else:
            (data) = self.update_policies_policy_rule_with_http_info(policies_policy_rule, policies_policy_rule_id, policy, **kwargs)  # noqa: E501
            return data

    def update_policies_policy_rule_with_http_info(self, policies_policy_rule, policies_policy_rule_id, policy, **kwargs):  # noqa: E501
        """update_policies_policy_rule  # noqa: E501

        Modify a network firewall rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_policies_policy_rule_with_http_info(policies_policy_rule, policies_policy_rule_id, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoliciesPolicyRule policies_policy_rule: (required)
        :param str policies_policy_rule_id: Modify a network firewall rule. (required)
        :param str policy: (required)
        :param bool allow_renumbering: Indicates whether to allow renumbering of other rules when an index already exists
        :param bool live: Live flag can only be used with active rules. Update will take effect immediately on all related network pools.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policies_policy_rule', 'policies_policy_rule_id', 'policy', 'allow_renumbering', 'live']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_policies_policy_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policies_policy_rule' is set
        if ('policies_policy_rule' not in params or
                params['policies_policy_rule'] is None):
            raise ValueError("Missing the required parameter `policies_policy_rule` when calling `update_policies_policy_rule`")  # noqa: E501
        # verify the required parameter 'policies_policy_rule_id' is set
        if ('policies_policy_rule_id' not in params or
                params['policies_policy_rule_id'] is None):
            raise ValueError("Missing the required parameter `policies_policy_rule_id` when calling `update_policies_policy_rule`")  # noqa: E501
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `update_policies_policy_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'policies_policy_rule_id' in params:
            path_params['PoliciesPolicyRuleId'] = params['policies_policy_rule_id']  # noqa: E501
        if 'policy' in params:
            path_params['Policy'] = params['policy']  # noqa: E501

        query_params = []
        if 'allow_renumbering' in params:
            query_params.append(('allow_renumbering', params['allow_renumbering']))  # noqa: E501
        if 'live' in params:
            query_params.append(('live', params['live']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policies_policy_rule' in params:
            body_params = params['policies_policy_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/16/network/firewall/policies/{Policy}/rules/{PoliciesPolicyRuleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
