# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class NetworkInterfaceVlan(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'flags': 'list[str]',
        'id': 'str',
        'ip_addrs': 'list[str]',
        'ipv4_gateway': 'str',
        'ipv6_gateway': 'str',
        'lnn': 'int',
        'mtu': 'int',
        'name': 'str',
        'nic_name': 'str',
        'status': 'str',
        'type': 'str',
        'vlan_id': 'int'
    }

    attribute_map = {
        'flags': 'flags',
        'id': 'id',
        'ip_addrs': 'ip_addrs',
        'ipv4_gateway': 'ipv4_gateway',
        'ipv6_gateway': 'ipv6_gateway',
        'lnn': 'lnn',
        'mtu': 'mtu',
        'name': 'name',
        'nic_name': 'nic_name',
        'status': 'status',
        'type': 'type',
        'vlan_id': 'vlan_id'
    }

    def __init__(self, flags=None, id=None, ip_addrs=None, ipv4_gateway=None, ipv6_gateway=None, lnn=None, mtu=None, name=None, nic_name=None, status=None, type=None, vlan_id=None):  # noqa: E501
        """NetworkInterfaceVlan - a model defined in Swagger"""  # noqa: E501

        self._flags = None
        self._id = None
        self._ip_addrs = None
        self._ipv4_gateway = None
        self._ipv6_gateway = None
        self._lnn = None
        self._mtu = None
        self._name = None
        self._nic_name = None
        self._status = None
        self._type = None
        self._vlan_id = None
        self.discriminator = None

        if flags is not None:
            self.flags = flags
        if id is not None:
            self.id = id
        if ip_addrs is not None:
            self.ip_addrs = ip_addrs
        if ipv4_gateway is not None:
            self.ipv4_gateway = ipv4_gateway
        if ipv6_gateway is not None:
            self.ipv6_gateway = ipv6_gateway
        if lnn is not None:
            self.lnn = lnn
        if mtu is not None:
            self.mtu = mtu
        if name is not None:
            self.name = name
        if nic_name is not None:
            self.nic_name = nic_name
        if status is not None:
            self.status = status
        if type is not None:
            self.type = type
        if vlan_id is not None:
            self.vlan_id = vlan_id

    @property
    def flags(self):
        """Gets the flags of this NetworkInterfaceVlan.  # noqa: E501

        List of interface flags  # noqa: E501

        :return: The flags of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: list[str]
        """
        return self._flags

    @flags.setter
    def flags(self, flags):
        """Sets the flags of this NetworkInterfaceVlan.

        List of interface flags  # noqa: E501

        :param flags: The flags of this NetworkInterfaceVlan.  # noqa: E501
        :type: list[str]
        """

        self._flags = flags

    @property
    def id(self):
        """Gets the id of this NetworkInterfaceVlan.  # noqa: E501

        Id is a concatenation of lnn and name in the format 'lnn:name' e.g. 3:ext-2.  # noqa: E501

        :return: The id of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this NetworkInterfaceVlan.

        Id is a concatenation of lnn and name in the format 'lnn:name' e.g. 3:ext-2.  # noqa: E501

        :param id: The id of this NetworkInterfaceVlan.  # noqa: E501
        :type: str
        """
        if id is not None and len(id) > 32:
            raise ValueError("Invalid value for `id`, length must be less than or equal to `32`")  # noqa: E501
        if id is not None and len(id) < 1:
            raise ValueError("Invalid value for `id`, length must be greater than or equal to `1`")  # noqa: E501

        self._id = id

    @property
    def ip_addrs(self):
        """Gets the ip_addrs of this NetworkInterfaceVlan.  # noqa: E501

        List of IP addresses  # noqa: E501

        :return: The ip_addrs of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: list[str]
        """
        return self._ip_addrs

    @ip_addrs.setter
    def ip_addrs(self, ip_addrs):
        """Sets the ip_addrs of this NetworkInterfaceVlan.

        List of IP addresses  # noqa: E501

        :param ip_addrs: The ip_addrs of this NetworkInterfaceVlan.  # noqa: E501
        :type: list[str]
        """

        self._ip_addrs = ip_addrs

    @property
    def ipv4_gateway(self):
        """Gets the ipv4_gateway of this NetworkInterfaceVlan.  # noqa: E501


        :return: The ipv4_gateway of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: str
        """
        return self._ipv4_gateway

    @ipv4_gateway.setter
    def ipv4_gateway(self, ipv4_gateway):
        """Sets the ipv4_gateway of this NetworkInterfaceVlan.


        :param ipv4_gateway: The ipv4_gateway of this NetworkInterfaceVlan.  # noqa: E501
        :type: str
        """
        if ipv4_gateway is not None and len(ipv4_gateway) > 16:
            raise ValueError("Invalid value for `ipv4_gateway`, length must be less than or equal to `16`")  # noqa: E501
        if ipv4_gateway is not None and len(ipv4_gateway) < 1:
            raise ValueError("Invalid value for `ipv4_gateway`, length must be greater than or equal to `1`")  # noqa: E501
        if ipv4_gateway is not None and not re.search('^([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])(\\.([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])){3}$', ipv4_gateway):  # noqa: E501
            raise ValueError("Invalid value for `ipv4_gateway`, must be a follow pattern or equal to `/^([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])(\\.([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])){3}$/`")  # noqa: E501

        self._ipv4_gateway = ipv4_gateway

    @property
    def ipv6_gateway(self):
        """Gets the ipv6_gateway of this NetworkInterfaceVlan.  # noqa: E501


        :return: The ipv6_gateway of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: str
        """
        return self._ipv6_gateway

    @ipv6_gateway.setter
    def ipv6_gateway(self, ipv6_gateway):
        """Sets the ipv6_gateway of this NetworkInterfaceVlan.


        :param ipv6_gateway: The ipv6_gateway of this NetworkInterfaceVlan.  # noqa: E501
        :type: str
        """
        if ipv6_gateway is not None and len(ipv6_gateway) > 40:
            raise ValueError("Invalid value for `ipv6_gateway`, length must be less than or equal to `40`")  # noqa: E501
        if ipv6_gateway is not None and len(ipv6_gateway) < 1:
            raise ValueError("Invalid value for `ipv6_gateway`, length must be greater than or equal to `1`")  # noqa: E501
        if ipv6_gateway is not None and not re.search('^[0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5}::([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?$|^[0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){7}$', ipv6_gateway):  # noqa: E501
            raise ValueError("Invalid value for `ipv6_gateway`, must be a follow pattern or equal to `/^[0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5}::([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?$|^[0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){7}$/`")  # noqa: E501

        self._ipv6_gateway = ipv6_gateway

    @property
    def lnn(self):
        """Gets the lnn of this NetworkInterfaceVlan.  # noqa: E501

        Logical Node Number (LNN) of a node.  # noqa: E501

        :return: The lnn of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: int
        """
        return self._lnn

    @lnn.setter
    def lnn(self, lnn):
        """Sets the lnn of this NetworkInterfaceVlan.

        Logical Node Number (LNN) of a node.  # noqa: E501

        :param lnn: The lnn of this NetworkInterfaceVlan.  # noqa: E501
        :type: int
        """
        if lnn is not None and lnn > 65535:  # noqa: E501
            raise ValueError("Invalid value for `lnn`, must be a value less than or equal to `65535`")  # noqa: E501
        if lnn is not None and lnn < 1:  # noqa: E501
            raise ValueError("Invalid value for `lnn`, must be a value greater than or equal to `1`")  # noqa: E501

        self._lnn = lnn

    @property
    def mtu(self):
        """Gets the mtu of this NetworkInterfaceVlan.  # noqa: E501

        The mtu the interface.  # noqa: E501

        :return: The mtu of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: int
        """
        return self._mtu

    @mtu.setter
    def mtu(self, mtu):
        """Sets the mtu of this NetworkInterfaceVlan.

        The mtu the interface.  # noqa: E501

        :param mtu: The mtu of this NetworkInterfaceVlan.  # noqa: E501
        :type: int
        """
        if mtu is not None and mtu > 9000:  # noqa: E501
            raise ValueError("Invalid value for `mtu`, must be a value less than or equal to `9000`")  # noqa: E501
        if mtu is not None and mtu < 0:  # noqa: E501
            raise ValueError("Invalid value for `mtu`, must be a value greater than or equal to `0`")  # noqa: E501

        self._mtu = mtu

    @property
    def name(self):
        """Gets the name of this NetworkInterfaceVlan.  # noqa: E501

        The name of the interface.  # noqa: E501

        :return: The name of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NetworkInterfaceVlan.

        The name of the interface.  # noqa: E501

        :param name: The name of this NetworkInterfaceVlan.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 32:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `32`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def nic_name(self):
        """Gets the nic_name of this NetworkInterfaceVlan.  # noqa: E501

        NIC name  # noqa: E501

        :return: The nic_name of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: str
        """
        return self._nic_name

    @nic_name.setter
    def nic_name(self, nic_name):
        """Sets the nic_name of this NetworkInterfaceVlan.

        NIC name  # noqa: E501

        :param nic_name: The nic_name of this NetworkInterfaceVlan.  # noqa: E501
        :type: str
        """
        if nic_name is not None and len(nic_name) > 32:
            raise ValueError("Invalid value for `nic_name`, length must be less than or equal to `32`")  # noqa: E501
        if nic_name is not None and len(nic_name) < 1:
            raise ValueError("Invalid value for `nic_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._nic_name = nic_name

    @property
    def status(self):
        """Gets the status of this NetworkInterfaceVlan.  # noqa: E501

        Status of the interface  # noqa: E501

        :return: The status of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this NetworkInterfaceVlan.

        Status of the interface  # noqa: E501

        :param status: The status of this NetworkInterfaceVlan.  # noqa: E501
        :type: str
        """
        allowed_values = ["up", "no_carrier", "active", "inactive", "disabled", "unknown"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def type(self):
        """Gets the type of this NetworkInterfaceVlan.  # noqa: E501

        The type of network interface  # noqa: E501

        :return: The type of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NetworkInterfaceVlan.

        The type of network interface  # noqa: E501

        :param type: The type of this NetworkInterfaceVlan.  # noqa: E501
        :type: str
        """
        if type is not None and len(type) > 32:
            raise ValueError("Invalid value for `type`, length must be less than or equal to `32`")  # noqa: E501
        if type is not None and len(type) < 1:
            raise ValueError("Invalid value for `type`, length must be greater than or equal to `1`")  # noqa: E501

        self._type = type

    @property
    def vlan_id(self):
        """Gets the vlan_id of this NetworkInterfaceVlan.  # noqa: E501

        The configured VLAN ID.  # noqa: E501

        :return: The vlan_id of this NetworkInterfaceVlan.  # noqa: E501
        :rtype: int
        """
        return self._vlan_id

    @vlan_id.setter
    def vlan_id(self, vlan_id):
        """Sets the vlan_id of this NetworkInterfaceVlan.

        The configured VLAN ID.  # noqa: E501

        :param vlan_id: The vlan_id of this NetworkInterfaceVlan.  # noqa: E501
        :type: int
        """
        if vlan_id is not None and vlan_id > 4094:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must be a value less than or equal to `4094`")  # noqa: E501
        if vlan_id is not None and vlan_id < 1:  # noqa: E501
            raise ValueError("Invalid value for `vlan_id`, must be a value greater than or equal to `1`")  # noqa: E501

        self._vlan_id = vlan_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkInterfaceVlan):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
