# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_4_0.models.kmip_server_ca_cert import KmipServerCaCert  # noqa: F401,E501
from isilon_sdk.v9_4_0.models.kmip_server_client_cert import KmipServerClientCert  # noqa: F401,E501


class KmipServerExtended(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ca_cert': 'KmipServerCaCert',
        'client_cert': 'KmipServerClientCert',
        'connection_timeout': 'int',
        'host': 'str',
        'id': 'str',
        'minimum_tls_version': 'str',
        'port': 'int',
        'retry_timeout': 'int'
    }

    attribute_map = {
        'ca_cert': 'ca_cert',
        'client_cert': 'client_cert',
        'connection_timeout': 'connection_timeout',
        'host': 'host',
        'id': 'id',
        'minimum_tls_version': 'minimum_tls_version',
        'port': 'port',
        'retry_timeout': 'retry_timeout'
    }

    def __init__(self, ca_cert=None, client_cert=None, connection_timeout=None, host=None, id=None, minimum_tls_version=None, port=None, retry_timeout=None):  # noqa: E501
        """KmipServerExtended - a model defined in Swagger"""  # noqa: E501

        self._ca_cert = None
        self._client_cert = None
        self._connection_timeout = None
        self._host = None
        self._id = None
        self._minimum_tls_version = None
        self._port = None
        self._retry_timeout = None
        self.discriminator = None

        if ca_cert is not None:
            self.ca_cert = ca_cert
        if client_cert is not None:
            self.client_cert = client_cert
        if connection_timeout is not None:
            self.connection_timeout = connection_timeout
        if host is not None:
            self.host = host
        if id is not None:
            self.id = id
        if minimum_tls_version is not None:
            self.minimum_tls_version = minimum_tls_version
        if port is not None:
            self.port = port
        if retry_timeout is not None:
            self.retry_timeout = retry_timeout

    @property
    def ca_cert(self):
        """Gets the ca_cert of this KmipServerExtended.  # noqa: E501

          # noqa: E501

        :return: The ca_cert of this KmipServerExtended.  # noqa: E501
        :rtype: KmipServerCaCert
        """
        return self._ca_cert

    @ca_cert.setter
    def ca_cert(self, ca_cert):
        """Sets the ca_cert of this KmipServerExtended.

          # noqa: E501

        :param ca_cert: The ca_cert of this KmipServerExtended.  # noqa: E501
        :type: KmipServerCaCert
        """

        self._ca_cert = ca_cert

    @property
    def client_cert(self):
        """Gets the client_cert of this KmipServerExtended.  # noqa: E501

          # noqa: E501

        :return: The client_cert of this KmipServerExtended.  # noqa: E501
        :rtype: KmipServerClientCert
        """
        return self._client_cert

    @client_cert.setter
    def client_cert(self, client_cert):
        """Sets the client_cert of this KmipServerExtended.

          # noqa: E501

        :param client_cert: The client_cert of this KmipServerExtended.  # noqa: E501
        :type: KmipServerClientCert
        """

        self._client_cert = client_cert

    @property
    def connection_timeout(self):
        """Gets the connection_timeout of this KmipServerExtended.  # noqa: E501

        KMIP RPC connection timeout in seconds.  # noqa: E501

        :return: The connection_timeout of this KmipServerExtended.  # noqa: E501
        :rtype: int
        """
        return self._connection_timeout

    @connection_timeout.setter
    def connection_timeout(self, connection_timeout):
        """Sets the connection_timeout of this KmipServerExtended.

        KMIP RPC connection timeout in seconds.  # noqa: E501

        :param connection_timeout: The connection_timeout of this KmipServerExtended.  # noqa: E501
        :type: int
        """
        if connection_timeout is not None and connection_timeout > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `connection_timeout`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if connection_timeout is not None and connection_timeout < 0:  # noqa: E501
            raise ValueError("Invalid value for `connection_timeout`, must be a value greater than or equal to `0`")  # noqa: E501

        self._connection_timeout = connection_timeout

    @property
    def host(self):
        """Gets the host of this KmipServerExtended.  # noqa: E501

        KMIP server hostname.  # noqa: E501

        :return: The host of this KmipServerExtended.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this KmipServerExtended.

        KMIP server hostname.  # noqa: E501

        :param host: The host of this KmipServerExtended.  # noqa: E501
        :type: str
        """
        if host is not None and len(host) > 256:
            raise ValueError("Invalid value for `host`, length must be less than or equal to `256`")  # noqa: E501
        if host is not None and len(host) < 1:
            raise ValueError("Invalid value for `host`, length must be greater than or equal to `1`")  # noqa: E501

        self._host = host

    @property
    def id(self):
        """Gets the id of this KmipServerExtended.  # noqa: E501

        Unique KMIP server identifier.  # noqa: E501

        :return: The id of this KmipServerExtended.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this KmipServerExtended.

        Unique KMIP server identifier.  # noqa: E501

        :param id: The id of this KmipServerExtended.  # noqa: E501
        :type: str
        """
        if id is not None and len(id) > 64:
            raise ValueError("Invalid value for `id`, length must be less than or equal to `64`")  # noqa: E501
        if id is not None and len(id) < 1:
            raise ValueError("Invalid value for `id`, length must be greater than or equal to `1`")  # noqa: E501
        if id is not None and not re.search('^[a-zA-Z0-9_-]+$', id):  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a follow pattern or equal to `/^[a-zA-Z0-9_-]+$/`")  # noqa: E501

        self._id = id

    @property
    def minimum_tls_version(self):
        """Gets the minimum_tls_version of this KmipServerExtended.  # noqa: E501

        Denotes the minimum TLS version supported by the KTP. Default value is set to '1.2'. However other supported values are '1.0' and '1.1'.  # noqa: E501

        :return: The minimum_tls_version of this KmipServerExtended.  # noqa: E501
        :rtype: str
        """
        return self._minimum_tls_version

    @minimum_tls_version.setter
    def minimum_tls_version(self, minimum_tls_version):
        """Sets the minimum_tls_version of this KmipServerExtended.

        Denotes the minimum TLS version supported by the KTP. Default value is set to '1.2'. However other supported values are '1.0' and '1.1'.  # noqa: E501

        :param minimum_tls_version: The minimum_tls_version of this KmipServerExtended.  # noqa: E501
        :type: str
        """
        if minimum_tls_version is not None and len(minimum_tls_version) > 3:
            raise ValueError("Invalid value for `minimum_tls_version`, length must be less than or equal to `3`")  # noqa: E501
        if minimum_tls_version is not None and len(minimum_tls_version) < 3:
            raise ValueError("Invalid value for `minimum_tls_version`, length must be greater than or equal to `3`")  # noqa: E501
        if minimum_tls_version is not None and not re.search('^[0-9]{1}[.][0-9]{1}$', minimum_tls_version):  # noqa: E501
            raise ValueError("Invalid value for `minimum_tls_version`, must be a follow pattern or equal to `/^[0-9]{1}[.][0-9]{1}$/`")  # noqa: E501

        self._minimum_tls_version = minimum_tls_version

    @property
    def port(self):
        """Gets the port of this KmipServerExtended.  # noqa: E501

        KMIP server port.  # noqa: E501

        :return: The port of this KmipServerExtended.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this KmipServerExtended.

        KMIP server port.  # noqa: E501

        :param port: The port of this KmipServerExtended.  # noqa: E501
        :type: int
        """
        if port is not None and port > 65535:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value less than or equal to `65535`")  # noqa: E501
        if port is not None and port < 1:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value greater than or equal to `1`")  # noqa: E501

        self._port = port

    @property
    def retry_timeout(self):
        """Gets the retry_timeout of this KmipServerExtended.  # noqa: E501

        KMIP RPC retry timeout in milliseconds.  # noqa: E501

        :return: The retry_timeout of this KmipServerExtended.  # noqa: E501
        :rtype: int
        """
        return self._retry_timeout

    @retry_timeout.setter
    def retry_timeout(self, retry_timeout):
        """Sets the retry_timeout of this KmipServerExtended.

        KMIP RPC retry timeout in milliseconds.  # noqa: E501

        :param retry_timeout: The retry_timeout of this KmipServerExtended.  # noqa: E501
        :type: int
        """
        if retry_timeout is not None and retry_timeout > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `retry_timeout`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if retry_timeout is not None and retry_timeout < 0:  # noqa: E501
            raise ValueError("Invalid value for `retry_timeout`, must be a value greater than or equal to `0`")  # noqa: E501

        self._retry_timeout = retry_timeout

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KmipServerExtended):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
