# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class EventChannelParameters(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'address': 'list[str]',
        'batch': 'str',
        'batch_period': 'int',
        'custom_template': 'str',
        'send_as': 'str',
        'smtp_host': 'str',
        'smtp_password': 'str',
        'smtp_port': 'int',
        'smtp_security': 'str',
        'smtp_use_auth': 'bool',
        'smtp_username': 'str',
        'subject': 'str'
    }

    attribute_map = {
        'address': 'address',
        'batch': 'batch',
        'batch_period': 'batch_period',
        'custom_template': 'custom_template',
        'send_as': 'send_as',
        'smtp_host': 'smtp_host',
        'smtp_password': 'smtp_password',
        'smtp_port': 'smtp_port',
        'smtp_security': 'smtp_security',
        'smtp_use_auth': 'smtp_use_auth',
        'smtp_username': 'smtp_username',
        'subject': 'subject'
    }

    def __init__(self, address=None, batch=None, batch_period=None, custom_template=None, send_as=None, smtp_host=None, smtp_password=None, smtp_port=None, smtp_security=None, smtp_use_auth=None, smtp_username=None, subject=None):  # noqa: E501
        """EventChannelParameters - a model defined in Swagger"""  # noqa: E501

        self._address = None
        self._batch = None
        self._batch_period = None
        self._custom_template = None
        self._send_as = None
        self._smtp_host = None
        self._smtp_password = None
        self._smtp_port = None
        self._smtp_security = None
        self._smtp_use_auth = None
        self._smtp_username = None
        self._subject = None
        self.discriminator = None

        if address is not None:
            self.address = address
        if batch is not None:
            self.batch = batch
        if batch_period is not None:
            self.batch_period = batch_period
        if custom_template is not None:
            self.custom_template = custom_template
        if send_as is not None:
            self.send_as = send_as
        if smtp_host is not None:
            self.smtp_host = smtp_host
        if smtp_password is not None:
            self.smtp_password = smtp_password
        if smtp_port is not None:
            self.smtp_port = smtp_port
        if smtp_security is not None:
            self.smtp_security = smtp_security
        if smtp_use_auth is not None:
            self.smtp_use_auth = smtp_use_auth
        if smtp_username is not None:
            self.smtp_username = smtp_username
        if subject is not None:
            self.subject = subject

    @property
    def address(self):
        """Gets the address of this EventChannelParameters.  # noqa: E501

        Email addresses to send to.  # noqa: E501

        :return: The address of this EventChannelParameters.  # noqa: E501
        :rtype: list[str]
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this EventChannelParameters.

        Email addresses to send to.  # noqa: E501

        :param address: The address of this EventChannelParameters.  # noqa: E501
        :type: list[str]
        """

        self._address = address

    @property
    def batch(self):
        """Gets the batch of this EventChannelParameters.  # noqa: E501

        Batching criterion.  # noqa: E501

        :return: The batch of this EventChannelParameters.  # noqa: E501
        :rtype: str
        """
        return self._batch

    @batch.setter
    def batch(self, batch):
        """Sets the batch of this EventChannelParameters.

        Batching criterion.  # noqa: E501

        :param batch: The batch of this EventChannelParameters.  # noqa: E501
        :type: str
        """
        allowed_values = ["NONE", "ALL", "CATEGORY", "SEVERITY"]  # noqa: E501
        if batch not in allowed_values:
            raise ValueError(
                "Invalid value for `batch` ({0}), must be one of {1}"  # noqa: E501
                .format(batch, allowed_values)
            )

        self._batch = batch

    @property
    def batch_period(self):
        """Gets the batch_period of this EventChannelParameters.  # noqa: E501

        Period over which batching is to be performed.  # noqa: E501

        :return: The batch_period of this EventChannelParameters.  # noqa: E501
        :rtype: int
        """
        return self._batch_period

    @batch_period.setter
    def batch_period(self, batch_period):
        """Sets the batch_period of this EventChannelParameters.

        Period over which batching is to be performed.  # noqa: E501

        :param batch_period: The batch_period of this EventChannelParameters.  # noqa: E501
        :type: int
        """
        if batch_period is not None and batch_period > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `batch_period`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if batch_period is not None and batch_period < 1:  # noqa: E501
            raise ValueError("Invalid value for `batch_period`, must be a value greater than or equal to `1`")  # noqa: E501

        self._batch_period = batch_period

    @property
    def custom_template(self):
        """Gets the custom_template of this EventChannelParameters.  # noqa: E501

        Path to custom notification template.  # noqa: E501

        :return: The custom_template of this EventChannelParameters.  # noqa: E501
        :rtype: str
        """
        return self._custom_template

    @custom_template.setter
    def custom_template(self, custom_template):
        """Sets the custom_template of this EventChannelParameters.

        Path to custom notification template.  # noqa: E501

        :param custom_template: The custom_template of this EventChannelParameters.  # noqa: E501
        :type: str
        """
        if custom_template is not None and len(custom_template) > 4096:
            raise ValueError("Invalid value for `custom_template`, length must be less than or equal to `4096`")  # noqa: E501
        if custom_template is not None and len(custom_template) < 0:
            raise ValueError("Invalid value for `custom_template`, length must be greater than or equal to `0`")  # noqa: E501
        if custom_template is not None and not re.search('^((\/[^\/[:cntrl:]]+)(\/?))*$', custom_template):  # noqa: E501
            raise ValueError("Invalid value for `custom_template`, must be a follow pattern or equal to `/^((\/[^\/[:cntrl:]]+)(\/?))*$/`")  # noqa: E501

        self._custom_template = custom_template

    @property
    def send_as(self):
        """Gets the send_as of this EventChannelParameters.  # noqa: E501

        Email address to use as from.  # noqa: E501

        :return: The send_as of this EventChannelParameters.  # noqa: E501
        :rtype: str
        """
        return self._send_as

    @send_as.setter
    def send_as(self, send_as):
        """Sets the send_as of this EventChannelParameters.

        Email address to use as from.  # noqa: E501

        :param send_as: The send_as of this EventChannelParameters.  # noqa: E501
        :type: str
        """
        if send_as is not None and len(send_as) > 320:
            raise ValueError("Invalid value for `send_as`, length must be less than or equal to `320`")  # noqa: E501
        if send_as is not None and len(send_as) < 0:
            raise ValueError("Invalid value for `send_as`, length must be greater than or equal to `0`")  # noqa: E501

        self._send_as = send_as

    @property
    def smtp_host(self):
        """Gets the smtp_host of this EventChannelParameters.  # noqa: E501

        SMTP relay host.  # noqa: E501

        :return: The smtp_host of this EventChannelParameters.  # noqa: E501
        :rtype: str
        """
        return self._smtp_host

    @smtp_host.setter
    def smtp_host(self, smtp_host):
        """Sets the smtp_host of this EventChannelParameters.

        SMTP relay host.  # noqa: E501

        :param smtp_host: The smtp_host of this EventChannelParameters.  # noqa: E501
        :type: str
        """
        if smtp_host is not None and len(smtp_host) > 255:
            raise ValueError("Invalid value for `smtp_host`, length must be less than or equal to `255`")  # noqa: E501
        if smtp_host is not None and len(smtp_host) < 0:
            raise ValueError("Invalid value for `smtp_host`, length must be greater than or equal to `0`")  # noqa: E501

        self._smtp_host = smtp_host

    @property
    def smtp_password(self):
        """Gets the smtp_password of this EventChannelParameters.  # noqa: E501

        Password for SMTP authentication - only if smtp_use_auth true.  # noqa: E501

        :return: The smtp_password of this EventChannelParameters.  # noqa: E501
        :rtype: str
        """
        return self._smtp_password

    @smtp_password.setter
    def smtp_password(self, smtp_password):
        """Sets the smtp_password of this EventChannelParameters.

        Password for SMTP authentication - only if smtp_use_auth true.  # noqa: E501

        :param smtp_password: The smtp_password of this EventChannelParameters.  # noqa: E501
        :type: str
        """
        if smtp_password is not None and len(smtp_password) > 255:
            raise ValueError("Invalid value for `smtp_password`, length must be less than or equal to `255`")  # noqa: E501
        if smtp_password is not None and len(smtp_password) < 0:
            raise ValueError("Invalid value for `smtp_password`, length must be greater than or equal to `0`")  # noqa: E501

        self._smtp_password = smtp_password

    @property
    def smtp_port(self):
        """Gets the smtp_port of this EventChannelParameters.  # noqa: E501

        SMTP relay port - optional defaults to 25.  # noqa: E501

        :return: The smtp_port of this EventChannelParameters.  # noqa: E501
        :rtype: int
        """
        return self._smtp_port

    @smtp_port.setter
    def smtp_port(self, smtp_port):
        """Sets the smtp_port of this EventChannelParameters.

        SMTP relay port - optional defaults to 25.  # noqa: E501

        :param smtp_port: The smtp_port of this EventChannelParameters.  # noqa: E501
        :type: int
        """
        if smtp_port is not None and smtp_port > 65535:  # noqa: E501
            raise ValueError("Invalid value for `smtp_port`, must be a value less than or equal to `65535`")  # noqa: E501
        if smtp_port is not None and smtp_port < 1:  # noqa: E501
            raise ValueError("Invalid value for `smtp_port`, must be a value greater than or equal to `1`")  # noqa: E501

        self._smtp_port = smtp_port

    @property
    def smtp_security(self):
        """Gets the smtp_security of this EventChannelParameters.  # noqa: E501

        Encryption protocol to use for SMTP.  # noqa: E501

        :return: The smtp_security of this EventChannelParameters.  # noqa: E501
        :rtype: str
        """
        return self._smtp_security

    @smtp_security.setter
    def smtp_security(self, smtp_security):
        """Sets the smtp_security of this EventChannelParameters.

        Encryption protocol to use for SMTP.  # noqa: E501

        :param smtp_security: The smtp_security of this EventChannelParameters.  # noqa: E501
        :type: str
        """
        allowed_values = ["NONE", "STARTTLS"]  # noqa: E501
        if smtp_security not in allowed_values:
            raise ValueError(
                "Invalid value for `smtp_security` ({0}), must be one of {1}"  # noqa: E501
                .format(smtp_security, allowed_values)
            )

        self._smtp_security = smtp_security

    @property
    def smtp_use_auth(self):
        """Gets the smtp_use_auth of this EventChannelParameters.  # noqa: E501

        Use SMTP authentication - optional defaults to false.  # noqa: E501

        :return: The smtp_use_auth of this EventChannelParameters.  # noqa: E501
        :rtype: bool
        """
        return self._smtp_use_auth

    @smtp_use_auth.setter
    def smtp_use_auth(self, smtp_use_auth):
        """Sets the smtp_use_auth of this EventChannelParameters.

        Use SMTP authentication - optional defaults to false.  # noqa: E501

        :param smtp_use_auth: The smtp_use_auth of this EventChannelParameters.  # noqa: E501
        :type: bool
        """

        self._smtp_use_auth = smtp_use_auth

    @property
    def smtp_username(self):
        """Gets the smtp_username of this EventChannelParameters.  # noqa: E501

        Username for SMTP authentication - only if smtp_use_auth true.  # noqa: E501

        :return: The smtp_username of this EventChannelParameters.  # noqa: E501
        :rtype: str
        """
        return self._smtp_username

    @smtp_username.setter
    def smtp_username(self, smtp_username):
        """Sets the smtp_username of this EventChannelParameters.

        Username for SMTP authentication - only if smtp_use_auth true.  # noqa: E501

        :param smtp_username: The smtp_username of this EventChannelParameters.  # noqa: E501
        :type: str
        """
        if smtp_username is not None and len(smtp_username) > 255:
            raise ValueError("Invalid value for `smtp_username`, length must be less than or equal to `255`")  # noqa: E501
        if smtp_username is not None and len(smtp_username) < 0:
            raise ValueError("Invalid value for `smtp_username`, length must be greater than or equal to `0`")  # noqa: E501

        self._smtp_username = smtp_username

    @property
    def subject(self):
        """Gets the subject of this EventChannelParameters.  # noqa: E501

        Subject for emails.  # noqa: E501

        :return: The subject of this EventChannelParameters.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this EventChannelParameters.

        Subject for emails.  # noqa: E501

        :param subject: The subject of this EventChannelParameters.  # noqa: E501
        :type: str
        """
        if subject is not None and len(subject) > 255:
            raise ValueError("Invalid value for `subject`, length must be less than or equal to `255`")  # noqa: E501
        if subject is not None and len(subject) < 0:
            raise ValueError("Invalid value for `subject`, length must be greater than or equal to `0`")  # noqa: E501

        self._subject = subject

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventChannelParameters):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
