# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_4_0.models.cluster_nodes_error import ClusterNodesError  # noqa: F401,E501
from isilon_sdk.v9_4_0.models.cluster_nodes_onefs_version import ClusterNodesOnefsVersion  # noqa: F401,E501


class ClusterNodes(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'domain': 'int',
        'down_peer': 'bool',
        'error': 'ClusterNodesError',
        'last_action': 'str',
        'last_action_result': 'str',
        'lnn': 'int',
        'node_state': 'str',
        'onefs_version': 'ClusterNodesOnefsVersion',
        'progress': 'int'
    }

    attribute_map = {
        'domain': 'domain',
        'down_peer': 'down_peer',
        'error': 'error',
        'last_action': 'last_action',
        'last_action_result': 'last_action_result',
        'lnn': 'lnn',
        'node_state': 'node_state',
        'onefs_version': 'onefs_version',
        'progress': 'progress'
    }

    def __init__(self, domain=None, down_peer=None, error=None, last_action=None, last_action_result=None, lnn=None, node_state=None, onefs_version=None, progress=None):  # noqa: E501
        """ClusterNodes - a model defined in Swagger"""  # noqa: E501

        self._domain = None
        self._down_peer = None
        self._error = None
        self._last_action = None
        self._last_action_result = None
        self._lnn = None
        self._node_state = None
        self._onefs_version = None
        self._progress = None
        self.discriminator = None

        if domain is not None:
            self.domain = domain
        if down_peer is not None:
            self.down_peer = down_peer
        if error is not None:
            self.error = error
        if last_action is not None:
            self.last_action = last_action
        if last_action_result is not None:
            self.last_action_result = last_action_result
        if lnn is not None:
            self.lnn = lnn
        if node_state is not None:
            self.node_state = node_state
        if onefs_version is not None:
            self.onefs_version = onefs_version
        if progress is not None:
            self.progress = progress

    @property
    def domain(self):
        """Gets the domain of this ClusterNodes.  # noqa: E501

        Unique identifier for the failure domain that thisnode resides in. Within a given domain, nodes are rebooted 1 at a time. The actual value is meaningless, it is merely used to group nodes by failure domain.  # noqa: E501

        :return: The domain of this ClusterNodes.  # noqa: E501
        :rtype: int
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this ClusterNodes.

        Unique identifier for the failure domain that thisnode resides in. Within a given domain, nodes are rebooted 1 at a time. The actual value is meaningless, it is merely used to group nodes by failure domain.  # noqa: E501

        :param domain: The domain of this ClusterNodes.  # noqa: E501
        :type: int
        """
        if domain is not None and domain > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `domain`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if domain is not None and domain < -1:  # noqa: E501
            raise ValueError("Invalid value for `domain`, must be a value greater than or equal to `-1`")  # noqa: E501

        self._domain = domain

    @property
    def down_peer(self):
        """Gets the down_peer of this ClusterNodes.  # noqa: E501

        Peer node is down.  # noqa: E501

        :return: The down_peer of this ClusterNodes.  # noqa: E501
        :rtype: bool
        """
        return self._down_peer

    @down_peer.setter
    def down_peer(self, down_peer):
        """Sets the down_peer of this ClusterNodes.

        Peer node is down.  # noqa: E501

        :param down_peer: The down_peer of this ClusterNodes.  # noqa: E501
        :type: bool
        """

        self._down_peer = down_peer

    @property
    def error(self):
        """Gets the error of this ClusterNodes.  # noqa: E501

        The current OneFS version before upgrade.  # noqa: E501

        :return: The error of this ClusterNodes.  # noqa: E501
        :rtype: ClusterNodesError
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this ClusterNodes.

        The current OneFS version before upgrade.  # noqa: E501

        :param error: The error of this ClusterNodes.  # noqa: E501
        :type: ClusterNodesError
        """

        self._error = error

    @property
    def last_action(self):
        """Gets the last_action of this ClusterNodes.  # noqa: E501

        The last action performed to completion/failure on this node.  Null if the node_state is 'committed' or 'assessing.' One of the following values: 'upgrade', 'rollback'.  # noqa: E501

        :return: The last_action of this ClusterNodes.  # noqa: E501
        :rtype: str
        """
        return self._last_action

    @last_action.setter
    def last_action(self, last_action):
        """Sets the last_action of this ClusterNodes.

        The last action performed to completion/failure on this node.  Null if the node_state is 'committed' or 'assessing.' One of the following values: 'upgrade', 'rollback'.  # noqa: E501

        :param last_action: The last_action of this ClusterNodes.  # noqa: E501
        :type: str
        """

        self._last_action = last_action

    @property
    def last_action_result(self):
        """Gets the last_action_result of this ClusterNodes.  # noqa: E501

        Did the node pass upgrade or rollback without failing? Null if the node_state is 'committed.' One of the following values: 'pass', 'fail', null  # noqa: E501

        :return: The last_action_result of this ClusterNodes.  # noqa: E501
        :rtype: str
        """
        return self._last_action_result

    @last_action_result.setter
    def last_action_result(self, last_action_result):
        """Sets the last_action_result of this ClusterNodes.

        Did the node pass upgrade or rollback without failing? Null if the node_state is 'committed.' One of the following values: 'pass', 'fail', null  # noqa: E501

        :param last_action_result: The last_action_result of this ClusterNodes.  # noqa: E501
        :type: str
        """

        self._last_action_result = last_action_result

    @property
    def lnn(self):
        """Gets the lnn of this ClusterNodes.  # noqa: E501

        The lnn of the node.  # noqa: E501

        :return: The lnn of this ClusterNodes.  # noqa: E501
        :rtype: int
        """
        return self._lnn

    @lnn.setter
    def lnn(self, lnn):
        """Sets the lnn of this ClusterNodes.

        The lnn of the node.  # noqa: E501

        :param lnn: The lnn of this ClusterNodes.  # noqa: E501
        :type: int
        """
        if lnn is not None and lnn > 65535:  # noqa: E501
            raise ValueError("Invalid value for `lnn`, must be a value less than or equal to `65535`")  # noqa: E501
        if lnn is not None and lnn < 1:  # noqa: E501
            raise ValueError("Invalid value for `lnn`, must be a value greater than or equal to `1`")  # noqa: E501

        self._lnn = lnn

    @property
    def node_state(self):
        """Gets the node_state of this ClusterNodes.  # noqa: E501

        \\e The state of the node during the upgrade, rollback, or assessment. One of the following values: 'committed', 'upgraded', 'upgrading', 'rolling back', 'assessing', 'error'  # noqa: E501

        :return: The node_state of this ClusterNodes.  # noqa: E501
        :rtype: str
        """
        return self._node_state

    @node_state.setter
    def node_state(self, node_state):
        """Sets the node_state of this ClusterNodes.

        \\e The state of the node during the upgrade, rollback, or assessment. One of the following values: 'committed', 'upgraded', 'upgrading', 'rolling back', 'assessing', 'error'  # noqa: E501

        :param node_state: The node_state of this ClusterNodes.  # noqa: E501
        :type: str
        """
        if node_state is not None and len(node_state) > 4096:
            raise ValueError("Invalid value for `node_state`, length must be less than or equal to `4096`")  # noqa: E501
        if node_state is not None and len(node_state) < 0:
            raise ValueError("Invalid value for `node_state`, length must be greater than or equal to `0`")  # noqa: E501

        self._node_state = node_state

    @property
    def onefs_version(self):
        """Gets the onefs_version of this ClusterNodes.  # noqa: E501

        The current OneFS version before upgrade.  # noqa: E501

        :return: The onefs_version of this ClusterNodes.  # noqa: E501
        :rtype: ClusterNodesOnefsVersion
        """
        return self._onefs_version

    @onefs_version.setter
    def onefs_version(self, onefs_version):
        """Sets the onefs_version of this ClusterNodes.

        The current OneFS version before upgrade.  # noqa: E501

        :param onefs_version: The onefs_version of this ClusterNodes.  # noqa: E501
        :type: ClusterNodesOnefsVersion
        """

        self._onefs_version = onefs_version

    @property
    def progress(self):
        """Gets the progress of this ClusterNodes.  # noqa: E501

        What step is the upgrade, assessment, or rollback in? To show via progress indicator. NOTE: the value is an integer between 0 and 100 (percent)  # noqa: E501

        :return: The progress of this ClusterNodes.  # noqa: E501
        :rtype: int
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """Sets the progress of this ClusterNodes.

        What step is the upgrade, assessment, or rollback in? To show via progress indicator. NOTE: the value is an integer between 0 and 100 (percent)  # noqa: E501

        :param progress: The progress of this ClusterNodes.  # noqa: E501
        :type: int
        """
        if progress is not None and progress > 100:  # noqa: E501
            raise ValueError("Invalid value for `progress`, must be a value less than or equal to `100`")  # noqa: E501
        if progress is not None and progress < 0:  # noqa: E501
            raise ValueError("Invalid value for `progress`, must be a value greater than or equal to `0`")  # noqa: E501

        self._progress = progress

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterNodes):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
