# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ClusterNodeHardware(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'chassis': 'str',
        'chassis_code': 'str',
        'chassis_depth': 'str',
        '_class': 'str',
        'compute_type': 'str',
        'configuration_id': 'str',
        'cpu': 'str',
        'disk_controller': 'str',
        'disk_expander': 'str',
        'family_code': 'str',
        'generation_code': 'str',
        'hwgen': 'str',
        'infiniband': 'str',
        'lcd_version': 'str',
        'model': 'str',
        'model_code': 'str',
        'motherboard': 'str',
        'net_interfaces': 'str',
        'node_slot_id': 'int',
        'nvram': 'str',
        'peer_serial_number': 'str',
        'performance_code': 'str',
        'powersupplies': 'list[str]',
        'processor': 'str',
        'product': 'str',
        'ram': 'int',
        'serial_number': 'str',
        'series': 'str',
        'sled_drive_count': 'int',
        'storage_class': 'str',
        'tier': 'int',
        'top_level_assembly_serial_number': 'str'
    }

    attribute_map = {
        'chassis': 'chassis',
        'chassis_code': 'chassis_code',
        'chassis_depth': 'chassis_depth',
        '_class': 'class',
        'compute_type': 'compute_type',
        'configuration_id': 'configuration_id',
        'cpu': 'cpu',
        'disk_controller': 'disk_controller',
        'disk_expander': 'disk_expander',
        'family_code': 'family_code',
        'generation_code': 'generation_code',
        'hwgen': 'hwgen',
        'infiniband': 'infiniband',
        'lcd_version': 'lcd_version',
        'model': 'model',
        'model_code': 'model_code',
        'motherboard': 'motherboard',
        'net_interfaces': 'net_interfaces',
        'node_slot_id': 'node_slot_id',
        'nvram': 'nvram',
        'peer_serial_number': 'peer_serial_number',
        'performance_code': 'performance_code',
        'powersupplies': 'powersupplies',
        'processor': 'processor',
        'product': 'product',
        'ram': 'ram',
        'serial_number': 'serial_number',
        'series': 'series',
        'sled_drive_count': 'sled_drive_count',
        'storage_class': 'storage_class',
        'tier': 'tier',
        'top_level_assembly_serial_number': 'top_level_assembly_serial_number'
    }

    def __init__(self, chassis=None, chassis_code=None, chassis_depth=None, _class=None, compute_type=None, configuration_id=None, cpu=None, disk_controller=None, disk_expander=None, family_code=None, generation_code=None, hwgen=None, infiniband=None, lcd_version=None, model=None, model_code=None, motherboard=None, net_interfaces=None, node_slot_id=None, nvram=None, peer_serial_number=None, performance_code=None, powersupplies=None, processor=None, product=None, ram=None, serial_number=None, series=None, sled_drive_count=None, storage_class=None, tier=None, top_level_assembly_serial_number=None):  # noqa: E501
        """ClusterNodeHardware - a model defined in Swagger"""  # noqa: E501

        self._chassis = None
        self._chassis_code = None
        self._chassis_depth = None
        self.__class = None
        self._compute_type = None
        self._configuration_id = None
        self._cpu = None
        self._disk_controller = None
        self._disk_expander = None
        self._family_code = None
        self._generation_code = None
        self._hwgen = None
        self._infiniband = None
        self._lcd_version = None
        self._model = None
        self._model_code = None
        self._motherboard = None
        self._net_interfaces = None
        self._node_slot_id = None
        self._nvram = None
        self._peer_serial_number = None
        self._performance_code = None
        self._powersupplies = None
        self._processor = None
        self._product = None
        self._ram = None
        self._serial_number = None
        self._series = None
        self._sled_drive_count = None
        self._storage_class = None
        self._tier = None
        self._top_level_assembly_serial_number = None
        self.discriminator = None

        if chassis is not None:
            self.chassis = chassis
        if chassis_code is not None:
            self.chassis_code = chassis_code
        if chassis_depth is not None:
            self.chassis_depth = chassis_depth
        if _class is not None:
            self._class = _class
        if compute_type is not None:
            self.compute_type = compute_type
        if configuration_id is not None:
            self.configuration_id = configuration_id
        if cpu is not None:
            self.cpu = cpu
        if disk_controller is not None:
            self.disk_controller = disk_controller
        if disk_expander is not None:
            self.disk_expander = disk_expander
        if family_code is not None:
            self.family_code = family_code
        if generation_code is not None:
            self.generation_code = generation_code
        if hwgen is not None:
            self.hwgen = hwgen
        if infiniband is not None:
            self.infiniband = infiniband
        if lcd_version is not None:
            self.lcd_version = lcd_version
        if model is not None:
            self.model = model
        if model_code is not None:
            self.model_code = model_code
        if motherboard is not None:
            self.motherboard = motherboard
        if net_interfaces is not None:
            self.net_interfaces = net_interfaces
        if node_slot_id is not None:
            self.node_slot_id = node_slot_id
        if nvram is not None:
            self.nvram = nvram
        if peer_serial_number is not None:
            self.peer_serial_number = peer_serial_number
        if performance_code is not None:
            self.performance_code = performance_code
        if powersupplies is not None:
            self.powersupplies = powersupplies
        if processor is not None:
            self.processor = processor
        if product is not None:
            self.product = product
        if ram is not None:
            self.ram = ram
        if serial_number is not None:
            self.serial_number = serial_number
        if series is not None:
            self.series = series
        if sled_drive_count is not None:
            self.sled_drive_count = sled_drive_count
        if storage_class is not None:
            self.storage_class = storage_class
        if tier is not None:
            self.tier = tier
        self.top_level_assembly_serial_number = top_level_assembly_serial_number

    @property
    def chassis(self):
        """Gets the chassis of this ClusterNodeHardware.  # noqa: E501

        Name of this node's chassis.  # noqa: E501

        :return: The chassis of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._chassis

    @chassis.setter
    def chassis(self, chassis):
        """Sets the chassis of this ClusterNodeHardware.

        Name of this node's chassis.  # noqa: E501

        :param chassis: The chassis of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if chassis is not None and len(chassis) > 255:
            raise ValueError("Invalid value for `chassis`, length must be less than or equal to `255`")  # noqa: E501
        if chassis is not None and len(chassis) < 0:
            raise ValueError("Invalid value for `chassis`, length must be greater than or equal to `0`")  # noqa: E501

        self._chassis = chassis

    @property
    def chassis_code(self):
        """Gets the chassis_code of this ClusterNodeHardware.  # noqa: E501

        Chassis code of this node (1U, 2U, etc.).  # noqa: E501

        :return: The chassis_code of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._chassis_code

    @chassis_code.setter
    def chassis_code(self, chassis_code):
        """Sets the chassis_code of this ClusterNodeHardware.

        Chassis code of this node (1U, 2U, etc.).  # noqa: E501

        :param chassis_code: The chassis_code of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if chassis_code is not None and len(chassis_code) > 255:
            raise ValueError("Invalid value for `chassis_code`, length must be less than or equal to `255`")  # noqa: E501
        if chassis_code is not None and len(chassis_code) < 0:
            raise ValueError("Invalid value for `chassis_code`, length must be greater than or equal to `0`")  # noqa: E501

        self._chassis_code = chassis_code

    @property
    def chassis_depth(self):
        """Gets the chassis_depth of this ClusterNodeHardware.  # noqa: E501

        Chassis depth for this node if applicable (e.g., Normal, Deep, Unknown). If not supported or error: Unknown.   # noqa: E501

        :return: The chassis_depth of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._chassis_depth

    @chassis_depth.setter
    def chassis_depth(self, chassis_depth):
        """Sets the chassis_depth of this ClusterNodeHardware.

        Chassis depth for this node if applicable (e.g., Normal, Deep, Unknown). If not supported or error: Unknown.   # noqa: E501

        :param chassis_depth: The chassis_depth of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if chassis_depth is not None and len(chassis_depth) > 255:
            raise ValueError("Invalid value for `chassis_depth`, length must be less than or equal to `255`")  # noqa: E501
        if chassis_depth is not None and len(chassis_depth) < 0:
            raise ValueError("Invalid value for `chassis_depth`, length must be greater than or equal to `0`")  # noqa: E501

        self._chassis_depth = chassis_depth

    @property
    def _class(self):
        """Gets the _class of this ClusterNodeHardware.  # noqa: E501

        Class of this node (storage, accelerator, etc.).  # noqa: E501

        :return: The _class of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self.__class

    @_class.setter
    def _class(self, _class):
        """Sets the _class of this ClusterNodeHardware.

        Class of this node (storage, accelerator, etc.).  # noqa: E501

        :param _class: The _class of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if _class is not None and len(_class) > 255:
            raise ValueError("Invalid value for `_class`, length must be less than or equal to `255`")  # noqa: E501
        if _class is not None and len(_class) < 0:
            raise ValueError("Invalid value for `_class`, length must be greater than or equal to `0`")  # noqa: E501

        self.__class = _class

    @property
    def compute_type(self):
        """Gets the compute_type of this ClusterNodeHardware.  # noqa: E501

        Type of compute node if applicable (e.g., Low, Medium, High, Turbo, Ultra, Unknown). If not supported or error: Unknown.   # noqa: E501

        :return: The compute_type of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._compute_type

    @compute_type.setter
    def compute_type(self, compute_type):
        """Sets the compute_type of this ClusterNodeHardware.

        Type of compute node if applicable (e.g., Low, Medium, High, Turbo, Ultra, Unknown). If not supported or error: Unknown.   # noqa: E501

        :param compute_type: The compute_type of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if compute_type is not None and len(compute_type) > 255:
            raise ValueError("Invalid value for `compute_type`, length must be less than or equal to `255`")  # noqa: E501
        if compute_type is not None and len(compute_type) < 0:
            raise ValueError("Invalid value for `compute_type`, length must be greater than or equal to `0`")  # noqa: E501

        self._compute_type = compute_type

    @property
    def configuration_id(self):
        """Gets the configuration_id of this ClusterNodeHardware.  # noqa: E501

        Node configuration ID.  # noqa: E501

        :return: The configuration_id of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._configuration_id

    @configuration_id.setter
    def configuration_id(self, configuration_id):
        """Sets the configuration_id of this ClusterNodeHardware.

        Node configuration ID.  # noqa: E501

        :param configuration_id: The configuration_id of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if configuration_id is not None and len(configuration_id) > 255:
            raise ValueError("Invalid value for `configuration_id`, length must be less than or equal to `255`")  # noqa: E501
        if configuration_id is not None and len(configuration_id) < 0:
            raise ValueError("Invalid value for `configuration_id`, length must be greater than or equal to `0`")  # noqa: E501

        self._configuration_id = configuration_id

    @property
    def cpu(self):
        """Gets the cpu of this ClusterNodeHardware.  # noqa: E501

        Manufacturer and model of this node's CPU.  # noqa: E501

        :return: The cpu of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._cpu

    @cpu.setter
    def cpu(self, cpu):
        """Sets the cpu of this ClusterNodeHardware.

        Manufacturer and model of this node's CPU.  # noqa: E501

        :param cpu: The cpu of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if cpu is not None and len(cpu) > 255:
            raise ValueError("Invalid value for `cpu`, length must be less than or equal to `255`")  # noqa: E501
        if cpu is not None and len(cpu) < 0:
            raise ValueError("Invalid value for `cpu`, length must be greater than or equal to `0`")  # noqa: E501

        self._cpu = cpu

    @property
    def disk_controller(self):
        """Gets the disk_controller of this ClusterNodeHardware.  # noqa: E501

        Manufacturer and model of this node's disk controller.  # noqa: E501

        :return: The disk_controller of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._disk_controller

    @disk_controller.setter
    def disk_controller(self, disk_controller):
        """Sets the disk_controller of this ClusterNodeHardware.

        Manufacturer and model of this node's disk controller.  # noqa: E501

        :param disk_controller: The disk_controller of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if disk_controller is not None and len(disk_controller) > 255:
            raise ValueError("Invalid value for `disk_controller`, length must be less than or equal to `255`")  # noqa: E501
        if disk_controller is not None and len(disk_controller) < 0:
            raise ValueError("Invalid value for `disk_controller`, length must be greater than or equal to `0`")  # noqa: E501

        self._disk_controller = disk_controller

    @property
    def disk_expander(self):
        """Gets the disk_expander of this ClusterNodeHardware.  # noqa: E501

        Manufacturer and model of this node's disk expander.  # noqa: E501

        :return: The disk_expander of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._disk_expander

    @disk_expander.setter
    def disk_expander(self, disk_expander):
        """Sets the disk_expander of this ClusterNodeHardware.

        Manufacturer and model of this node's disk expander.  # noqa: E501

        :param disk_expander: The disk_expander of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if disk_expander is not None and len(disk_expander) > 255:
            raise ValueError("Invalid value for `disk_expander`, length must be less than or equal to `255`")  # noqa: E501
        if disk_expander is not None and len(disk_expander) < 0:
            raise ValueError("Invalid value for `disk_expander`, length must be greater than or equal to `0`")  # noqa: E501

        self._disk_expander = disk_expander

    @property
    def family_code(self):
        """Gets the family_code of this ClusterNodeHardware.  # noqa: E501

        Family code of this node (X, S, NL, etc.).  # noqa: E501

        :return: The family_code of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._family_code

    @family_code.setter
    def family_code(self, family_code):
        """Sets the family_code of this ClusterNodeHardware.

        Family code of this node (X, S, NL, etc.).  # noqa: E501

        :param family_code: The family_code of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if family_code is not None and len(family_code) > 255:
            raise ValueError("Invalid value for `family_code`, length must be less than or equal to `255`")  # noqa: E501
        if family_code is not None and len(family_code) < 0:
            raise ValueError("Invalid value for `family_code`, length must be greater than or equal to `0`")  # noqa: E501

        self._family_code = family_code

    @property
    def generation_code(self):
        """Gets the generation_code of this ClusterNodeHardware.  # noqa: E501

        Generation code of this node.  # noqa: E501

        :return: The generation_code of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._generation_code

    @generation_code.setter
    def generation_code(self, generation_code):
        """Sets the generation_code of this ClusterNodeHardware.

        Generation code of this node.  # noqa: E501

        :param generation_code: The generation_code of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if generation_code is not None and len(generation_code) > 255:
            raise ValueError("Invalid value for `generation_code`, length must be less than or equal to `255`")  # noqa: E501
        if generation_code is not None and len(generation_code) < 0:
            raise ValueError("Invalid value for `generation_code`, length must be greater than or equal to `0`")  # noqa: E501

        self._generation_code = generation_code

    @property
    def hwgen(self):
        """Gets the hwgen of this ClusterNodeHardware.  # noqa: E501

        PowerScale hardware generation name.  # noqa: E501

        :return: The hwgen of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._hwgen

    @hwgen.setter
    def hwgen(self, hwgen):
        """Sets the hwgen of this ClusterNodeHardware.

        PowerScale hardware generation name.  # noqa: E501

        :param hwgen: The hwgen of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if hwgen is not None and len(hwgen) > 255:
            raise ValueError("Invalid value for `hwgen`, length must be less than or equal to `255`")  # noqa: E501
        if hwgen is not None and len(hwgen) < 0:
            raise ValueError("Invalid value for `hwgen`, length must be greater than or equal to `0`")  # noqa: E501

        self._hwgen = hwgen

    @property
    def infiniband(self):
        """Gets the infiniband of this ClusterNodeHardware.  # noqa: E501

        Infiniband card type.  # noqa: E501

        :return: The infiniband of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._infiniband

    @infiniband.setter
    def infiniband(self, infiniband):
        """Sets the infiniband of this ClusterNodeHardware.

        Infiniband card type.  # noqa: E501

        :param infiniband: The infiniband of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if infiniband is not None and len(infiniband) > 255:
            raise ValueError("Invalid value for `infiniband`, length must be less than or equal to `255`")  # noqa: E501
        if infiniband is not None and len(infiniband) < 0:
            raise ValueError("Invalid value for `infiniband`, length must be greater than or equal to `0`")  # noqa: E501

        self._infiniband = infiniband

    @property
    def lcd_version(self):
        """Gets the lcd_version of this ClusterNodeHardware.  # noqa: E501

        Version of the LCD panel.  # noqa: E501

        :return: The lcd_version of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._lcd_version

    @lcd_version.setter
    def lcd_version(self, lcd_version):
        """Sets the lcd_version of this ClusterNodeHardware.

        Version of the LCD panel.  # noqa: E501

        :param lcd_version: The lcd_version of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if lcd_version is not None and len(lcd_version) > 255:
            raise ValueError("Invalid value for `lcd_version`, length must be less than or equal to `255`")  # noqa: E501
        if lcd_version is not None and len(lcd_version) < 0:
            raise ValueError("Invalid value for `lcd_version`, length must be greater than or equal to `0`")  # noqa: E501

        self._lcd_version = lcd_version

    @property
    def model(self):
        """Gets the model of this ClusterNodeHardware.  # noqa: E501

        PowerScale node model identifier string (S200, X410, Infinity-H500, etc.).  # noqa: E501

        :return: The model of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """Sets the model of this ClusterNodeHardware.

        PowerScale node model identifier string (S200, X410, Infinity-H500, etc.).  # noqa: E501

        :param model: The model of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if model is not None and len(model) > 255:
            raise ValueError("Invalid value for `model`, length must be less than or equal to `255`")  # noqa: E501
        if model is not None and len(model) < 0:
            raise ValueError("Invalid value for `model`, length must be greater than or equal to `0`")  # noqa: E501

        self._model = model

    @property
    def model_code(self):
        """Gets the model_code of this ClusterNodeHardware.  # noqa: E501

        PowerScale node model code string (S200, X410, H500, etc.).  # noqa: E501

        :return: The model_code of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._model_code

    @model_code.setter
    def model_code(self, model_code):
        """Sets the model_code of this ClusterNodeHardware.

        PowerScale node model code string (S200, X410, H500, etc.).  # noqa: E501

        :param model_code: The model_code of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if model_code is not None and len(model_code) > 255:
            raise ValueError("Invalid value for `model_code`, length must be less than or equal to `255`")  # noqa: E501
        if model_code is not None and len(model_code) < 0:
            raise ValueError("Invalid value for `model_code`, length must be greater than or equal to `0`")  # noqa: E501

        self._model_code = model_code

    @property
    def motherboard(self):
        """Gets the motherboard of this ClusterNodeHardware.  # noqa: E501

        Manufacturer and model of this node's motherboard.  # noqa: E501

        :return: The motherboard of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._motherboard

    @motherboard.setter
    def motherboard(self, motherboard):
        """Sets the motherboard of this ClusterNodeHardware.

        Manufacturer and model of this node's motherboard.  # noqa: E501

        :param motherboard: The motherboard of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if motherboard is not None and len(motherboard) > 255:
            raise ValueError("Invalid value for `motherboard`, length must be less than or equal to `255`")  # noqa: E501
        if motherboard is not None and len(motherboard) < 0:
            raise ValueError("Invalid value for `motherboard`, length must be greater than or equal to `0`")  # noqa: E501

        self._motherboard = motherboard

    @property
    def net_interfaces(self):
        """Gets the net_interfaces of this ClusterNodeHardware.  # noqa: E501

        Description of all this node's network interfaces.  # noqa: E501

        :return: The net_interfaces of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._net_interfaces

    @net_interfaces.setter
    def net_interfaces(self, net_interfaces):
        """Sets the net_interfaces of this ClusterNodeHardware.

        Description of all this node's network interfaces.  # noqa: E501

        :param net_interfaces: The net_interfaces of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if net_interfaces is not None and len(net_interfaces) > 255:
            raise ValueError("Invalid value for `net_interfaces`, length must be less than or equal to `255`")  # noqa: E501
        if net_interfaces is not None and len(net_interfaces) < 0:
            raise ValueError("Invalid value for `net_interfaces`, length must be greater than or equal to `0`")  # noqa: E501

        self._net_interfaces = net_interfaces

    @property
    def node_slot_id(self):
        """Gets the node_slot_id of this ClusterNodeHardware.  # noqa: E501

        Position of node within chassis. -1 for error or not supported.  # noqa: E501

        :return: The node_slot_id of this ClusterNodeHardware.  # noqa: E501
        :rtype: int
        """
        return self._node_slot_id

    @node_slot_id.setter
    def node_slot_id(self, node_slot_id):
        """Sets the node_slot_id of this ClusterNodeHardware.

        Position of node within chassis. -1 for error or not supported.  # noqa: E501

        :param node_slot_id: The node_slot_id of this ClusterNodeHardware.  # noqa: E501
        :type: int
        """
        if node_slot_id is not None and node_slot_id > 4:  # noqa: E501
            raise ValueError("Invalid value for `node_slot_id`, must be a value less than or equal to `4`")  # noqa: E501
        if node_slot_id is not None and node_slot_id < -1:  # noqa: E501
            raise ValueError("Invalid value for `node_slot_id`, must be a value greater than or equal to `-1`")  # noqa: E501

        self._node_slot_id = node_slot_id

    @property
    def nvram(self):
        """Gets the nvram of this ClusterNodeHardware.  # noqa: E501

        Manufacturer and model of this node's NVRAM board.  # noqa: E501

        :return: The nvram of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._nvram

    @nvram.setter
    def nvram(self, nvram):
        """Sets the nvram of this ClusterNodeHardware.

        Manufacturer and model of this node's NVRAM board.  # noqa: E501

        :param nvram: The nvram of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if nvram is not None and len(nvram) > 255:
            raise ValueError("Invalid value for `nvram`, length must be less than or equal to `255`")  # noqa: E501
        if nvram is not None and len(nvram) < 0:
            raise ValueError("Invalid value for `nvram`, length must be greater than or equal to `0`")  # noqa: E501

        self._nvram = nvram

    @property
    def peer_serial_number(self):
        """Gets the peer_serial_number of this ClusterNodeHardware.  # noqa: E501

        Serial number of this node's peer/buddy node.(Infinity Only)  # noqa: E501

        :return: The peer_serial_number of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._peer_serial_number

    @peer_serial_number.setter
    def peer_serial_number(self, peer_serial_number):
        """Sets the peer_serial_number of this ClusterNodeHardware.

        Serial number of this node's peer/buddy node.(Infinity Only)  # noqa: E501

        :param peer_serial_number: The peer_serial_number of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """

        self._peer_serial_number = peer_serial_number

    @property
    def performance_code(self):
        """Gets the performance_code of this ClusterNodeHardware.  # noqa: E501

        Performance code of this node, if applicable (2, 4, 5, etc.).  # noqa: E501

        :return: The performance_code of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._performance_code

    @performance_code.setter
    def performance_code(self, performance_code):
        """Sets the performance_code of this ClusterNodeHardware.

        Performance code of this node, if applicable (2, 4, 5, etc.).  # noqa: E501

        :param performance_code: The performance_code of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if performance_code is not None and len(performance_code) > 255:
            raise ValueError("Invalid value for `performance_code`, length must be less than or equal to `255`")  # noqa: E501
        if performance_code is not None and len(performance_code) < 0:
            raise ValueError("Invalid value for `performance_code`, length must be greater than or equal to `0`")  # noqa: E501

        self._performance_code = performance_code

    @property
    def powersupplies(self):
        """Gets the powersupplies of this ClusterNodeHardware.  # noqa: E501

        Description strings for each power supply on this node.  # noqa: E501

        :return: The powersupplies of this ClusterNodeHardware.  # noqa: E501
        :rtype: list[str]
        """
        return self._powersupplies

    @powersupplies.setter
    def powersupplies(self, powersupplies):
        """Sets the powersupplies of this ClusterNodeHardware.

        Description strings for each power supply on this node.  # noqa: E501

        :param powersupplies: The powersupplies of this ClusterNodeHardware.  # noqa: E501
        :type: list[str]
        """

        self._powersupplies = powersupplies

    @property
    def processor(self):
        """Gets the processor of this ClusterNodeHardware.  # noqa: E501

        Number of processors and cores on this node.  # noqa: E501

        :return: The processor of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._processor

    @processor.setter
    def processor(self, processor):
        """Sets the processor of this ClusterNodeHardware.

        Number of processors and cores on this node.  # noqa: E501

        :param processor: The processor of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if processor is not None and len(processor) > 255:
            raise ValueError("Invalid value for `processor`, length must be less than or equal to `255`")  # noqa: E501
        if processor is not None and len(processor) < 0:
            raise ValueError("Invalid value for `processor`, length must be greater than or equal to `0`")  # noqa: E501

        self._processor = processor

    @property
    def product(self):
        """Gets the product of this ClusterNodeHardware.  # noqa: E501

        PowerScale product name.  # noqa: E501

        :return: The product of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this ClusterNodeHardware.

        PowerScale product name.  # noqa: E501

        :param product: The product of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if product is not None and len(product) > 255:
            raise ValueError("Invalid value for `product`, length must be less than or equal to `255`")  # noqa: E501
        if product is not None and len(product) < 0:
            raise ValueError("Invalid value for `product`, length must be greater than or equal to `0`")  # noqa: E501

        self._product = product

    @property
    def ram(self):
        """Gets the ram of this ClusterNodeHardware.  # noqa: E501

        Size of RAM in bytes.  # noqa: E501

        :return: The ram of this ClusterNodeHardware.  # noqa: E501
        :rtype: int
        """
        return self._ram

    @ram.setter
    def ram(self, ram):
        """Sets the ram of this ClusterNodeHardware.

        Size of RAM in bytes.  # noqa: E501

        :param ram: The ram of this ClusterNodeHardware.  # noqa: E501
        :type: int
        """
        if ram is not None and ram > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `ram`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if ram is not None and ram < 0:  # noqa: E501
            raise ValueError("Invalid value for `ram`, must be a value greater than or equal to `0`")  # noqa: E501

        self._ram = ram

    @property
    def serial_number(self):
        """Gets the serial_number of this ClusterNodeHardware.  # noqa: E501

        Serial number of this node.  # noqa: E501

        :return: The serial_number of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._serial_number

    @serial_number.setter
    def serial_number(self, serial_number):
        """Sets the serial_number of this ClusterNodeHardware.

        Serial number of this node.  # noqa: E501

        :param serial_number: The serial_number of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if serial_number is not None and len(serial_number) > 255:
            raise ValueError("Invalid value for `serial_number`, length must be less than or equal to `255`")  # noqa: E501
        if serial_number is not None and len(serial_number) < 0:
            raise ValueError("Invalid value for `serial_number`, length must be greater than or equal to `0`")  # noqa: E501

        self._serial_number = serial_number

    @property
    def series(self):
        """Gets the series of this ClusterNodeHardware.  # noqa: E501

        Series of this node (X, I, NL, etc.).  # noqa: E501

        :return: The series of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._series

    @series.setter
    def series(self, series):
        """Sets the series of this ClusterNodeHardware.

        Series of this node (X, I, NL, etc.).  # noqa: E501

        :param series: The series of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if series is not None and len(series) > 255:
            raise ValueError("Invalid value for `series`, length must be less than or equal to `255`")  # noqa: E501
        if series is not None and len(series) < 0:
            raise ValueError("Invalid value for `series`, length must be greater than or equal to `0`")  # noqa: E501

        self._series = series

    @property
    def sled_drive_count(self):
        """Gets the sled_drive_count of this ClusterNodeHardware.  # noqa: E501

        Size of drive sleds in node, if applicable. Expected values: 3, 4, 6. 0 if unable to determine sled size. -1 for error or not supported. If PSI_Get fails: -1. PSI_Get can fail if PSI not initialized, or key does not exist.  # noqa: E501

        :return: The sled_drive_count of this ClusterNodeHardware.  # noqa: E501
        :rtype: int
        """
        return self._sled_drive_count

    @sled_drive_count.setter
    def sled_drive_count(self, sled_drive_count):
        """Sets the sled_drive_count of this ClusterNodeHardware.

        Size of drive sleds in node, if applicable. Expected values: 3, 4, 6. 0 if unable to determine sled size. -1 for error or not supported. If PSI_Get fails: -1. PSI_Get can fail if PSI not initialized, or key does not exist.  # noqa: E501

        :param sled_drive_count: The sled_drive_count of this ClusterNodeHardware.  # noqa: E501
        :type: int
        """
        if sled_drive_count is not None and sled_drive_count > 6:  # noqa: E501
            raise ValueError("Invalid value for `sled_drive_count`, must be a value less than or equal to `6`")  # noqa: E501
        if sled_drive_count is not None and sled_drive_count < -1:  # noqa: E501
            raise ValueError("Invalid value for `sled_drive_count`, must be a value greater than or equal to `-1`")  # noqa: E501

        self._sled_drive_count = sled_drive_count

    @property
    def storage_class(self):
        """Gets the storage_class of this ClusterNodeHardware.  # noqa: E501

        Storage class of this node (storage or diskless).  # noqa: E501

        :return: The storage_class of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._storage_class

    @storage_class.setter
    def storage_class(self, storage_class):
        """Sets the storage_class of this ClusterNodeHardware.

        Storage class of this node (storage or diskless).  # noqa: E501

        :param storage_class: The storage_class of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if storage_class is not None and len(storage_class) > 255:
            raise ValueError("Invalid value for `storage_class`, length must be less than or equal to `255`")  # noqa: E501
        if storage_class is not None and len(storage_class) < 0:
            raise ValueError("Invalid value for `storage_class`, length must be greater than or equal to `0`")  # noqa: E501

        self._storage_class = storage_class

    @property
    def tier(self):
        """Gets the tier of this ClusterNodeHardware.  # noqa: E501

        Platform tier level of this node if applicable(positive for a defined tier, 0 for unknown or not supported, -1 for error).  # noqa: E501

        :return: The tier of this ClusterNodeHardware.  # noqa: E501
        :rtype: int
        """
        return self._tier

    @tier.setter
    def tier(self, tier):
        """Sets the tier of this ClusterNodeHardware.

        Platform tier level of this node if applicable(positive for a defined tier, 0 for unknown or not supported, -1 for error).  # noqa: E501

        :param tier: The tier of this ClusterNodeHardware.  # noqa: E501
        :type: int
        """
        if tier is not None and tier > 2147483647:  # noqa: E501
            raise ValueError("Invalid value for `tier`, must be a value less than or equal to `2147483647`")  # noqa: E501
        if tier is not None and tier < -1:  # noqa: E501
            raise ValueError("Invalid value for `tier`, must be a value greater than or equal to `-1`")  # noqa: E501

        self._tier = tier

    @property
    def top_level_assembly_serial_number(self):
        """Gets the top_level_assembly_serial_number of this ClusterNodeHardware.  # noqa: E501

        Serial number of the top level assembly of this node.(Infinity Only)  # noqa: E501

        :return: The top_level_assembly_serial_number of this ClusterNodeHardware.  # noqa: E501
        :rtype: str
        """
        return self._top_level_assembly_serial_number

    @top_level_assembly_serial_number.setter
    def top_level_assembly_serial_number(self, top_level_assembly_serial_number):
        """Sets the top_level_assembly_serial_number of this ClusterNodeHardware.

        Serial number of the top level assembly of this node.(Infinity Only)  # noqa: E501

        :param top_level_assembly_serial_number: The top_level_assembly_serial_number of this ClusterNodeHardware.  # noqa: E501
        :type: str
        """
        if top_level_assembly_serial_number is None:
            raise ValueError("Invalid value for `top_level_assembly_serial_number`, must not be `None`")  # noqa: E501
        if top_level_assembly_serial_number is not None and len(top_level_assembly_serial_number) > 255:
            raise ValueError("Invalid value for `top_level_assembly_serial_number`, length must be less than or equal to `255`")  # noqa: E501
        if top_level_assembly_serial_number is not None and len(top_level_assembly_serial_number) < 0:
            raise ValueError("Invalid value for `top_level_assembly_serial_number`, length must be greater than or equal to `0`")  # noqa: E501

        self._top_level_assembly_serial_number = top_level_assembly_serial_number

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterNodeHardware):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
