# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class AdsProviderSearchItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'domain': 'str',
        'filter': 'str',
        'limit': 'int',
        'password': 'str',
        'resume': 'str',
        'search_groups': 'bool',
        'search_users': 'bool',
        'user': 'str'
    }

    attribute_map = {
        'description': 'description',
        'domain': 'domain',
        'filter': 'filter',
        'limit': 'limit',
        'password': 'password',
        'resume': 'resume',
        'search_groups': 'search_groups',
        'search_users': 'search_users',
        'user': 'user'
    }

    def __init__(self, description=None, domain=None, filter=None, limit=None, password=None, resume=None, search_groups=None, search_users=None, user=None):  # noqa: E501
        """AdsProviderSearchItem - a model defined in Swagger"""  # noqa: E501

        self._description = None
        self._domain = None
        self._filter = None
        self._limit = None
        self._password = None
        self._resume = None
        self._search_groups = None
        self._search_users = None
        self._user = None
        self.discriminator = None

        if description is not None:
            self.description = description
        if domain is not None:
            self.domain = domain
        if filter is not None:
            self.filter = filter
        if limit is not None:
            self.limit = limit
        if password is not None:
            self.password = password
        if resume is not None:
            self.resume = resume
        if search_groups is not None:
            self.search_groups = search_groups
        if search_users is not None:
            self.search_users = search_users
        if user is not None:
            self.user = user

    @property
    def description(self):
        """Gets the description of this AdsProviderSearchItem.  # noqa: E501

        The user or group description to search for.  # noqa: E501

        :return: The description of this AdsProviderSearchItem.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AdsProviderSearchItem.

        The user or group description to search for.  # noqa: E501

        :param description: The description of this AdsProviderSearchItem.  # noqa: E501
        :type: str
        """
        if description is not None and len(description) > 255:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `255`")  # noqa: E501
        if description is not None and len(description) < 0:
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def domain(self):
        """Gets the domain of this AdsProviderSearchItem.  # noqa: E501

        The Active Directory provider name to search for.  # noqa: E501

        :return: The domain of this AdsProviderSearchItem.  # noqa: E501
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """Sets the domain of this AdsProviderSearchItem.

        The Active Directory provider name to search for.  # noqa: E501

        :param domain: The domain of this AdsProviderSearchItem.  # noqa: E501
        :type: str
        """
        if domain is not None and len(domain) > 255:
            raise ValueError("Invalid value for `domain`, length must be less than or equal to `255`")  # noqa: E501
        if domain is not None and len(domain) < 0:
            raise ValueError("Invalid value for `domain`, length must be greater than or equal to `0`")  # noqa: E501

        self._domain = domain

    @property
    def filter(self):
        """Gets the filter of this AdsProviderSearchItem.  # noqa: E501

        The LDAP filter to apply to the search.  # noqa: E501

        :return: The filter of this AdsProviderSearchItem.  # noqa: E501
        :rtype: str
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """Sets the filter of this AdsProviderSearchItem.

        The LDAP filter to apply to the search.  # noqa: E501

        :param filter: The filter of this AdsProviderSearchItem.  # noqa: E501
        :type: str
        """
        if filter is not None and len(filter) > 255:
            raise ValueError("Invalid value for `filter`, length must be less than or equal to `255`")  # noqa: E501
        if filter is not None and len(filter) < 0:
            raise ValueError("Invalid value for `filter`, length must be greater than or equal to `0`")  # noqa: E501

        self._filter = filter

    @property
    def limit(self):
        """Gets the limit of this AdsProviderSearchItem.  # noqa: E501

        Return no more than this many results at once (see resume).  # noqa: E501

        :return: The limit of this AdsProviderSearchItem.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this AdsProviderSearchItem.

        Return no more than this many results at once (see resume).  # noqa: E501

        :param limit: The limit of this AdsProviderSearchItem.  # noqa: E501
        :type: int
        """
        if limit is not None and limit > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if limit is not None and limit < 1:  # noqa: E501
            raise ValueError("Invalid value for `limit`, must be a value greater than or equal to `1`")  # noqa: E501

        self._limit = limit

    @property
    def password(self):
        """Gets the password of this AdsProviderSearchItem.  # noqa: E501

        The password for the domain if untrusted.  # noqa: E501

        :return: The password of this AdsProviderSearchItem.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this AdsProviderSearchItem.

        The password for the domain if untrusted.  # noqa: E501

        :param password: The password of this AdsProviderSearchItem.  # noqa: E501
        :type: str
        """
        if password is not None and len(password) > 255:
            raise ValueError("Invalid value for `password`, length must be less than or equal to `255`")  # noqa: E501
        if password is not None and len(password) < 0:
            raise ValueError("Invalid value for `password`, length must be greater than or equal to `0`")  # noqa: E501

        self._password = password

    @property
    def resume(self):
        """Gets the resume of this AdsProviderSearchItem.  # noqa: E501

        Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).  # noqa: E501

        :return: The resume of this AdsProviderSearchItem.  # noqa: E501
        :rtype: str
        """
        return self._resume

    @resume.setter
    def resume(self, resume):
        """Sets the resume of this AdsProviderSearchItem.

        Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).  # noqa: E501

        :param resume: The resume of this AdsProviderSearchItem.  # noqa: E501
        :type: str
        """
        if resume is not None and len(resume) > 8192:
            raise ValueError("Invalid value for `resume`, length must be less than or equal to `8192`")  # noqa: E501
        if resume is not None and len(resume) < 0:
            raise ValueError("Invalid value for `resume`, length must be greater than or equal to `0`")  # noqa: E501

        self._resume = resume

    @property
    def search_groups(self):
        """Gets the search_groups of this AdsProviderSearchItem.  # noqa: E501

        If true, search for groups.  # noqa: E501

        :return: The search_groups of this AdsProviderSearchItem.  # noqa: E501
        :rtype: bool
        """
        return self._search_groups

    @search_groups.setter
    def search_groups(self, search_groups):
        """Sets the search_groups of this AdsProviderSearchItem.

        If true, search for groups.  # noqa: E501

        :param search_groups: The search_groups of this AdsProviderSearchItem.  # noqa: E501
        :type: bool
        """

        self._search_groups = search_groups

    @property
    def search_users(self):
        """Gets the search_users of this AdsProviderSearchItem.  # noqa: E501

        If true, search for users.  # noqa: E501

        :return: The search_users of this AdsProviderSearchItem.  # noqa: E501
        :rtype: bool
        """
        return self._search_users

    @search_users.setter
    def search_users(self, search_users):
        """Sets the search_users of this AdsProviderSearchItem.

        If true, search for users.  # noqa: E501

        :param search_users: The search_users of this AdsProviderSearchItem.  # noqa: E501
        :type: bool
        """

        self._search_users = search_users

    @property
    def user(self):
        """Gets the user of this AdsProviderSearchItem.  # noqa: E501

        The user name for the domain if untrusted.  # noqa: E501

        :return: The user of this AdsProviderSearchItem.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this AdsProviderSearchItem.

        The user name for the domain if untrusted.  # noqa: E501

        :param user: The user of this AdsProviderSearchItem.  # noqa: E501
        :type: str
        """
        if user is not None and len(user) > 255:
            raise ValueError("Invalid value for `user`, length must be less than or equal to `255`")  # noqa: E501
        if user is not None and len(user) < 0:
            raise ValueError("Invalid value for `user`, length must be greater than or equal to `0`")  # noqa: E501

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdsProviderSearchItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
