# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_4_0.api_client import ApiClient


class LocalApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_cluster_time(self, **kwargs):  # noqa: E501
        """get_cluster_time  # noqa: E501

        Get the current time on the local node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_time(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ClusterTimeExtendedExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_time_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_time_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cluster_time_with_http_info(self, **kwargs):  # noqa: E501
        """get_cluster_time  # noqa: E501

        Get the current time on the local node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_time_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ClusterTimeExtendedExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_time" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/local/cluster/time', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterTimeExtendedExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_network_interfaces(self, **kwargs):  # noqa: E501
        """get_network_interfaces  # noqa: E501

        Get a list of interfaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_interfaces(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cache: Control where interface data is source from. no-cache only returns live data from a running node, and if a node can't be reached, no results will be returned. cache-only only returns cached data, some fields are set as null/unknown if they can't be determined, and IPs listed are the IPs that should be configured. Finally, nodes-first will try to query live nodes, and fall back to the cache for any nodes that fail. Default: nodes-first
        :param str dir: The direction of the sort.
        :param bool include_vlans: If include_vlans is set to true, all vlans are returned unless further filtered by vlan_id. If include_vlans is set to false, no vlans are returned.
        :param int limit: Return no more than this many results at once (see resume).
        :param list[int] lnn: Get a list of interfaces for the specified lnns.
        :param str network: Show interfaces associated with external and/or internal networks. Default is 'external'
        :param str owner: Filter results by owner id. Support partials matches too. Ex owner=groupnet0 or owner=groupnet0.subnet0.pool0.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :param str type: Filter the returned IPs by IP type.
        :param int vlan_id: Only return IPs/interfaces configured in the specified VLAN ID
        :return: NetworkInterfaces
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_network_interfaces_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_network_interfaces_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_network_interfaces_with_http_info(self, **kwargs):  # noqa: E501
        """get_network_interfaces  # noqa: E501

        Get a list of interfaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_interfaces_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cache: Control where interface data is source from. no-cache only returns live data from a running node, and if a node can't be reached, no results will be returned. cache-only only returns cached data, some fields are set as null/unknown if they can't be determined, and IPs listed are the IPs that should be configured. Finally, nodes-first will try to query live nodes, and fall back to the cache for any nodes that fail. Default: nodes-first
        :param str dir: The direction of the sort.
        :param bool include_vlans: If include_vlans is set to true, all vlans are returned unless further filtered by vlan_id. If include_vlans is set to false, no vlans are returned.
        :param int limit: Return no more than this many results at once (see resume).
        :param list[int] lnn: Get a list of interfaces for the specified lnns.
        :param str network: Show interfaces associated with external and/or internal networks. Default is 'external'
        :param str owner: Filter results by owner id. Support partials matches too. Ex owner=groupnet0 or owner=groupnet0.subnet0.pool0.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :param str type: Filter the returned IPs by IP type.
        :param int vlan_id: Only return IPs/interfaces configured in the specified VLAN ID
        :return: NetworkInterfaces
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cache', 'dir', 'include_vlans', 'limit', 'lnn', 'network', 'owner', 'resume', 'sort', 'type', 'vlan_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_interfaces" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_network_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_interfaces`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_network_interfaces`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('owner' in params and
                len(params['owner']) > 99):
            raise ValueError("Invalid value for parameter `owner` when calling `get_network_interfaces`, length must be less than or equal to `99`")  # noqa: E501
        if ('owner' in params and
                len(params['owner']) < 1):
            raise ValueError("Invalid value for parameter `owner` when calling `get_network_interfaces`, length must be greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_interfaces`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_network_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_interfaces`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_network_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        if 'vlan_id' in params and params['vlan_id'] > 4094:  # noqa: E501
            raise ValueError("Invalid value for parameter `vlan_id` when calling `get_network_interfaces`, must be a value less than or equal to `4094`")  # noqa: E501
        if 'vlan_id' in params and params['vlan_id'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `vlan_id` when calling `get_network_interfaces`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'cache' in params:
            query_params.append(('cache', params['cache']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'include_vlans' in params:
            query_params.append(('include_vlans', params['include_vlans']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'lnn' in params:
            query_params.append(('lnn', params['lnn']))  # noqa: E501
            collection_formats['lnn'] = 'csv'  # noqa: E501
        if 'network' in params:
            query_params.append(('network', params['network']))  # noqa: E501
        if 'owner' in params:
            query_params.append(('owner', params['owner']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'vlan_id' in params:
            query_params.append(('vlan_id', params['vlan_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/14/local/network/interfaces', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NetworkInterfaces',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_protocols_smb_sessions(self, **kwargs):  # noqa: E501
        """get_protocols_smb_sessions  # noqa: E501

        List open SMB sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_protocols_smb_sessions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str lnn: The node to fetch open sessions from.
        :param str lnn_skip: When parameter lnn=all, don't fetch open session info from this node.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: ProtocolsSmbSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_protocols_smb_sessions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_protocols_smb_sessions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_protocols_smb_sessions_with_http_info(self, **kwargs):  # noqa: E501
        """get_protocols_smb_sessions  # noqa: E501

        List open SMB sessions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_protocols_smb_sessions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str lnn: The node to fetch open sessions from.
        :param str lnn_skip: When parameter lnn=all, don't fetch open session info from this node.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: ProtocolsSmbSessions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'lnn', 'lnn_skip', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_protocols_smb_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_protocols_smb_sessions`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_protocols_smb_sessions`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_protocols_smb_sessions`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_protocols_smb_sessions`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'lnn' in params:
            query_params.append(('lnn', params['lnn']))  # noqa: E501
        if 'lnn_skip' in params:
            query_params.append(('lnn_skip', params['lnn_skip']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/local/protocols/smb/sessions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProtocolsSmbSessions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_upgrade_cluster_firmware_device(self, **kwargs):  # noqa: E501
        """get_upgrade_cluster_firmware_device  # noqa: E501

        The firmware status for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_cluster_firmware_device(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool devices: Show devices. If false, this returns an empty list. Default is false.
        :param bool package: Show package. If false, this returns an empty list. Default is false.
        :param bool refresh: Re-gather firmware status. Default is false.
        :return: UpgradeClusterFirmwareDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_upgrade_cluster_firmware_device_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_upgrade_cluster_firmware_device_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_upgrade_cluster_firmware_device_with_http_info(self, **kwargs):  # noqa: E501
        """get_upgrade_cluster_firmware_device  # noqa: E501

        The firmware status for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_cluster_firmware_device_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool devices: Show devices. If false, this returns an empty list. Default is false.
        :param bool package: Show package. If false, this returns an empty list. Default is false.
        :param bool refresh: Re-gather firmware status. Default is false.
        :return: UpgradeClusterFirmwareDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['devices', 'package', 'refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upgrade_cluster_firmware_device" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'devices' in params:
            query_params.append(('devices', params['devices']))  # noqa: E501
        if 'package' in params:
            query_params.append(('package', params['package']))  # noqa: E501
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/local/upgrade/cluster/firmware/device', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpgradeClusterFirmwareDevice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_upgrade_cluster_firmware_status(self, **kwargs):  # noqa: E501
        """get_upgrade_cluster_firmware_status  # noqa: E501

        The firmware status for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_cluster_firmware_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool devices: Show devices. If false, this returns an empty list. Default is false.
        :param bool package: Show package. If false, this returns an empty list. Default is false.
        :param bool refresh: Re-gather firmware status. Default is false.
        :return: UpgradeClusterFirmwareDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_upgrade_cluster_firmware_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_upgrade_cluster_firmware_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_upgrade_cluster_firmware_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_upgrade_cluster_firmware_status  # noqa: E501

        The firmware status for the cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_upgrade_cluster_firmware_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool devices: Show devices. If false, this returns an empty list. Default is false.
        :param bool package: Show package. If false, this returns an empty list. Default is false.
        :param bool refresh: Re-gather firmware status. Default is false.
        :return: UpgradeClusterFirmwareDevice
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['devices', 'package', 'refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_upgrade_cluster_firmware_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'devices' in params:
            query_params.append(('devices', params['devices']))  # noqa: E501
        if 'package' in params:
            query_params.append(('package', params['package']))  # noqa: E501
        if 'refresh' in params:
            query_params.append(('refresh', params['refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/local/upgrade/cluster/firmware/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UpgradeClusterFirmwareDevice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
