# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_4_0.api_client import ApiClient


class KeymanagerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_kmip_server(self, kmip_server, **kwargs):  # noqa: E501
        """create_kmip_server  # noqa: E501

        Create a new KMIP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_kmip_server(kmip_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmipServerCreateParams kmip_server: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_kmip_server_with_http_info(kmip_server, **kwargs)  # noqa: E501
        else:
            (data) = self.create_kmip_server_with_http_info(kmip_server, **kwargs)  # noqa: E501
            return data

    def create_kmip_server_with_http_info(self, kmip_server, **kwargs):  # noqa: E501
        """create_kmip_server  # noqa: E501

        Create a new KMIP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_kmip_server_with_http_info(kmip_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmipServerCreateParams kmip_server: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kmip_server']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_kmip_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kmip_server' is set
        if ('kmip_server' not in params or
                params['kmip_server'] is None):
            raise ValueError("Missing the required parameter `kmip_server` when calling `create_kmip_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'kmip_server' in params:
            body_params = params['kmip_server']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/kmip/servers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_kmip_server_verify_item(self, kmip_server_verify_item, **kwargs):  # noqa: E501
        """create_kmip_server_verify_item  # noqa: E501

        Verify KMIP configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_kmip_server_verify_item(kmip_server_verify_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmipServerVerifyItem kmip_server_verify_item: (required)
        :return: CreateKmipServerVerifyItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_kmip_server_verify_item_with_http_info(kmip_server_verify_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_kmip_server_verify_item_with_http_info(kmip_server_verify_item, **kwargs)  # noqa: E501
            return data

    def create_kmip_server_verify_item_with_http_info(self, kmip_server_verify_item, **kwargs):  # noqa: E501
        """create_kmip_server_verify_item  # noqa: E501

        Verify KMIP configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_kmip_server_verify_item_with_http_info(kmip_server_verify_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmipServerVerifyItem kmip_server_verify_item: (required)
        :return: CreateKmipServerVerifyItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kmip_server_verify_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_kmip_server_verify_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kmip_server_verify_item' is set
        if ('kmip_server_verify_item' not in params or
                params['kmip_server_verify_item'] is None):
            raise ValueError("Missing the required parameter `kmip_server_verify_item` when calling `create_kmip_server_verify_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'kmip_server_verify_item' in params:
            body_params = params['kmip_server_verify_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/kmip/server/verify', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateKmipServerVerifyItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_sed_migrate_item(self, sed_migrate_item, **kwargs):  # noqa: E501
        """create_sed_migrate_item  # noqa: E501

        Indicates the direction of the migration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sed_migrate_item(sed_migrate_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SedMigrateItem sed_migrate_item: (required)
        :return: CreateSedMigrateItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_sed_migrate_item_with_http_info(sed_migrate_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sed_migrate_item_with_http_info(sed_migrate_item, **kwargs)  # noqa: E501
            return data

    def create_sed_migrate_item_with_http_info(self, sed_migrate_item, **kwargs):  # noqa: E501
        """create_sed_migrate_item  # noqa: E501

        Indicates the direction of the migration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sed_migrate_item_with_http_info(sed_migrate_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SedMigrateItem sed_migrate_item: (required)
        :return: CreateSedMigrateItemResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sed_migrate_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sed_migrate_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sed_migrate_item' is set
        if ('sed_migrate_item' not in params or
                params['sed_migrate_item'] is None):
            raise ValueError("Missing the required parameter `sed_migrate_item` when calling `create_sed_migrate_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sed_migrate_item' in params:
            body_params = params['sed_migrate_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/sed/migrate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateSedMigrateItemResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_kmip_server(self, kmip_server_id, **kwargs):  # noqa: E501
        """delete_kmip_server  # noqa: E501

        Delete a KMIP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_kmip_server(kmip_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str kmip_server_id: Delete a KMIP server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_kmip_server_with_http_info(kmip_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_kmip_server_with_http_info(kmip_server_id, **kwargs)  # noqa: E501
            return data

    def delete_kmip_server_with_http_info(self, kmip_server_id, **kwargs):  # noqa: E501
        """delete_kmip_server  # noqa: E501

        Delete a KMIP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_kmip_server_with_http_info(kmip_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str kmip_server_id: Delete a KMIP server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kmip_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_kmip_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kmip_server_id' is set
        if ('kmip_server_id' not in params or
                params['kmip_server_id'] is None):
            raise ValueError("Missing the required parameter `kmip_server_id` when calling `delete_kmip_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kmip_server_id' in params:
            path_params['KmipServerId'] = params['kmip_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/kmip/servers/{KmipServerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kmip_server(self, kmip_server_id, **kwargs):  # noqa: E501
        """get_kmip_server  # noqa: E501

        Retrieve a specific KMIP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kmip_server(kmip_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str kmip_server_id: Retrieve a specific KMIP server entry. (required)
        :return: KmipServers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kmip_server_with_http_info(kmip_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kmip_server_with_http_info(kmip_server_id, **kwargs)  # noqa: E501
            return data

    def get_kmip_server_with_http_info(self, kmip_server_id, **kwargs):  # noqa: E501
        """get_kmip_server  # noqa: E501

        Retrieve a specific KMIP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kmip_server_with_http_info(kmip_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str kmip_server_id: Retrieve a specific KMIP server entry. (required)
        :return: KmipServers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kmip_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kmip_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kmip_server_id' is set
        if ('kmip_server_id' not in params or
                params['kmip_server_id'] is None):
            raise ValueError("Missing the required parameter `kmip_server_id` when calling `get_kmip_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kmip_server_id' in params:
            path_params['KmipServerId'] = params['kmip_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/kmip/servers/{KmipServerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KmipServers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sed_settings(self, **kwargs):  # noqa: E501
        """get_sed_settings  # noqa: E501

        Retrieve Current SED settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sed_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SedSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sed_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sed_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sed_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_sed_settings  # noqa: E501

        Retrieve Current SED settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sed_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SedSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sed_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/sed/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SedSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sed_status(self, **kwargs):  # noqa: E501
        """get_sed_status  # noqa: E501

        Retrieve SED status on all nodes in this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sed_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SedStatusExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sed_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sed_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sed_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_sed_status  # noqa: E501

        Retrieve SED status on all nodes in this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sed_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SedStatusExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sed_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/sed/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SedStatusExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sed_status_lnn(self, sed_status_lnn, **kwargs):  # noqa: E501
        """get_sed_status_lnn  # noqa: E501

        Retrieve SED status on a node in this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sed_status_lnn(sed_status_lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sed_status_lnn: Retrieve SED status on a node in this cluster. (required)
        :return: SedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sed_status_lnn_with_http_info(sed_status_lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sed_status_lnn_with_http_info(sed_status_lnn, **kwargs)  # noqa: E501
            return data

    def get_sed_status_lnn_with_http_info(self, sed_status_lnn, **kwargs):  # noqa: E501
        """get_sed_status_lnn  # noqa: E501

        Retrieve SED status on a node in this cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sed_status_lnn_with_http_info(sed_status_lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int sed_status_lnn: Retrieve SED status on a node in this cluster. (required)
        :return: SedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sed_status_lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sed_status_lnn" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sed_status_lnn' is set
        if ('sed_status_lnn' not in params or
                params['sed_status_lnn'] is None):
            raise ValueError("Missing the required parameter `sed_status_lnn` when calling `get_sed_status_lnn`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'sed_status_lnn' in params:
            path_params['SedStatusLnn'] = params['sed_status_lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/sed/status/{SedStatusLnn}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SedStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_kmip_servers(self, **kwargs):  # noqa: E501
        """list_kmip_servers  # noqa: E501

        Retrieve a list of configured KMIP server entries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_kmip_servers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: KmipServersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_kmip_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_kmip_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_kmip_servers_with_http_info(self, **kwargs):  # noqa: E501
        """list_kmip_servers  # noqa: E501

        Retrieve a list of configured KMIP server entries.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_kmip_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: KmipServersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_kmip_servers" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_kmip_servers`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_kmip_servers`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_kmip_servers`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_kmip_servers`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_kmip_servers`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_kmip_servers`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_kmip_servers`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/kmip/servers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KmipServersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_kmip_server(self, kmip_server, kmip_server_id, **kwargs):  # noqa: E501
        """update_kmip_server  # noqa: E501

        Modify a KMIP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_kmip_server(kmip_server, kmip_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmipServer kmip_server: (required)
        :param str kmip_server_id: Modify a KMIP server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_kmip_server_with_http_info(kmip_server, kmip_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_kmip_server_with_http_info(kmip_server, kmip_server_id, **kwargs)  # noqa: E501
            return data

    def update_kmip_server_with_http_info(self, kmip_server, kmip_server_id, **kwargs):  # noqa: E501
        """update_kmip_server  # noqa: E501

        Modify a KMIP server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_kmip_server_with_http_info(kmip_server, kmip_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param KmipServer kmip_server: (required)
        :param str kmip_server_id: Modify a KMIP server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['kmip_server', 'kmip_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_kmip_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'kmip_server' is set
        if ('kmip_server' not in params or
                params['kmip_server'] is None):
            raise ValueError("Missing the required parameter `kmip_server` when calling `update_kmip_server`")  # noqa: E501
        # verify the required parameter 'kmip_server_id' is set
        if ('kmip_server_id' not in params or
                params['kmip_server_id'] is None):
            raise ValueError("Missing the required parameter `kmip_server_id` when calling `update_kmip_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kmip_server_id' in params:
            path_params['KmipServerId'] = params['kmip_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'kmip_server' in params:
            body_params = params['kmip_server']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/kmip/servers/{KmipServerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sed_settings(self, sed_settings, **kwargs):  # noqa: E501
        """update_sed_settings  # noqa: E501

        Modify SED settings to allow migration, or forbid it and retrieve all keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sed_settings(sed_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SedSettingsExtended sed_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sed_settings_with_http_info(sed_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sed_settings_with_http_info(sed_settings, **kwargs)  # noqa: E501
            return data

    def update_sed_settings_with_http_info(self, sed_settings, **kwargs):  # noqa: E501
        """update_sed_settings  # noqa: E501

        Modify SED settings to allow migration, or forbid it and retrieve all keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sed_settings_with_http_info(sed_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SedSettingsExtended sed_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sed_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sed_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'sed_settings' is set
        if ('sed_settings' not in params or
                params['sed_settings'] is None):
            raise ValueError("Missing the required parameter `sed_settings` when calling `update_sed_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'sed_settings' in params:
            body_params = params['sed_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/keymanager/sed/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
