# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_4_0.api_client import ApiClient


class DatamoverApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_certificates_ca_item(self, certificates_ca_item, **kwargs):  # noqa: E501
        """create_certificates_ca_item  # noqa: E501

        Import a trusted Datamover TLS CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_ca_item(certificates_ca_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificatesCaItem certificates_ca_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_certificates_ca_item_with_http_info(certificates_ca_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_certificates_ca_item_with_http_info(certificates_ca_item, **kwargs)  # noqa: E501
            return data

    def create_certificates_ca_item_with_http_info(self, certificates_ca_item, **kwargs):  # noqa: E501
        """create_certificates_ca_item  # noqa: E501

        Import a trusted Datamover TLS CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_ca_item_with_http_info(certificates_ca_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificatesCaItem certificates_ca_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_ca_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_certificates_ca_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_ca_item' is set
        if ('certificates_ca_item' not in params or
                params['certificates_ca_item'] is None):
            raise ValueError("Missing the required parameter `certificates_ca_item` when calling `create_certificates_ca_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificates_ca_item' in params:
            body_params = params['certificates_ca_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/ca', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_certificates_identity_item(self, certificates_identity_item, **kwargs):  # noqa: E501
        """create_certificates_identity_item  # noqa: E501

        Import a trusted Datamover TLS Identity certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_identity_item(certificates_identity_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificatesIdentityItem certificates_identity_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_certificates_identity_item_with_http_info(certificates_identity_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_certificates_identity_item_with_http_info(certificates_identity_item, **kwargs)  # noqa: E501
            return data

    def create_certificates_identity_item_with_http_info(self, certificates_identity_item, **kwargs):  # noqa: E501
        """create_certificates_identity_item  # noqa: E501

        Import a trusted Datamover TLS Identity certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_certificates_identity_item_with_http_info(certificates_identity_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificatesIdentityItem certificates_identity_item: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_identity_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_certificates_identity_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_identity_item' is set
        if ('certificates_identity_item' not in params or
                params['certificates_identity_item'] is None):
            raise ValueError("Missing the required parameter `certificates_identity_item` when calling `create_certificates_identity_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificates_identity_item' in params:
            body_params = params['certificates_identity_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/identity', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_datamover_account(self, datamover_account, **kwargs):  # noqa: E501
        """create_datamover_account  # noqa: E501

        Create a new account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_datamover_account(datamover_account, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverAccountCreateParams datamover_account: (required)
        :return: CreateDatamoverAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_datamover_account_with_http_info(datamover_account, **kwargs)  # noqa: E501
        else:
            (data) = self.create_datamover_account_with_http_info(datamover_account, **kwargs)  # noqa: E501
            return data

    def create_datamover_account_with_http_info(self, datamover_account, **kwargs):  # noqa: E501
        """create_datamover_account  # noqa: E501

        Create a new account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_datamover_account_with_http_info(datamover_account, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverAccountCreateParams datamover_account: (required)
        :return: CreateDatamoverAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_account']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_datamover_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_account' is set
        if ('datamover_account' not in params or
                params['datamover_account'] is None):
            raise ValueError("Missing the required parameter `datamover_account` when calling `create_datamover_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'datamover_account' in params:
            body_params = params['datamover_account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/accounts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateDatamoverAccountResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_datamover_base_policy(self, datamover_base_policy, **kwargs):  # noqa: E501
        """create_datamover_base_policy  # noqa: E501

        Create a new Data Mover base policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_datamover_base_policy(datamover_base_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverBasePolicyCreateParams datamover_base_policy: (required)
        :return: CreateDatamoverBasePolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_datamover_base_policy_with_http_info(datamover_base_policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_datamover_base_policy_with_http_info(datamover_base_policy, **kwargs)  # noqa: E501
            return data

    def create_datamover_base_policy_with_http_info(self, datamover_base_policy, **kwargs):  # noqa: E501
        """create_datamover_base_policy  # noqa: E501

        Create a new Data Mover base policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_datamover_base_policy_with_http_info(datamover_base_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverBasePolicyCreateParams datamover_base_policy: (required)
        :return: CreateDatamoverBasePolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_base_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_datamover_base_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_base_policy' is set
        if ('datamover_base_policy' not in params or
                params['datamover_base_policy'] is None):
            raise ValueError("Missing the required parameter `datamover_base_policy` when calling `create_datamover_base_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'datamover_base_policy' in params:
            body_params = params['datamover_base_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/base-policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateDatamoverBasePolicyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_datamover_policy(self, datamover_policy, **kwargs):  # noqa: E501
        """create_datamover_policy  # noqa: E501

        Create a new datamover policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_datamover_policy(datamover_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverPolicyCreateParams datamover_policy: (required)
        :return: CreateDatamoverBasePolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_datamover_policy_with_http_info(datamover_policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_datamover_policy_with_http_info(datamover_policy, **kwargs)  # noqa: E501
            return data

    def create_datamover_policy_with_http_info(self, datamover_policy, **kwargs):  # noqa: E501
        """create_datamover_policy  # noqa: E501

        Create a new datamover policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_datamover_policy_with_http_info(datamover_policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverPolicyCreateParams datamover_policy: (required)
        :return: CreateDatamoverBasePolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_policy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_datamover_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_policy' is set
        if ('datamover_policy' not in params or
                params['datamover_policy'] is None):
            raise ValueError("Missing the required parameter `datamover_policy` when calling `create_datamover_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'datamover_policy' in params:
            body_params = params['datamover_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateDatamoverBasePolicyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_throttling_bw_rule(self, throttling_bw_rule, **kwargs):  # noqa: E501
        """create_throttling_bw_rule  # noqa: E501

        Create a new bandwidth throttling rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_throttling_bw_rule(throttling_bw_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThrottlingBwRuleCreateParams throttling_bw_rule: (required)
        :return: CreateThrottlingBwRuleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_throttling_bw_rule_with_http_info(throttling_bw_rule, **kwargs)  # noqa: E501
        else:
            (data) = self.create_throttling_bw_rule_with_http_info(throttling_bw_rule, **kwargs)  # noqa: E501
            return data

    def create_throttling_bw_rule_with_http_info(self, throttling_bw_rule, **kwargs):  # noqa: E501
        """create_throttling_bw_rule  # noqa: E501

        Create a new bandwidth throttling rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_throttling_bw_rule_with_http_info(throttling_bw_rule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThrottlingBwRuleCreateParams throttling_bw_rule: (required)
        :return: CreateThrottlingBwRuleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['throttling_bw_rule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_throttling_bw_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'throttling_bw_rule' is set
        if ('throttling_bw_rule' not in params or
                params['throttling_bw_rule'] is None):
            raise ValueError("Missing the required parameter `throttling_bw_rule` when calling `create_throttling_bw_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'throttling_bw_rule' in params:
            body_params = params['throttling_bw_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/throttling/bw-rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateThrottlingBwRuleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_certificates_ca_by_id(self, certificates_ca_id, **kwargs):  # noqa: E501
        """delete_certificates_ca_by_id  # noqa: E501

        Delete a trusted Datamover TLS CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificates_ca_by_id(certificates_ca_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_ca_id: Delete a trusted Datamover TLS CA certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_certificates_ca_by_id_with_http_info(certificates_ca_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_certificates_ca_by_id_with_http_info(certificates_ca_id, **kwargs)  # noqa: E501
            return data

    def delete_certificates_ca_by_id_with_http_info(self, certificates_ca_id, **kwargs):  # noqa: E501
        """delete_certificates_ca_by_id  # noqa: E501

        Delete a trusted Datamover TLS CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificates_ca_by_id_with_http_info(certificates_ca_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_ca_id: Delete a trusted Datamover TLS CA certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_ca_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_certificates_ca_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_ca_id' is set
        if ('certificates_ca_id' not in params or
                params['certificates_ca_id'] is None):
            raise ValueError("Missing the required parameter `certificates_ca_id` when calling `delete_certificates_ca_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_ca_id' in params:
            path_params['CertificatesCaId'] = params['certificates_ca_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/ca/{CertificatesCaId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_certificates_identity_by_id(self, certificates_identity_id, **kwargs):  # noqa: E501
        """delete_certificates_identity_by_id  # noqa: E501

        Delete a trusted Datamover TLS Identity certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificates_identity_by_id(certificates_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_identity_id: Delete a trusted Datamover TLS Identity certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_certificates_identity_by_id_with_http_info(certificates_identity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_certificates_identity_by_id_with_http_info(certificates_identity_id, **kwargs)  # noqa: E501
            return data

    def delete_certificates_identity_by_id_with_http_info(self, certificates_identity_id, **kwargs):  # noqa: E501
        """delete_certificates_identity_by_id  # noqa: E501

        Delete a trusted Datamover TLS Identity certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_certificates_identity_by_id_with_http_info(certificates_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_identity_id: Delete a trusted Datamover TLS Identity certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_identity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_certificates_identity_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_identity_id' is set
        if ('certificates_identity_id' not in params or
                params['certificates_identity_id'] is None):
            raise ValueError("Missing the required parameter `certificates_identity_id` when calling `delete_certificates_identity_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_identity_id' in params:
            path_params['CertificatesIdentityId'] = params['certificates_identity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/identity/{CertificatesIdentityId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_datamover_account(self, datamover_account_id, **kwargs):  # noqa: E501
        """delete_datamover_account  # noqa: E501

        Delete the account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datamover_account(datamover_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_account_id: Delete the account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_datamover_account_with_http_info(datamover_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_datamover_account_with_http_info(datamover_account_id, **kwargs)  # noqa: E501
            return data

    def delete_datamover_account_with_http_info(self, datamover_account_id, **kwargs):  # noqa: E501
        """delete_datamover_account  # noqa: E501

        Delete the account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datamover_account_with_http_info(datamover_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_account_id: Delete the account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_datamover_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_account_id' is set
        if ('datamover_account_id' not in params or
                params['datamover_account_id'] is None):
            raise ValueError("Missing the required parameter `datamover_account_id` when calling `delete_datamover_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_account_id' in params:
            path_params['DatamoverAccountId'] = params['datamover_account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/accounts/{DatamoverAccountId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_datamover_base_policy(self, datamover_base_policy_id, **kwargs):  # noqa: E501
        """delete_datamover_base_policy  # noqa: E501

        Delete the base policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datamover_base_policy(datamover_base_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_base_policy_id: Delete the base policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_datamover_base_policy_with_http_info(datamover_base_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_datamover_base_policy_with_http_info(datamover_base_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_datamover_base_policy_with_http_info(self, datamover_base_policy_id, **kwargs):  # noqa: E501
        """delete_datamover_base_policy  # noqa: E501

        Delete the base policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datamover_base_policy_with_http_info(datamover_base_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_base_policy_id: Delete the base policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_base_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_datamover_base_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_base_policy_id' is set
        if ('datamover_base_policy_id' not in params or
                params['datamover_base_policy_id'] is None):
            raise ValueError("Missing the required parameter `datamover_base_policy_id` when calling `delete_datamover_base_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_base_policy_id' in params:
            path_params['DatamoverBasePolicyId'] = params['datamover_base_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/base-policies/{DatamoverBasePolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_datamover_historical_jobs(self, **kwargs):  # noqa: E501
        """delete_datamover_historical_jobs  # noqa: E501

        List/Delete finished jobs based on their end time. Capped at 1000. If 'after-time' is specified, latest 1000 jobs ended after this time will be listed/deleted. If 'after-time' is not specified, latest 1000 jobs finished in last 24 hours will be listed/deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datamover_historical_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str after_time: The time in '%Y-%m-%d %H:%M:%S' format. The year range is 2001-2099.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_datamover_historical_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_datamover_historical_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_datamover_historical_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """delete_datamover_historical_jobs  # noqa: E501

        List/Delete finished jobs based on their end time. Capped at 1000. If 'after-time' is specified, latest 1000 jobs ended after this time will be listed/deleted. If 'after-time' is not specified, latest 1000 jobs finished in last 24 hours will be listed/deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datamover_historical_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str after_time: The time in '%Y-%m-%d %H:%M:%S' format. The year range is 2001-2099.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['after_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_datamover_historical_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if ('after_time' in params and
                len(params['after_time']) > 19):
            raise ValueError("Invalid value for parameter `after_time` when calling `delete_datamover_historical_jobs`, length must be less than or equal to `19`")  # noqa: E501
        if ('after_time' in params and
                len(params['after_time']) < 14):
            raise ValueError("Invalid value for parameter `after_time` when calling `delete_datamover_historical_jobs`, length must be greater than or equal to `14`")  # noqa: E501
        if 'after_time' in params and not re.search('20[0-9][0-9]-1[0-2]|[1-9]-3[01]|[12][0-9]|0?[1-9] 2[0-3]|1[0-9]|0?[0-9]:[0-5]?[0-9]:[0-5]?[0-9]', params['after_time']):  # noqa: E501
            raise ValueError("Invalid value for parameter `after_time` when calling `delete_datamover_historical_jobs`, must conform to the pattern `/20[0-9][0-9]-1[0-2]|[1-9]-3[01]|[12][0-9]|0?[1-9] 2[0-3]|1[0-9]|0?[0-9]:[0-5]?[0-9]:[0-5]?[0-9]/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'after_time' in params:
            query_params.append(('after_time', params['after_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/historical-jobs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_datamover_policy(self, datamover_policy_id, **kwargs):  # noqa: E501
        """delete_datamover_policy  # noqa: E501

        Delete the policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datamover_policy(datamover_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_policy_id: Delete the policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_datamover_policy_with_http_info(datamover_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_datamover_policy_with_http_info(datamover_policy_id, **kwargs)  # noqa: E501
            return data

    def delete_datamover_policy_with_http_info(self, datamover_policy_id, **kwargs):  # noqa: E501
        """delete_datamover_policy  # noqa: E501

        Delete the policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_datamover_policy_with_http_info(datamover_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_policy_id: Delete the policy. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_datamover_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_policy_id' is set
        if ('datamover_policy_id' not in params or
                params['datamover_policy_id'] is None):
            raise ValueError("Missing the required parameter `datamover_policy_id` when calling `delete_datamover_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_policy_id' in params:
            path_params['DatamoverPolicyId'] = params['datamover_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/policies/{DatamoverPolicyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_throttling_bw_rule(self, throttling_bw_rule_id, **kwargs):  # noqa: E501
        """delete_throttling_bw_rule  # noqa: E501

        Delete a bandwidth throttling rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_throttling_bw_rule(throttling_bw_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str throttling_bw_rule_id: Delete a bandwidth throttling rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_throttling_bw_rule_with_http_info(throttling_bw_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_throttling_bw_rule_with_http_info(throttling_bw_rule_id, **kwargs)  # noqa: E501
            return data

    def delete_throttling_bw_rule_with_http_info(self, throttling_bw_rule_id, **kwargs):  # noqa: E501
        """delete_throttling_bw_rule  # noqa: E501

        Delete a bandwidth throttling rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_throttling_bw_rule_with_http_info(throttling_bw_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str throttling_bw_rule_id: Delete a bandwidth throttling rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['throttling_bw_rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_throttling_bw_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'throttling_bw_rule_id' is set
        if ('throttling_bw_rule_id' not in params or
                params['throttling_bw_rule_id'] is None):
            raise ValueError("Missing the required parameter `throttling_bw_rule_id` when calling `delete_throttling_bw_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'throttling_bw_rule_id' in params:
            path_params['ThrottlingBwRuleId'] = params['throttling_bw_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/throttling/bw-rules/{ThrottlingBwRuleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_certificates_ca_by_id(self, certificates_ca_id, **kwargs):  # noqa: E501
        """get_certificates_ca_by_id  # noqa: E501

        Retrieve a single trusted Datamover TLS CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_ca_by_id(certificates_ca_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_ca_id: Retrieve a single trusted Datamover TLS CA certificate. (required)
        :return: CertificatesCa
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_certificates_ca_by_id_with_http_info(certificates_ca_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_certificates_ca_by_id_with_http_info(certificates_ca_id, **kwargs)  # noqa: E501
            return data

    def get_certificates_ca_by_id_with_http_info(self, certificates_ca_id, **kwargs):  # noqa: E501
        """get_certificates_ca_by_id  # noqa: E501

        Retrieve a single trusted Datamover TLS CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_ca_by_id_with_http_info(certificates_ca_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_ca_id: Retrieve a single trusted Datamover TLS CA certificate. (required)
        :return: CertificatesCa
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_ca_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_certificates_ca_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_ca_id' is set
        if ('certificates_ca_id' not in params or
                params['certificates_ca_id'] is None):
            raise ValueError("Missing the required parameter `certificates_ca_id` when calling `get_certificates_ca_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_ca_id' in params:
            path_params['CertificatesCaId'] = params['certificates_ca_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/ca/{CertificatesCaId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificatesCa',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_certificates_identity_by_id(self, certificates_identity_id, **kwargs):  # noqa: E501
        """get_certificates_identity_by_id  # noqa: E501

        Retrieve a single trusted Datamover TLS Identity certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_identity_by_id(certificates_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_identity_id: Retrieve a single trusted Datamover TLS Identity certificate. (required)
        :return: CertificatesIdentity
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_certificates_identity_by_id_with_http_info(certificates_identity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_certificates_identity_by_id_with_http_info(certificates_identity_id, **kwargs)  # noqa: E501
            return data

    def get_certificates_identity_by_id_with_http_info(self, certificates_identity_id, **kwargs):  # noqa: E501
        """get_certificates_identity_by_id  # noqa: E501

        Retrieve a single trusted Datamover TLS Identity certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_certificates_identity_by_id_with_http_info(certificates_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str certificates_identity_id: Retrieve a single trusted Datamover TLS Identity certificate. (required)
        :return: CertificatesIdentity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_identity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_certificates_identity_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_identity_id' is set
        if ('certificates_identity_id' not in params or
                params['certificates_identity_id'] is None):
            raise ValueError("Missing the required parameter `certificates_identity_id` when calling `get_certificates_identity_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_identity_id' in params:
            path_params['CertificatesIdentityId'] = params['certificates_identity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/identity/{CertificatesIdentityId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificatesIdentity',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datamover_account(self, datamover_account_id, **kwargs):  # noqa: E501
        """get_datamover_account  # noqa: E501

        Retrieve account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_account(datamover_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_account_id: Retrieve account information. (required)
        :return: DatamoverAccounts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datamover_account_with_http_info(datamover_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_datamover_account_with_http_info(datamover_account_id, **kwargs)  # noqa: E501
            return data

    def get_datamover_account_with_http_info(self, datamover_account_id, **kwargs):  # noqa: E501
        """get_datamover_account  # noqa: E501

        Retrieve account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_account_with_http_info(datamover_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_account_id: Retrieve account information. (required)
        :return: DatamoverAccounts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datamover_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_account_id' is set
        if ('datamover_account_id' not in params or
                params['datamover_account_id'] is None):
            raise ValueError("Missing the required parameter `datamover_account_id` when calling `get_datamover_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_account_id' in params:
            path_params['DatamoverAccountId'] = params['datamover_account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/accounts/{DatamoverAccountId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverAccounts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datamover_base_policy(self, datamover_base_policy_id, **kwargs):  # noqa: E501
        """get_datamover_base_policy  # noqa: E501

        Retrieve base policy information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_base_policy(datamover_base_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_base_policy_id: Retrieve base policy information. (required)
        :return: DatamoverBasePolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datamover_base_policy_with_http_info(datamover_base_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_datamover_base_policy_with_http_info(datamover_base_policy_id, **kwargs)  # noqa: E501
            return data

    def get_datamover_base_policy_with_http_info(self, datamover_base_policy_id, **kwargs):  # noqa: E501
        """get_datamover_base_policy  # noqa: E501

        Retrieve base policy information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_base_policy_with_http_info(datamover_base_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_base_policy_id: Retrieve base policy information. (required)
        :return: DatamoverBasePolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_base_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datamover_base_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_base_policy_id' is set
        if ('datamover_base_policy_id' not in params or
                params['datamover_base_policy_id'] is None):
            raise ValueError("Missing the required parameter `datamover_base_policy_id` when calling `get_datamover_base_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_base_policy_id' in params:
            path_params['DatamoverBasePolicyId'] = params['datamover_base_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/base-policies/{DatamoverBasePolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverBasePolicies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datamover_dataset(self, datamover_dataset_id, **kwargs):  # noqa: E501
        """get_datamover_dataset  # noqa: E501

        Retrieve dataset information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_dataset(datamover_dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_dataset_id: Retrieve dataset information. (required)
        :param str account_id: Unique account ID
        :return: DatamoverDatasets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datamover_dataset_with_http_info(datamover_dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_datamover_dataset_with_http_info(datamover_dataset_id, **kwargs)  # noqa: E501
            return data

    def get_datamover_dataset_with_http_info(self, datamover_dataset_id, **kwargs):  # noqa: E501
        """get_datamover_dataset  # noqa: E501

        Retrieve dataset information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_dataset_with_http_info(datamover_dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_dataset_id: Retrieve dataset information. (required)
        :param str account_id: Unique account ID
        :return: DatamoverDatasets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_dataset_id', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datamover_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_dataset_id' is set
        if ('datamover_dataset_id' not in params or
                params['datamover_dataset_id'] is None):
            raise ValueError("Missing the required parameter `datamover_dataset_id` when calling `get_datamover_dataset`")  # noqa: E501

        if ('account_id' in params and
                len(params['account_id']) > 48):
            raise ValueError("Invalid value for parameter `account_id` when calling `get_datamover_dataset`, length must be less than or equal to `48`")  # noqa: E501
        if ('account_id' in params and
                len(params['account_id']) < 2):
            raise ValueError("Invalid value for parameter `account_id` when calling `get_datamover_dataset`, length must be greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'datamover_dataset_id' in params:
            path_params['DatamoverDatasetId'] = params['datamover_dataset_id']  # noqa: E501

        query_params = []
        if 'account_id' in params:
            query_params.append(('account_id', params['account_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/datasets/{DatamoverDatasetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverDatasets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datamover_datasets(self, **kwargs):  # noqa: E501
        """get_datamover_datasets  # noqa: E501

        List all datasets or retrieve datasets of the specified type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_datasets(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: Unique account ID
        :param str base_path:
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverDatasetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datamover_datasets_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_datamover_datasets_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_datamover_datasets_with_http_info(self, **kwargs):  # noqa: E501
        """get_datamover_datasets  # noqa: E501

        List all datasets or retrieve datasets of the specified type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_datasets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: Unique account ID
        :param str base_path:
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverDatasetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'base_path', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datamover_datasets" % key
                )
            params[key] = val
        del params['kwargs']

        if ('account_id' in params and
                len(params['account_id']) > 48):
            raise ValueError("Invalid value for parameter `account_id` when calling `get_datamover_datasets`, length must be less than or equal to `48`")  # noqa: E501
        if ('account_id' in params and
                len(params['account_id']) < 2):
            raise ValueError("Invalid value for parameter `account_id` when calling `get_datamover_datasets`, length must be greater than or equal to `2`")  # noqa: E501
        if ('base_path' in params and
                len(params['base_path']) > 4096):
            raise ValueError("Invalid value for parameter `base_path` when calling `get_datamover_datasets`, length must be less than or equal to `4096`")  # noqa: E501
        if ('base_path' in params and
                len(params['base_path']) < 1):
            raise ValueError("Invalid value for parameter `base_path` when calling `get_datamover_datasets`, length must be greater than or equal to `1`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_datamover_datasets`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_datamover_datasets`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_datamover_datasets`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_datamover_datasets`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'account_id' in params:
            query_params.append(('account_id', params['account_id']))  # noqa: E501
        if 'base_path' in params:
            query_params.append(('base_path', params['base_path']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/datasets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverDatasetsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datamover_historical_jobs(self, **kwargs):  # noqa: E501
        """get_datamover_historical_jobs  # noqa: E501

        List/Delete finished jobs based on their end time. Capped at 1000. If 'after-time' is specified, latest 1000 jobs ended after this time will be listed/deleted. If 'after-time' is not specified, latest 1000 jobs finished in last 24 hours will be listed/deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_historical_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str after_time: The time in '%Y-%m-%d %H:%M:%S' format. The year range is 2001-2099.
        :return: DatamoverHistoricalJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datamover_historical_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_datamover_historical_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_datamover_historical_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """get_datamover_historical_jobs  # noqa: E501

        List/Delete finished jobs based on their end time. Capped at 1000. If 'after-time' is specified, latest 1000 jobs ended after this time will be listed/deleted. If 'after-time' is not specified, latest 1000 jobs finished in last 24 hours will be listed/deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_historical_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str after_time: The time in '%Y-%m-%d %H:%M:%S' format. The year range is 2001-2099.
        :return: DatamoverHistoricalJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['after_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datamover_historical_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if ('after_time' in params and
                len(params['after_time']) > 19):
            raise ValueError("Invalid value for parameter `after_time` when calling `get_datamover_historical_jobs`, length must be less than or equal to `19`")  # noqa: E501
        if ('after_time' in params and
                len(params['after_time']) < 14):
            raise ValueError("Invalid value for parameter `after_time` when calling `get_datamover_historical_jobs`, length must be greater than or equal to `14`")  # noqa: E501
        if 'after_time' in params and not re.search('20[0-9][0-9]-1[0-2]|[1-9]-3[01]|[12][0-9]|0?[1-9] 2[0-3]|1[0-9]|0?[0-9]:[0-5]?[0-9]:[0-5]?[0-9]', params['after_time']):  # noqa: E501
            raise ValueError("Invalid value for parameter `after_time` when calling `get_datamover_historical_jobs`, must conform to the pattern `/20[0-9][0-9]-1[0-2]|[1-9]-3[01]|[12][0-9]|0?[1-9] 2[0-3]|1[0-9]|0?[0-9]:[0-5]?[0-9]:[0-5]?[0-9]/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'after_time' in params:
            query_params.append(('after_time', params['after_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/historical-jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverHistoricalJobs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datamover_job(self, datamover_job_id, **kwargs):  # noqa: E501
        """get_datamover_job  # noqa: E501

        Retrieve job information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_job(datamover_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_job_id: Retrieve job information. (required)
        :return: DatamoverJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datamover_job_with_http_info(datamover_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_datamover_job_with_http_info(datamover_job_id, **kwargs)  # noqa: E501
            return data

    def get_datamover_job_with_http_info(self, datamover_job_id, **kwargs):  # noqa: E501
        """get_datamover_job  # noqa: E501

        Retrieve job information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_job_with_http_info(datamover_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_job_id: Retrieve job information. (required)
        :return: DatamoverJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datamover_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_job_id' is set
        if ('datamover_job_id' not in params or
                params['datamover_job_id'] is None):
            raise ValueError("Missing the required parameter `datamover_job_id` when calling `get_datamover_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_job_id' in params:
            path_params['DatamoverJobId'] = params['datamover_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/jobs/{DatamoverJobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverJobs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datamover_jobs(self, **kwargs):  # noqa: E501
        """get_datamover_jobs  # noqa: E501

        List all jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverHistoricalJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datamover_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_datamover_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_datamover_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """get_datamover_jobs  # noqa: E501

        List all jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverHistoricalJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datamover_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_datamover_jobs`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_datamover_jobs`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_datamover_jobs`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_datamover_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverHistoricalJobs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_datamover_policy(self, datamover_policy_id, **kwargs):  # noqa: E501
        """get_datamover_policy  # noqa: E501

        Retrieve policy information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_policy(datamover_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_policy_id: Retrieve policy information. (required)
        :return: DatamoverPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_datamover_policy_with_http_info(datamover_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_datamover_policy_with_http_info(datamover_policy_id, **kwargs)  # noqa: E501
            return data

    def get_datamover_policy_with_http_info(self, datamover_policy_id, **kwargs):  # noqa: E501
        """get_datamover_policy  # noqa: E501

        Retrieve policy information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_datamover_policy_with_http_info(datamover_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str datamover_policy_id: Retrieve policy information. (required)
        :return: DatamoverPolicies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_datamover_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_policy_id' is set
        if ('datamover_policy_id' not in params or
                params['datamover_policy_id'] is None):
            raise ValueError("Missing the required parameter `datamover_policy_id` when calling `get_datamover_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_policy_id' in params:
            path_params['DatamoverPolicyId'] = params['datamover_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/policies/{DatamoverPolicyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverPolicies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_throttling_bw_rule(self, throttling_bw_rule_id, **kwargs):  # noqa: E501
        """get_throttling_bw_rule  # noqa: E501

        Retrieve a bandwidth throttling rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_throttling_bw_rule(throttling_bw_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str throttling_bw_rule_id: Retrieve a bandwidth throttling rule. (required)
        :return: ThrottlingBwRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_throttling_bw_rule_with_http_info(throttling_bw_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_throttling_bw_rule_with_http_info(throttling_bw_rule_id, **kwargs)  # noqa: E501
            return data

    def get_throttling_bw_rule_with_http_info(self, throttling_bw_rule_id, **kwargs):  # noqa: E501
        """get_throttling_bw_rule  # noqa: E501

        Retrieve a bandwidth throttling rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_throttling_bw_rule_with_http_info(throttling_bw_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str throttling_bw_rule_id: Retrieve a bandwidth throttling rule. (required)
        :return: ThrottlingBwRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['throttling_bw_rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_throttling_bw_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'throttling_bw_rule_id' is set
        if ('throttling_bw_rule_id' not in params or
                params['throttling_bw_rule_id'] is None):
            raise ValueError("Missing the required parameter `throttling_bw_rule_id` when calling `get_throttling_bw_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'throttling_bw_rule_id' in params:
            path_params['ThrottlingBwRuleId'] = params['throttling_bw_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/throttling/bw-rules/{ThrottlingBwRuleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThrottlingBwRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_throttling_settings(self, **kwargs):  # noqa: E501
        """get_throttling_settings  # noqa: E501

        View Datamover throttling settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_throttling_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ThrottlingSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_throttling_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_throttling_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_throttling_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_throttling_settings  # noqa: E501

        View Datamover throttling settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_throttling_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ThrottlingSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_throttling_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/throttling/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThrottlingSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_certificates_ca(self, **kwargs):  # noqa: E501
        """list_certificates_ca  # noqa: E501

        Retrieve a list of all trusted Datamover TLS CA certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_certificates_ca(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CertificatesCaExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_certificates_ca_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_certificates_ca_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_certificates_ca_with_http_info(self, **kwargs):  # noqa: E501
        """list_certificates_ca  # noqa: E501

        Retrieve a list of all trusted Datamover TLS CA certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_certificates_ca_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CertificatesCaExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_certificates_ca" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_certificates_ca`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_certificates_ca`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_certificates_ca`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_certificates_ca`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_certificates_ca`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_certificates_ca`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_certificates_ca`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/ca', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificatesCaExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_certificates_identity(self, **kwargs):  # noqa: E501
        """list_certificates_identity  # noqa: E501

        Retrieve a list of all trusted Datamover TLS Identity certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_certificates_identity(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CertificatesIdentityExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_certificates_identity_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_certificates_identity_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_certificates_identity_with_http_info(self, **kwargs):  # noqa: E501
        """list_certificates_identity  # noqa: E501

        Retrieve a list of all trusted Datamover TLS Identity certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_certificates_identity_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CertificatesIdentityExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_certificates_identity" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_certificates_identity`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_certificates_identity`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_certificates_identity`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_certificates_identity`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_certificates_identity`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_certificates_identity`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_certificates_identity`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/identity', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificatesIdentityExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_datamover_accounts(self, **kwargs):  # noqa: E501
        """list_datamover_accounts  # noqa: E501

        List all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datamover_accounts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverAccountsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_datamover_accounts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_datamover_accounts_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_datamover_accounts_with_http_info(self, **kwargs):  # noqa: E501
        """list_datamover_accounts  # noqa: E501

        List all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datamover_accounts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverAccountsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_datamover_accounts" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_datamover_accounts`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_datamover_accounts`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_datamover_accounts`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_datamover_accounts`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/accounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverAccountsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_datamover_base_policies(self, **kwargs):  # noqa: E501
        """list_datamover_base_policies  # noqa: E501

        List all base policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datamover_base_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverBasePoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_datamover_base_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_datamover_base_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_datamover_base_policies_with_http_info(self, **kwargs):  # noqa: E501
        """list_datamover_base_policies  # noqa: E501

        List all base policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datamover_base_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverBasePoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_datamover_base_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_datamover_base_policies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_datamover_base_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_datamover_base_policies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_datamover_base_policies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/base-policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverBasePoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_datamover_policies(self, **kwargs):  # noqa: E501
        """list_datamover_policies  # noqa: E501

        List all policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datamover_policies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_datamover_policies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_datamover_policies_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_datamover_policies_with_http_info(self, **kwargs):  # noqa: E501
        """list_datamover_policies  # noqa: E501

        List all policies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_datamover_policies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: DatamoverPoliciesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_datamover_policies" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_datamover_policies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_datamover_policies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_datamover_policies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_datamover_policies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatamoverPoliciesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_throttling_bw_rules(self, **kwargs):  # noqa: E501
        """list_throttling_bw_rules  # noqa: E501

        List all bandwidth throttling rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_throttling_bw_rules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ThrottlingBwRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_throttling_bw_rules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_throttling_bw_rules_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_throttling_bw_rules_with_http_info(self, **kwargs):  # noqa: E501
        """list_throttling_bw_rules  # noqa: E501

        List all bandwidth throttling rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_throttling_bw_rules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ThrottlingBwRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_throttling_bw_rules" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/throttling/bw-rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThrottlingBwRulesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_certificates_ca_by_id(self, certificates_ca_id_params, certificates_ca_id, **kwargs):  # noqa: E501
        """update_certificates_ca_by_id  # noqa: E501

        Modify a trusted Datamover TLS CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_ca_by_id(certificates_ca_id_params, certificates_ca_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificatesCaIdParams certificates_ca_id_params: (required)
        :param str certificates_ca_id: Modify a trusted Datamover TLS CA certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_certificates_ca_by_id_with_http_info(certificates_ca_id_params, certificates_ca_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_certificates_ca_by_id_with_http_info(certificates_ca_id_params, certificates_ca_id, **kwargs)  # noqa: E501
            return data

    def update_certificates_ca_by_id_with_http_info(self, certificates_ca_id_params, certificates_ca_id, **kwargs):  # noqa: E501
        """update_certificates_ca_by_id  # noqa: E501

        Modify a trusted Datamover TLS CA certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_ca_by_id_with_http_info(certificates_ca_id_params, certificates_ca_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificatesCaIdParams certificates_ca_id_params: (required)
        :param str certificates_ca_id: Modify a trusted Datamover TLS CA certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_ca_id_params', 'certificates_ca_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_certificates_ca_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_ca_id_params' is set
        if ('certificates_ca_id_params' not in params or
                params['certificates_ca_id_params'] is None):
            raise ValueError("Missing the required parameter `certificates_ca_id_params` when calling `update_certificates_ca_by_id`")  # noqa: E501
        # verify the required parameter 'certificates_ca_id' is set
        if ('certificates_ca_id' not in params or
                params['certificates_ca_id'] is None):
            raise ValueError("Missing the required parameter `certificates_ca_id` when calling `update_certificates_ca_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_ca_id' in params:
            path_params['CertificatesCaId'] = params['certificates_ca_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificates_ca_id_params' in params:
            body_params = params['certificates_ca_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/ca/{CertificatesCaId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_certificates_identity_by_id(self, certificates_identity_id_params, certificates_identity_id, **kwargs):  # noqa: E501
        """update_certificates_identity_by_id  # noqa: E501

        Modify a trusted Datamover TLS Identity certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_identity_by_id(certificates_identity_id_params, certificates_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificatesCaIdParams certificates_identity_id_params: (required)
        :param str certificates_identity_id: Modify a trusted Datamover TLS Identity certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_certificates_identity_by_id_with_http_info(certificates_identity_id_params, certificates_identity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_certificates_identity_by_id_with_http_info(certificates_identity_id_params, certificates_identity_id, **kwargs)  # noqa: E501
            return data

    def update_certificates_identity_by_id_with_http_info(self, certificates_identity_id_params, certificates_identity_id, **kwargs):  # noqa: E501
        """update_certificates_identity_by_id  # noqa: E501

        Modify a trusted Datamover TLS Identity certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_certificates_identity_by_id_with_http_info(certificates_identity_id_params, certificates_identity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificatesCaIdParams certificates_identity_id_params: (required)
        :param str certificates_identity_id: Modify a trusted Datamover TLS Identity certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['certificates_identity_id_params', 'certificates_identity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_certificates_identity_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'certificates_identity_id_params' is set
        if ('certificates_identity_id_params' not in params or
                params['certificates_identity_id_params'] is None):
            raise ValueError("Missing the required parameter `certificates_identity_id_params` when calling `update_certificates_identity_by_id`")  # noqa: E501
        # verify the required parameter 'certificates_identity_id' is set
        if ('certificates_identity_id' not in params or
                params['certificates_identity_id'] is None):
            raise ValueError("Missing the required parameter `certificates_identity_id` when calling `update_certificates_identity_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certificates_identity_id' in params:
            path_params['CertificatesIdentityId'] = params['certificates_identity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certificates_identity_id_params' in params:
            body_params = params['certificates_identity_id_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/certificates/identity/{CertificatesIdentityId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_datamover_account(self, datamover_account, datamover_account_id, **kwargs):  # noqa: E501
        """update_datamover_account  # noqa: E501

        Modify account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_datamover_account(datamover_account, datamover_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverAccount datamover_account: (required)
        :param str datamover_account_id: Modify account information. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_datamover_account_with_http_info(datamover_account, datamover_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_datamover_account_with_http_info(datamover_account, datamover_account_id, **kwargs)  # noqa: E501
            return data

    def update_datamover_account_with_http_info(self, datamover_account, datamover_account_id, **kwargs):  # noqa: E501
        """update_datamover_account  # noqa: E501

        Modify account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_datamover_account_with_http_info(datamover_account, datamover_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverAccount datamover_account: (required)
        :param str datamover_account_id: Modify account information. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_account', 'datamover_account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_datamover_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_account' is set
        if ('datamover_account' not in params or
                params['datamover_account'] is None):
            raise ValueError("Missing the required parameter `datamover_account` when calling `update_datamover_account`")  # noqa: E501
        # verify the required parameter 'datamover_account_id' is set
        if ('datamover_account_id' not in params or
                params['datamover_account_id'] is None):
            raise ValueError("Missing the required parameter `datamover_account_id` when calling `update_datamover_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_account_id' in params:
            path_params['DatamoverAccountId'] = params['datamover_account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'datamover_account' in params:
            body_params = params['datamover_account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/accounts/{DatamoverAccountId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_datamover_base_policy(self, datamover_base_policy, datamover_base_policy_id, **kwargs):  # noqa: E501
        """update_datamover_base_policy  # noqa: E501

        Modify base policy information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_datamover_base_policy(datamover_base_policy, datamover_base_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverBasePolicy datamover_base_policy: (required)
        :param str datamover_base_policy_id: Modify base policy information. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_datamover_base_policy_with_http_info(datamover_base_policy, datamover_base_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_datamover_base_policy_with_http_info(datamover_base_policy, datamover_base_policy_id, **kwargs)  # noqa: E501
            return data

    def update_datamover_base_policy_with_http_info(self, datamover_base_policy, datamover_base_policy_id, **kwargs):  # noqa: E501
        """update_datamover_base_policy  # noqa: E501

        Modify base policy information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_datamover_base_policy_with_http_info(datamover_base_policy, datamover_base_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverBasePolicy datamover_base_policy: (required)
        :param str datamover_base_policy_id: Modify base policy information. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_base_policy', 'datamover_base_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_datamover_base_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_base_policy' is set
        if ('datamover_base_policy' not in params or
                params['datamover_base_policy'] is None):
            raise ValueError("Missing the required parameter `datamover_base_policy` when calling `update_datamover_base_policy`")  # noqa: E501
        # verify the required parameter 'datamover_base_policy_id' is set
        if ('datamover_base_policy_id' not in params or
                params['datamover_base_policy_id'] is None):
            raise ValueError("Missing the required parameter `datamover_base_policy_id` when calling `update_datamover_base_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_base_policy_id' in params:
            path_params['DatamoverBasePolicyId'] = params['datamover_base_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'datamover_base_policy' in params:
            body_params = params['datamover_base_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/base-policies/{DatamoverBasePolicyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_datamover_job(self, action, datamover_job, datamover_job_id, **kwargs):  # noqa: E501
        """update_datamover_job  # noqa: E501

        Modify job state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_datamover_job(action, datamover_job, datamover_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: Job control request. (required)
        :param Empty datamover_job: (required)
        :param str datamover_job_id: Modify job state. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_datamover_job_with_http_info(action, datamover_job, datamover_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_datamover_job_with_http_info(action, datamover_job, datamover_job_id, **kwargs)  # noqa: E501
            return data

    def update_datamover_job_with_http_info(self, action, datamover_job, datamover_job_id, **kwargs):  # noqa: E501
        """update_datamover_job  # noqa: E501

        Modify job state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_datamover_job_with_http_info(action, datamover_job, datamover_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: Job control request. (required)
        :param Empty datamover_job: (required)
        :param str datamover_job_id: Modify job state. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action', 'datamover_job', 'datamover_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_datamover_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'action' is set
        if ('action' not in params or
                params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `update_datamover_job`")  # noqa: E501
        # verify the required parameter 'datamover_job' is set
        if ('datamover_job' not in params or
                params['datamover_job'] is None):
            raise ValueError("Missing the required parameter `datamover_job` when calling `update_datamover_job`")  # noqa: E501
        # verify the required parameter 'datamover_job_id' is set
        if ('datamover_job_id' not in params or
                params['datamover_job_id'] is None):
            raise ValueError("Missing the required parameter `datamover_job_id` when calling `update_datamover_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_job_id' in params:
            path_params['DatamoverJobId'] = params['datamover_job_id']  # noqa: E501

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'datamover_job' in params:
            body_params = params['datamover_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/jobs/{DatamoverJobId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_datamover_policy(self, datamover_policy, datamover_policy_id, **kwargs):  # noqa: E501
        """update_datamover_policy  # noqa: E501

        Modify policy information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_datamover_policy(datamover_policy, datamover_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverPolicy datamover_policy: (required)
        :param str datamover_policy_id: Modify policy information. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_datamover_policy_with_http_info(datamover_policy, datamover_policy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_datamover_policy_with_http_info(datamover_policy, datamover_policy_id, **kwargs)  # noqa: E501
            return data

    def update_datamover_policy_with_http_info(self, datamover_policy, datamover_policy_id, **kwargs):  # noqa: E501
        """update_datamover_policy  # noqa: E501

        Modify policy information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_datamover_policy_with_http_info(datamover_policy, datamover_policy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatamoverPolicy datamover_policy: (required)
        :param str datamover_policy_id: Modify policy information. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datamover_policy', 'datamover_policy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_datamover_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'datamover_policy' is set
        if ('datamover_policy' not in params or
                params['datamover_policy'] is None):
            raise ValueError("Missing the required parameter `datamover_policy` when calling `update_datamover_policy`")  # noqa: E501
        # verify the required parameter 'datamover_policy_id' is set
        if ('datamover_policy_id' not in params or
                params['datamover_policy_id'] is None):
            raise ValueError("Missing the required parameter `datamover_policy_id` when calling `update_datamover_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'datamover_policy_id' in params:
            path_params['DatamoverPolicyId'] = params['datamover_policy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'datamover_policy' in params:
            body_params = params['datamover_policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/policies/{DatamoverPolicyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_throttling_bw_rule(self, throttling_bw_rule, throttling_bw_rule_id, **kwargs):  # noqa: E501
        """update_throttling_bw_rule  # noqa: E501

        Modify a bandwidth throttling rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_throttling_bw_rule(throttling_bw_rule, throttling_bw_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThrottlingBwRule throttling_bw_rule: (required)
        :param str throttling_bw_rule_id: Modify a bandwidth throttling rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_throttling_bw_rule_with_http_info(throttling_bw_rule, throttling_bw_rule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_throttling_bw_rule_with_http_info(throttling_bw_rule, throttling_bw_rule_id, **kwargs)  # noqa: E501
            return data

    def update_throttling_bw_rule_with_http_info(self, throttling_bw_rule, throttling_bw_rule_id, **kwargs):  # noqa: E501
        """update_throttling_bw_rule  # noqa: E501

        Modify a bandwidth throttling rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_throttling_bw_rule_with_http_info(throttling_bw_rule, throttling_bw_rule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThrottlingBwRule throttling_bw_rule: (required)
        :param str throttling_bw_rule_id: Modify a bandwidth throttling rule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['throttling_bw_rule', 'throttling_bw_rule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_throttling_bw_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'throttling_bw_rule' is set
        if ('throttling_bw_rule' not in params or
                params['throttling_bw_rule'] is None):
            raise ValueError("Missing the required parameter `throttling_bw_rule` when calling `update_throttling_bw_rule`")  # noqa: E501
        # verify the required parameter 'throttling_bw_rule_id' is set
        if ('throttling_bw_rule_id' not in params or
                params['throttling_bw_rule_id'] is None):
            raise ValueError("Missing the required parameter `throttling_bw_rule_id` when calling `update_throttling_bw_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'throttling_bw_rule_id' in params:
            path_params['ThrottlingBwRuleId'] = params['throttling_bw_rule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'throttling_bw_rule' in params:
            body_params = params['throttling_bw_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/throttling/bw-rules/{ThrottlingBwRuleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_throttling_settings(self, throttling_settings, **kwargs):  # noqa: E501
        """update_throttling_settings  # noqa: E501

        Modify Datamover throttling settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_throttling_settings(throttling_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThrottlingSettingsSettings throttling_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_throttling_settings_with_http_info(throttling_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_throttling_settings_with_http_info(throttling_settings, **kwargs)  # noqa: E501
            return data

    def update_throttling_settings_with_http_info(self, throttling_settings, **kwargs):  # noqa: E501
        """update_throttling_settings  # noqa: E501

        Modify Datamover throttling settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_throttling_settings_with_http_info(throttling_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThrottlingSettingsSettings throttling_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['throttling_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_throttling_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'throttling_settings' is set
        if ('throttling_settings' not in params or
                params['throttling_settings'] is None):
            raise ValueError("Missing the required parameter `throttling_settings` when calling `update_throttling_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'throttling_settings' in params:
            body_params = params['throttling_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/15/datamover/throttling/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
