# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_4_0.api_client import ApiClient


class ConfigApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_config_export(self, config_export, **kwargs):  # noqa: E501
        """create_config_export  # noqa: E501

        Create a new config export task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_config_export(config_export, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigExportCreateParams config_export: (required)
        :return: CreateConfigExportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_config_export_with_http_info(config_export, **kwargs)  # noqa: E501
        else:
            (data) = self.create_config_export_with_http_info(config_export, **kwargs)  # noqa: E501
            return data

    def create_config_export_with_http_info(self, config_export, **kwargs):  # noqa: E501
        """create_config_export  # noqa: E501

        Create a new config export task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_config_export_with_http_info(config_export, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigExportCreateParams config_export: (required)
        :return: CreateConfigExportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_export']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_config_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_export' is set
        if ('config_export' not in params or
                params['config_export'] is None):
            raise ValueError("Missing the required parameter `config_export` when calling `create_config_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_export' in params:
            body_params = params['config_export']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/config/exports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateConfigExportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_config_import(self, config_import, **kwargs):  # noqa: E501
        """create_config_import  # noqa: E501

        Create a new config import task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_config_import(config_import, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigImportCreateParams config_import: (required)
        :return: CreateConfigImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_config_import_with_http_info(config_import, **kwargs)  # noqa: E501
        else:
            (data) = self.create_config_import_with_http_info(config_import, **kwargs)  # noqa: E501
            return data

    def create_config_import_with_http_info(self, config_import, **kwargs):  # noqa: E501
        """create_config_import  # noqa: E501

        Create a new config import task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_config_import_with_http_info(config_import, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigImportCreateParams config_import: (required)
        :return: CreateConfigImportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_import']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_config_import" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_import' is set
        if ('config_import' not in params or
                params['config_import'] is None):
            raise ValueError("Missing the required parameter `config_import` when calling `create_config_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_import' in params:
            body_params = params['config_import']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/config/imports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateConfigImportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config_export(self, config_export_id, **kwargs):  # noqa: E501
        """get_config_export  # noqa: E501

        Retrieve export task information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_export(config_export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str config_export_id: Retrieve export task information. (required)
        :return: ConfigExports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_export_with_http_info(config_export_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_config_export_with_http_info(config_export_id, **kwargs)  # noqa: E501
            return data

    def get_config_export_with_http_info(self, config_export_id, **kwargs):  # noqa: E501
        """get_config_export  # noqa: E501

        Retrieve export task information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_export_with_http_info(config_export_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str config_export_id: Retrieve export task information. (required)
        :return: ConfigExports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_export_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_export_id' is set
        if ('config_export_id' not in params or
                params['config_export_id'] is None):
            raise ValueError("Missing the required parameter `config_export_id` when calling `get_config_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_export_id' in params:
            path_params['ConfigExportId'] = params['config_export_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/config/exports/{ConfigExportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigExports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config_import(self, config_import_id, **kwargs):  # noqa: E501
        """get_config_import  # noqa: E501

        Retrieve import task information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_import(config_import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str config_import_id: Retrieve import task information. (required)
        :return: ConfigImports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_import_with_http_info(config_import_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_config_import_with_http_info(config_import_id, **kwargs)  # noqa: E501
            return data

    def get_config_import_with_http_info(self, config_import_id, **kwargs):  # noqa: E501
        """get_config_import  # noqa: E501

        Retrieve import task information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_import_with_http_info(config_import_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str config_import_id: Retrieve import task information. (required)
        :return: ConfigImports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_import_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_import" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_import_id' is set
        if ('config_import_id' not in params or
                params['config_import_id'] is None):
            raise ValueError("Missing the required parameter `config_import_id` when calling `get_config_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_import_id' in params:
            path_params['ConfigImportId'] = params['config_import_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/config/imports/{ConfigImportId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigImports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_config_exports(self, **kwargs):  # noqa: E501
        """list_config_exports  # noqa: E501

        List all config export tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_config_exports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigExports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_config_exports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_config_exports_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_config_exports_with_http_info(self, **kwargs):  # noqa: E501
        """list_config_exports  # noqa: E501

        List all config export tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_config_exports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigExports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_config_exports" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/config/exports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigExports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_config_imports(self, **kwargs):  # noqa: E501
        """list_config_imports  # noqa: E501

        List all config import tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_config_imports(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigImports
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_config_imports_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_config_imports_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_config_imports_with_http_info(self, **kwargs):  # noqa: E501
        """list_config_imports  # noqa: E501

        List all config import tasks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_config_imports_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigImports
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_config_imports" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/config/imports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigImports',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
