# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 15
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_4_0.api_client import ApiClient


class CloudApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_cloud_access_item(self, cloud_access_item, **kwargs):  # noqa: E501
        """create_cloud_access_item  # noqa: E501

        Add a cluster identifier to access list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_access_item(cloud_access_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudAccessItem cloud_access_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cloud_access_item_with_http_info(cloud_access_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_access_item_with_http_info(cloud_access_item, **kwargs)  # noqa: E501
            return data

    def create_cloud_access_item_with_http_info(self, cloud_access_item, **kwargs):  # noqa: E501
        """create_cloud_access_item  # noqa: E501

        Add a cluster identifier to access list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_access_item_with_http_info(cloud_access_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudAccessItem cloud_access_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_access_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_access_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_access_item' is set
        if ('cloud_access_item' not in params or
                params['cloud_access_item'] is None):
            raise ValueError("Missing the required parameter `cloud_access_item` when calling `create_cloud_access_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_access_item' in params:
            body_params = params['cloud_access_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/access', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_account(self, cloud_account, **kwargs):  # noqa: E501
        """create_cloud_account  # noqa: E501

        Create a new account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_account(cloud_account, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudAccountCreateParams cloud_account: (required)
        :return: CreateCloudAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cloud_account_with_http_info(cloud_account, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_account_with_http_info(cloud_account, **kwargs)  # noqa: E501
            return data

    def create_cloud_account_with_http_info(self, cloud_account, **kwargs):  # noqa: E501
        """create_cloud_account  # noqa: E501

        Create a new account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_account_with_http_info(cloud_account, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudAccountCreateParams cloud_account: (required)
        :return: CreateCloudAccountResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_account']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_account' is set
        if ('cloud_account' not in params or
                params['cloud_account'] is None):
            raise ValueError("Missing the required parameter `cloud_account` when calling `create_cloud_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_account' in params:
            body_params = params['cloud_account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/accounts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCloudAccountResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_certificate(self, cloud_certificate, **kwargs):  # noqa: E501
        """create_cloud_certificate  # noqa: E501

        Import a TLS client certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_certificate(cloud_certificate, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerItem cloud_certificate: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cloud_certificate_with_http_info(cloud_certificate, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_certificate_with_http_info(cloud_certificate, **kwargs)  # noqa: E501
            return data

    def create_cloud_certificate_with_http_info(self, cloud_certificate, **kwargs):  # noqa: E501
        """create_cloud_certificate  # noqa: E501

        Import a TLS client certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_certificate_with_http_info(cloud_certificate, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerItem cloud_certificate: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_certificate']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_certificate' is set
        if ('cloud_certificate' not in params or
                params['cloud_certificate'] is None):
            raise ValueError("Missing the required parameter `cloud_certificate` when calling `create_cloud_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_certificate' in params:
            body_params = params['cloud_certificate']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/certificates', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_job(self, cloud_job, **kwargs):  # noqa: E501
        """create_cloud_job  # noqa: E501

        Create a new job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_job(cloud_job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudJobCreateParams cloud_job: (required)
        :return: CreateCloudJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cloud_job_with_http_info(cloud_job, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_job_with_http_info(cloud_job, **kwargs)  # noqa: E501
            return data

    def create_cloud_job_with_http_info(self, cloud_job, **kwargs):  # noqa: E501
        """create_cloud_job  # noqa: E501

        Create a new job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_job_with_http_info(cloud_job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudJobCreateParams cloud_job: (required)
        :return: CreateCloudJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_job']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_job' is set
        if ('cloud_job' not in params or
                params['cloud_job'] is None):
            raise ValueError("Missing the required parameter `cloud_job` when calling `create_cloud_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_job' in params:
            body_params = params['cloud_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCloudJobResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_pool(self, cloud_pool, **kwargs):  # noqa: E501
        """create_cloud_pool  # noqa: E501

        Create a new pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_pool(cloud_pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudPoolCreateParams cloud_pool: (required)
        :return: CreateCloudPoolResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cloud_pool_with_http_info(cloud_pool, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_pool_with_http_info(cloud_pool, **kwargs)  # noqa: E501
            return data

    def create_cloud_pool_with_http_info(self, cloud_pool, **kwargs):  # noqa: E501
        """create_cloud_pool  # noqa: E501

        Create a new pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_pool_with_http_info(cloud_pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudPoolCreateParams cloud_pool: (required)
        :return: CreateCloudPoolResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_pool' is set
        if ('cloud_pool' not in params or
                params['cloud_pool'] is None):
            raise ValueError("Missing the required parameter `cloud_pool` when calling `create_cloud_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_pool' in params:
            body_params = params['cloud_pool']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/pools', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCloudPoolResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cloud_proxy(self, cloud_proxy, **kwargs):  # noqa: E501
        """create_cloud_proxy  # noqa: E501

        Create a new proxy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_proxy(cloud_proxy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudProxyCreateParams cloud_proxy: (required)
        :return: CreateCloudProxyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cloud_proxy_with_http_info(cloud_proxy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cloud_proxy_with_http_info(cloud_proxy, **kwargs)  # noqa: E501
            return data

    def create_cloud_proxy_with_http_info(self, cloud_proxy, **kwargs):  # noqa: E501
        """create_cloud_proxy  # noqa: E501

        Create a new proxy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cloud_proxy_with_http_info(cloud_proxy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudProxyCreateParams cloud_proxy: (required)
        :return: CreateCloudProxyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_proxy']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cloud_proxy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_proxy' is set
        if ('cloud_proxy' not in params or
                params['cloud_proxy'] is None):
            raise ValueError("Missing the required parameter `cloud_proxy` when calling `create_cloud_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_proxy' in params:
            body_params = params['cloud_proxy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/cloud/proxies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateCloudProxyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_settings_encryption_key_item(self, settings_encryption_key_item, **kwargs):  # noqa: E501
        """create_settings_encryption_key_item  # noqa: E501

        Regenerate master encryption key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_encryption_key_item(settings_encryption_key_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty settings_encryption_key_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_settings_encryption_key_item_with_http_info(settings_encryption_key_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_settings_encryption_key_item_with_http_info(settings_encryption_key_item, **kwargs)  # noqa: E501
            return data

    def create_settings_encryption_key_item_with_http_info(self, settings_encryption_key_item, **kwargs):  # noqa: E501
        """create_settings_encryption_key_item  # noqa: E501

        Regenerate master encryption key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_encryption_key_item_with_http_info(settings_encryption_key_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty settings_encryption_key_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_encryption_key_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_settings_encryption_key_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_encryption_key_item' is set
        if ('settings_encryption_key_item' not in params or
                params['settings_encryption_key_item'] is None):
            raise ValueError("Missing the required parameter `settings_encryption_key_item` when calling `create_settings_encryption_key_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_encryption_key_item' in params:
            body_params = params['settings_encryption_key_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings/encryption-key', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_settings_reporting_eula_item(self, settings_reporting_eula_item, **kwargs):  # noqa: E501
        """create_settings_reporting_eula_item  # noqa: E501

        Accept telemetry collection EULA.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_reporting_eula_item(settings_reporting_eula_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty settings_reporting_eula_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_settings_reporting_eula_item_with_http_info(settings_reporting_eula_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_settings_reporting_eula_item_with_http_info(settings_reporting_eula_item, **kwargs)  # noqa: E501
            return data

    def create_settings_reporting_eula_item_with_http_info(self, settings_reporting_eula_item, **kwargs):  # noqa: E501
        """create_settings_reporting_eula_item  # noqa: E501

        Accept telemetry collection EULA.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_settings_reporting_eula_item_with_http_info(settings_reporting_eula_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty settings_reporting_eula_item: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_reporting_eula_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_settings_reporting_eula_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_reporting_eula_item' is set
        if ('settings_reporting_eula_item' not in params or
                params['settings_reporting_eula_item'] is None):
            raise ValueError("Missing the required parameter `settings_reporting_eula_item` when calling `create_settings_reporting_eula_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_reporting_eula_item' in params:
            body_params = params['settings_reporting_eula_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings/reporting-eula', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_access_guid(self, cloud_access_guid, **kwargs):  # noqa: E501
        """delete_cloud_access_guid  # noqa: E501

        Delete cloud access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_access_guid(cloud_access_guid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_access_guid: Delete cloud access. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cloud_access_guid_with_http_info(cloud_access_guid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_access_guid_with_http_info(cloud_access_guid, **kwargs)  # noqa: E501
            return data

    def delete_cloud_access_guid_with_http_info(self, cloud_access_guid, **kwargs):  # noqa: E501
        """delete_cloud_access_guid  # noqa: E501

        Delete cloud access.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_access_guid_with_http_info(cloud_access_guid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_access_guid: Delete cloud access. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_access_guid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_access_guid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_access_guid' is set
        if ('cloud_access_guid' not in params or
                params['cloud_access_guid'] is None):
            raise ValueError("Missing the required parameter `cloud_access_guid` when calling `delete_cloud_access_guid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_access_guid' in params:
            path_params['CloudAccessGuid'] = params['cloud_access_guid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/access/{CloudAccessGuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_account(self, cloud_account_id, **kwargs):  # noqa: E501
        """delete_cloud_account  # noqa: E501

        Delete cloud account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_account(cloud_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_account_id: Delete cloud account. (required)
        :param str acknowledge_force_delete: A value of 1 acknowledges that the user is deleting data.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cloud_account_with_http_info(cloud_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_account_with_http_info(cloud_account_id, **kwargs)  # noqa: E501
            return data

    def delete_cloud_account_with_http_info(self, cloud_account_id, **kwargs):  # noqa: E501
        """delete_cloud_account  # noqa: E501

        Delete cloud account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_account_with_http_info(cloud_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_account_id: Delete cloud account. (required)
        :param str acknowledge_force_delete: A value of 1 acknowledges that the user is deleting data.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_account_id', 'acknowledge_force_delete']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_account_id' is set
        if ('cloud_account_id' not in params or
                params['cloud_account_id'] is None):
            raise ValueError("Missing the required parameter `cloud_account_id` when calling `delete_cloud_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_account_id' in params:
            path_params['CloudAccountId'] = params['cloud_account_id']  # noqa: E501

        query_params = []
        if 'acknowledge_force_delete' in params:
            query_params.append(('acknowledge_force_delete', params['acknowledge_force_delete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/accounts/{CloudAccountId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_certificate(self, cloud_certificate_id, **kwargs):  # noqa: E501
        """delete_cloud_certificate  # noqa: E501

        Delete a CloudPools TLS client certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_certificate(cloud_certificate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_certificate_id: Delete a CloudPools TLS client certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cloud_certificate_with_http_info(cloud_certificate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_certificate_with_http_info(cloud_certificate_id, **kwargs)  # noqa: E501
            return data

    def delete_cloud_certificate_with_http_info(self, cloud_certificate_id, **kwargs):  # noqa: E501
        """delete_cloud_certificate  # noqa: E501

        Delete a CloudPools TLS client certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_certificate_with_http_info(cloud_certificate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_certificate_id: Delete a CloudPools TLS client certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_certificate_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_certificate_id' is set
        if ('cloud_certificate_id' not in params or
                params['cloud_certificate_id'] is None):
            raise ValueError("Missing the required parameter `cloud_certificate_id` when calling `delete_cloud_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_certificate_id' in params:
            path_params['CloudCertificateId'] = params['cloud_certificate_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/certificates/{CloudCertificateId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_pool(self, cloud_pool_id, **kwargs):  # noqa: E501
        """delete_cloud_pool  # noqa: E501

        Delete a cloud pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_pool(cloud_pool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pool_id: Delete a cloud pool. (required)
        :param str acknowledge_force_delete: A value of 1 acknowledges that the user is deleting data.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cloud_pool_with_http_info(cloud_pool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_pool_with_http_info(cloud_pool_id, **kwargs)  # noqa: E501
            return data

    def delete_cloud_pool_with_http_info(self, cloud_pool_id, **kwargs):  # noqa: E501
        """delete_cloud_pool  # noqa: E501

        Delete a cloud pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_pool_with_http_info(cloud_pool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pool_id: Delete a cloud pool. (required)
        :param str acknowledge_force_delete: A value of 1 acknowledges that the user is deleting data.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_pool_id', 'acknowledge_force_delete']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_pool_id' is set
        if ('cloud_pool_id' not in params or
                params['cloud_pool_id'] is None):
            raise ValueError("Missing the required parameter `cloud_pool_id` when calling `delete_cloud_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pool_id' in params:
            path_params['CloudPoolId'] = params['cloud_pool_id']  # noqa: E501

        query_params = []
        if 'acknowledge_force_delete' in params:
            query_params.append(('acknowledge_force_delete', params['acknowledge_force_delete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/pools/{CloudPoolId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cloud_proxy(self, cloud_proxy_id, **kwargs):  # noqa: E501
        """delete_cloud_proxy  # noqa: E501

        Delete cloud account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_proxy(cloud_proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_proxy_id: Delete cloud account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cloud_proxy_with_http_info(cloud_proxy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cloud_proxy_with_http_info(cloud_proxy_id, **kwargs)  # noqa: E501
            return data

    def delete_cloud_proxy_with_http_info(self, cloud_proxy_id, **kwargs):  # noqa: E501
        """delete_cloud_proxy  # noqa: E501

        Delete cloud account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cloud_proxy_with_http_info(cloud_proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_proxy_id: Delete cloud account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_proxy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cloud_proxy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_proxy_id' is set
        if ('cloud_proxy_id' not in params or
                params['cloud_proxy_id'] is None):
            raise ValueError("Missing the required parameter `cloud_proxy_id` when calling `delete_cloud_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_proxy_id' in params:
            path_params['CloudProxyId'] = params['cloud_proxy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/cloud/proxies/{CloudProxyId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_settings_reporting_eula(self, **kwargs):  # noqa: E501
        """delete_settings_reporting_eula  # noqa: E501

        Revoke acceptance of telemetry collection EULA.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_reporting_eula(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_settings_reporting_eula_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_settings_reporting_eula_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_settings_reporting_eula_with_http_info(self, **kwargs):  # noqa: E501
        """delete_settings_reporting_eula  # noqa: E501

        Revoke acceptance of telemetry collection EULA.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_settings_reporting_eula_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_settings_reporting_eula" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings/reporting-eula', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_access_guid(self, cloud_access_guid, **kwargs):  # noqa: E501
        """get_cloud_access_guid  # noqa: E501

        Retrieve cloud access information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_access_guid(cloud_access_guid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_access_guid: Retrieve cloud access information. (required)
        :return: CloudAccess
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_access_guid_with_http_info(cloud_access_guid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_access_guid_with_http_info(cloud_access_guid, **kwargs)  # noqa: E501
            return data

    def get_cloud_access_guid_with_http_info(self, cloud_access_guid, **kwargs):  # noqa: E501
        """get_cloud_access_guid  # noqa: E501

        Retrieve cloud access information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_access_guid_with_http_info(cloud_access_guid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_access_guid: Retrieve cloud access information. (required)
        :return: CloudAccess
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_access_guid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_access_guid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_access_guid' is set
        if ('cloud_access_guid' not in params or
                params['cloud_access_guid'] is None):
            raise ValueError("Missing the required parameter `cloud_access_guid` when calling `get_cloud_access_guid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_access_guid' in params:
            path_params['CloudAccessGuid'] = params['cloud_access_guid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/access/{CloudAccessGuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudAccess',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_account(self, cloud_account_id, **kwargs):  # noqa: E501
        """get_cloud_account  # noqa: E501

        Retrieve cloud account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_account(cloud_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_account_id: Retrieve cloud account information. (required)
        :return: CloudAccounts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_account_with_http_info(cloud_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_account_with_http_info(cloud_account_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_account_with_http_info(self, cloud_account_id, **kwargs):  # noqa: E501
        """get_cloud_account  # noqa: E501

        Retrieve cloud account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_account_with_http_info(cloud_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_account_id: Retrieve cloud account information. (required)
        :return: CloudAccounts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_account_id' is set
        if ('cloud_account_id' not in params or
                params['cloud_account_id'] is None):
            raise ValueError("Missing the required parameter `cloud_account_id` when calling `get_cloud_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_account_id' in params:
            path_params['CloudAccountId'] = params['cloud_account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/accounts/{CloudAccountId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudAccounts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_certificate(self, cloud_certificate_id, **kwargs):  # noqa: E501
        """get_cloud_certificate  # noqa: E501

        Retrieve a CloudPools TLS client certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_certificate(cloud_certificate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_certificate_id: Retrieve a CloudPools TLS client certificate. (required)
        :return: CertificatesCa
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_certificate_with_http_info(cloud_certificate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_certificate_with_http_info(cloud_certificate_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_certificate_with_http_info(self, cloud_certificate_id, **kwargs):  # noqa: E501
        """get_cloud_certificate  # noqa: E501

        Retrieve a CloudPools TLS client certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_certificate_with_http_info(cloud_certificate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_certificate_id: Retrieve a CloudPools TLS client certificate. (required)
        :return: CertificatesCa
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_certificate_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_certificate_id' is set
        if ('cloud_certificate_id' not in params or
                params['cloud_certificate_id'] is None):
            raise ValueError("Missing the required parameter `cloud_certificate_id` when calling `get_cloud_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_certificate_id' in params:
            path_params['CloudCertificateId'] = params['cloud_certificate_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/certificates/{CloudCertificateId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertificatesCa',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_job(self, cloud_job_id, **kwargs):  # noqa: E501
        """get_cloud_job  # noqa: E501

        Retrieve cloudpool job information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_job(cloud_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_job_id: Retrieve cloudpool job information. (required)
        :return: CloudJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_job_with_http_info(cloud_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_job_with_http_info(cloud_job_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_job_with_http_info(self, cloud_job_id, **kwargs):  # noqa: E501
        """get_cloud_job  # noqa: E501

        Retrieve cloudpool job information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_job_with_http_info(cloud_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_job_id: Retrieve cloudpool job information. (required)
        :return: CloudJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_job_id' is set
        if ('cloud_job_id' not in params or
                params['cloud_job_id'] is None):
            raise ValueError("Missing the required parameter `cloud_job_id` when calling `get_cloud_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_job_id' in params:
            path_params['CloudJobId'] = params['cloud_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs/{CloudJobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudJobs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_jobs_file(self, cloud_jobs_file_id, **kwargs):  # noqa: E501
        """get_cloud_jobs_file  # noqa: E501

        Retrieve files associated with a cloudpool job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_jobs_file(cloud_jobs_file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_jobs_file_id: Retrieve files associated with a cloudpool job. (required)
        :param str dir: The direction of the sort.
        :param int limit: Number of files to display; range from 1 to 100000.
        :param int offset: Specifies the starting entry to be displayed.
        :param int page: Used with limit option. If exists, specifies the starting page to display where page size is specified by limit. This option will be deprecated; please use offset option instead.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting. Output is limited to maximum of 100000 files.
        :return: CloudJobsFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_jobs_file_with_http_info(cloud_jobs_file_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_jobs_file_with_http_info(cloud_jobs_file_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_jobs_file_with_http_info(self, cloud_jobs_file_id, **kwargs):  # noqa: E501
        """get_cloud_jobs_file  # noqa: E501

        Retrieve files associated with a cloudpool job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_jobs_file_with_http_info(cloud_jobs_file_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_jobs_file_id: Retrieve files associated with a cloudpool job. (required)
        :param str dir: The direction of the sort.
        :param int limit: Number of files to display; range from 1 to 100000.
        :param int offset: Specifies the starting entry to be displayed.
        :param int page: Used with limit option. If exists, specifies the starting page to display where page size is specified by limit. This option will be deprecated; please use offset option instead.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting. Output is limited to maximum of 100000 files.
        :return: CloudJobsFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_jobs_file_id', 'dir', 'limit', 'offset', 'page', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_jobs_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_jobs_file_id' is set
        if ('cloud_jobs_file_id' not in params or
                params['cloud_jobs_file_id'] is None):
            raise ValueError("Missing the required parameter `cloud_jobs_file_id` when calling `get_cloud_jobs_file`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_cloud_jobs_file`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 100000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_cloud_jobs_file`, must be a value less than or equal to `100000`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_cloud_jobs_file`, must be a value greater than or equal to `1`")  # noqa: E501
        if 'offset' in params and params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_cloud_jobs_file`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'page' in params and params['page'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page` when calling `get_cloud_jobs_file`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_cloud_jobs_file`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_cloud_jobs_file`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'cloud_jobs_file_id' in params:
            path_params['CloudJobsFileId'] = params['cloud_jobs_file_id']  # noqa: E501

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs-files/{CloudJobsFileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudJobsFiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_pool(self, cloud_pool_id, **kwargs):  # noqa: E501
        """get_cloud_pool  # noqa: E501

        Retrieve cloud pool information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_pool(cloud_pool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pool_id: Retrieve cloud pool information (required)
        :return: CloudPools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_pool_with_http_info(cloud_pool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_pool_with_http_info(cloud_pool_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_pool_with_http_info(self, cloud_pool_id, **kwargs):  # noqa: E501
        """get_cloud_pool  # noqa: E501

        Retrieve cloud pool information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_pool_with_http_info(cloud_pool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_pool_id: Retrieve cloud pool information (required)
        :return: CloudPools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_pool_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_pool_id' is set
        if ('cloud_pool_id' not in params or
                params['cloud_pool_id'] is None):
            raise ValueError("Missing the required parameter `cloud_pool_id` when calling `get_cloud_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pool_id' in params:
            path_params['CloudPoolId'] = params['cloud_pool_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/pools/{CloudPoolId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudPools',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_proxy(self, cloud_proxy_id, **kwargs):  # noqa: E501
        """get_cloud_proxy  # noqa: E501

        Retrieve cloud account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_proxy(cloud_proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_proxy_id: Retrieve cloud account information. (required)
        :return: CloudProxies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_proxy_with_http_info(cloud_proxy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_proxy_with_http_info(cloud_proxy_id, **kwargs)  # noqa: E501
            return data

    def get_cloud_proxy_with_http_info(self, cloud_proxy_id, **kwargs):  # noqa: E501
        """get_cloud_proxy  # noqa: E501

        Retrieve cloud account information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_proxy_with_http_info(cloud_proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str cloud_proxy_id: Retrieve cloud account information. (required)
        :return: CloudProxies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_proxy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_proxy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_proxy_id' is set
        if ('cloud_proxy_id' not in params or
                params['cloud_proxy_id'] is None):
            raise ValueError("Missing the required parameter `cloud_proxy_id` when calling `get_cloud_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_proxy_id' in params:
            path_params['CloudProxyId'] = params['cloud_proxy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/cloud/proxies/{CloudProxyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudProxies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cloud_settings(self, **kwargs):  # noqa: E501
        """get_cloud_settings  # noqa: E501

        List all cloud settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CloudSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cloud_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_cloud_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_cloud_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_cloud_settings  # noqa: E501

        List all cloud settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cloud_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CloudSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cloud_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_access(self, **kwargs):  # noqa: E501
        """list_cloud_access  # noqa: E501

        List all accessible cluster identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_access(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudAccessExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cloud_access_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_access_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_access_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_access  # noqa: E501

        List all accessible cluster identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_access_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudAccessExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_access" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_cloud_access`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_access`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_access`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_access`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_access`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_access`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_access`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/access', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudAccessExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_accounts(self, **kwargs):  # noqa: E501
        """list_cloud_accounts  # noqa: E501

        List all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_accounts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudAccountsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cloud_accounts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_accounts_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_accounts_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_accounts  # noqa: E501

        List all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_accounts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudAccountsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_accounts" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_cloud_accounts`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_accounts`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_accounts`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_accounts`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_accounts`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_accounts`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_accounts`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/accounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudAccountsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_certificates(self, **kwargs):  # noqa: E501
        """list_cloud_certificates  # noqa: E501

        Retrieve a list of all CloudPools client certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_certificates(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudCertificates
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cloud_certificates_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_certificates_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_certificates_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_certificates  # noqa: E501

        Retrieve a list of all CloudPools client certificates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_certificates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudCertificates
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_certificates" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_cloud_certificates`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_certificates`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_certificates`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_certificates`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_certificates`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_certificates`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_certificates`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/certificates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudCertificates',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_jobs(self, **kwargs):  # noqa: E501
        """list_cloud_jobs  # noqa: E501

        List all cloudpools jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cloud_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_jobs  # noqa: E501

        List all cloudpools jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_cloud_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_jobs`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_jobs`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_jobs`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_jobs`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudJobsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_pools(self, **kwargs):  # noqa: E501
        """list_cloud_pools  # noqa: E501

        List all pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_pools(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudPoolsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cloud_pools_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_pools_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_pools_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_pools  # noqa: E501

        List all pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_pools_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudPoolsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_pools" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_cloud_pools`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_pools`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_pools`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_pools`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_pools`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_pools`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_pools`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/pools', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudPoolsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cloud_proxies(self, **kwargs):  # noqa: E501
        """list_cloud_proxies  # noqa: E501

        List all proxies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_proxies(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudProxiesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cloud_proxies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_cloud_proxies_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_cloud_proxies_with_http_info(self, **kwargs):  # noqa: E501
        """list_cloud_proxies  # noqa: E501

        List all proxies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cloud_proxies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: CloudProxiesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cloud_proxies" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_cloud_proxies`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_proxies`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_cloud_proxies`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_proxies`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_cloud_proxies`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_proxies`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_cloud_proxies`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/cloud/proxies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CloudProxiesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_settings_reporting_eula(self, **kwargs):  # noqa: E501
        """list_settings_reporting_eula  # noqa: E501

        View telemetry collection EULA acceptance and content URI.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_reporting_eula(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsReportingEula
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_settings_reporting_eula_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_settings_reporting_eula_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_settings_reporting_eula_with_http_info(self, **kwargs):  # noqa: E501
        """list_settings_reporting_eula  # noqa: E501

        View telemetry collection EULA acceptance and content URI.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_settings_reporting_eula_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsReportingEula
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_settings_reporting_eula" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings/reporting-eula', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsReportingEula',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_account(self, cloud_account, cloud_account_id, **kwargs):  # noqa: E501
        """update_cloud_account  # noqa: E501

        Modify cloud account.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_account(cloud_account, cloud_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudAccount cloud_account: (required)
        :param str cloud_account_id: Modify cloud account.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cloud_account_with_http_info(cloud_account, cloud_account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_account_with_http_info(cloud_account, cloud_account_id, **kwargs)  # noqa: E501
            return data

    def update_cloud_account_with_http_info(self, cloud_account, cloud_account_id, **kwargs):  # noqa: E501
        """update_cloud_account  # noqa: E501

        Modify cloud account.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_account_with_http_info(cloud_account, cloud_account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudAccount cloud_account: (required)
        :param str cloud_account_id: Modify cloud account.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_account', 'cloud_account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_account' is set
        if ('cloud_account' not in params or
                params['cloud_account'] is None):
            raise ValueError("Missing the required parameter `cloud_account` when calling `update_cloud_account`")  # noqa: E501
        # verify the required parameter 'cloud_account_id' is set
        if ('cloud_account_id' not in params or
                params['cloud_account_id'] is None):
            raise ValueError("Missing the required parameter `cloud_account_id` when calling `update_cloud_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_account_id' in params:
            path_params['CloudAccountId'] = params['cloud_account_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_account' in params:
            body_params = params['cloud_account']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/accounts/{CloudAccountId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_certificate(self, cloud_certificate, cloud_certificate_id, **kwargs):  # noqa: E501
        """update_cloud_certificate  # noqa: E501

        Modify a CloudPools TLS client certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_certificate(cloud_certificate, cloud_certificate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerIdParams cloud_certificate: (required)
        :param str cloud_certificate_id: Modify a CloudPools TLS client certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cloud_certificate_with_http_info(cloud_certificate, cloud_certificate_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_certificate_with_http_info(cloud_certificate, cloud_certificate_id, **kwargs)  # noqa: E501
            return data

    def update_cloud_certificate_with_http_info(self, cloud_certificate, cloud_certificate_id, **kwargs):  # noqa: E501
        """update_cloud_certificate  # noqa: E501

        Modify a CloudPools TLS client certificate.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_certificate_with_http_info(cloud_certificate, cloud_certificate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CertificateServerIdParams cloud_certificate: (required)
        :param str cloud_certificate_id: Modify a CloudPools TLS client certificate. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_certificate', 'cloud_certificate_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_certificate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_certificate' is set
        if ('cloud_certificate' not in params or
                params['cloud_certificate'] is None):
            raise ValueError("Missing the required parameter `cloud_certificate` when calling `update_cloud_certificate`")  # noqa: E501
        # verify the required parameter 'cloud_certificate_id' is set
        if ('cloud_certificate_id' not in params or
                params['cloud_certificate_id'] is None):
            raise ValueError("Missing the required parameter `cloud_certificate_id` when calling `update_cloud_certificate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_certificate_id' in params:
            path_params['CloudCertificateId'] = params['cloud_certificate_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_certificate' in params:
            body_params = params['cloud_certificate']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/certificates/{CloudCertificateId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_job(self, cloud_job, cloud_job_id, **kwargs):  # noqa: E501
        """update_cloud_job  # noqa: E501

        Modify a cloud job or operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_job(cloud_job, cloud_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudJob cloud_job: (required)
        :param str cloud_job_id: Modify a cloud job or operation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cloud_job_with_http_info(cloud_job, cloud_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_job_with_http_info(cloud_job, cloud_job_id, **kwargs)  # noqa: E501
            return data

    def update_cloud_job_with_http_info(self, cloud_job, cloud_job_id, **kwargs):  # noqa: E501
        """update_cloud_job  # noqa: E501

        Modify a cloud job or operation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_job_with_http_info(cloud_job, cloud_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudJob cloud_job: (required)
        :param str cloud_job_id: Modify a cloud job or operation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_job', 'cloud_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_job' is set
        if ('cloud_job' not in params or
                params['cloud_job'] is None):
            raise ValueError("Missing the required parameter `cloud_job` when calling `update_cloud_job`")  # noqa: E501
        # verify the required parameter 'cloud_job_id' is set
        if ('cloud_job_id' not in params or
                params['cloud_job_id'] is None):
            raise ValueError("Missing the required parameter `cloud_job_id` when calling `update_cloud_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_job_id' in params:
            path_params['CloudJobId'] = params['cloud_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_job' in params:
            body_params = params['cloud_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/jobs/{CloudJobId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_pool(self, cloud_pool, cloud_pool_id, **kwargs):  # noqa: E501
        """update_cloud_pool  # noqa: E501

        Modify a cloud pool.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_pool(cloud_pool, cloud_pool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudPool cloud_pool: (required)
        :param str cloud_pool_id: Modify a cloud pool.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cloud_pool_with_http_info(cloud_pool, cloud_pool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_pool_with_http_info(cloud_pool, cloud_pool_id, **kwargs)  # noqa: E501
            return data

    def update_cloud_pool_with_http_info(self, cloud_pool, cloud_pool_id, **kwargs):  # noqa: E501
        """update_cloud_pool  # noqa: E501

        Modify a cloud pool.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_pool_with_http_info(cloud_pool, cloud_pool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudPool cloud_pool: (required)
        :param str cloud_pool_id: Modify a cloud pool.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_pool', 'cloud_pool_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_pool' is set
        if ('cloud_pool' not in params or
                params['cloud_pool'] is None):
            raise ValueError("Missing the required parameter `cloud_pool` when calling `update_cloud_pool`")  # noqa: E501
        # verify the required parameter 'cloud_pool_id' is set
        if ('cloud_pool_id' not in params or
                params['cloud_pool_id'] is None):
            raise ValueError("Missing the required parameter `cloud_pool_id` when calling `update_cloud_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_pool_id' in params:
            path_params['CloudPoolId'] = params['cloud_pool_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_pool' in params:
            body_params = params['cloud_pool']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cloud/pools/{CloudPoolId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_proxy(self, cloud_proxy, cloud_proxy_id, **kwargs):  # noqa: E501
        """update_cloud_proxy  # noqa: E501

        Modify cloud account.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_proxy(cloud_proxy, cloud_proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudProxy cloud_proxy: (required)
        :param str cloud_proxy_id: Modify cloud account.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cloud_proxy_with_http_info(cloud_proxy, cloud_proxy_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_proxy_with_http_info(cloud_proxy, cloud_proxy_id, **kwargs)  # noqa: E501
            return data

    def update_cloud_proxy_with_http_info(self, cloud_proxy, cloud_proxy_id, **kwargs):  # noqa: E501
        """update_cloud_proxy  # noqa: E501

        Modify cloud account.  All fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_proxy_with_http_info(cloud_proxy, cloud_proxy_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudProxy cloud_proxy: (required)
        :param str cloud_proxy_id: Modify cloud account.  All fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_proxy', 'cloud_proxy_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_proxy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_proxy' is set
        if ('cloud_proxy' not in params or
                params['cloud_proxy'] is None):
            raise ValueError("Missing the required parameter `cloud_proxy` when calling `update_cloud_proxy`")  # noqa: E501
        # verify the required parameter 'cloud_proxy_id' is set
        if ('cloud_proxy_id' not in params or
                params['cloud_proxy_id'] is None):
            raise ValueError("Missing the required parameter `cloud_proxy_id` when calling `update_cloud_proxy`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cloud_proxy_id' in params:
            path_params['CloudProxyId'] = params['cloud_proxy_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_proxy' in params:
            body_params = params['cloud_proxy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/cloud/proxies/{CloudProxyId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cloud_settings(self, cloud_settings, **kwargs):  # noqa: E501
        """update_cloud_settings  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_settings(cloud_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudSettingsSettings cloud_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cloud_settings_with_http_info(cloud_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cloud_settings_with_http_info(cloud_settings, **kwargs)  # noqa: E501
            return data

    def update_cloud_settings_with_http_info(self, cloud_settings, **kwargs):  # noqa: E501
        """update_cloud_settings  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_cloud_settings_with_http_info(cloud_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CloudSettingsSettings cloud_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cloud_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cloud_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'cloud_settings' is set
        if ('cloud_settings' not in params or
                params['cloud_settings'] is None):
            raise ValueError("Missing the required parameter `cloud_settings` when calling `update_cloud_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'cloud_settings' in params:
            body_params = params['cloud_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cloud/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
