# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 14
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SnapshotWritableWritableItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created': 'int',
        'dst_path': 'str',
        'id': 'int',
        'log_size': 'int',
        'phys_size': 'int',
        'src_id': 'int',
        'src_path': 'str',
        'src_snap': 'str',
        'state': 'str'
    }

    attribute_map = {
        'created': 'created',
        'dst_path': 'dst_path',
        'id': 'id',
        'log_size': 'log_size',
        'phys_size': 'phys_size',
        'src_id': 'src_id',
        'src_path': 'src_path',
        'src_snap': 'src_snap',
        'state': 'state'
    }

    def __init__(self, created=None, dst_path=None, id=None, log_size=None, phys_size=None, src_id=None, src_path=None, src_snap=None, state=None):  # noqa: E501
        """SnapshotWritableWritableItem - a model defined in Swagger"""  # noqa: E501

        self._created = None
        self._dst_path = None
        self._id = None
        self._log_size = None
        self._phys_size = None
        self._src_id = None
        self._src_path = None
        self._src_snap = None
        self._state = None
        self.discriminator = None

        self.created = created
        self.dst_path = dst_path
        self.id = id
        self.log_size = log_size
        self.phys_size = phys_size
        self.src_id = src_id
        if src_path is not None:
            self.src_path = src_path
        if src_snap is not None:
            self.src_snap = src_snap
        self.state = state

    @property
    def created(self):
        """Gets the created of this SnapshotWritableWritableItem.  # noqa: E501

        The Unix Epoch time the writable snapshot was created.  # noqa: E501

        :return: The created of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this SnapshotWritableWritableItem.

        The Unix Epoch time the writable snapshot was created.  # noqa: E501

        :param created: The created of this SnapshotWritableWritableItem.  # noqa: E501
        :type: int
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")  # noqa: E501
        if created is not None and created > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `created`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if created is not None and created < 0:  # noqa: E501
            raise ValueError("Invalid value for `created`, must be a value greater than or equal to `0`")  # noqa: E501

        self._created = created

    @property
    def dst_path(self):
        """Gets the dst_path of this SnapshotWritableWritableItem.  # noqa: E501

        The user supplied /ifs path of writable snapshot.  # noqa: E501

        :return: The dst_path of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: str
        """
        return self._dst_path

    @dst_path.setter
    def dst_path(self, dst_path):
        """Sets the dst_path of this SnapshotWritableWritableItem.

        The user supplied /ifs path of writable snapshot.  # noqa: E501

        :param dst_path: The dst_path of this SnapshotWritableWritableItem.  # noqa: E501
        :type: str
        """
        if dst_path is None:
            raise ValueError("Invalid value for `dst_path`, must not be `None`")  # noqa: E501
        if dst_path is not None and len(dst_path) > 4096:
            raise ValueError("Invalid value for `dst_path`, length must be less than or equal to `4096`")  # noqa: E501
        if dst_path is not None and len(dst_path) < 4:
            raise ValueError("Invalid value for `dst_path`, length must be greater than or equal to `4`")  # noqa: E501
        if dst_path is not None and not re.search('^\/ifs$|^\/ifs\/', dst_path):  # noqa: E501
            raise ValueError("Invalid value for `dst_path`, must be a follow pattern or equal to `/^\/ifs$|^\/ifs\//`")  # noqa: E501

        self._dst_path = dst_path

    @property
    def id(self):
        """Gets the id of this SnapshotWritableWritableItem.  # noqa: E501

        The system ID given to the writable snapshot. This is useful for debugging.  # noqa: E501

        :return: The id of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SnapshotWritableWritableItem.

        The system ID given to the writable snapshot. This is useful for debugging.  # noqa: E501

        :param id: The id of this SnapshotWritableWritableItem.  # noqa: E501
        :type: int
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if id is not None and id > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if id is not None and id < 0:  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._id = id

    @property
    def log_size(self):
        """Gets the log_size of this SnapshotWritableWritableItem.  # noqa: E501

        The sum in bytes of logical size of files in this writable snapshot.  # noqa: E501

        :return: The log_size of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: int
        """
        return self._log_size

    @log_size.setter
    def log_size(self, log_size):
        """Sets the log_size of this SnapshotWritableWritableItem.

        The sum in bytes of logical size of files in this writable snapshot.  # noqa: E501

        :param log_size: The log_size of this SnapshotWritableWritableItem.  # noqa: E501
        :type: int
        """
        if log_size is None:
            raise ValueError("Invalid value for `log_size`, must not be `None`")  # noqa: E501
        if log_size is not None and log_size > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `log_size`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if log_size is not None and log_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `log_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._log_size = log_size

    @property
    def phys_size(self):
        """Gets the phys_size of this SnapshotWritableWritableItem.  # noqa: E501

        The amount of storage in bytes used to store this writable snapshot.  # noqa: E501

        :return: The phys_size of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: int
        """
        return self._phys_size

    @phys_size.setter
    def phys_size(self, phys_size):
        """Sets the phys_size of this SnapshotWritableWritableItem.

        The amount of storage in bytes used to store this writable snapshot.  # noqa: E501

        :param phys_size: The phys_size of this SnapshotWritableWritableItem.  # noqa: E501
        :type: int
        """
        if phys_size is None:
            raise ValueError("Invalid value for `phys_size`, must not be `None`")  # noqa: E501
        if phys_size is not None and phys_size > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `phys_size`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if phys_size is not None and phys_size < 0:  # noqa: E501
            raise ValueError("Invalid value for `phys_size`, must be a value greater than or equal to `0`")  # noqa: E501

        self._phys_size = phys_size

    @property
    def src_id(self):
        """Gets the src_id of this SnapshotWritableWritableItem.  # noqa: E501

        The system ID of the user supplied source snapshot. This is useful for debugging.  # noqa: E501

        :return: The src_id of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: int
        """
        return self._src_id

    @src_id.setter
    def src_id(self, src_id):
        """Sets the src_id of this SnapshotWritableWritableItem.

        The system ID of the user supplied source snapshot. This is useful for debugging.  # noqa: E501

        :param src_id: The src_id of this SnapshotWritableWritableItem.  # noqa: E501
        :type: int
        """
        if src_id is None:
            raise ValueError("Invalid value for `src_id`, must not be `None`")  # noqa: E501
        if src_id is not None and src_id > 9223372036854775807:  # noqa: E501
            raise ValueError("Invalid value for `src_id`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if src_id is not None and src_id < 0:  # noqa: E501
            raise ValueError("Invalid value for `src_id`, must be a value greater than or equal to `0`")  # noqa: E501

        self._src_id = src_id

    @property
    def src_path(self):
        """Gets the src_path of this SnapshotWritableWritableItem.  # noqa: E501

        The /ifs path of user supplied source snapshot. This will be null for writable snapshots pending delete.  # noqa: E501

        :return: The src_path of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: str
        """
        return self._src_path

    @src_path.setter
    def src_path(self, src_path):
        """Sets the src_path of this SnapshotWritableWritableItem.

        The /ifs path of user supplied source snapshot. This will be null for writable snapshots pending delete.  # noqa: E501

        :param src_path: The src_path of this SnapshotWritableWritableItem.  # noqa: E501
        :type: str
        """
        if src_path is not None and len(src_path) > 4096:
            raise ValueError("Invalid value for `src_path`, length must be less than or equal to `4096`")  # noqa: E501
        if src_path is not None and len(src_path) < 4:
            raise ValueError("Invalid value for `src_path`, length must be greater than or equal to `4`")  # noqa: E501
        if src_path is not None and not re.search('^\/ifs$|^\/ifs\/', src_path):  # noqa: E501
            raise ValueError("Invalid value for `src_path`, must be a follow pattern or equal to `/^\/ifs$|^\/ifs\//`")  # noqa: E501

        self._src_path = src_path

    @property
    def src_snap(self):
        """Gets the src_snap of this SnapshotWritableWritableItem.  # noqa: E501

        The user supplied source snapshot name or ID. This will be null for writable snapshots pending delete.  # noqa: E501

        :return: The src_snap of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: str
        """
        return self._src_snap

    @src_snap.setter
    def src_snap(self, src_snap):
        """Sets the src_snap of this SnapshotWritableWritableItem.

        The user supplied source snapshot name or ID. This will be null for writable snapshots pending delete.  # noqa: E501

        :param src_snap: The src_snap of this SnapshotWritableWritableItem.  # noqa: E501
        :type: str
        """
        if src_snap is not None and len(src_snap) < 0:
            raise ValueError("Invalid value for `src_snap`, length must be greater than or equal to `0`")  # noqa: E501

        self._src_snap = src_snap

    @property
    def state(self):
        """Gets the state of this SnapshotWritableWritableItem.  # noqa: E501

        Writable Snapshot state.  # noqa: E501

        :return: The state of this SnapshotWritableWritableItem.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this SnapshotWritableWritableItem.

        Writable Snapshot state.  # noqa: E501

        :param state: The state of this SnapshotWritableWritableItem.  # noqa: E501
        :type: str
        """
        if state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501
        allowed_values = ["active", "deleting"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotWritableWritableItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
