# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 14
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ClusterUpgradeItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'alert_timeout': 'int',
        'drain_timeout': 'int',
        'exclude_device': 'str',
        'exclude_type': 'str',
        'fw_pkg': 'str',
        'include_device': 'str',
        'include_type': 'str',
        'install_image_path': 'str',
        'no_burn': 'bool',
        'nodes_to_rolling_upgrade': 'list[int]',
        'patch_paths': 'list[str]',
        'skip_optional': 'bool',
        'upgrade_type': 'str'
    }

    attribute_map = {
        'alert_timeout': 'alert_timeout',
        'drain_timeout': 'drain_timeout',
        'exclude_device': 'exclude_device',
        'exclude_type': 'exclude_type',
        'fw_pkg': 'fw_pkg',
        'include_device': 'include_device',
        'include_type': 'include_type',
        'install_image_path': 'install_image_path',
        'no_burn': 'no_burn',
        'nodes_to_rolling_upgrade': 'nodes_to_rolling_upgrade',
        'patch_paths': 'patch_paths',
        'skip_optional': 'skip_optional',
        'upgrade_type': 'upgrade_type'
    }

    def __init__(self, alert_timeout=None, drain_timeout=None, exclude_device=None, exclude_type=None, fw_pkg=None, include_device=None, include_type=None, install_image_path=None, no_burn=None, nodes_to_rolling_upgrade=None, patch_paths=None, skip_optional=None, upgrade_type=None):  # noqa: E501
        """ClusterUpgradeItem - a model defined in Swagger"""  # noqa: E501

        self._alert_timeout = None
        self._drain_timeout = None
        self._exclude_device = None
        self._exclude_type = None
        self._fw_pkg = None
        self._include_device = None
        self._include_type = None
        self._install_image_path = None
        self._no_burn = None
        self._nodes_to_rolling_upgrade = None
        self._patch_paths = None
        self._skip_optional = None
        self._upgrade_type = None
        self.discriminator = None

        if alert_timeout is not None:
            self.alert_timeout = alert_timeout
        if drain_timeout is not None:
            self.drain_timeout = drain_timeout
        if exclude_device is not None:
            self.exclude_device = exclude_device
        if exclude_type is not None:
            self.exclude_type = exclude_type
        if fw_pkg is not None:
            self.fw_pkg = fw_pkg
        if include_device is not None:
            self.include_device = include_device
        if include_type is not None:
            self.include_type = include_type
        if install_image_path is not None:
            self.install_image_path = install_image_path
        if no_burn is not None:
            self.no_burn = no_burn
        if nodes_to_rolling_upgrade is not None:
            self.nodes_to_rolling_upgrade = nodes_to_rolling_upgrade
        if patch_paths is not None:
            self.patch_paths = patch_paths
        if skip_optional is not None:
            self.skip_optional = skip_optional
        self.upgrade_type = upgrade_type

    @property
    def alert_timeout(self):
        """Gets the alert_timeout of this ClusterUpgradeItem.  # noqa: E501

        The duration in seconds after drain begins that an alert will be raised. An alert timeout must be set to a smaller value than the drain timeout to be used. If not specified, an alert will not be raised (legacy behavior).  # noqa: E501

        :return: The alert_timeout of this ClusterUpgradeItem.  # noqa: E501
        :rtype: int
        """
        return self._alert_timeout

    @alert_timeout.setter
    def alert_timeout(self, alert_timeout):
        """Sets the alert_timeout of this ClusterUpgradeItem.

        The duration in seconds after drain begins that an alert will be raised. An alert timeout must be set to a smaller value than the drain timeout to be used. If not specified, an alert will not be raised (legacy behavior).  # noqa: E501

        :param alert_timeout: The alert_timeout of this ClusterUpgradeItem.  # noqa: E501
        :type: int
        """
        if alert_timeout is not None and alert_timeout > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `alert_timeout`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if alert_timeout is not None and alert_timeout < 1:  # noqa: E501
            raise ValueError("Invalid value for `alert_timeout`, must be a value greater than or equal to `1`")  # noqa: E501

        self._alert_timeout = alert_timeout

    @property
    def drain_timeout(self):
        """Gets the drain_timeout of this ClusterUpgradeItem.  # noqa: E501

        The duration in seconds that upgrade waits for all SMB clients to disconnect from a node before rebooting it. A value of 0 means wait indefinitely. If not specified, upgrade proceeds with reboots regardless of SMB client connections (legacy behavior).  # noqa: E501

        :return: The drain_timeout of this ClusterUpgradeItem.  # noqa: E501
        :rtype: int
        """
        return self._drain_timeout

    @drain_timeout.setter
    def drain_timeout(self, drain_timeout):
        """Sets the drain_timeout of this ClusterUpgradeItem.

        The duration in seconds that upgrade waits for all SMB clients to disconnect from a node before rebooting it. A value of 0 means wait indefinitely. If not specified, upgrade proceeds with reboots regardless of SMB client connections (legacy behavior).  # noqa: E501

        :param drain_timeout: The drain_timeout of this ClusterUpgradeItem.  # noqa: E501
        :type: int
        """
        if drain_timeout is not None and drain_timeout > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for `drain_timeout`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if drain_timeout is not None and drain_timeout < 0:  # noqa: E501
            raise ValueError("Invalid value for `drain_timeout`, must be a value greater than or equal to `0`")  # noqa: E501

        self._drain_timeout = drain_timeout

    @property
    def exclude_device(self):
        """Gets the exclude_device of this ClusterUpgradeItem.  # noqa: E501

        Exclude the specified devices in the firmware upgrade.  # noqa: E501

        :return: The exclude_device of this ClusterUpgradeItem.  # noqa: E501
        :rtype: str
        """
        return self._exclude_device

    @exclude_device.setter
    def exclude_device(self, exclude_device):
        """Sets the exclude_device of this ClusterUpgradeItem.

        Exclude the specified devices in the firmware upgrade.  # noqa: E501

        :param exclude_device: The exclude_device of this ClusterUpgradeItem.  # noqa: E501
        :type: str
        """
        if exclude_device is not None and len(exclude_device) > 128:
            raise ValueError("Invalid value for `exclude_device`, length must be less than or equal to `128`")  # noqa: E501
        if exclude_device is not None and len(exclude_device) < 1:
            raise ValueError("Invalid value for `exclude_device`, length must be greater than or equal to `1`")  # noqa: E501

        self._exclude_device = exclude_device

    @property
    def exclude_type(self):
        """Gets the exclude_type of this ClusterUpgradeItem.  # noqa: E501

        Exclude the specified device type in the firmware upgrade.  # noqa: E501

        :return: The exclude_type of this ClusterUpgradeItem.  # noqa: E501
        :rtype: str
        """
        return self._exclude_type

    @exclude_type.setter
    def exclude_type(self, exclude_type):
        """Sets the exclude_type of this ClusterUpgradeItem.

        Exclude the specified device type in the firmware upgrade.  # noqa: E501

        :param exclude_type: The exclude_type of this ClusterUpgradeItem.  # noqa: E501
        :type: str
        """
        if exclude_type is not None and len(exclude_type) > 128:
            raise ValueError("Invalid value for `exclude_type`, length must be less than or equal to `128`")  # noqa: E501
        if exclude_type is not None and len(exclude_type) < 1:
            raise ValueError("Invalid value for `exclude_type`, length must be greater than or equal to `1`")  # noqa: E501

        self._exclude_type = exclude_type

    @property
    def fw_pkg(self):
        """Gets the fw_pkg of this ClusterUpgradeItem.  # noqa: E501

        The location (path) of the firmware package which must be within /ifs.  # noqa: E501

        :return: The fw_pkg of this ClusterUpgradeItem.  # noqa: E501
        :rtype: str
        """
        return self._fw_pkg

    @fw_pkg.setter
    def fw_pkg(self, fw_pkg):
        """Sets the fw_pkg of this ClusterUpgradeItem.

        The location (path) of the firmware package which must be within /ifs.  # noqa: E501

        :param fw_pkg: The fw_pkg of this ClusterUpgradeItem.  # noqa: E501
        :type: str
        """
        if fw_pkg is not None and len(fw_pkg) > 4096:
            raise ValueError("Invalid value for `fw_pkg`, length must be less than or equal to `4096`")  # noqa: E501
        if fw_pkg is not None and len(fw_pkg) < 3:
            raise ValueError("Invalid value for `fw_pkg`, length must be greater than or equal to `3`")  # noqa: E501

        self._fw_pkg = fw_pkg

    @property
    def include_device(self):
        """Gets the include_device of this ClusterUpgradeItem.  # noqa: E501

        Include the specified devices in the firmware upgrade.  # noqa: E501

        :return: The include_device of this ClusterUpgradeItem.  # noqa: E501
        :rtype: str
        """
        return self._include_device

    @include_device.setter
    def include_device(self, include_device):
        """Sets the include_device of this ClusterUpgradeItem.

        Include the specified devices in the firmware upgrade.  # noqa: E501

        :param include_device: The include_device of this ClusterUpgradeItem.  # noqa: E501
        :type: str
        """
        if include_device is not None and len(include_device) > 128:
            raise ValueError("Invalid value for `include_device`, length must be less than or equal to `128`")  # noqa: E501
        if include_device is not None and len(include_device) < 1:
            raise ValueError("Invalid value for `include_device`, length must be greater than or equal to `1`")  # noqa: E501

        self._include_device = include_device

    @property
    def include_type(self):
        """Gets the include_type of this ClusterUpgradeItem.  # noqa: E501

        Include the specified device type in the firmware upgrade.  # noqa: E501

        :return: The include_type of this ClusterUpgradeItem.  # noqa: E501
        :rtype: str
        """
        return self._include_type

    @include_type.setter
    def include_type(self, include_type):
        """Sets the include_type of this ClusterUpgradeItem.

        Include the specified device type in the firmware upgrade.  # noqa: E501

        :param include_type: The include_type of this ClusterUpgradeItem.  # noqa: E501
        :type: str
        """
        if include_type is not None and len(include_type) > 128:
            raise ValueError("Invalid value for `include_type`, length must be less than or equal to `128`")  # noqa: E501
        if include_type is not None and len(include_type) < 1:
            raise ValueError("Invalid value for `include_type`, length must be greater than or equal to `1`")  # noqa: E501

        self._include_type = include_type

    @property
    def install_image_path(self):
        """Gets the install_image_path of this ClusterUpgradeItem.  # noqa: E501

        The location (path) of the upgrade image which must be within /ifs.  # noqa: E501

        :return: The install_image_path of this ClusterUpgradeItem.  # noqa: E501
        :rtype: str
        """
        return self._install_image_path

    @install_image_path.setter
    def install_image_path(self, install_image_path):
        """Sets the install_image_path of this ClusterUpgradeItem.

        The location (path) of the upgrade image which must be within /ifs.  # noqa: E501

        :param install_image_path: The install_image_path of this ClusterUpgradeItem.  # noqa: E501
        :type: str
        """
        if install_image_path is not None and len(install_image_path) > 4096:
            raise ValueError("Invalid value for `install_image_path`, length must be less than or equal to `4096`")  # noqa: E501
        if install_image_path is not None and len(install_image_path) < 1:
            raise ValueError("Invalid value for `install_image_path`, length must be greater than or equal to `1`")  # noqa: E501

        self._install_image_path = install_image_path

    @property
    def no_burn(self):
        """Gets the no_burn of this ClusterUpgradeItem.  # noqa: E501

        Do not burn the firmware.  # noqa: E501

        :return: The no_burn of this ClusterUpgradeItem.  # noqa: E501
        :rtype: bool
        """
        return self._no_burn

    @no_burn.setter
    def no_burn(self, no_burn):
        """Sets the no_burn of this ClusterUpgradeItem.

        Do not burn the firmware.  # noqa: E501

        :param no_burn: The no_burn of this ClusterUpgradeItem.  # noqa: E501
        :type: bool
        """

        self._no_burn = no_burn

    @property
    def nodes_to_rolling_upgrade(self):
        """Gets the nodes_to_rolling_upgrade of this ClusterUpgradeItem.  # noqa: E501

        The nodes (to be) scheduled for upgrade ordered by queue position number. Null if the cluster_state is 'partially upgraded' or upgrade_type is 'simultaneous'. One of the following values: [<lnn-1>, <lnn-2>, ... ], 'all', null  # noqa: E501

        :return: The nodes_to_rolling_upgrade of this ClusterUpgradeItem.  # noqa: E501
        :rtype: list[int]
        """
        return self._nodes_to_rolling_upgrade

    @nodes_to_rolling_upgrade.setter
    def nodes_to_rolling_upgrade(self, nodes_to_rolling_upgrade):
        """Sets the nodes_to_rolling_upgrade of this ClusterUpgradeItem.

        The nodes (to be) scheduled for upgrade ordered by queue position number. Null if the cluster_state is 'partially upgraded' or upgrade_type is 'simultaneous'. One of the following values: [<lnn-1>, <lnn-2>, ... ], 'all', null  # noqa: E501

        :param nodes_to_rolling_upgrade: The nodes_to_rolling_upgrade of this ClusterUpgradeItem.  # noqa: E501
        :type: list[int]
        """

        self._nodes_to_rolling_upgrade = nodes_to_rolling_upgrade

    @property
    def patch_paths(self):
        """Gets the patch_paths of this ClusterUpgradeItem.  # noqa: E501

        List of additional patches to install during the upgrade.  # noqa: E501

        :return: The patch_paths of this ClusterUpgradeItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._patch_paths

    @patch_paths.setter
    def patch_paths(self, patch_paths):
        """Sets the patch_paths of this ClusterUpgradeItem.

        List of additional patches to install during the upgrade.  # noqa: E501

        :param patch_paths: The patch_paths of this ClusterUpgradeItem.  # noqa: E501
        :type: list[str]
        """

        self._patch_paths = patch_paths

    @property
    def skip_optional(self):
        """Gets the skip_optional of this ClusterUpgradeItem.  # noqa: E501

        Used to indicate that the pre-upgrade check should be skipped.  # noqa: E501

        :return: The skip_optional of this ClusterUpgradeItem.  # noqa: E501
        :rtype: bool
        """
        return self._skip_optional

    @skip_optional.setter
    def skip_optional(self, skip_optional):
        """Sets the skip_optional of this ClusterUpgradeItem.

        Used to indicate that the pre-upgrade check should be skipped.  # noqa: E501

        :param skip_optional: The skip_optional of this ClusterUpgradeItem.  # noqa: E501
        :type: bool
        """

        self._skip_optional = skip_optional

    @property
    def upgrade_type(self):
        """Gets the upgrade_type of this ClusterUpgradeItem.  # noqa: E501

        The type of upgrade to perform. One of the following values: 'rolling', 'simultaneous, parallel'  # noqa: E501

        :return: The upgrade_type of this ClusterUpgradeItem.  # noqa: E501
        :rtype: str
        """
        return self._upgrade_type

    @upgrade_type.setter
    def upgrade_type(self, upgrade_type):
        """Sets the upgrade_type of this ClusterUpgradeItem.

        The type of upgrade to perform. One of the following values: 'rolling', 'simultaneous, parallel'  # noqa: E501

        :param upgrade_type: The upgrade_type of this ClusterUpgradeItem.  # noqa: E501
        :type: str
        """
        if upgrade_type is None:
            raise ValueError("Invalid value for `upgrade_type`, must not be `None`")  # noqa: E501
        allowed_values = ["rolling", "parallel", "simultaneous"]  # noqa: E501
        if upgrade_type not in allowed_values:
            raise ValueError(
                "Invalid value for `upgrade_type` ({0}), must be one of {1}"  # noqa: E501
                .format(upgrade_type, allowed_values)
            )

        self._upgrade_type = upgrade_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterUpgradeItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
