# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 14
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_3_0.api_client import ApiClient


class PerformanceDatasetsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_dataset_filter(self, dataset_filter, dataset, **kwargs):  # noqa: E501
        """create_dataset_filter  # noqa: E501

        Create a new filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dataset_filter(dataset_filter, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetFilterCreateParams dataset_filter: (required)
        :param str dataset: (required)
        :param bool force: For use by support only.
        :return: CreateDatasetFilterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_dataset_filter_with_http_info(dataset_filter, dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.create_dataset_filter_with_http_info(dataset_filter, dataset, **kwargs)  # noqa: E501
            return data

    def create_dataset_filter_with_http_info(self, dataset_filter, dataset, **kwargs):  # noqa: E501
        """create_dataset_filter  # noqa: E501

        Create a new filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dataset_filter_with_http_info(dataset_filter, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetFilterCreateParams dataset_filter: (required)
        :param str dataset: (required)
        :param bool force: For use by support only.
        :return: CreateDatasetFilterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_filter', 'dataset', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_dataset_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_filter' is set
        if ('dataset_filter' not in params or
                params['dataset_filter'] is None):
            raise ValueError("Missing the required parameter `dataset_filter` when calling `create_dataset_filter`")  # noqa: E501
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `create_dataset_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dataset_filter' in params:
            body_params = params['dataset_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/filters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateDatasetFilterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_dataset_workload(self, dataset_workload, dataset, **kwargs):  # noqa: E501
        """create_dataset_workload  # noqa: E501

        Create a new workload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dataset_workload(dataset_workload, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetWorkloadCreateParams dataset_workload: (required)
        :param str dataset: (required)
        :param bool force: For use by support only.
        :return: CreateDatasetWorkloadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_dataset_workload_with_http_info(dataset_workload, dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.create_dataset_workload_with_http_info(dataset_workload, dataset, **kwargs)  # noqa: E501
            return data

    def create_dataset_workload_with_http_info(self, dataset_workload, dataset, **kwargs):  # noqa: E501
        """create_dataset_workload  # noqa: E501

        Create a new workload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dataset_workload_with_http_info(dataset_workload, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetWorkloadCreateParams dataset_workload: (required)
        :param str dataset: (required)
        :param bool force: For use by support only.
        :return: CreateDatasetWorkloadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_workload', 'dataset', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_dataset_workload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_workload' is set
        if ('dataset_workload' not in params or
                params['dataset_workload'] is None):
            raise ValueError("Missing the required parameter `dataset_workload` when calling `create_dataset_workload`")  # noqa: E501
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `create_dataset_workload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dataset_workload' in params:
            body_params = params['dataset_workload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/workloads', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateDatasetWorkloadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dataset_filter(self, dataset_filter_id, dataset, **kwargs):  # noqa: E501
        """delete_dataset_filter  # noqa: E501

        Delete the filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_filter(dataset_filter_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_filter_id: Delete the filter. (required)
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dataset_filter_with_http_info(dataset_filter_id, dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dataset_filter_with_http_info(dataset_filter_id, dataset, **kwargs)  # noqa: E501
            return data

    def delete_dataset_filter_with_http_info(self, dataset_filter_id, dataset, **kwargs):  # noqa: E501
        """delete_dataset_filter  # noqa: E501

        Delete the filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_filter_with_http_info(dataset_filter_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_filter_id: Delete the filter. (required)
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_filter_id', 'dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataset_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_filter_id' is set
        if ('dataset_filter_id' not in params or
                params['dataset_filter_id'] is None):
            raise ValueError("Missing the required parameter `dataset_filter_id` when calling `delete_dataset_filter`")  # noqa: E501
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `delete_dataset_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_filter_id' in params:
            path_params['DatasetFilterId'] = params['dataset_filter_id']  # noqa: E501
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/filters/{DatasetFilterId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dataset_filters(self, dataset, **kwargs):  # noqa: E501
        """delete_dataset_filters  # noqa: E501

        Delete all filters associated with the dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_filters(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dataset_filters_with_http_info(dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dataset_filters_with_http_info(dataset, **kwargs)  # noqa: E501
            return data

    def delete_dataset_filters_with_http_info(self, dataset, **kwargs):  # noqa: E501
        """delete_dataset_filters  # noqa: E501

        Delete all filters associated with the dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_filters_with_http_info(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataset_filters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `delete_dataset_filters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/filters', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dataset_workload(self, dataset_workload_id, dataset, **kwargs):  # noqa: E501
        """delete_dataset_workload  # noqa: E501

        Delete the workload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_workload(dataset_workload_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_workload_id: Delete the workload. (required)
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dataset_workload_with_http_info(dataset_workload_id, dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dataset_workload_with_http_info(dataset_workload_id, dataset, **kwargs)  # noqa: E501
            return data

    def delete_dataset_workload_with_http_info(self, dataset_workload_id, dataset, **kwargs):  # noqa: E501
        """delete_dataset_workload  # noqa: E501

        Delete the workload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_workload_with_http_info(dataset_workload_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_workload_id: Delete the workload. (required)
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_workload_id', 'dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataset_workload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_workload_id' is set
        if ('dataset_workload_id' not in params or
                params['dataset_workload_id'] is None):
            raise ValueError("Missing the required parameter `dataset_workload_id` when calling `delete_dataset_workload`")  # noqa: E501
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `delete_dataset_workload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_workload_id' in params:
            path_params['DatasetWorkloadId'] = params['dataset_workload_id']  # noqa: E501
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/workloads/{DatasetWorkloadId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dataset_workloads(self, dataset, **kwargs):  # noqa: E501
        """delete_dataset_workloads  # noqa: E501

        Delete all workloads associated with the dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_workloads(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dataset_workloads_with_http_info(dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_dataset_workloads_with_http_info(dataset, **kwargs)  # noqa: E501
            return data

    def delete_dataset_workloads_with_http_info(self, dataset, **kwargs):  # noqa: E501
        """delete_dataset_workloads  # noqa: E501

        Delete all workloads associated with the dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dataset_workloads_with_http_info(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataset_workloads" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `delete_dataset_workloads`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/workloads', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset_filter(self, dataset_filter_id, dataset, **kwargs):  # noqa: E501
        """get_dataset_filter  # noqa: E501

        Retrieve the filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_filter(dataset_filter_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_filter_id: Retrieve the filter. (required)
        :param str dataset: (required)
        :return: DatasetFilters
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_filter_with_http_info(dataset_filter_id, dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_filter_with_http_info(dataset_filter_id, dataset, **kwargs)  # noqa: E501
            return data

    def get_dataset_filter_with_http_info(self, dataset_filter_id, dataset, **kwargs):  # noqa: E501
        """get_dataset_filter  # noqa: E501

        Retrieve the filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_filter_with_http_info(dataset_filter_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_filter_id: Retrieve the filter. (required)
        :param str dataset: (required)
        :return: DatasetFilters
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_filter_id', 'dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_filter_id' is set
        if ('dataset_filter_id' not in params or
                params['dataset_filter_id'] is None):
            raise ValueError("Missing the required parameter `dataset_filter_id` when calling `get_dataset_filter`")  # noqa: E501
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `get_dataset_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_filter_id' in params:
            path_params['DatasetFilterId'] = params['dataset_filter_id']  # noqa: E501
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/filters/{DatasetFilterId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatasetFilters',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset_workload(self, dataset_workload_id, dataset, **kwargs):  # noqa: E501
        """get_dataset_workload  # noqa: E501

        Retrieve the workload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_workload(dataset_workload_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_workload_id: Retrieve the workload. (required)
        :param str dataset: (required)
        :return: DatasetWorkloads
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_workload_with_http_info(dataset_workload_id, dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_workload_with_http_info(dataset_workload_id, dataset, **kwargs)  # noqa: E501
            return data

    def get_dataset_workload_with_http_info(self, dataset_workload_id, dataset, **kwargs):  # noqa: E501
        """get_dataset_workload  # noqa: E501

        Retrieve the workload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_workload_with_http_info(dataset_workload_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_workload_id: Retrieve the workload. (required)
        :param str dataset: (required)
        :return: DatasetWorkloads
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_workload_id', 'dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_workload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_workload_id' is set
        if ('dataset_workload_id' not in params or
                params['dataset_workload_id'] is None):
            raise ValueError("Missing the required parameter `dataset_workload_id` when calling `get_dataset_workload`")  # noqa: E501
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `get_dataset_workload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_workload_id' in params:
            path_params['DatasetWorkloadId'] = params['dataset_workload_id']  # noqa: E501
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/workloads/{DatasetWorkloadId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatasetWorkloads',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_dataset_filters(self, dataset, **kwargs):  # noqa: E501
        """list_dataset_filters  # noqa: E501

        List all filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataset_filters(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: DatasetFiltersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_dataset_filters_with_http_info(dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.list_dataset_filters_with_http_info(dataset, **kwargs)  # noqa: E501
            return data

    def list_dataset_filters_with_http_info(self, dataset, **kwargs):  # noqa: E501
        """list_dataset_filters  # noqa: E501

        List all filters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataset_filters_with_http_info(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: DatasetFiltersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset', 'dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_dataset_filters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `list_dataset_filters`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_dataset_filters`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_dataset_filters`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_dataset_filters`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_dataset_filters`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_dataset_filters`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_dataset_filters`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_dataset_filters`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/filters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatasetFiltersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_dataset_workloads(self, dataset, **kwargs):  # noqa: E501
        """list_dataset_workloads  # noqa: E501

        List all workloads.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataset_workloads(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: DatasetWorkloadsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_dataset_workloads_with_http_info(dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.list_dataset_workloads_with_http_info(dataset, **kwargs)  # noqa: E501
            return data

    def list_dataset_workloads_with_http_info(self, dataset, **kwargs):  # noqa: E501
        """list_dataset_workloads  # noqa: E501

        List all workloads.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_dataset_workloads_with_http_info(dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: DatasetWorkloadsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset', 'dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_dataset_workloads" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `list_dataset_workloads`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_dataset_workloads`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_dataset_workloads`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_dataset_workloads`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_dataset_workloads`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_dataset_workloads`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_dataset_workloads`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_dataset_workloads`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/workloads', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatasetWorkloadsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dataset_filter(self, dataset_filter, dataset_filter_id, dataset, **kwargs):  # noqa: E501
        """update_dataset_filter  # noqa: E501

        Modify the filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_filter(dataset_filter, dataset_filter_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetFilter dataset_filter: (required)
        :param str dataset_filter_id: Modify the filter. (required)
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dataset_filter_with_http_info(dataset_filter, dataset_filter_id, dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dataset_filter_with_http_info(dataset_filter, dataset_filter_id, dataset, **kwargs)  # noqa: E501
            return data

    def update_dataset_filter_with_http_info(self, dataset_filter, dataset_filter_id, dataset, **kwargs):  # noqa: E501
        """update_dataset_filter  # noqa: E501

        Modify the filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_filter_with_http_info(dataset_filter, dataset_filter_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetFilter dataset_filter: (required)
        :param str dataset_filter_id: Modify the filter. (required)
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_filter', 'dataset_filter_id', 'dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dataset_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_filter' is set
        if ('dataset_filter' not in params or
                params['dataset_filter'] is None):
            raise ValueError("Missing the required parameter `dataset_filter` when calling `update_dataset_filter`")  # noqa: E501
        # verify the required parameter 'dataset_filter_id' is set
        if ('dataset_filter_id' not in params or
                params['dataset_filter_id'] is None):
            raise ValueError("Missing the required parameter `dataset_filter_id` when calling `update_dataset_filter`")  # noqa: E501
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `update_dataset_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_filter_id' in params:
            path_params['DatasetFilterId'] = params['dataset_filter_id']  # noqa: E501
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dataset_filter' in params:
            body_params = params['dataset_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/filters/{DatasetFilterId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dataset_workload(self, dataset_workload, dataset_workload_id, dataset, **kwargs):  # noqa: E501
        """update_dataset_workload  # noqa: E501

        Modify the workload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_workload(dataset_workload, dataset_workload_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetWorkload dataset_workload: (required)
        :param str dataset_workload_id: Modify the workload. (required)
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dataset_workload_with_http_info(dataset_workload, dataset_workload_id, dataset, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dataset_workload_with_http_info(dataset_workload, dataset_workload_id, dataset, **kwargs)  # noqa: E501
            return data

    def update_dataset_workload_with_http_info(self, dataset_workload, dataset_workload_id, dataset, **kwargs):  # noqa: E501
        """update_dataset_workload  # noqa: E501

        Modify the workload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_workload_with_http_info(dataset_workload, dataset_workload_id, dataset, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatasetWorkload dataset_workload: (required)
        :param str dataset_workload_id: Modify the workload. (required)
        :param str dataset: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_workload', 'dataset_workload_id', 'dataset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dataset_workload" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_workload' is set
        if ('dataset_workload' not in params or
                params['dataset_workload'] is None):
            raise ValueError("Missing the required parameter `dataset_workload` when calling `update_dataset_workload`")  # noqa: E501
        # verify the required parameter 'dataset_workload_id' is set
        if ('dataset_workload_id' not in params or
                params['dataset_workload_id'] is None):
            raise ValueError("Missing the required parameter `dataset_workload_id` when calling `update_dataset_workload`")  # noqa: E501
        # verify the required parameter 'dataset' is set
        if ('dataset' not in params or
                params['dataset'] is None):
            raise ValueError("Missing the required parameter `dataset` when calling `update_dataset_workload`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_workload_id' in params:
            path_params['DatasetWorkloadId'] = params['dataset_workload_id']  # noqa: E501
        if 'dataset' in params:
            path_params['Dataset'] = params['dataset']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'dataset_workload' in params:
            body_params = params['dataset_workload']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/performance/datasets/{Dataset}/workloads/{DatasetWorkloadId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
