# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class HealthcheckChecklistDeliveryItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'address': 'list[str]',
        'email_host': 'str',
        'email_pass': 'str',
        'email_port': 'int',
        'email_security': 'str',
        'email_user': 'str',
        'failonly': 'bool',
        'method': 'str'
    }

    attribute_map = {
        'address': 'address',
        'email_host': 'email_host',
        'email_pass': 'email_pass',
        'email_port': 'email_port',
        'email_security': 'email_security',
        'email_user': 'email_user',
        'failonly': 'failonly',
        'method': 'method'
    }

    def __init__(self, address=None, email_host=None, email_pass=None, email_port=None, email_security=None, email_user=None, failonly=None, method=None):  # noqa: E501
        """HealthcheckChecklistDeliveryItem - a model defined in Swagger"""  # noqa: E501

        self._address = None
        self._email_host = None
        self._email_pass = None
        self._email_port = None
        self._email_security = None
        self._email_user = None
        self._failonly = None
        self._method = None
        self.discriminator = None

        if address is not None:
            self.address = address
        if email_host is not None:
            self.email_host = email_host
        if email_pass is not None:
            self.email_pass = email_pass
        if email_port is not None:
            self.email_port = email_port
        if email_security is not None:
            self.email_security = email_security
        if email_user is not None:
            self.email_user = email_user
        self.failonly = failonly
        self.method = method

    @property
    def address(self):
        """Gets the address of this HealthcheckChecklistDeliveryItem.  # noqa: E501

        Email addresses to send to.  # noqa: E501

        :return: The address of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._address

    @address.setter
    def address(self, address):
        """Sets the address of this HealthcheckChecklistDeliveryItem.

        Email addresses to send to.  # noqa: E501

        :param address: The address of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :type: list[str]
        """

        self._address = address

    @property
    def email_host(self):
        """Gets the email_host of this HealthcheckChecklistDeliveryItem.  # noqa: E501

        SMTP relay host.  # noqa: E501

        :return: The email_host of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :rtype: str
        """
        return self._email_host

    @email_host.setter
    def email_host(self, email_host):
        """Sets the email_host of this HealthcheckChecklistDeliveryItem.

        SMTP relay host.  # noqa: E501

        :param email_host: The email_host of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :type: str
        """
        if email_host is not None and len(email_host) > 255:
            raise ValueError("Invalid value for `email_host`, length must be less than or equal to `255`")  # noqa: E501
        if email_host is not None and len(email_host) < 0:
            raise ValueError("Invalid value for `email_host`, length must be greater than or equal to `0`")  # noqa: E501

        self._email_host = email_host

    @property
    def email_pass(self):
        """Gets the email_pass of this HealthcheckChecklistDeliveryItem.  # noqa: E501

        Password for SMTP authentication.  # noqa: E501

        :return: The email_pass of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :rtype: str
        """
        return self._email_pass

    @email_pass.setter
    def email_pass(self, email_pass):
        """Sets the email_pass of this HealthcheckChecklistDeliveryItem.

        Password for SMTP authentication.  # noqa: E501

        :param email_pass: The email_pass of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :type: str
        """
        if email_pass is not None and len(email_pass) > 255:
            raise ValueError("Invalid value for `email_pass`, length must be less than or equal to `255`")  # noqa: E501
        if email_pass is not None and len(email_pass) < 0:
            raise ValueError("Invalid value for `email_pass`, length must be greater than or equal to `0`")  # noqa: E501

        self._email_pass = email_pass

    @property
    def email_port(self):
        """Gets the email_port of this HealthcheckChecklistDeliveryItem.  # noqa: E501

        SMTP relay port - optional defaults to 25.  # noqa: E501

        :return: The email_port of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :rtype: int
        """
        return self._email_port

    @email_port.setter
    def email_port(self, email_port):
        """Sets the email_port of this HealthcheckChecklistDeliveryItem.

        SMTP relay port - optional defaults to 25.  # noqa: E501

        :param email_port: The email_port of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :type: int
        """
        if email_port is not None and email_port > 65535:  # noqa: E501
            raise ValueError("Invalid value for `email_port`, must be a value less than or equal to `65535`")  # noqa: E501
        if email_port is not None and email_port < 1:  # noqa: E501
            raise ValueError("Invalid value for `email_port`, must be a value greater than or equal to `1`")  # noqa: E501

        self._email_port = email_port

    @property
    def email_security(self):
        """Gets the email_security of this HealthcheckChecklistDeliveryItem.  # noqa: E501

        Encryption protocol to use for SMTP.  # noqa: E501

        :return: The email_security of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :rtype: str
        """
        return self._email_security

    @email_security.setter
    def email_security(self, email_security):
        """Sets the email_security of this HealthcheckChecklistDeliveryItem.

        Encryption protocol to use for SMTP.  # noqa: E501

        :param email_security: The email_security of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :type: str
        """
        allowed_values = ["NONE", "STARTTLS"]  # noqa: E501
        if email_security not in allowed_values:
            raise ValueError(
                "Invalid value for `email_security` ({0}), must be one of {1}"  # noqa: E501
                .format(email_security, allowed_values)
            )

        self._email_security = email_security

    @property
    def email_user(self):
        """Gets the email_user of this HealthcheckChecklistDeliveryItem.  # noqa: E501

        Username for SMTP authentication.  # noqa: E501

        :return: The email_user of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :rtype: str
        """
        return self._email_user

    @email_user.setter
    def email_user(self, email_user):
        """Sets the email_user of this HealthcheckChecklistDeliveryItem.

        Username for SMTP authentication.  # noqa: E501

        :param email_user: The email_user of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :type: str
        """
        if email_user is not None and len(email_user) > 255:
            raise ValueError("Invalid value for `email_user`, length must be less than or equal to `255`")  # noqa: E501
        if email_user is not None and len(email_user) < 0:
            raise ValueError("Invalid value for `email_user`, length must be greater than or equal to `0`")  # noqa: E501

        self._email_user = email_user

    @property
    def failonly(self):
        """Gets the failonly of this HealthcheckChecklistDeliveryItem.  # noqa: E501

        Only send failures  # noqa: E501

        :return: The failonly of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :rtype: bool
        """
        return self._failonly

    @failonly.setter
    def failonly(self, failonly):
        """Sets the failonly of this HealthcheckChecklistDeliveryItem.

        Only send failures  # noqa: E501

        :param failonly: The failonly of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :type: bool
        """
        if failonly is None:
            raise ValueError("Invalid value for `failonly`, must not be `None`")  # noqa: E501

        self._failonly = failonly

    @property
    def method(self):
        """Gets the method of this HealthcheckChecklistDeliveryItem.  # noqa: E501

        Delivery method  # noqa: E501

        :return: The method of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this HealthcheckChecklistDeliveryItem.

        Delivery method  # noqa: E501

        :param method: The method of this HealthcheckChecklistDeliveryItem.  # noqa: E501
        :type: str
        """
        if method is None:
            raise ValueError("Invalid value for `method`, must not be `None`")  # noqa: E501
        allowed_values = ["EMAIL"]  # noqa: E501
        if method not in allowed_values:
            raise ValueError(
                "Invalid value for `method` ({0}), must be one of {1}"  # noqa: E501
                .format(method, allowed_values)
            )

        self._method = method

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HealthcheckChecklistDeliveryItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
