# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_2_1.api_client import ApiClient


class StoragepoolApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_storagepool_nodepool(self, storagepool_nodepool, **kwargs):  # noqa: E501
        """create_storagepool_nodepool  # noqa: E501

        Create a new node pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_storagepool_nodepool(storagepool_nodepool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolNodepoolCreateParams storagepool_nodepool: (required)
        :return: CreateStoragepoolTierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_storagepool_nodepool_with_http_info(storagepool_nodepool, **kwargs)  # noqa: E501
        else:
            (data) = self.create_storagepool_nodepool_with_http_info(storagepool_nodepool, **kwargs)  # noqa: E501
            return data

    def create_storagepool_nodepool_with_http_info(self, storagepool_nodepool, **kwargs):  # noqa: E501
        """create_storagepool_nodepool  # noqa: E501

        Create a new node pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_storagepool_nodepool_with_http_info(storagepool_nodepool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolNodepoolCreateParams storagepool_nodepool: (required)
        :return: CreateStoragepoolTierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_nodepool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_storagepool_nodepool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_nodepool' is set
        if ('storagepool_nodepool' not in params or
                params['storagepool_nodepool'] is None):
            raise ValueError("Missing the required parameter `storagepool_nodepool` when calling `create_storagepool_nodepool`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'storagepool_nodepool' in params:
            body_params = params['storagepool_nodepool']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/storagepool/nodepools', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateStoragepoolTierResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_storagepool_tier(self, storagepool_tier, **kwargs):  # noqa: E501
        """create_storagepool_tier  # noqa: E501

        Create a new tier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_storagepool_tier(storagepool_tier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolTierCreateParams storagepool_tier: (required)
        :return: CreateStoragepoolTierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_storagepool_tier_with_http_info(storagepool_tier, **kwargs)  # noqa: E501
        else:
            (data) = self.create_storagepool_tier_with_http_info(storagepool_tier, **kwargs)  # noqa: E501
            return data

    def create_storagepool_tier_with_http_info(self, storagepool_tier, **kwargs):  # noqa: E501
        """create_storagepool_tier  # noqa: E501

        Create a new tier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_storagepool_tier_with_http_info(storagepool_tier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolTierCreateParams storagepool_tier: (required)
        :return: CreateStoragepoolTierResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_tier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_storagepool_tier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_tier' is set
        if ('storagepool_tier' not in params or
                params['storagepool_tier'] is None):
            raise ValueError("Missing the required parameter `storagepool_tier` when calling `create_storagepool_tier`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'storagepool_tier' in params:
            body_params = params['storagepool_tier']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/storagepool/tiers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateStoragepoolTierResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_storagepool_nodepool(self, storagepool_nodepool_id, **kwargs):  # noqa: E501
        """delete_storagepool_nodepool  # noqa: E501

        Delete node pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storagepool_nodepool(storagepool_nodepool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_nodepool_id: Delete node pool. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_storagepool_nodepool_with_http_info(storagepool_nodepool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_storagepool_nodepool_with_http_info(storagepool_nodepool_id, **kwargs)  # noqa: E501
            return data

    def delete_storagepool_nodepool_with_http_info(self, storagepool_nodepool_id, **kwargs):  # noqa: E501
        """delete_storagepool_nodepool  # noqa: E501

        Delete node pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storagepool_nodepool_with_http_info(storagepool_nodepool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_nodepool_id: Delete node pool. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_nodepool_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_storagepool_nodepool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_nodepool_id' is set
        if ('storagepool_nodepool_id' not in params or
                params['storagepool_nodepool_id'] is None):
            raise ValueError("Missing the required parameter `storagepool_nodepool_id` when calling `delete_storagepool_nodepool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storagepool_nodepool_id' in params:
            path_params['StoragepoolNodepoolId'] = params['storagepool_nodepool_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/storagepool/nodepools/{StoragepoolNodepoolId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_storagepool_nodepools(self, **kwargs):  # noqa: E501
        """delete_storagepool_nodepools  # noqa: E501

        Delete node pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storagepool_nodepools(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_storagepool_nodepools_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_storagepool_nodepools_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_storagepool_nodepools_with_http_info(self, **kwargs):  # noqa: E501
        """delete_storagepool_nodepools  # noqa: E501

        Delete node pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storagepool_nodepools_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_storagepool_nodepools" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/storagepool/nodepools', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_storagepool_tier(self, storagepool_tier_id, **kwargs):  # noqa: E501
        """delete_storagepool_tier  # noqa: E501

        Delete tier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storagepool_tier(storagepool_tier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_tier_id: Delete tier. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_storagepool_tier_with_http_info(storagepool_tier_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_storagepool_tier_with_http_info(storagepool_tier_id, **kwargs)  # noqa: E501
            return data

    def delete_storagepool_tier_with_http_info(self, storagepool_tier_id, **kwargs):  # noqa: E501
        """delete_storagepool_tier  # noqa: E501

        Delete tier.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storagepool_tier_with_http_info(storagepool_tier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_tier_id: Delete tier. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_tier_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_storagepool_tier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_tier_id' is set
        if ('storagepool_tier_id' not in params or
                params['storagepool_tier_id'] is None):
            raise ValueError("Missing the required parameter `storagepool_tier_id` when calling `delete_storagepool_tier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storagepool_tier_id' in params:
            path_params['StoragepoolTierId'] = params['storagepool_tier_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/storagepool/tiers/{StoragepoolTierId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_storagepool_tiers(self, **kwargs):  # noqa: E501
        """delete_storagepool_tiers  # noqa: E501

        Delete all tiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storagepool_tiers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_storagepool_tiers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_storagepool_tiers_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_storagepool_tiers_with_http_info(self, **kwargs):  # noqa: E501
        """delete_storagepool_tiers  # noqa: E501

        Delete all tiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_storagepool_tiers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_storagepool_tiers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/storagepool/tiers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_nodepool(self, storagepool_nodepool_id, **kwargs):  # noqa: E501
        """get_storagepool_nodepool  # noqa: E501

        Retrieve node pool information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_nodepool(storagepool_nodepool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_nodepool_id: Retrieve node pool information. (required)
        :return: StoragepoolNodepools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_nodepool_with_http_info(storagepool_nodepool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_nodepool_with_http_info(storagepool_nodepool_id, **kwargs)  # noqa: E501
            return data

    def get_storagepool_nodepool_with_http_info(self, storagepool_nodepool_id, **kwargs):  # noqa: E501
        """get_storagepool_nodepool  # noqa: E501

        Retrieve node pool information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_nodepool_with_http_info(storagepool_nodepool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_nodepool_id: Retrieve node pool information. (required)
        :return: StoragepoolNodepools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_nodepool_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_nodepool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_nodepool_id' is set
        if ('storagepool_nodepool_id' not in params or
                params['storagepool_nodepool_id'] is None):
            raise ValueError("Missing the required parameter `storagepool_nodepool_id` when calling `get_storagepool_nodepool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storagepool_nodepool_id' in params:
            path_params['StoragepoolNodepoolId'] = params['storagepool_nodepool_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/storagepool/nodepools/{StoragepoolNodepoolId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolNodepools',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_nodetype(self, storagepool_nodetype_id, **kwargs):  # noqa: E501
        """get_storagepool_nodetype  # noqa: E501

        Retrieve node type information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_nodetype(storagepool_nodetype_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_nodetype_id: Retrieve node type information. (required)
        :return: StoragepoolNodetypes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_nodetype_with_http_info(storagepool_nodetype_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_nodetype_with_http_info(storagepool_nodetype_id, **kwargs)  # noqa: E501
            return data

    def get_storagepool_nodetype_with_http_info(self, storagepool_nodetype_id, **kwargs):  # noqa: E501
        """get_storagepool_nodetype  # noqa: E501

        Retrieve node type information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_nodetype_with_http_info(storagepool_nodetype_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_nodetype_id: Retrieve node type information. (required)
        :return: StoragepoolNodetypes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_nodetype_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_nodetype" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_nodetype_id' is set
        if ('storagepool_nodetype_id' not in params or
                params['storagepool_nodetype_id'] is None):
            raise ValueError("Missing the required parameter `storagepool_nodetype_id` when calling `get_storagepool_nodetype`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storagepool_nodetype_id' in params:
            path_params['StoragepoolNodetypeId'] = params['storagepool_nodetype_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/storagepool/nodetypes/{StoragepoolNodetypeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolNodetypes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_nodetypes(self, **kwargs):  # noqa: E501
        """get_storagepool_nodetypes  # noqa: E501

        List all node types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_nodetypes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolNodetypesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_nodetypes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_nodetypes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_storagepool_nodetypes_with_http_info(self, **kwargs):  # noqa: E501
        """get_storagepool_nodetypes  # noqa: E501

        List all node types.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_nodetypes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolNodetypesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_nodetypes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/storagepool/nodetypes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolNodetypesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_settings(self, **kwargs):  # noqa: E501
        """get_storagepool_settings  # noqa: E501

        List all storagepool settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_storagepool_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_storagepool_settings  # noqa: E501

        List all storagepool settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/storagepool/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_status(self, **kwargs):  # noqa: E501
        """get_storagepool_status  # noqa: E501

        List any health conditions detected.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_storagepool_status_with_http_info(self, **kwargs):  # noqa: E501
        """get_storagepool_status  # noqa: E501

        List any health conditions detected.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/storagepool/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_storagepools(self, **kwargs):  # noqa: E501
        """get_storagepool_storagepools  # noqa: E501

        List all storage pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_storagepools(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param str sort: The field that will be used for sorting.
        :param str toplevels: If true, node pools contained within tiers will be filtered out of results.
        :return: StoragepoolStoragepools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_storagepools_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_storagepools_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_storagepool_storagepools_with_http_info(self, **kwargs):  # noqa: E501
        """get_storagepool_storagepools  # noqa: E501

        List all storage pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_storagepools_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param str sort: The field that will be used for sorting.
        :param str toplevels: If true, node pools contained within tiers will be filtered out of results.
        :return: StoragepoolStoragepools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'sort', 'toplevels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_storagepools" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_storagepool_storagepools`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_storagepool_storagepools`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_storagepool_storagepools`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'toplevels' in params:
            query_params.append(('toplevels', params['toplevels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/storagepool/storagepools', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolStoragepools',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_suggested_protection_nid(self, storagepool_suggested_protection_nid, **kwargs):  # noqa: E501
        """get_storagepool_suggested_protection_nid  # noqa: E501

        Retrieve the suggested protection policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_suggested_protection_nid(storagepool_suggested_protection_nid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_suggested_protection_nid: Retrieve the suggested protection policy. (required)
        :return: StoragepoolSuggestedProtection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_suggested_protection_nid_with_http_info(storagepool_suggested_protection_nid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_suggested_protection_nid_with_http_info(storagepool_suggested_protection_nid, **kwargs)  # noqa: E501
            return data

    def get_storagepool_suggested_protection_nid_with_http_info(self, storagepool_suggested_protection_nid, **kwargs):  # noqa: E501
        """get_storagepool_suggested_protection_nid  # noqa: E501

        Retrieve the suggested protection policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_suggested_protection_nid_with_http_info(storagepool_suggested_protection_nid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_suggested_protection_nid: Retrieve the suggested protection policy. (required)
        :return: StoragepoolSuggestedProtection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_suggested_protection_nid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_suggested_protection_nid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_suggested_protection_nid' is set
        if ('storagepool_suggested_protection_nid' not in params or
                params['storagepool_suggested_protection_nid'] is None):
            raise ValueError("Missing the required parameter `storagepool_suggested_protection_nid` when calling `get_storagepool_suggested_protection_nid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storagepool_suggested_protection_nid' in params:
            path_params['StoragepoolSuggestedProtectionNid'] = params['storagepool_suggested_protection_nid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/storagepool/suggested-protection/{StoragepoolSuggestedProtectionNid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolSuggestedProtection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_tier(self, storagepool_tier_id, **kwargs):  # noqa: E501
        """get_storagepool_tier  # noqa: E501

        Retrieve tier information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_tier(storagepool_tier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_tier_id: Retrieve tier information. (required)
        :return: StoragepoolTiers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_tier_with_http_info(storagepool_tier_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_tier_with_http_info(storagepool_tier_id, **kwargs)  # noqa: E501
            return data

    def get_storagepool_tier_with_http_info(self, storagepool_tier_id, **kwargs):  # noqa: E501
        """get_storagepool_tier  # noqa: E501

        Retrieve tier information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_tier_with_http_info(storagepool_tier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str storagepool_tier_id: Retrieve tier information. (required)
        :return: StoragepoolTiers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_tier_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_tier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_tier_id' is set
        if ('storagepool_tier_id' not in params or
                params['storagepool_tier_id'] is None):
            raise ValueError("Missing the required parameter `storagepool_tier_id` when calling `get_storagepool_tier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storagepool_tier_id' in params:
            path_params['StoragepoolTierId'] = params['storagepool_tier_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/storagepool/tiers/{StoragepoolTierId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolTiers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_storagepool_unprovisioned(self, **kwargs):  # noqa: E501
        """get_storagepool_unprovisioned  # noqa: E501

        Get the unprovisioned nodes and drives  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_unprovisioned(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolUnprovisioned
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_storagepool_unprovisioned_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_storagepool_unprovisioned_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_storagepool_unprovisioned_with_http_info(self, **kwargs):  # noqa: E501
        """get_storagepool_unprovisioned  # noqa: E501

        Get the unprovisioned nodes and drives  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_storagepool_unprovisioned_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolUnprovisioned
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_storagepool_unprovisioned" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/storagepool/unprovisioned', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolUnprovisioned',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_storagepool_nodepools(self, **kwargs):  # noqa: E501
        """list_storagepool_nodepools  # noqa: E501

        List all node pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_storagepool_nodepools(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolNodepoolsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_storagepool_nodepools_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_storagepool_nodepools_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_storagepool_nodepools_with_http_info(self, **kwargs):  # noqa: E501
        """list_storagepool_nodepools  # noqa: E501

        List all node pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_storagepool_nodepools_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolNodepoolsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_storagepool_nodepools" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/storagepool/nodepools', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolNodepoolsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_storagepool_tiers(self, **kwargs):  # noqa: E501
        """list_storagepool_tiers  # noqa: E501

        List all tiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_storagepool_tiers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolTiersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_storagepool_tiers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_storagepool_tiers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_storagepool_tiers_with_http_info(self, **kwargs):  # noqa: E501
        """list_storagepool_tiers  # noqa: E501

        List all tiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_storagepool_tiers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: StoragepoolTiersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_storagepool_tiers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/storagepool/tiers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StoragepoolTiersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_storagepool_nodepool(self, storagepool_nodepool, storagepool_nodepool_id, **kwargs):  # noqa: E501
        """update_storagepool_nodepool  # noqa: E501

        Modify node pool. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storagepool_nodepool(storagepool_nodepool, storagepool_nodepool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolNodepool storagepool_nodepool: (required)
        :param str storagepool_nodepool_id: Modify node pool. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_storagepool_nodepool_with_http_info(storagepool_nodepool, storagepool_nodepool_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_storagepool_nodepool_with_http_info(storagepool_nodepool, storagepool_nodepool_id, **kwargs)  # noqa: E501
            return data

    def update_storagepool_nodepool_with_http_info(self, storagepool_nodepool, storagepool_nodepool_id, **kwargs):  # noqa: E501
        """update_storagepool_nodepool  # noqa: E501

        Modify node pool. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storagepool_nodepool_with_http_info(storagepool_nodepool, storagepool_nodepool_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolNodepool storagepool_nodepool: (required)
        :param str storagepool_nodepool_id: Modify node pool. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_nodepool', 'storagepool_nodepool_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_storagepool_nodepool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_nodepool' is set
        if ('storagepool_nodepool' not in params or
                params['storagepool_nodepool'] is None):
            raise ValueError("Missing the required parameter `storagepool_nodepool` when calling `update_storagepool_nodepool`")  # noqa: E501
        # verify the required parameter 'storagepool_nodepool_id' is set
        if ('storagepool_nodepool_id' not in params or
                params['storagepool_nodepool_id'] is None):
            raise ValueError("Missing the required parameter `storagepool_nodepool_id` when calling `update_storagepool_nodepool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storagepool_nodepool_id' in params:
            path_params['StoragepoolNodepoolId'] = params['storagepool_nodepool_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'storagepool_nodepool' in params:
            body_params = params['storagepool_nodepool']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/storagepool/nodepools/{StoragepoolNodepoolId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_storagepool_settings(self, storagepool_settings, **kwargs):  # noqa: E501
        """update_storagepool_settings  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storagepool_settings(storagepool_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolSettingsExtended storagepool_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_storagepool_settings_with_http_info(storagepool_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_storagepool_settings_with_http_info(storagepool_settings, **kwargs)  # noqa: E501
            return data

    def update_storagepool_settings_with_http_info(self, storagepool_settings, **kwargs):  # noqa: E501
        """update_storagepool_settings  # noqa: E501

        Modify one or more settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storagepool_settings_with_http_info(storagepool_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolSettingsExtended storagepool_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_storagepool_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_settings' is set
        if ('storagepool_settings' not in params or
                params['storagepool_settings'] is None):
            raise ValueError("Missing the required parameter `storagepool_settings` when calling `update_storagepool_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'storagepool_settings' in params:
            body_params = params['storagepool_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/storagepool/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_storagepool_tier(self, storagepool_tier, storagepool_tier_id, **kwargs):  # noqa: E501
        """update_storagepool_tier  # noqa: E501

        Modify tier. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storagepool_tier(storagepool_tier, storagepool_tier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolTier storagepool_tier: (required)
        :param str storagepool_tier_id: Modify tier. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_storagepool_tier_with_http_info(storagepool_tier, storagepool_tier_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_storagepool_tier_with_http_info(storagepool_tier, storagepool_tier_id, **kwargs)  # noqa: E501
            return data

    def update_storagepool_tier_with_http_info(self, storagepool_tier, storagepool_tier_id, **kwargs):  # noqa: E501
        """update_storagepool_tier  # noqa: E501

        Modify tier. All input fields are optional, but one or more must be supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_storagepool_tier_with_http_info(storagepool_tier, storagepool_tier_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param StoragepoolTier storagepool_tier: (required)
        :param str storagepool_tier_id: Modify tier. All input fields are optional, but one or more must be supplied. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['storagepool_tier', 'storagepool_tier_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_storagepool_tier" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'storagepool_tier' is set
        if ('storagepool_tier' not in params or
                params['storagepool_tier'] is None):
            raise ValueError("Missing the required parameter `storagepool_tier` when calling `update_storagepool_tier`")  # noqa: E501
        # verify the required parameter 'storagepool_tier_id' is set
        if ('storagepool_tier_id' not in params or
                params['storagepool_tier_id'] is None):
            raise ValueError("Missing the required parameter `storagepool_tier_id` when calling `update_storagepool_tier`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'storagepool_tier_id' in params:
            path_params['StoragepoolTierId'] = params['storagepool_tier_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'storagepool_tier' in params:
            body_params = params['storagepool_tier']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/storagepool/tiers/{StoragepoolTierId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
