# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_2_1.api_client import ApiClient


class NamespaceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def copy_directory(self, directory_copy_target, x_isi_ifs_copy_source, **kwargs):  # noqa: E501
        """copy_directory  # noqa: E501

        Recursively copies a directory to a specified destination path. Symbolic links are copied as regular files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_directory(directory_copy_target, x_isi_ifs_copy_source, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_copy_target: Directory copy destination relative to /. (required)
        :param str x_isi_ifs_copy_source: Specifies the full path to the source directory. (required)
        :param bool overwrite: Deletes and replaces the existing user attributes and ACLs of the directory with user-specified attributes and ACLS from the header, when set to true.
        :param bool merge: Specifies if the contents of a directory should be merged with an existing directory with the same name.
        :param bool _continue: Specifies whether to continue the copy operation on remaining objects when there is a conflict or error.
        :return: CopyErrors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.copy_directory_with_http_info(directory_copy_target, x_isi_ifs_copy_source, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_directory_with_http_info(directory_copy_target, x_isi_ifs_copy_source, **kwargs)  # noqa: E501
            return data

    def copy_directory_with_http_info(self, directory_copy_target, x_isi_ifs_copy_source, **kwargs):  # noqa: E501
        """copy_directory  # noqa: E501

        Recursively copies a directory to a specified destination path. Symbolic links are copied as regular files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_directory_with_http_info(directory_copy_target, x_isi_ifs_copy_source, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_copy_target: Directory copy destination relative to /. (required)
        :param str x_isi_ifs_copy_source: Specifies the full path to the source directory. (required)
        :param bool overwrite: Deletes and replaces the existing user attributes and ACLs of the directory with user-specified attributes and ACLS from the header, when set to true.
        :param bool merge: Specifies if the contents of a directory should be merged with an existing directory with the same name.
        :param bool _continue: Specifies whether to continue the copy operation on remaining objects when there is a conflict or error.
        :return: CopyErrors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_copy_target', 'x_isi_ifs_copy_source', 'overwrite', 'merge', '_continue']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_directory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_copy_target' is set
        if ('directory_copy_target' not in params or
                params['directory_copy_target'] is None):
            raise ValueError("Missing the required parameter `directory_copy_target` when calling `copy_directory`")  # noqa: E501
        # verify the required parameter 'x_isi_ifs_copy_source' is set
        if ('x_isi_ifs_copy_source' not in params or
                params['x_isi_ifs_copy_source'] is None):
            raise ValueError("Missing the required parameter `x_isi_ifs_copy_source` when calling `copy_directory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'directory_copy_target' in params:
            path_params['DirectoryCopyTarget'] = params['directory_copy_target']  # noqa: E501

        query_params = []
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501
        if 'merge' in params:
            query_params.append(('merge', params['merge']))  # noqa: E501
        if '_continue' in params:
            query_params.append(('continue', params['_continue']))  # noqa: E501

        header_params = {}
        if 'x_isi_ifs_copy_source' in params:
            header_params['x-isi-ifs-copy-source'] = params['x_isi_ifs_copy_source']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{DirectoryCopyTarget}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CopyErrors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_file(self, file_copy_target, x_isi_ifs_copy_source, **kwargs):  # noqa: E501
        """copy_file  # noqa: E501

        Copies a file to the specified destination path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_file(file_copy_target, x_isi_ifs_copy_source, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_copy_target: File copy destination relative to /. (required)
        :param str x_isi_ifs_copy_source: Specifies the full path to the source file. (required)
        :param bool clone: You must set this parameter to true in order to clone a file.
        :param str snapshot: Specifies a snapshot name to clone the file from.
        :param bool overwrite: Specifies if an existing file should be overwritten by a new file with the same name.
        :return: CopyErrors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.copy_file_with_http_info(file_copy_target, x_isi_ifs_copy_source, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_file_with_http_info(file_copy_target, x_isi_ifs_copy_source, **kwargs)  # noqa: E501
            return data

    def copy_file_with_http_info(self, file_copy_target, x_isi_ifs_copy_source, **kwargs):  # noqa: E501
        """copy_file  # noqa: E501

        Copies a file to the specified destination path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_file_with_http_info(file_copy_target, x_isi_ifs_copy_source, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_copy_target: File copy destination relative to /. (required)
        :param str x_isi_ifs_copy_source: Specifies the full path to the source file. (required)
        :param bool clone: You must set this parameter to true in order to clone a file.
        :param str snapshot: Specifies a snapshot name to clone the file from.
        :param bool overwrite: Specifies if an existing file should be overwritten by a new file with the same name.
        :return: CopyErrors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_copy_target', 'x_isi_ifs_copy_source', 'clone', 'snapshot', 'overwrite']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_copy_target' is set
        if ('file_copy_target' not in params or
                params['file_copy_target'] is None):
            raise ValueError("Missing the required parameter `file_copy_target` when calling `copy_file`")  # noqa: E501
        # verify the required parameter 'x_isi_ifs_copy_source' is set
        if ('x_isi_ifs_copy_source' not in params or
                params['x_isi_ifs_copy_source'] is None):
            raise ValueError("Missing the required parameter `x_isi_ifs_copy_source` when calling `copy_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_copy_target' in params:
            path_params['FileCopyTarget'] = params['file_copy_target']  # noqa: E501

        query_params = []
        if 'clone' in params:
            query_params.append(('clone', params['clone']))  # noqa: E501
        if 'snapshot' in params:
            query_params.append(('snapshot', params['snapshot']))  # noqa: E501
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501

        header_params = {}
        if 'x_isi_ifs_copy_source' in params:
            header_params['x-isi-ifs-copy-source'] = params['x_isi_ifs_copy_source']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{FileCopyTarget}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CopyErrors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_access_point(self, access_point_name, access_point, **kwargs):  # noqa: E501
        """create_access_point  # noqa: E501

        Creates a namespace access point in the file system. Only root users can create or change namespace access points.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_point(access_point_name, access_point, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point_name: Access point name. (required)
        :param AccessPointCreateParams access_point: Access point parameters model. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_access_point_with_http_info(access_point_name, access_point, **kwargs)  # noqa: E501
        else:
            (data) = self.create_access_point_with_http_info(access_point_name, access_point, **kwargs)  # noqa: E501
            return data

    def create_access_point_with_http_info(self, access_point_name, access_point, **kwargs):  # noqa: E501
        """create_access_point  # noqa: E501

        Creates a namespace access point in the file system. Only root users can create or change namespace access points.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_access_point_with_http_info(access_point_name, access_point, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point_name: Access point name. (required)
        :param AccessPointCreateParams access_point: Access point parameters model. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_point_name', 'access_point']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_access_point" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_point_name' is set
        if ('access_point_name' not in params or
                params['access_point_name'] is None):
            raise ValueError("Missing the required parameter `access_point_name` when calling `create_access_point`")  # noqa: E501
        # verify the required parameter 'access_point' is set
        if ('access_point' not in params or
                params['access_point'] is None):
            raise ValueError("Missing the required parameter `access_point` when calling `create_access_point`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_point_name' in params:
            path_params['AccessPointName'] = params['access_point_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'access_point' in params:
            body_params = params['access_point']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{AccessPointName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_directory(self, directory_path, x_isi_ifs_target_type, **kwargs):  # noqa: E501
        """create_directory  # noqa: E501

        Creates a directory with a specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_directory(directory_path, x_isi_ifs_target_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param str x_isi_ifs_target_type: Specifies the resource type. (required)
        :param str x_isi_ifs_access_control: Specifies a pre-defined ACL value or POSIX mode with a string in octal string format.
        :param str x_isi_ifs_node_pool_name: Specifies a pre-defined ACL value or POSIX mode with a string.
        :param bool recursive: Specifies the OneFS node pool name.
        :param bool overwrite: Deletes and replaces the existing user attributes and ACLs of the directory with user-specified attributes and ACLS from the header, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_directory_with_http_info(directory_path, x_isi_ifs_target_type, **kwargs)  # noqa: E501
        else:
            (data) = self.create_directory_with_http_info(directory_path, x_isi_ifs_target_type, **kwargs)  # noqa: E501
            return data

    def create_directory_with_http_info(self, directory_path, x_isi_ifs_target_type, **kwargs):  # noqa: E501
        """create_directory  # noqa: E501

        Creates a directory with a specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_directory_with_http_info(directory_path, x_isi_ifs_target_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param str x_isi_ifs_target_type: Specifies the resource type. (required)
        :param str x_isi_ifs_access_control: Specifies a pre-defined ACL value or POSIX mode with a string in octal string format.
        :param str x_isi_ifs_node_pool_name: Specifies a pre-defined ACL value or POSIX mode with a string.
        :param bool recursive: Specifies the OneFS node pool name.
        :param bool overwrite: Deletes and replaces the existing user attributes and ACLs of the directory with user-specified attributes and ACLS from the header, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_path', 'x_isi_ifs_target_type', 'x_isi_ifs_access_control', 'x_isi_ifs_node_pool_name', 'recursive', 'overwrite']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_directory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_path' is set
        if ('directory_path' not in params or
                params['directory_path'] is None):
            raise ValueError("Missing the required parameter `directory_path` when calling `create_directory`")  # noqa: E501
        # verify the required parameter 'x_isi_ifs_target_type' is set
        if ('x_isi_ifs_target_type' not in params or
                params['x_isi_ifs_target_type'] is None):
            raise ValueError("Missing the required parameter `x_isi_ifs_target_type` when calling `create_directory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'directory_path' in params:
            path_params['DirectoryPath'] = params['directory_path']  # noqa: E501

        query_params = []
        if 'recursive' in params:
            query_params.append(('recursive', params['recursive']))  # noqa: E501
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501

        header_params = {}
        if 'x_isi_ifs_target_type' in params:
            header_params['x-isi-ifs-target-type'] = params['x_isi_ifs_target_type']  # noqa: E501
        if 'x_isi_ifs_access_control' in params:
            header_params['x-isi-ifs-access-control'] = params['x_isi_ifs_access_control']  # noqa: E501
        if 'x_isi_ifs_node_pool_name' in params:
            header_params['x-isi-ifs-node-pool-name'] = params['x_isi_ifs_node_pool_name']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{DirectoryPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_directory_with_access_point_container_path(self, access_point, container_path, x_isi_ifs_target_type, **kwargs):  # noqa: E501
        """create_directory_with_access_point_container_path  # noqa: E501

        Creates a directory with a specified accesspoint and container path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_directory_with_access_point_container_path(access_point, container_path, x_isi_ifs_target_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point: Access point. (required)
        :param str container_path: Directory path relative to access point. (required)
        :param str x_isi_ifs_target_type: Specifies the resource type. (required)
        :param str x_isi_ifs_access_control: Specifies a pre-defined ACL value or POSIX mode with a string in octal string format.
        :param str x_isi_ifs_node_pool_name: Specifies a pre-defined ACL value or POSIX mode with a string.
        :param bool recursive: Specifies the OneFS node pool name.
        :param bool overwrite: Deletes and replaces the existing user attributes and ACLs of the directory with user-specified attributes and ACLS from the header, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_directory_with_access_point_container_path_with_http_info(access_point, container_path, x_isi_ifs_target_type, **kwargs)  # noqa: E501
        else:
            (data) = self.create_directory_with_access_point_container_path_with_http_info(access_point, container_path, x_isi_ifs_target_type, **kwargs)  # noqa: E501
            return data

    def create_directory_with_access_point_container_path_with_http_info(self, access_point, container_path, x_isi_ifs_target_type, **kwargs):  # noqa: E501
        """create_directory_with_access_point_container_path  # noqa: E501

        Creates a directory with a specified accesspoint and container path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_directory_with_access_point_container_path_with_http_info(access_point, container_path, x_isi_ifs_target_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point: Access point. (required)
        :param str container_path: Directory path relative to access point. (required)
        :param str x_isi_ifs_target_type: Specifies the resource type. (required)
        :param str x_isi_ifs_access_control: Specifies a pre-defined ACL value or POSIX mode with a string in octal string format.
        :param str x_isi_ifs_node_pool_name: Specifies a pre-defined ACL value or POSIX mode with a string.
        :param bool recursive: Specifies the OneFS node pool name.
        :param bool overwrite: Deletes and replaces the existing user attributes and ACLs of the directory with user-specified attributes and ACLS from the header, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_point', 'container_path', 'x_isi_ifs_target_type', 'x_isi_ifs_access_control', 'x_isi_ifs_node_pool_name', 'recursive', 'overwrite']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_directory_with_access_point_container_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_point' is set
        if ('access_point' not in params or
                params['access_point'] is None):
            raise ValueError("Missing the required parameter `access_point` when calling `create_directory_with_access_point_container_path`")  # noqa: E501
        # verify the required parameter 'container_path' is set
        if ('container_path' not in params or
                params['container_path'] is None):
            raise ValueError("Missing the required parameter `container_path` when calling `create_directory_with_access_point_container_path`")  # noqa: E501
        # verify the required parameter 'x_isi_ifs_target_type' is set
        if ('x_isi_ifs_target_type' not in params or
                params['x_isi_ifs_target_type'] is None):
            raise ValueError("Missing the required parameter `x_isi_ifs_target_type` when calling `create_directory_with_access_point_container_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_point' in params:
            path_params['AccessPoint'] = params['access_point']  # noqa: E501
        if 'container_path' in params:
            path_params['ContainerPath'] = params['container_path']  # noqa: E501

        query_params = []
        if 'recursive' in params:
            query_params.append(('recursive', params['recursive']))  # noqa: E501
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501

        header_params = {}
        if 'x_isi_ifs_target_type' in params:
            header_params['x-isi-ifs-target-type'] = params['x_isi_ifs_target_type']  # noqa: E501
        if 'x_isi_ifs_access_control' in params:
            header_params['x-isi-ifs-access-control'] = params['x_isi_ifs_access_control']  # noqa: E501
        if 'x_isi_ifs_node_pool_name' in params:
            header_params['x-isi-ifs-node-pool-name'] = params['x_isi_ifs_node_pool_name']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{AccessPoint}/{ContainerPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_file(self, file_path, x_isi_ifs_target_type, file_contents, **kwargs):  # noqa: E501
        """create_file  # noqa: E501

        Creates a file object with a given path. Note that file streaming is not supported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file(file_path, x_isi_ifs_target_type, file_contents, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :param str x_isi_ifs_target_type: Specifies the resource type. (required)
        :param str file_contents: The contents of the file object. (required)
        :param str x_isi_ifs_access_control: Specifies a pre-defined ACL value or POSIX mode with a string in octal string format.
        :param str content_encoding: Specifies the content encoding that was applied to the object content, so that decoding can be applied when retrieving the content.
        :param str content_type: Specifies a standard MIME-type description of the content format.
        :param bool overwrite: Deletes and replaces the existing user attributes and ACLs of the directory with user-specified attributes and ACLS from the header, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_file_with_http_info(file_path, x_isi_ifs_target_type, file_contents, **kwargs)  # noqa: E501
        else:
            (data) = self.create_file_with_http_info(file_path, x_isi_ifs_target_type, file_contents, **kwargs)  # noqa: E501
            return data

    def create_file_with_http_info(self, file_path, x_isi_ifs_target_type, file_contents, **kwargs):  # noqa: E501
        """create_file  # noqa: E501

        Creates a file object with a given path. Note that file streaming is not supported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_file_with_http_info(file_path, x_isi_ifs_target_type, file_contents, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :param str x_isi_ifs_target_type: Specifies the resource type. (required)
        :param str file_contents: The contents of the file object. (required)
        :param str x_isi_ifs_access_control: Specifies a pre-defined ACL value or POSIX mode with a string in octal string format.
        :param str content_encoding: Specifies the content encoding that was applied to the object content, so that decoding can be applied when retrieving the content.
        :param str content_type: Specifies a standard MIME-type description of the content format.
        :param bool overwrite: Deletes and replaces the existing user attributes and ACLs of the directory with user-specified attributes and ACLS from the header, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_path', 'x_isi_ifs_target_type', 'file_contents', 'x_isi_ifs_access_control', 'content_encoding', 'content_type', 'overwrite']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_path' is set
        if ('file_path' not in params or
                params['file_path'] is None):
            raise ValueError("Missing the required parameter `file_path` when calling `create_file`")  # noqa: E501
        # verify the required parameter 'x_isi_ifs_target_type' is set
        if ('x_isi_ifs_target_type' not in params or
                params['x_isi_ifs_target_type'] is None):
            raise ValueError("Missing the required parameter `x_isi_ifs_target_type` when calling `create_file`")  # noqa: E501
        # verify the required parameter 'file_contents' is set
        if ('file_contents' not in params or
                params['file_contents'] is None):
            raise ValueError("Missing the required parameter `file_contents` when calling `create_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_path' in params:
            path_params['FilePath'] = params['file_path']  # noqa: E501

        query_params = []
        if 'overwrite' in params:
            query_params.append(('overwrite', params['overwrite']))  # noqa: E501

        header_params = {}
        if 'x_isi_ifs_target_type' in params:
            header_params['x-isi-ifs-target-type'] = params['x_isi_ifs_target_type']  # noqa: E501
        if 'x_isi_ifs_access_control' in params:
            header_params['x-isi-ifs-access-control'] = params['x_isi_ifs_access_control']  # noqa: E501
        if 'content_encoding' in params:
            header_params['Content-Encoding'] = params['content_encoding']  # noqa: E501
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'file_contents' in params:
            body_params = params['file_contents']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{FilePath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_access_point(self, access_point_name, **kwargs):  # noqa: E501
        """delete_access_point  # noqa: E501

        Deletes a namespace access point. Only root users can delete namespace access points.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_point(access_point_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point_name: Access point name. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_access_point_with_http_info(access_point_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_access_point_with_http_info(access_point_name, **kwargs)  # noqa: E501
            return data

    def delete_access_point_with_http_info(self, access_point_name, **kwargs):  # noqa: E501
        """delete_access_point  # noqa: E501

        Deletes a namespace access point. Only root users can delete namespace access points.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_access_point_with_http_info(access_point_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point_name: Access point name. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_point_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_access_point" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_point_name' is set
        if ('access_point_name' not in params or
                params['access_point_name'] is None):
            raise ValueError("Missing the required parameter `access_point_name` when calling `delete_access_point`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_point_name' in params:
            path_params['AccessPointName'] = params['access_point_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{AccessPointName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_directory(self, directory_path, **kwargs):  # noqa: E501
        """delete_directory  # noqa: E501

        Deletes the directory at the specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_directory(directory_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param bool recursive: Deletes directories recursively, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_directory_with_http_info(directory_path, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_directory_with_http_info(directory_path, **kwargs)  # noqa: E501
            return data

    def delete_directory_with_http_info(self, directory_path, **kwargs):  # noqa: E501
        """delete_directory  # noqa: E501

        Deletes the directory at the specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_directory_with_http_info(directory_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param bool recursive: Deletes directories recursively, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_path', 'recursive']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_directory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_path' is set
        if ('directory_path' not in params or
                params['directory_path'] is None):
            raise ValueError("Missing the required parameter `directory_path` when calling `delete_directory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'directory_path' in params:
            path_params['DirectoryPath'] = params['directory_path']  # noqa: E501

        query_params = []
        if 'recursive' in params:
            query_params.append(('recursive', params['recursive']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{DirectoryPath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_directory_with_access_point_container_path(self, access_point, container_path, **kwargs):  # noqa: E501
        """delete_directory_with_access_point_container_path  # noqa: E501

        Deletes the directory at the specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_directory_with_access_point_container_path(access_point, container_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point: Access point. (required)
        :param str container_path: Directory path relative to access point. (required)
        :param bool recursive: Deletes directories recursively, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_directory_with_access_point_container_path_with_http_info(access_point, container_path, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_directory_with_access_point_container_path_with_http_info(access_point, container_path, **kwargs)  # noqa: E501
            return data

    def delete_directory_with_access_point_container_path_with_http_info(self, access_point, container_path, **kwargs):  # noqa: E501
        """delete_directory_with_access_point_container_path  # noqa: E501

        Deletes the directory at the specified path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_directory_with_access_point_container_path_with_http_info(access_point, container_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point: Access point. (required)
        :param str container_path: Directory path relative to access point. (required)
        :param bool recursive: Deletes directories recursively, when set to true.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_point', 'container_path', 'recursive']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_directory_with_access_point_container_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_point' is set
        if ('access_point' not in params or
                params['access_point'] is None):
            raise ValueError("Missing the required parameter `access_point` when calling `delete_directory_with_access_point_container_path`")  # noqa: E501
        # verify the required parameter 'container_path' is set
        if ('container_path' not in params or
                params['container_path'] is None):
            raise ValueError("Missing the required parameter `container_path` when calling `delete_directory_with_access_point_container_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_point' in params:
            path_params['AccessPoint'] = params['access_point']  # noqa: E501
        if 'container_path' in params:
            path_params['ContainerPath'] = params['container_path']  # noqa: E501

        query_params = []
        if 'recursive' in params:
            query_params.append(('recursive', params['recursive']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{AccessPoint}/{ContainerPath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file(self, file_path, **kwargs):  # noqa: E501
        """delete_file  # noqa: E501

        Deletes the specified file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file(file_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_file_with_http_info(file_path, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_with_http_info(file_path, **kwargs)  # noqa: E501
            return data

    def delete_file_with_http_info(self, file_path, **kwargs):  # noqa: E501
        """delete_file  # noqa: E501

        Deletes the specified file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_file_with_http_info(file_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_path' is set
        if ('file_path' not in params or
                params['file_path'] is None):
            raise ValueError("Missing the required parameter `file_path` when calling `delete_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_path' in params:
            path_params['FilePath'] = params['file_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{FilePath}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_acl(self, namespace_path, acl, **kwargs):  # noqa: E501
        """get_acl  # noqa: E501

        Retrieves the access control list for a namespace object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_acl(namespace_path, acl, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace_path: Namespace path relative to /. (required)
        :param bool acl: Show access control lists. (required)
        :param bool nsaccess: Indicates that the operation is on the access point instead of the store path.
        :return: NamespaceAcl
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_acl_with_http_info(namespace_path, acl, **kwargs)  # noqa: E501
        else:
            (data) = self.get_acl_with_http_info(namespace_path, acl, **kwargs)  # noqa: E501
            return data

    def get_acl_with_http_info(self, namespace_path, acl, **kwargs):  # noqa: E501
        """get_acl  # noqa: E501

        Retrieves the access control list for a namespace object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_acl_with_http_info(namespace_path, acl, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace_path: Namespace path relative to /. (required)
        :param bool acl: Show access control lists. (required)
        :param bool nsaccess: Indicates that the operation is on the access point instead of the store path.
        :return: NamespaceAcl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace_path', 'acl', 'nsaccess']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_acl" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace_path' is set
        if ('namespace_path' not in params or
                params['namespace_path'] is None):
            raise ValueError("Missing the required parameter `namespace_path` when calling `get_acl`")  # noqa: E501
        # verify the required parameter 'acl' is set
        if ('acl' not in params or
                params['acl'] is None):
            raise ValueError("Missing the required parameter `acl` when calling `get_acl`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace_path' in params:
            path_params['NamespacePath'] = params['namespace_path']  # noqa: E501

        query_params = []
        if 'acl' in params:
            query_params.append(('acl', params['acl']))  # noqa: E501
        if 'nsaccess' in params:
            query_params.append(('nsaccess', params['nsaccess']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{NamespacePath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NamespaceAcl',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_directory_attributes(self, directory_path, **kwargs):  # noqa: E501
        """get_directory_attributes  # noqa: E501

        Retrieves the attribute information for a specified directory without transferring the contents of the directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_directory_attributes(directory_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param str if_modified_since: Returns only files that were modified since the specified time. If no files were modified since this time, a 304 message is returned.
        :param str if_unmodified_since: Returns only files that were not modified since the specified time. If there are no unmodified files since this time, a 412 message is returned to indicate that the precondition failed.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_directory_attributes_with_http_info(directory_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_directory_attributes_with_http_info(directory_path, **kwargs)  # noqa: E501
            return data

    def get_directory_attributes_with_http_info(self, directory_path, **kwargs):  # noqa: E501
        """get_directory_attributes  # noqa: E501

        Retrieves the attribute information for a specified directory without transferring the contents of the directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_directory_attributes_with_http_info(directory_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param str if_modified_since: Returns only files that were modified since the specified time. If no files were modified since this time, a 304 message is returned.
        :param str if_unmodified_since: Returns only files that were not modified since the specified time. If there are no unmodified files since this time, a 412 message is returned to indicate that the precondition failed.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_path', 'if_modified_since', 'if_unmodified_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_directory_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_path' is set
        if ('directory_path' not in params or
                params['directory_path'] is None):
            raise ValueError("Missing the required parameter `directory_path` when calling `get_directory_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'directory_path' in params:
            path_params['DirectoryPath'] = params['directory_path']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_modified_since' in params:
            header_params['If-Modified-Since'] = params['if_modified_since']  # noqa: E501
        if 'if_unmodified_since' in params:
            header_params['If-Unmodified-Since'] = params['if_unmodified_since']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{DirectoryPath}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_directory_contents(self, directory_path, **kwargs):  # noqa: E501
        """get_directory_contents  # noqa: E501

        Retrieves a list of files and subdirectories from a directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_directory_contents(directory_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param str detail: Specifies which object attributes are displayed.
        :param int limit: Specifies the maximum number of objects to send to the client.
        :param str resume: Specifies a token to return in the JSON result to indicate when there is a next page.
        :param str sort: Specifies one or more attributes to sort on the directory entries.
        :param str dir: Specifies the sort direction. This value can be either ascending (ASC) or descending (DESC).
        :param str type: Specifies the object type to return, which can be one of the following values: container, object, pipe, character_device, block_device, symbolic_link, socket, or whiteout_file.
        :param bool hidden: Specifies if hidden objects are returned.
        :return: NamespaceObjects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_directory_contents_with_http_info(directory_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_directory_contents_with_http_info(directory_path, **kwargs)  # noqa: E501
            return data

    def get_directory_contents_with_http_info(self, directory_path, **kwargs):  # noqa: E501
        """get_directory_contents  # noqa: E501

        Retrieves a list of files and subdirectories from a directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_directory_contents_with_http_info(directory_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param str detail: Specifies which object attributes are displayed.
        :param int limit: Specifies the maximum number of objects to send to the client.
        :param str resume: Specifies a token to return in the JSON result to indicate when there is a next page.
        :param str sort: Specifies one or more attributes to sort on the directory entries.
        :param str dir: Specifies the sort direction. This value can be either ascending (ASC) or descending (DESC).
        :param str type: Specifies the object type to return, which can be one of the following values: container, object, pipe, character_device, block_device, symbolic_link, socket, or whiteout_file.
        :param bool hidden: Specifies if hidden objects are returned.
        :return: NamespaceObjects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_path', 'detail', 'limit', 'resume', 'sort', 'dir', 'type', 'hidden']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_directory_contents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_path' is set
        if ('directory_path' not in params or
                params['directory_path'] is None):
            raise ValueError("Missing the required parameter `directory_path` when calling `get_directory_contents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'directory_path' in params:
            path_params['DirectoryPath'] = params['directory_path']  # noqa: E501

        query_params = []
        if 'detail' in params:
            query_params.append(('detail', params['detail']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'hidden' in params:
            query_params.append(('hidden', params['hidden']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{DirectoryPath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NamespaceObjects',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_directory_metadata(self, directory_metadata_path, metadata, **kwargs):  # noqa: E501
        """get_directory_metadata  # noqa: E501

        Retrieves the attribute information for a specified directory with the metadata query argument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_directory_metadata(directory_metadata_path, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_metadata_path: Directory path relative to /. (required)
        :param bool metadata: Show directory metadata. (required)
        :return: NamespaceMetadataList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_directory_metadata_with_http_info(directory_metadata_path, metadata, **kwargs)  # noqa: E501
        else:
            (data) = self.get_directory_metadata_with_http_info(directory_metadata_path, metadata, **kwargs)  # noqa: E501
            return data

    def get_directory_metadata_with_http_info(self, directory_metadata_path, metadata, **kwargs):  # noqa: E501
        """get_directory_metadata  # noqa: E501

        Retrieves the attribute information for a specified directory with the metadata query argument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_directory_metadata_with_http_info(directory_metadata_path, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_metadata_path: Directory path relative to /. (required)
        :param bool metadata: Show directory metadata. (required)
        :return: NamespaceMetadataList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_metadata_path', 'metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_directory_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_metadata_path' is set
        if ('directory_metadata_path' not in params or
                params['directory_metadata_path'] is None):
            raise ValueError("Missing the required parameter `directory_metadata_path` when calling `get_directory_metadata`")  # noqa: E501
        # verify the required parameter 'metadata' is set
        if ('metadata' not in params or
                params['metadata'] is None):
            raise ValueError("Missing the required parameter `metadata` when calling `get_directory_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'directory_metadata_path' in params:
            path_params['DirectoryMetadataPath'] = params['directory_metadata_path']  # noqa: E501

        query_params = []
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{DirectoryMetadataPath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NamespaceMetadataList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_directory_with_access_point_container_path(self, access_point, container_path, **kwargs):  # noqa: E501
        """get_directory_with_access_point_container_path  # noqa: E501

        Retrieves a list of files and subdirectories from a directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_directory_with_access_point_container_path(access_point, container_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point: Access point. (required)
        :param str container_path: Container path relative to access point. (required)
        :param str detail: Specifies which object attributes are displayed.
        :param int limit: Specifies the maximum number of objects to send to the client.
        :param str resume: Specifies a token to return in the JSON result to indicate when there is a next page.
        :param str sort: Specifies one or more attributes to sort on the directory entries.
        :param str dir: Specifies the sort direction. This value can be either ascending (ASC) or descending (DESC).
        :param str type: Specifies the object type to return, which can be one of the following values: container, object, pipe, character_device, block_device, symbolic_link, socket, or whiteout_file.
        :param bool hidden: Specifies if hidden objects are returned.
        :return: NamespaceObjects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_directory_with_access_point_container_path_with_http_info(access_point, container_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_directory_with_access_point_container_path_with_http_info(access_point, container_path, **kwargs)  # noqa: E501
            return data

    def get_directory_with_access_point_container_path_with_http_info(self, access_point, container_path, **kwargs):  # noqa: E501
        """get_directory_with_access_point_container_path  # noqa: E501

        Retrieves a list of files and subdirectories from a directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_directory_with_access_point_container_path_with_http_info(access_point, container_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point: Access point. (required)
        :param str container_path: Container path relative to access point. (required)
        :param str detail: Specifies which object attributes are displayed.
        :param int limit: Specifies the maximum number of objects to send to the client.
        :param str resume: Specifies a token to return in the JSON result to indicate when there is a next page.
        :param str sort: Specifies one or more attributes to sort on the directory entries.
        :param str dir: Specifies the sort direction. This value can be either ascending (ASC) or descending (DESC).
        :param str type: Specifies the object type to return, which can be one of the following values: container, object, pipe, character_device, block_device, symbolic_link, socket, or whiteout_file.
        :param bool hidden: Specifies if hidden objects are returned.
        :return: NamespaceObjects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_point', 'container_path', 'detail', 'limit', 'resume', 'sort', 'dir', 'type', 'hidden']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_directory_with_access_point_container_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_point' is set
        if ('access_point' not in params or
                params['access_point'] is None):
            raise ValueError("Missing the required parameter `access_point` when calling `get_directory_with_access_point_container_path`")  # noqa: E501
        # verify the required parameter 'container_path' is set
        if ('container_path' not in params or
                params['container_path'] is None):
            raise ValueError("Missing the required parameter `container_path` when calling `get_directory_with_access_point_container_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_point' in params:
            path_params['AccessPoint'] = params['access_point']  # noqa: E501
        if 'container_path' in params:
            path_params['ContainerPath'] = params['container_path']  # noqa: E501

        query_params = []
        if 'detail' in params:
            query_params.append(('detail', params['detail']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'hidden' in params:
            query_params.append(('hidden', params['hidden']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{AccessPoint}/{ContainerPath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NamespaceObjects',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_attributes(self, file_path, **kwargs):  # noqa: E501
        """get_file_attributes  # noqa: E501

        Retrieves the attribute information for a specified file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_attributes(file_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :param str if_modified_since: Returns only files that were modified since the specified time. If no files were modified since this time, a 304 message is returned.
        :param str if_unmodified_since: Returns only files that were not modified since the specified time. If there are no unmodified files since this time, a 412 message is returned to indicate that the precondition failed.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_attributes_with_http_info(file_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_attributes_with_http_info(file_path, **kwargs)  # noqa: E501
            return data

    def get_file_attributes_with_http_info(self, file_path, **kwargs):  # noqa: E501
        """get_file_attributes  # noqa: E501

        Retrieves the attribute information for a specified file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_attributes_with_http_info(file_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :param str if_modified_since: Returns only files that were modified since the specified time. If no files were modified since this time, a 304 message is returned.
        :param str if_unmodified_since: Returns only files that were not modified since the specified time. If there are no unmodified files since this time, a 412 message is returned to indicate that the precondition failed.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_path', 'if_modified_since', 'if_unmodified_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_path' is set
        if ('file_path' not in params or
                params['file_path'] is None):
            raise ValueError("Missing the required parameter `file_path` when calling `get_file_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_path' in params:
            path_params['FilePath'] = params['file_path']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_modified_since' in params:
            header_params['If-Modified-Since'] = params['if_modified_since']  # noqa: E501
        if 'if_unmodified_since' in params:
            header_params['If-Unmodified-Since'] = params['if_unmodified_since']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{FilePath}', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_contents(self, file_path, **kwargs):  # noqa: E501
        """get_file_contents  # noqa: E501

        Retrieves the contents of a file from a specified path. Note that file streaming is not supported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_contents(file_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :param str range: Returns the specified range bytes of an object. 
        :param str if_modified_since: Returns only files that were modified since the specified time. If no files were modified since this time, a 304 message is returned.
        :param str if_unmodified_since: Returns only files that were not modified since the specified time. If there are no unmodified files since this time, a 412 message is returned to indicate that the precondition failed.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_contents_with_http_info(file_path, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_contents_with_http_info(file_path, **kwargs)  # noqa: E501
            return data

    def get_file_contents_with_http_info(self, file_path, **kwargs):  # noqa: E501
        """get_file_contents  # noqa: E501

        Retrieves the contents of a file from a specified path. Note that file streaming is not supported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_contents_with_http_info(file_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :param str range: Returns the specified range bytes of an object. 
        :param str if_modified_since: Returns only files that were modified since the specified time. If no files were modified since this time, a 304 message is returned.
        :param str if_unmodified_since: Returns only files that were not modified since the specified time. If there are no unmodified files since this time, a 412 message is returned to indicate that the precondition failed.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_path', 'range', 'if_modified_since', 'if_unmodified_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_contents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_path' is set
        if ('file_path' not in params or
                params['file_path'] is None):
            raise ValueError("Missing the required parameter `file_path` when calling `get_file_contents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_path' in params:
            path_params['FilePath'] = params['file_path']  # noqa: E501

        query_params = []

        header_params = {}
        if 'range' in params:
            header_params['Range'] = params['range']  # noqa: E501
        if 'if_modified_since' in params:
            header_params['If-Modified-Since'] = params['if_modified_since']  # noqa: E501
        if 'if_unmodified_since' in params:
            header_params['If-Unmodified-Since'] = params['if_unmodified_since']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{FilePath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_metadata(self, file_metadata_path, metadata, **kwargs):  # noqa: E501
        """get_file_metadata  # noqa: E501

        Retrieves the attribute information for a specified file with the metadata query argument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_metadata(file_metadata_path, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_metadata_path: File path relative to /. (required)
        :param bool metadata: Show file metadata. (required)
        :return: NamespaceMetadataList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_file_metadata_with_http_info(file_metadata_path, metadata, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_metadata_with_http_info(file_metadata_path, metadata, **kwargs)  # noqa: E501
            return data

    def get_file_metadata_with_http_info(self, file_metadata_path, metadata, **kwargs):  # noqa: E501
        """get_file_metadata  # noqa: E501

        Retrieves the attribute information for a specified file with the metadata query argument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_file_metadata_with_http_info(file_metadata_path, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_metadata_path: File path relative to /. (required)
        :param bool metadata: Show file metadata. (required)
        :return: NamespaceMetadataList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_metadata_path', 'metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_metadata_path' is set
        if ('file_metadata_path' not in params or
                params['file_metadata_path'] is None):
            raise ValueError("Missing the required parameter `file_metadata_path` when calling `get_file_metadata`")  # noqa: E501
        # verify the required parameter 'metadata' is set
        if ('metadata' not in params or
                params['metadata'] is None):
            raise ValueError("Missing the required parameter `metadata` when calling `get_file_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_metadata_path' in params:
            path_params['FileMetadataPath'] = params['file_metadata_path']  # noqa: E501

        query_params = []
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{FileMetadataPath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NamespaceMetadataList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_worm_properties(self, worm_file_path, worm, **kwargs):  # noqa: E501
        """get_worm_properties  # noqa: E501

        Retrieves the WORM retention date and committed state of the file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_worm_properties(worm_file_path, worm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str worm_file_path: Write once read many file path relative to /. (required)
        :param bool worm: View WORM properties (required)
        :return: WormProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_worm_properties_with_http_info(worm_file_path, worm, **kwargs)  # noqa: E501
        else:
            (data) = self.get_worm_properties_with_http_info(worm_file_path, worm, **kwargs)  # noqa: E501
            return data

    def get_worm_properties_with_http_info(self, worm_file_path, worm, **kwargs):  # noqa: E501
        """get_worm_properties  # noqa: E501

        Retrieves the WORM retention date and committed state of the file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_worm_properties_with_http_info(worm_file_path, worm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str worm_file_path: Write once read many file path relative to /. (required)
        :param bool worm: View WORM properties (required)
        :return: WormProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worm_file_path', 'worm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_worm_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'worm_file_path' is set
        if ('worm_file_path' not in params or
                params['worm_file_path'] is None):
            raise ValueError("Missing the required parameter `worm_file_path` when calling `get_worm_properties`")  # noqa: E501
        # verify the required parameter 'worm' is set
        if ('worm' not in params or
                params['worm'] is None):
            raise ValueError("Missing the required parameter `worm` when calling `get_worm_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'worm_file_path' in params:
            path_params['WormFilePath'] = params['worm_file_path']  # noqa: E501

        query_params = []
        if 'worm' in params:
            query_params.append(('worm', params['worm']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{WormFilePath}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WormProperties',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_access_points(self, **kwargs):  # noqa: E501
        """list_access_points  # noqa: E501

        Retrieves the namespace access points available for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_points(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool versions: Protocol versions that are supported for the current namespace access server.
        :return: NamespaceAccessPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_access_points_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_access_points_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_access_points_with_http_info(self, **kwargs):  # noqa: E501
        """list_access_points  # noqa: E501

        Retrieves the namespace access points available for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_access_points_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool versions: Protocol versions that are supported for the current namespace access server.
        :return: NamespaceAccessPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['versions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_access_points" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'versions' in params:
            query_params.append(('versions', params['versions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NamespaceAccessPoints',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_directory(self, directory_path, x_isi_ifs_set_location, **kwargs):  # noqa: E501
        """move_directory  # noqa: E501

        Moves a directory from an existing source to a new destination path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_directory(directory_path, x_isi_ifs_set_location, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param str x_isi_ifs_set_location: Specifies the full path for the destination directory. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_directory_with_http_info(directory_path, x_isi_ifs_set_location, **kwargs)  # noqa: E501
        else:
            (data) = self.move_directory_with_http_info(directory_path, x_isi_ifs_set_location, **kwargs)  # noqa: E501
            return data

    def move_directory_with_http_info(self, directory_path, x_isi_ifs_set_location, **kwargs):  # noqa: E501
        """move_directory  # noqa: E501

        Moves a directory from an existing source to a new destination path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_directory_with_http_info(directory_path, x_isi_ifs_set_location, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_path: Directory path relative to /. (required)
        :param str x_isi_ifs_set_location: Specifies the full path for the destination directory. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_path', 'x_isi_ifs_set_location']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_directory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_path' is set
        if ('directory_path' not in params or
                params['directory_path'] is None):
            raise ValueError("Missing the required parameter `directory_path` when calling `move_directory`")  # noqa: E501
        # verify the required parameter 'x_isi_ifs_set_location' is set
        if ('x_isi_ifs_set_location' not in params or
                params['x_isi_ifs_set_location'] is None):
            raise ValueError("Missing the required parameter `x_isi_ifs_set_location` when calling `move_directory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'directory_path' in params:
            path_params['DirectoryPath'] = params['directory_path']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_isi_ifs_set_location' in params:
            header_params['x-isi-ifs-set-location'] = params['x_isi_ifs_set_location']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{DirectoryPath}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_directory_with_access_point_container_path(self, access_point, container_path, x_isi_ifs_set_location, **kwargs):  # noqa: E501
        """move_directory_with_access_point_container_path  # noqa: E501

        Moves a directory from an existing source to a new destination path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_directory_with_access_point_container_path(access_point, container_path, x_isi_ifs_set_location, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point: Access point. (required)
        :param str container_path: Directory path relative to access point. (required)
        :param str x_isi_ifs_set_location: Specifies the full path for the destination directory. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_directory_with_access_point_container_path_with_http_info(access_point, container_path, x_isi_ifs_set_location, **kwargs)  # noqa: E501
        else:
            (data) = self.move_directory_with_access_point_container_path_with_http_info(access_point, container_path, x_isi_ifs_set_location, **kwargs)  # noqa: E501
            return data

    def move_directory_with_access_point_container_path_with_http_info(self, access_point, container_path, x_isi_ifs_set_location, **kwargs):  # noqa: E501
        """move_directory_with_access_point_container_path  # noqa: E501

        Moves a directory from an existing source to a new destination path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_directory_with_access_point_container_path_with_http_info(access_point, container_path, x_isi_ifs_set_location, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_point: Access point. (required)
        :param str container_path: Directory path relative to access point. (required)
        :param str x_isi_ifs_set_location: Specifies the full path for the destination directory. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_point', 'container_path', 'x_isi_ifs_set_location']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_directory_with_access_point_container_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'access_point' is set
        if ('access_point' not in params or
                params['access_point'] is None):
            raise ValueError("Missing the required parameter `access_point` when calling `move_directory_with_access_point_container_path`")  # noqa: E501
        # verify the required parameter 'container_path' is set
        if ('container_path' not in params or
                params['container_path'] is None):
            raise ValueError("Missing the required parameter `container_path` when calling `move_directory_with_access_point_container_path`")  # noqa: E501
        # verify the required parameter 'x_isi_ifs_set_location' is set
        if ('x_isi_ifs_set_location' not in params or
                params['x_isi_ifs_set_location'] is None):
            raise ValueError("Missing the required parameter `x_isi_ifs_set_location` when calling `move_directory_with_access_point_container_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'access_point' in params:
            path_params['AccessPoint'] = params['access_point']  # noqa: E501
        if 'container_path' in params:
            path_params['ContainerPath'] = params['container_path']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_isi_ifs_set_location' in params:
            header_params['x-isi-ifs-set-location'] = params['x_isi_ifs_set_location']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{AccessPoint}/{ContainerPath}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_file(self, file_path, x_isi_ifs_set_location, **kwargs):  # noqa: E501
        """move_file  # noqa: E501

        Moves a file to a destination path that does not yet exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_file(file_path, x_isi_ifs_set_location, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :param str x_isi_ifs_set_location: Specifies the full path for the destination file.  (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.move_file_with_http_info(file_path, x_isi_ifs_set_location, **kwargs)  # noqa: E501
        else:
            (data) = self.move_file_with_http_info(file_path, x_isi_ifs_set_location, **kwargs)  # noqa: E501
            return data

    def move_file_with_http_info(self, file_path, x_isi_ifs_set_location, **kwargs):  # noqa: E501
        """move_file  # noqa: E501

        Moves a file to a destination path that does not yet exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.move_file_with_http_info(file_path, x_isi_ifs_set_location, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path: File path relative to /. (required)
        :param str x_isi_ifs_set_location: Specifies the full path for the destination file.  (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_path', 'x_isi_ifs_set_location']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_path' is set
        if ('file_path' not in params or
                params['file_path'] is None):
            raise ValueError("Missing the required parameter `file_path` when calling `move_file`")  # noqa: E501
        # verify the required parameter 'x_isi_ifs_set_location' is set
        if ('x_isi_ifs_set_location' not in params or
                params['x_isi_ifs_set_location'] is None):
            raise ValueError("Missing the required parameter `x_isi_ifs_set_location` when calling `move_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_path' in params:
            path_params['FilePath'] = params['file_path']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_isi_ifs_set_location' in params:
            header_params['x-isi-ifs-set-location'] = params['x_isi_ifs_set_location']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{FilePath}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_directory(self, query_path, query, directory_query, **kwargs):  # noqa: E501
        """query_directory  # noqa: E501

        Query objects by system-defined and user-defined attributes in a directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_directory(query_path, query, directory_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query_path: Directory path relative to /. (required)
        :param bool query: Enable directory query. (required)
        :param DirectoryQuery directory_query: Directory query parameters model. (required)
        :param int limit: Specifies the maximum number of objects to send to the client. You can set the value to a negative number to retrieve all objects.
        :param str detail: Specifies which object attributes are displayed. If the detail parameter is excluded, only the name of the object is returned.
        :param str resume: Specifies a token to return in the JSON result to indicate when there is a next page.
        :param str sort: Specifies one or more attributes to sort on the directory entries.
        :param str dir: Specifies the sort direction. This value can be either ascending (ASC) or descending (DESC).
        :param str type: Specifies the object type to return, which can be one of the following values: container, object, pipe, character_device, block_device, symbolic_link, socket, or whiteout_file.
        :param bool hidden: Specifies if hidden objects are returned.
        :param int max_depth: Specifies the maximum directory level depth to search for objects.
        :return: NamespaceObjects
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.query_directory_with_http_info(query_path, query, directory_query, **kwargs)  # noqa: E501
        else:
            (data) = self.query_directory_with_http_info(query_path, query, directory_query, **kwargs)  # noqa: E501
            return data

    def query_directory_with_http_info(self, query_path, query, directory_query, **kwargs):  # noqa: E501
        """query_directory  # noqa: E501

        Query objects by system-defined and user-defined attributes in a directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_directory_with_http_info(query_path, query, directory_query, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str query_path: Directory path relative to /. (required)
        :param bool query: Enable directory query. (required)
        :param DirectoryQuery directory_query: Directory query parameters model. (required)
        :param int limit: Specifies the maximum number of objects to send to the client. You can set the value to a negative number to retrieve all objects.
        :param str detail: Specifies which object attributes are displayed. If the detail parameter is excluded, only the name of the object is returned.
        :param str resume: Specifies a token to return in the JSON result to indicate when there is a next page.
        :param str sort: Specifies one or more attributes to sort on the directory entries.
        :param str dir: Specifies the sort direction. This value can be either ascending (ASC) or descending (DESC).
        :param str type: Specifies the object type to return, which can be one of the following values: container, object, pipe, character_device, block_device, symbolic_link, socket, or whiteout_file.
        :param bool hidden: Specifies if hidden objects are returned.
        :param int max_depth: Specifies the maximum directory level depth to search for objects.
        :return: NamespaceObjects
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_path', 'query', 'directory_query', 'limit', 'detail', 'resume', 'sort', 'dir', 'type', 'hidden', 'max_depth']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_directory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query_path' is set
        if ('query_path' not in params or
                params['query_path'] is None):
            raise ValueError("Missing the required parameter `query_path` when calling `query_directory`")  # noqa: E501
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `query_directory`")  # noqa: E501
        # verify the required parameter 'directory_query' is set
        if ('directory_query' not in params or
                params['directory_query'] is None):
            raise ValueError("Missing the required parameter `directory_query` when calling `query_directory`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'query_path' in params:
            path_params['QueryPath'] = params['query_path']  # noqa: E501

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'detail' in params:
            query_params.append(('detail', params['detail']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'hidden' in params:
            query_params.append(('hidden', params['hidden']))  # noqa: E501
        if 'max_depth' in params:
            query_params.append(('max-depth', params['max_depth']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'directory_query' in params:
            body_params = params['directory_query']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{QueryPath}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NamespaceObjects',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_acl(self, namespace_path, acl, namespace_acl, **kwargs):  # noqa: E501
        """set_acl  # noqa: E501

        Sets the access control list for a namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_acl(namespace_path, acl, namespace_acl, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace_path: Namespace path relative to /. (required)
        :param bool acl: Update access control lists. (required)
        :param NamespaceAcl namespace_acl: Namespace ACL parameters model. (required)
        :param bool nsaccess: Indicates that the operation is on the access point instead of the store path.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_acl_with_http_info(namespace_path, acl, namespace_acl, **kwargs)  # noqa: E501
        else:
            (data) = self.set_acl_with_http_info(namespace_path, acl, namespace_acl, **kwargs)  # noqa: E501
            return data

    def set_acl_with_http_info(self, namespace_path, acl, namespace_acl, **kwargs):  # noqa: E501
        """set_acl  # noqa: E501

        Sets the access control list for a namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_acl_with_http_info(namespace_path, acl, namespace_acl, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace_path: Namespace path relative to /. (required)
        :param bool acl: Update access control lists. (required)
        :param NamespaceAcl namespace_acl: Namespace ACL parameters model. (required)
        :param bool nsaccess: Indicates that the operation is on the access point instead of the store path.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace_path', 'acl', 'namespace_acl', 'nsaccess']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_acl" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace_path' is set
        if ('namespace_path' not in params or
                params['namespace_path'] is None):
            raise ValueError("Missing the required parameter `namespace_path` when calling `set_acl`")  # noqa: E501
        # verify the required parameter 'acl' is set
        if ('acl' not in params or
                params['acl'] is None):
            raise ValueError("Missing the required parameter `acl` when calling `set_acl`")  # noqa: E501
        # verify the required parameter 'namespace_acl' is set
        if ('namespace_acl' not in params or
                params['namespace_acl'] is None):
            raise ValueError("Missing the required parameter `namespace_acl` when calling `set_acl`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace_path' in params:
            path_params['NamespacePath'] = params['namespace_path']  # noqa: E501

        query_params = []
        if 'acl' in params:
            query_params.append(('acl', params['acl']))  # noqa: E501
        if 'nsaccess' in params:
            query_params.append(('nsaccess', params['nsaccess']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'namespace_acl' in params:
            body_params = params['namespace_acl']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{NamespacePath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_directory_metadata(self, directory_metadata_path, metadata, directory_metadata, **kwargs):  # noqa: E501
        """set_directory_metadata  # noqa: E501

        Sets attributes on a specified directory with the metadata query argument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_directory_metadata(directory_metadata_path, metadata, directory_metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_metadata_path: Directory path relative to /. (required)
        :param bool metadata: Set directory metadata. (required)
        :param NamespaceMetadata directory_metadata: Directory metadata parameters model. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_directory_metadata_with_http_info(directory_metadata_path, metadata, directory_metadata, **kwargs)  # noqa: E501
        else:
            (data) = self.set_directory_metadata_with_http_info(directory_metadata_path, metadata, directory_metadata, **kwargs)  # noqa: E501
            return data

    def set_directory_metadata_with_http_info(self, directory_metadata_path, metadata, directory_metadata, **kwargs):  # noqa: E501
        """set_directory_metadata  # noqa: E501

        Sets attributes on a specified directory with the metadata query argument.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_directory_metadata_with_http_info(directory_metadata_path, metadata, directory_metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str directory_metadata_path: Directory path relative to /. (required)
        :param bool metadata: Set directory metadata. (required)
        :param NamespaceMetadata directory_metadata: Directory metadata parameters model. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['directory_metadata_path', 'metadata', 'directory_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_directory_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'directory_metadata_path' is set
        if ('directory_metadata_path' not in params or
                params['directory_metadata_path'] is None):
            raise ValueError("Missing the required parameter `directory_metadata_path` when calling `set_directory_metadata`")  # noqa: E501
        # verify the required parameter 'metadata' is set
        if ('metadata' not in params or
                params['metadata'] is None):
            raise ValueError("Missing the required parameter `metadata` when calling `set_directory_metadata`")  # noqa: E501
        # verify the required parameter 'directory_metadata' is set
        if ('directory_metadata' not in params or
                params['directory_metadata'] is None):
            raise ValueError("Missing the required parameter `directory_metadata` when calling `set_directory_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'directory_metadata_path' in params:
            path_params['DirectoryMetadataPath'] = params['directory_metadata_path']  # noqa: E501

        query_params = []
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'directory_metadata' in params:
            body_params = params['directory_metadata']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{DirectoryMetadataPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_file_metadata(self, file_metadata_path, metadata, file_metadata, **kwargs):  # noqa: E501
        """set_file_metadata  # noqa: E501

        Sets attributes on a specified file with the metadata query argument through the JSON body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_file_metadata(file_metadata_path, metadata, file_metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_metadata_path: File path relative to /. (required)
        :param bool metadata: Set file metadata. (required)
        :param NamespaceMetadata file_metadata: File metadata parameters model. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_file_metadata_with_http_info(file_metadata_path, metadata, file_metadata, **kwargs)  # noqa: E501
        else:
            (data) = self.set_file_metadata_with_http_info(file_metadata_path, metadata, file_metadata, **kwargs)  # noqa: E501
            return data

    def set_file_metadata_with_http_info(self, file_metadata_path, metadata, file_metadata, **kwargs):  # noqa: E501
        """set_file_metadata  # noqa: E501

        Sets attributes on a specified file with the metadata query argument through the JSON body.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_file_metadata_with_http_info(file_metadata_path, metadata, file_metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_metadata_path: File path relative to /. (required)
        :param bool metadata: Set file metadata. (required)
        :param NamespaceMetadata file_metadata: File metadata parameters model. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_metadata_path', 'metadata', 'file_metadata']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_file_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'file_metadata_path' is set
        if ('file_metadata_path' not in params or
                params['file_metadata_path'] is None):
            raise ValueError("Missing the required parameter `file_metadata_path` when calling `set_file_metadata`")  # noqa: E501
        # verify the required parameter 'metadata' is set
        if ('metadata' not in params or
                params['metadata'] is None):
            raise ValueError("Missing the required parameter `metadata` when calling `set_file_metadata`")  # noqa: E501
        # verify the required parameter 'file_metadata' is set
        if ('file_metadata' not in params or
                params['file_metadata'] is None):
            raise ValueError("Missing the required parameter `file_metadata` when calling `set_file_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'file_metadata_path' in params:
            path_params['FileMetadataPath'] = params['file_metadata_path']  # noqa: E501

        query_params = []
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'file_metadata' in params:
            body_params = params['file_metadata']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{FileMetadataPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_worm_properties(self, worm_file_path, worm, worm_properties, **kwargs):  # noqa: E501
        """set_worm_properties  # noqa: E501

        Sets the retention period and commits a file in a SmartLock directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_worm_properties(worm_file_path, worm, worm_properties, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str worm_file_path: Write once read many file path relative to /. (required)
        :param bool worm: View WORM properties (required)
        :param WormCreateParams worm_properties: WORM parameters model. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_worm_properties_with_http_info(worm_file_path, worm, worm_properties, **kwargs)  # noqa: E501
        else:
            (data) = self.set_worm_properties_with_http_info(worm_file_path, worm, worm_properties, **kwargs)  # noqa: E501
            return data

    def set_worm_properties_with_http_info(self, worm_file_path, worm, worm_properties, **kwargs):  # noqa: E501
        """set_worm_properties  # noqa: E501

        Sets the retention period and commits a file in a SmartLock directory.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_worm_properties_with_http_info(worm_file_path, worm, worm_properties, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str worm_file_path: Write once read many file path relative to /. (required)
        :param bool worm: View WORM properties (required)
        :param WormCreateParams worm_properties: WORM parameters model. (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worm_file_path', 'worm', 'worm_properties']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_worm_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'worm_file_path' is set
        if ('worm_file_path' not in params or
                params['worm_file_path'] is None):
            raise ValueError("Missing the required parameter `worm_file_path` when calling `set_worm_properties`")  # noqa: E501
        # verify the required parameter 'worm' is set
        if ('worm' not in params or
                params['worm'] is None):
            raise ValueError("Missing the required parameter `worm` when calling `set_worm_properties`")  # noqa: E501
        # verify the required parameter 'worm_properties' is set
        if ('worm_properties' not in params or
                params['worm_properties'] is None):
            raise ValueError("Missing the required parameter `worm_properties` when calling `set_worm_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'worm_file_path' in params:
            path_params['WormFilePath'] = params['worm_file_path']  # noqa: E501

        query_params = []
        if 'worm' in params:
            query_params.append(('worm', params['worm']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'worm_properties' in params:
            body_params = params['worm_properties']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/namespace/{WormFilePath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
