# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_2_1.api_client import ApiClient


class ClusterNodesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_drives_drive_add_item(self, drives_drive_add_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_add_item  # noqa: E501

        Add a drive to a node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_add_item(drives_drive_add_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty drives_drive_add_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_drives_drive_add_item_with_http_info(drives_drive_add_item, lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_drives_drive_add_item_with_http_info(drives_drive_add_item, lnn, driveid, **kwargs)  # noqa: E501
            return data

    def create_drives_drive_add_item_with_http_info(self, drives_drive_add_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_add_item  # noqa: E501

        Add a drive to a node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_add_item_with_http_info(drives_drive_add_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty drives_drive_add_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['drives_drive_add_item', 'lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_drives_drive_add_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'drives_drive_add_item' is set
        if ('drives_drive_add_item' not in params or
                params['drives_drive_add_item'] is None):
            raise ValueError("Missing the required parameter `drives_drive_add_item` when calling `create_drives_drive_add_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_drives_drive_add_item`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `create_drives_drive_add_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drives_drive_add_item' in params:
            body_params = params['drives_drive_add_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_drives_drive_firmware_update_item(self, drives_drive_firmware_update_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_firmware_update_item  # noqa: E501

        Start a drive firmware update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_firmware_update_item(drives_drive_firmware_update_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrivesDriveFirmwareUpdateItem drives_drive_firmware_update_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_drives_drive_firmware_update_item_with_http_info(drives_drive_firmware_update_item, lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_drives_drive_firmware_update_item_with_http_info(drives_drive_firmware_update_item, lnn, driveid, **kwargs)  # noqa: E501
            return data

    def create_drives_drive_firmware_update_item_with_http_info(self, drives_drive_firmware_update_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_firmware_update_item  # noqa: E501

        Start a drive firmware update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_firmware_update_item_with_http_info(drives_drive_firmware_update_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrivesDriveFirmwareUpdateItem drives_drive_firmware_update_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['drives_drive_firmware_update_item', 'lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_drives_drive_firmware_update_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'drives_drive_firmware_update_item' is set
        if ('drives_drive_firmware_update_item' not in params or
                params['drives_drive_firmware_update_item'] is None):
            raise ValueError("Missing the required parameter `drives_drive_firmware_update_item` when calling `create_drives_drive_firmware_update_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_drives_drive_firmware_update_item`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `create_drives_drive_firmware_update_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drives_drive_firmware_update_item' in params:
            body_params = params['drives_drive_firmware_update_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/firmware/update', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_drives_drive_format_item(self, drives_drive_format_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_format_item  # noqa: E501

        Format a drive for use by OneFS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_format_item(drives_drive_format_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrivesDriveFormatItem drives_drive_format_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_drives_drive_format_item_with_http_info(drives_drive_format_item, lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_drives_drive_format_item_with_http_info(drives_drive_format_item, lnn, driveid, **kwargs)  # noqa: E501
            return data

    def create_drives_drive_format_item_with_http_info(self, drives_drive_format_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_format_item  # noqa: E501

        Format a drive for use by OneFS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_format_item_with_http_info(drives_drive_format_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrivesDriveFormatItem drives_drive_format_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['drives_drive_format_item', 'lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_drives_drive_format_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'drives_drive_format_item' is set
        if ('drives_drive_format_item' not in params or
                params['drives_drive_format_item'] is None):
            raise ValueError("Missing the required parameter `drives_drive_format_item` when calling `create_drives_drive_format_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_drives_drive_format_item`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `create_drives_drive_format_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drives_drive_format_item' in params:
            body_params = params['drives_drive_format_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/format', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_drives_drive_purpose_item(self, drives_drive_purpose_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_purpose_item  # noqa: E501

        Assign a drive to a specific use case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_purpose_item(drives_drive_purpose_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrivesDrivePurposeItem drives_drive_purpose_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_drives_drive_purpose_item_with_http_info(drives_drive_purpose_item, lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_drives_drive_purpose_item_with_http_info(drives_drive_purpose_item, lnn, driveid, **kwargs)  # noqa: E501
            return data

    def create_drives_drive_purpose_item_with_http_info(self, drives_drive_purpose_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_purpose_item  # noqa: E501

        Assign a drive to a specific use case.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_purpose_item_with_http_info(drives_drive_purpose_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DrivesDrivePurposeItem drives_drive_purpose_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['drives_drive_purpose_item', 'lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_drives_drive_purpose_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'drives_drive_purpose_item' is set
        if ('drives_drive_purpose_item' not in params or
                params['drives_drive_purpose_item'] is None):
            raise ValueError("Missing the required parameter `drives_drive_purpose_item` when calling `create_drives_drive_purpose_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_drives_drive_purpose_item`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `create_drives_drive_purpose_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drives_drive_purpose_item' in params:
            body_params = params['drives_drive_purpose_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/purpose', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_drives_drive_smartfail_item(self, drives_drive_smartfail_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_smartfail_item  # noqa: E501

        Remove a drive from use by OneFS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_smartfail_item(drives_drive_smartfail_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty drives_drive_smartfail_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_drives_drive_smartfail_item_with_http_info(drives_drive_smartfail_item, lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_drives_drive_smartfail_item_with_http_info(drives_drive_smartfail_item, lnn, driveid, **kwargs)  # noqa: E501
            return data

    def create_drives_drive_smartfail_item_with_http_info(self, drives_drive_smartfail_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_smartfail_item  # noqa: E501

        Remove a drive from use by OneFS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_smartfail_item_with_http_info(drives_drive_smartfail_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty drives_drive_smartfail_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['drives_drive_smartfail_item', 'lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_drives_drive_smartfail_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'drives_drive_smartfail_item' is set
        if ('drives_drive_smartfail_item' not in params or
                params['drives_drive_smartfail_item'] is None):
            raise ValueError("Missing the required parameter `drives_drive_smartfail_item` when calling `create_drives_drive_smartfail_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_drives_drive_smartfail_item`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `create_drives_drive_smartfail_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drives_drive_smartfail_item' in params:
            body_params = params['drives_drive_smartfail_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/smartfail', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_drives_drive_stopfail_item(self, drives_drive_stopfail_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_stopfail_item  # noqa: E501

        Stop restriping from a smartfailing drive.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_stopfail_item(drives_drive_stopfail_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty drives_drive_stopfail_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_drives_drive_stopfail_item_with_http_info(drives_drive_stopfail_item, lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_drives_drive_stopfail_item_with_http_info(drives_drive_stopfail_item, lnn, driveid, **kwargs)  # noqa: E501
            return data

    def create_drives_drive_stopfail_item_with_http_info(self, drives_drive_stopfail_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_stopfail_item  # noqa: E501

        Stop restriping from a smartfailing drive.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_stopfail_item_with_http_info(drives_drive_stopfail_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty drives_drive_stopfail_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['drives_drive_stopfail_item', 'lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_drives_drive_stopfail_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'drives_drive_stopfail_item' is set
        if ('drives_drive_stopfail_item' not in params or
                params['drives_drive_stopfail_item'] is None):
            raise ValueError("Missing the required parameter `drives_drive_stopfail_item` when calling `create_drives_drive_stopfail_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_drives_drive_stopfail_item`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `create_drives_drive_stopfail_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drives_drive_stopfail_item' in params:
            body_params = params['drives_drive_stopfail_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/stopfail', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_drives_drive_suspend_item(self, drives_drive_suspend_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_suspend_item  # noqa: E501

        Temporarily remove a drive from use by OneFS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_suspend_item(drives_drive_suspend_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty drives_drive_suspend_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_drives_drive_suspend_item_with_http_info(drives_drive_suspend_item, lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.create_drives_drive_suspend_item_with_http_info(drives_drive_suspend_item, lnn, driveid, **kwargs)  # noqa: E501
            return data

    def create_drives_drive_suspend_item_with_http_info(self, drives_drive_suspend_item, lnn, driveid, **kwargs):  # noqa: E501
        """create_drives_drive_suspend_item  # noqa: E501

        Temporarily remove a drive from use by OneFS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_drives_drive_suspend_item_with_http_info(drives_drive_suspend_item, lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty drives_drive_suspend_item: (required)
        :param int lnn: (required)
        :param str driveid: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['drives_drive_suspend_item', 'lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_drives_drive_suspend_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'drives_drive_suspend_item' is set
        if ('drives_drive_suspend_item' not in params or
                params['drives_drive_suspend_item'] is None):
            raise ValueError("Missing the required parameter `drives_drive_suspend_item` when calling `create_drives_drive_suspend_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_drives_drive_suspend_item`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `create_drives_drive_suspend_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'drives_drive_suspend_item' in params:
            body_params = params['drives_drive_suspend_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/suspend', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_node_reboot_item(self, node_reboot_item, lnn, **kwargs):  # noqa: E501
        """create_node_reboot_item  # noqa: E501

        Reboot the node specified by <LNN>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_reboot_item(node_reboot_item, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty node_reboot_item: (required)
        :param int lnn: (required)
        :param bool force: Force reboot on Infinity platform even if a drive sled is not present.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_node_reboot_item_with_http_info(node_reboot_item, lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.create_node_reboot_item_with_http_info(node_reboot_item, lnn, **kwargs)  # noqa: E501
            return data

    def create_node_reboot_item_with_http_info(self, node_reboot_item, lnn, **kwargs):  # noqa: E501
        """create_node_reboot_item  # noqa: E501

        Reboot the node specified by <LNN>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_reboot_item_with_http_info(node_reboot_item, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty node_reboot_item: (required)
        :param int lnn: (required)
        :param bool force: Force reboot on Infinity platform even if a drive sled is not present.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_reboot_item', 'lnn', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_node_reboot_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_reboot_item' is set
        if ('node_reboot_item' not in params or
                params['node_reboot_item'] is None):
            raise ValueError("Missing the required parameter `node_reboot_item` when calling `create_node_reboot_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_node_reboot_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'node_reboot_item' in params:
            body_params = params['node_reboot_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/cluster/nodes/{Lnn}/reboot', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_node_shutdown_item(self, node_shutdown_item, lnn, **kwargs):  # noqa: E501
        """create_node_shutdown_item  # noqa: E501

        Shutdown the node specified by <LNN>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_shutdown_item(node_shutdown_item, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty node_shutdown_item: (required)
        :param int lnn: (required)
        :param bool force: Force shutdown on Infinity platform even if a drive sled is not present.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_node_shutdown_item_with_http_info(node_shutdown_item, lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.create_node_shutdown_item_with_http_info(node_shutdown_item, lnn, **kwargs)  # noqa: E501
            return data

    def create_node_shutdown_item_with_http_info(self, node_shutdown_item, lnn, **kwargs):  # noqa: E501
        """create_node_shutdown_item  # noqa: E501

        Shutdown the node specified by <LNN>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_node_shutdown_item_with_http_info(node_shutdown_item, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty node_shutdown_item: (required)
        :param int lnn: (required)
        :param bool force: Force shutdown on Infinity platform even if a drive sled is not present.
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_shutdown_item', 'lnn', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_node_shutdown_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_shutdown_item' is set
        if ('node_shutdown_item' not in params or
                params['node_shutdown_item'] is None):
            raise ValueError("Missing the required parameter `node_shutdown_item` when calling `create_node_shutdown_item`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `create_node_shutdown_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'node_shutdown_item' in params:
            body_params = params['node_shutdown_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/cluster/nodes/{Lnn}/shutdown', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_drives_drive_firmware(self, lnn, driveid, **kwargs):  # noqa: E501
        """get_drives_drive_firmware  # noqa: E501

        Retrieve drive firmware information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_drives_drive_firmware(lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param str driveid: (required)
        :return: DrivesDriveFirmware
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_drives_drive_firmware_with_http_info(lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_drives_drive_firmware_with_http_info(lnn, driveid, **kwargs)  # noqa: E501
            return data

    def get_drives_drive_firmware_with_http_info(self, lnn, driveid, **kwargs):  # noqa: E501
        """get_drives_drive_firmware  # noqa: E501

        Retrieve drive firmware information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_drives_drive_firmware_with_http_info(lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param str driveid: (required)
        :return: DrivesDriveFirmware
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_drives_drive_firmware" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_drives_drive_firmware`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `get_drives_drive_firmware`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes/{Lnn}/drives/{Driveid}/firmware', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DrivesDriveFirmware',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_drive(self, node_drive_id, lnn, **kwargs):  # noqa: E501
        """get_node_drive  # noqa: E501

        Retrieve drive information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_drive(node_drive_id, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_drive_id: Retrieve drive information. (required)
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeDrives
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_drive_with_http_info(node_drive_id, lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_drive_with_http_info(node_drive_id, lnn, **kwargs)  # noqa: E501
            return data

    def get_node_drive_with_http_info(self, node_drive_id, lnn, **kwargs):  # noqa: E501
        """get_node_drive  # noqa: E501

        Retrieve drive information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_drive_with_http_info(node_drive_id, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_drive_id: Retrieve drive information. (required)
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeDrives
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_drive_id', 'lnn', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_drive" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_drive_id' is set
        if ('node_drive_id' not in params or
                params['node_drive_id'] is None):
            raise ValueError("Missing the required parameter `node_drive_id` when calling `get_node_drive`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_drive`")  # noqa: E501

        if 'timeout' in params and params['timeout'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_drive`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'timeout' in params and params['timeout'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_drive`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'node_drive_id' in params:
            path_params['NodeDriveId'] = params['node_drive_id']  # noqa: E501
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes/{Lnn}/drives/{NodeDriveId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeDrives',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_driveconfig(self, lnn, **kwargs):  # noqa: E501
        """get_node_driveconfig  # noqa: E501

        View a node's drive subsystem XML configuration file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_driveconfig(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeDriveconfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_driveconfig_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_driveconfig_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_driveconfig_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_driveconfig  # noqa: E501

        View a node's drive subsystem XML configuration file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_driveconfig_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeDriveconfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_driveconfig" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_driveconfig`")  # noqa: E501

        if 'timeout' in params and params['timeout'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_driveconfig`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'timeout' in params and params['timeout'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_driveconfig`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes/{Lnn}/driveconfig', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeDriveconfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_drives(self, lnn, **kwargs):  # noqa: E501
        """get_node_drives  # noqa: E501

        List the drives on this node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_drives(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeDrives
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_drives_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_drives_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_drives_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_drives  # noqa: E501

        List the drives on this node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_drives_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeDrives
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_drives" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_drives`")  # noqa: E501

        if 'timeout' in params and params['timeout'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_drives`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'timeout' in params and params['timeout'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_drives`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes/{Lnn}/drives', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeDrives',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_drives_purposelist(self, lnn, **kwargs):  # noqa: E501
        """get_node_drives_purposelist  # noqa: E501

        Lists the available purposes for drives in this node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_drives_purposelist(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeDrivesPurposelist
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_drives_purposelist_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_drives_purposelist_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_drives_purposelist_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_drives_purposelist  # noqa: E501

        Lists the available purposes for drives in this node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_drives_purposelist_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeDrivesPurposelist
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_drives_purposelist" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_drives_purposelist`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives-purposelist', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeDrivesPurposelist',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_hardware(self, lnn, **kwargs):  # noqa: E501
        """get_node_hardware  # noqa: E501

        Retrieve node hardware identity information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_hardware(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeHardware
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_hardware_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_hardware_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_hardware_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_hardware  # noqa: E501

        Retrieve node hardware identity information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_hardware_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeHardware
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_hardware" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_hardware`")  # noqa: E501

        if 'timeout' in params and params['timeout'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_hardware`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'timeout' in params and params['timeout'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_hardware`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/cluster/nodes/{Lnn}/hardware', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeHardware',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_hardware_fast(self, lnn, **kwargs):  # noqa: E501
        """get_node_hardware_fast  # noqa: E501

        Quickly retrieve a subset of node hardware identity information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_hardware_fast(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeHardwareFast
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_hardware_fast_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_hardware_fast_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_hardware_fast_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_hardware_fast  # noqa: E501

        Quickly retrieve a subset of node hardware identity information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_hardware_fast_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeHardwareFast
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_hardware_fast" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_hardware_fast`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/hardware-fast', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeHardwareFast',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_internal_ip_address(self, lnn, **kwargs):  # noqa: E501
        """get_node_internal_ip_address  # noqa: E501

        View internal ip address with respect to node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_internal_ip_address(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeInternalIpAddress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_internal_ip_address_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_internal_ip_address_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_internal_ip_address_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_internal_ip_address  # noqa: E501

        View internal ip address with respect to node.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_internal_ip_address_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeInternalIpAddress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_internal_ip_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_internal_ip_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes/{Lnn}/internal-ip-address', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeInternalIpAddress',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_partitions(self, lnn, **kwargs):  # noqa: E501
        """get_node_partitions  # noqa: E501

        Retrieve node partition information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_partitions(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodePartitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_partitions_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_partitions_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_partitions_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_partitions  # noqa: E501

        Retrieve node partition information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_partitions_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodePartitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_partitions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_partitions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/partitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodePartitions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_sensors(self, lnn, **kwargs):  # noqa: E501
        """get_node_sensors  # noqa: E501

        Retrieve node sensor information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_sensors(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeSensors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_sensors_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_sensors_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_sensors_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_sensors  # noqa: E501

        Retrieve node sensor information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_sensors_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeSensors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_sensors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_sensors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/sensors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeSensors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_sled(self, node_sled_id, lnn, **kwargs):  # noqa: E501
        """get_node_sled  # noqa: E501

        Get detailed information for the sled specified by <SLEDID>, or all sleds in the case where <SLEDID> is 'all', in the node specified by <LNN>.  Accepts <sledid> in either 'sled' or 'all' formats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_sled(node_sled_id, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_sled_id: Get detailed information for the sled specified by <SLEDID>, or all sleds in the case where <SLEDID> is 'all', in the node specified by <LNN>.  Accepts <sledid> in either 'sled' or 'all' formats. (required)
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeSleds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_sled_with_http_info(node_sled_id, lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_sled_with_http_info(node_sled_id, lnn, **kwargs)  # noqa: E501
            return data

    def get_node_sled_with_http_info(self, node_sled_id, lnn, **kwargs):  # noqa: E501
        """get_node_sled  # noqa: E501

        Get detailed information for the sled specified by <SLEDID>, or all sleds in the case where <SLEDID> is 'all', in the node specified by <LNN>.  Accepts <sledid> in either 'sled' or 'all' formats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_sled_with_http_info(node_sled_id, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str node_sled_id: Get detailed information for the sled specified by <SLEDID>, or all sleds in the case where <SLEDID> is 'all', in the node specified by <LNN>.  Accepts <sledid> in either 'sled' or 'all' formats. (required)
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeSleds
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_sled_id', 'lnn', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_sled" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_sled_id' is set
        if ('node_sled_id' not in params or
                params['node_sled_id'] is None):
            raise ValueError("Missing the required parameter `node_sled_id` when calling `get_node_sled`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_sled`")  # noqa: E501

        if 'timeout' in params and params['timeout'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_sled`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'timeout' in params and params['timeout'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_sled`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'node_sled_id' in params:
            path_params['NodeSledId'] = params['node_sled_id']  # noqa: E501
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/cluster/nodes/{Lnn}/sleds/{NodeSledId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeSleds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_sleds(self, lnn, **kwargs):  # noqa: E501
        """get_node_sleds  # noqa: E501

        Get detailed information for all sleds in this node. Equivalent to /5/cluster/nodes/<lnn>/sleds/all.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_sleds(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeSleds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_sleds_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_sleds_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_sleds_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_sleds  # noqa: E501

        Get detailed information for all sleds in this node. Equivalent to /5/cluster/nodes/<lnn>/sleds/all.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_sleds_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param float timeout: Request timeout
        :return: NodeSleds
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_sleds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_sleds`")  # noqa: E501

        if 'timeout' in params and params['timeout'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_sleds`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'timeout' in params and params['timeout'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `timeout` when calling `get_node_sleds`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/cluster/nodes/{Lnn}/sleds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeSleds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_state(self, lnn, **kwargs):  # noqa: E501
        """get_node_state  # noqa: E501

        Retrieve node state information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_state(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeState
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_state_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_state_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_state_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_state  # noqa: E501

        Retrieve node state information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_state_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeState
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_state" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_state`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/cluster/nodes/{Lnn}/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeState',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_state_readonly(self, lnn, **kwargs):  # noqa: E501
        """get_node_state_readonly  # noqa: E501

        Retrieve node readonly state information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_state_readonly(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStateReadonly
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_state_readonly_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_state_readonly_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_state_readonly_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_state_readonly  # noqa: E501

        Retrieve node readonly state information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_state_readonly_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStateReadonly
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_state_readonly" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_state_readonly`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/state/readonly', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeStateReadonly',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_state_servicelight(self, lnn, **kwargs):  # noqa: E501
        """get_node_state_servicelight  # noqa: E501

        Retrieve node service light state information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_state_servicelight(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStateServicelight
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_state_servicelight_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_state_servicelight_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_state_servicelight_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_state_servicelight  # noqa: E501

        Retrieve node service light state information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_state_servicelight_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStateServicelight
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_state_servicelight" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_state_servicelight`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/cluster/nodes/{Lnn}/state/servicelight', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeStateServicelight',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_state_smartfail(self, lnn, **kwargs):  # noqa: E501
        """get_node_state_smartfail  # noqa: E501

        Retrieve node smartfail state information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_state_smartfail(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStateSmartfail
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_state_smartfail_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_state_smartfail_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_state_smartfail_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_state_smartfail  # noqa: E501

        Retrieve node smartfail state information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_state_smartfail_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStateSmartfail
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_state_smartfail" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_state_smartfail`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/state/smartfail', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeStateSmartfail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_status(self, lnn, **kwargs):  # noqa: E501
        """get_node_status  # noqa: E501

        Retrieve node status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_status_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_status_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_status_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_status  # noqa: E501

        Retrieve node status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/cluster/nodes/{Lnn}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeStatusExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_status_batterystatus(self, lnn, **kwargs):  # noqa: E501
        """get_node_status_batterystatus  # noqa: E501

        Retrieve node battery status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_batterystatus(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusBatterystatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_status_batterystatus_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_status_batterystatus_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_status_batterystatus_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_status_batterystatus  # noqa: E501

        Retrieve node battery status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_batterystatus_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusBatterystatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_status_batterystatus" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_status_batterystatus`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/status/batterystatus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeStatusBatterystatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_status_cpu(self, lnn, **kwargs):  # noqa: E501
        """get_node_status_cpu  # noqa: E501

        Retrieve node CPU status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_cpu(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusCpu
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_status_cpu_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_status_cpu_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_status_cpu_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_status_cpu  # noqa: E501

        Retrieve node CPU status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_cpu_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusCpu
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_status_cpu" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_status_cpu`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/cluster/nodes/{Lnn}/status/cpu', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeStatusCpu',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_status_nvram(self, lnn, **kwargs):  # noqa: E501
        """get_node_status_nvram  # noqa: E501

        Retrieve node NVRAM status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_nvram(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusNvram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_status_nvram_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_status_nvram_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_status_nvram_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_status_nvram  # noqa: E501

        Retrieve node NVRAM status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_nvram_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusNvram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_status_nvram" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_status_nvram`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/cluster/nodes/{Lnn}/status/nvram', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeStatusNvram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_status_powersupplies(self, lnn, **kwargs):  # noqa: E501
        """get_node_status_powersupplies  # noqa: E501

        Retrieve node power supplies status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_powersupplies(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusPowersupplies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_status_powersupplies_with_http_info(lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_status_powersupplies_with_http_info(lnn, **kwargs)  # noqa: E501
            return data

    def get_node_status_powersupplies_with_http_info(self, lnn, **kwargs):  # noqa: E501
        """get_node_status_powersupplies  # noqa: E501

        Retrieve node power supplies status information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_node_status_powersupplies_with_http_info(lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :return: NodeStatusPowersupplies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_status_powersupplies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `get_node_status_powersupplies`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/cluster/nodes/{Lnn}/status/powersupplies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NodeStatusPowersupplies',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_drives_drive_firmware_update(self, lnn, driveid, **kwargs):  # noqa: E501
        """list_drives_drive_firmware_update  # noqa: E501

        Retrieve firmware update information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_drives_drive_firmware_update(lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param str driveid: (required)
        :return: DrivesDriveFirmwareUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_drives_drive_firmware_update_with_http_info(lnn, driveid, **kwargs)  # noqa: E501
        else:
            (data) = self.list_drives_drive_firmware_update_with_http_info(lnn, driveid, **kwargs)  # noqa: E501
            return data

    def list_drives_drive_firmware_update_with_http_info(self, lnn, driveid, **kwargs):  # noqa: E501
        """list_drives_drive_firmware_update  # noqa: E501

        Retrieve firmware update information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_drives_drive_firmware_update_with_http_info(lnn, driveid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: (required)
        :param str driveid: (required)
        :return: DrivesDriveFirmwareUpdate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn', 'driveid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_drives_drive_firmware_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `list_drives_drive_firmware_update`")  # noqa: E501
        # verify the required parameter 'driveid' is set
        if ('driveid' not in params or
                params['driveid'] is None):
            raise ValueError("Missing the required parameter `driveid` when calling `list_drives_drive_firmware_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501
        if 'driveid' in params:
            path_params['Driveid'] = params['driveid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/drives/{Driveid}/firmware/update', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DrivesDriveFirmwareUpdate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_driveconfig(self, node_driveconfig, lnn, **kwargs):  # noqa: E501
        """update_node_driveconfig  # noqa: E501

        Modify a node's drive subsystem XML configuration file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_driveconfig(node_driveconfig, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeDriveconfigExtended node_driveconfig: (required)
        :param int lnn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_driveconfig_with_http_info(node_driveconfig, lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_driveconfig_with_http_info(node_driveconfig, lnn, **kwargs)  # noqa: E501
            return data

    def update_node_driveconfig_with_http_info(self, node_driveconfig, lnn, **kwargs):  # noqa: E501
        """update_node_driveconfig  # noqa: E501

        Modify a node's drive subsystem XML configuration file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_driveconfig_with_http_info(node_driveconfig, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeDriveconfigExtended node_driveconfig: (required)
        :param int lnn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_driveconfig', 'lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_driveconfig" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_driveconfig' is set
        if ('node_driveconfig' not in params or
                params['node_driveconfig'] is None):
            raise ValueError("Missing the required parameter `node_driveconfig` when calling `update_node_driveconfig`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `update_node_driveconfig`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'node_driveconfig' in params:
            body_params = params['node_driveconfig']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/cluster/nodes/{Lnn}/driveconfig', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_state_readonly(self, node_state_readonly, lnn, **kwargs):  # noqa: E501
        """update_node_state_readonly  # noqa: E501

        Modify one or more node readonly state settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_state_readonly(node_state_readonly, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeStateNodeReadonly node_state_readonly: (required)
        :param int lnn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_state_readonly_with_http_info(node_state_readonly, lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_state_readonly_with_http_info(node_state_readonly, lnn, **kwargs)  # noqa: E501
            return data

    def update_node_state_readonly_with_http_info(self, node_state_readonly, lnn, **kwargs):  # noqa: E501
        """update_node_state_readonly  # noqa: E501

        Modify one or more node readonly state settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_state_readonly_with_http_info(node_state_readonly, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeStateNodeReadonly node_state_readonly: (required)
        :param int lnn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_state_readonly', 'lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_state_readonly" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_state_readonly' is set
        if ('node_state_readonly' not in params or
                params['node_state_readonly'] is None):
            raise ValueError("Missing the required parameter `node_state_readonly` when calling `update_node_state_readonly`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `update_node_state_readonly`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'node_state_readonly' in params:
            body_params = params['node_state_readonly']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/state/readonly', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_state_servicelight(self, node_state_servicelight, lnn, **kwargs):  # noqa: E501
        """update_node_state_servicelight  # noqa: E501

        Modify one or more node service light state settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_state_servicelight(node_state_servicelight, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeStateServicelightExtended node_state_servicelight: (required)
        :param int lnn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_state_servicelight_with_http_info(node_state_servicelight, lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_state_servicelight_with_http_info(node_state_servicelight, lnn, **kwargs)  # noqa: E501
            return data

    def update_node_state_servicelight_with_http_info(self, node_state_servicelight, lnn, **kwargs):  # noqa: E501
        """update_node_state_servicelight  # noqa: E501

        Modify one or more node service light state settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_state_servicelight_with_http_info(node_state_servicelight, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeStateServicelightExtended node_state_servicelight: (required)
        :param int lnn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_state_servicelight', 'lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_state_servicelight" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_state_servicelight' is set
        if ('node_state_servicelight' not in params or
                params['node_state_servicelight'] is None):
            raise ValueError("Missing the required parameter `node_state_servicelight` when calling `update_node_state_servicelight`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `update_node_state_servicelight`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'node_state_servicelight' in params:
            body_params = params['node_state_servicelight']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/cluster/nodes/{Lnn}/state/servicelight', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_node_state_smartfail(self, node_state_smartfail, lnn, **kwargs):  # noqa: E501
        """update_node_state_smartfail  # noqa: E501

        Modify smartfail state of the node.  Only the 'smartfailed' body member has any effect on node smartfail state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_state_smartfail(node_state_smartfail, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeStateNodeSmartfail node_state_smartfail: (required)
        :param int lnn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_node_state_smartfail_with_http_info(node_state_smartfail, lnn, **kwargs)  # noqa: E501
        else:
            (data) = self.update_node_state_smartfail_with_http_info(node_state_smartfail, lnn, **kwargs)  # noqa: E501
            return data

    def update_node_state_smartfail_with_http_info(self, node_state_smartfail, lnn, **kwargs):  # noqa: E501
        """update_node_state_smartfail  # noqa: E501

        Modify smartfail state of the node.  Only the 'smartfailed' body member has any effect on node smartfail state.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_node_state_smartfail_with_http_info(node_state_smartfail, lnn, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NodeStateNodeSmartfail node_state_smartfail: (required)
        :param int lnn: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['node_state_smartfail', 'lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_node_state_smartfail" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'node_state_smartfail' is set
        if ('node_state_smartfail' not in params or
                params['node_state_smartfail'] is None):
            raise ValueError("Missing the required parameter `node_state_smartfail` when calling `update_node_state_smartfail`")  # noqa: E501
        # verify the required parameter 'lnn' is set
        if ('lnn' not in params or
                params['lnn'] is None):
            raise ValueError("Missing the required parameter `lnn` when calling `update_node_state_smartfail`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'lnn' in params:
            path_params['Lnn'] = params['lnn']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'node_state_smartfail' in params:
            body_params = params['node_state_smartfail']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/cluster/nodes/{Lnn}/state/smartfail', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
