# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_2_0.models.kmip_server_ca_cert import KmipServerCaCert  # noqa: F401,E501
from isilon_sdk.v9_2_0.models.kmip_server_client_cert import KmipServerClientCert  # noqa: F401,E501
from isilon_sdk.v9_2_0.models.kmip_server_extended import KmipServerExtended  # noqa: F401,E501


class KmipServerExtendedExtended(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'ca_cert': 'KmipServerCaCert',
        'client_cert': 'KmipServerClientCert',
        'host': 'str',
        'id': 'str',
        'minimum_tls_version': 'str',
        'port': 'int'
    }

    attribute_map = {
        'ca_cert': 'ca_cert',
        'client_cert': 'client_cert',
        'host': 'host',
        'id': 'id',
        'minimum_tls_version': 'minimum_tls_version',
        'port': 'port'
    }

    def __init__(self, ca_cert=None, client_cert=None, host=None, id=None, minimum_tls_version=None, port=None):  # noqa: E501
        """KmipServerExtendedExtended - a model defined in Swagger"""  # noqa: E501

        self._ca_cert = None
        self._client_cert = None
        self._host = None
        self._id = None
        self._minimum_tls_version = None
        self._port = None
        self.discriminator = None

        self.ca_cert = ca_cert
        self.client_cert = client_cert
        self.host = host
        self.id = id
        self.minimum_tls_version = minimum_tls_version
        self.port = port

    @property
    def ca_cert(self):
        """Gets the ca_cert of this KmipServerExtendedExtended.  # noqa: E501

          # noqa: E501

        :return: The ca_cert of this KmipServerExtendedExtended.  # noqa: E501
        :rtype: KmipServerCaCert
        """
        return self._ca_cert

    @ca_cert.setter
    def ca_cert(self, ca_cert):
        """Sets the ca_cert of this KmipServerExtendedExtended.

          # noqa: E501

        :param ca_cert: The ca_cert of this KmipServerExtendedExtended.  # noqa: E501
        :type: KmipServerCaCert
        """
        if ca_cert is None:
            raise ValueError("Invalid value for `ca_cert`, must not be `None`")  # noqa: E501

        self._ca_cert = ca_cert

    @property
    def client_cert(self):
        """Gets the client_cert of this KmipServerExtendedExtended.  # noqa: E501

          # noqa: E501

        :return: The client_cert of this KmipServerExtendedExtended.  # noqa: E501
        :rtype: KmipServerClientCert
        """
        return self._client_cert

    @client_cert.setter
    def client_cert(self, client_cert):
        """Sets the client_cert of this KmipServerExtendedExtended.

          # noqa: E501

        :param client_cert: The client_cert of this KmipServerExtendedExtended.  # noqa: E501
        :type: KmipServerClientCert
        """
        if client_cert is None:
            raise ValueError("Invalid value for `client_cert`, must not be `None`")  # noqa: E501

        self._client_cert = client_cert

    @property
    def host(self):
        """Gets the host of this KmipServerExtendedExtended.  # noqa: E501

        KMIP server hostname.  # noqa: E501

        :return: The host of this KmipServerExtendedExtended.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this KmipServerExtendedExtended.

        KMIP server hostname.  # noqa: E501

        :param host: The host of this KmipServerExtendedExtended.  # noqa: E501
        :type: str
        """
        if host is None:
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501
        if host is not None and len(host) > 256:
            raise ValueError("Invalid value for `host`, length must be less than or equal to `256`")  # noqa: E501
        if host is not None and len(host) < 1:
            raise ValueError("Invalid value for `host`, length must be greater than or equal to `1`")  # noqa: E501

        self._host = host

    @property
    def id(self):
        """Gets the id of this KmipServerExtendedExtended.  # noqa: E501

        Unique KMIP server identifier.  # noqa: E501

        :return: The id of this KmipServerExtendedExtended.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this KmipServerExtendedExtended.

        Unique KMIP server identifier.  # noqa: E501

        :param id: The id of this KmipServerExtendedExtended.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if id is not None and len(id) > 64:
            raise ValueError("Invalid value for `id`, length must be less than or equal to `64`")  # noqa: E501
        if id is not None and len(id) < 1:
            raise ValueError("Invalid value for `id`, length must be greater than or equal to `1`")  # noqa: E501
        if id is not None and not re.search('^[a-zA-Z0-9_-]+$', id):  # noqa: E501
            raise ValueError("Invalid value for `id`, must be a follow pattern or equal to `/^[a-zA-Z0-9_-]+$/`")  # noqa: E501

        self._id = id

    @property
    def minimum_tls_version(self):
        """Gets the minimum_tls_version of this KmipServerExtendedExtended.  # noqa: E501

        Denotes the minimum TLS version supported by the KTP. Default value is set to '1.2'. However other supported values are '1.0' and '1.1'.  # noqa: E501

        :return: The minimum_tls_version of this KmipServerExtendedExtended.  # noqa: E501
        :rtype: str
        """
        return self._minimum_tls_version

    @minimum_tls_version.setter
    def minimum_tls_version(self, minimum_tls_version):
        """Sets the minimum_tls_version of this KmipServerExtendedExtended.

        Denotes the minimum TLS version supported by the KTP. Default value is set to '1.2'. However other supported values are '1.0' and '1.1'.  # noqa: E501

        :param minimum_tls_version: The minimum_tls_version of this KmipServerExtendedExtended.  # noqa: E501
        :type: str
        """
        if minimum_tls_version is None:
            raise ValueError("Invalid value for `minimum_tls_version`, must not be `None`")  # noqa: E501
        if minimum_tls_version is not None and len(minimum_tls_version) > 3:
            raise ValueError("Invalid value for `minimum_tls_version`, length must be less than or equal to `3`")  # noqa: E501
        if minimum_tls_version is not None and len(minimum_tls_version) < 3:
            raise ValueError("Invalid value for `minimum_tls_version`, length must be greater than or equal to `3`")  # noqa: E501
        if minimum_tls_version is not None and not re.search('^[0-9]{1}[.][0-9]{1}$', minimum_tls_version):  # noqa: E501
            raise ValueError("Invalid value for `minimum_tls_version`, must be a follow pattern or equal to `/^[0-9]{1}[.][0-9]{1}$/`")  # noqa: E501

        self._minimum_tls_version = minimum_tls_version

    @property
    def port(self):
        """Gets the port of this KmipServerExtendedExtended.  # noqa: E501

        KMIP server port.  # noqa: E501

        :return: The port of this KmipServerExtendedExtended.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this KmipServerExtendedExtended.

        KMIP server port.  # noqa: E501

        :param port: The port of this KmipServerExtendedExtended.  # noqa: E501
        :type: int
        """
        if port is None:
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501
        if port is not None and port > 65535:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value less than or equal to `65535`")  # noqa: E501
        if port is not None and port < 1:  # noqa: E501
            raise ValueError("Invalid value for `port`, must be a value greater than or equal to `1`")  # noqa: E501

        self._port = port

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KmipServerExtendedExtended):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
