# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_2_0.models.empty import Empty  # noqa: F401,E501


class CloudJobCreateParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'accounts': 'list[str]',
        'directories': 'list[str]',
        'expiration_date': 'int',
        'file_matching_pattern': 'Empty',
        'files': 'list[str]',
        'policy': 'str',
        'type': 'str'
    }

    attribute_map = {
        'accounts': 'accounts',
        'directories': 'directories',
        'expiration_date': 'expiration_date',
        'file_matching_pattern': 'file_matching_pattern',
        'files': 'files',
        'policy': 'policy',
        'type': 'type'
    }

    def __init__(self, accounts=None, directories=None, expiration_date=None, file_matching_pattern=None, files=None, policy=None, type=None):  # noqa: E501
        """CloudJobCreateParams - a model defined in Swagger"""  # noqa: E501

        self._accounts = None
        self._directories = None
        self._expiration_date = None
        self._file_matching_pattern = None
        self._files = None
        self._policy = None
        self._type = None
        self.discriminator = None

        if accounts is not None:
            self.accounts = accounts
        if directories is not None:
            self.directories = directories
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if file_matching_pattern is not None:
            self.file_matching_pattern = file_matching_pattern
        if files is not None:
            self.files = files
        if policy is not None:
            self.policy = policy
        self.type = type

    @property
    def accounts(self):
        """Gets the accounts of this CloudJobCreateParams.  # noqa: E501

        The names of accounts for COI restore  # noqa: E501

        :return: The accounts of this CloudJobCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._accounts

    @accounts.setter
    def accounts(self, accounts):
        """Sets the accounts of this CloudJobCreateParams.

        The names of accounts for COI restore  # noqa: E501

        :param accounts: The accounts of this CloudJobCreateParams.  # noqa: E501
        :type: list[str]
        """

        self._accounts = accounts

    @property
    def directories(self):
        """Gets the directories of this CloudJobCreateParams.  # noqa: E501

        Directories addressed by this job  # noqa: E501

        :return: The directories of this CloudJobCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._directories

    @directories.setter
    def directories(self, directories):
        """Sets the directories of this CloudJobCreateParams.

        Directories addressed by this job  # noqa: E501

        :param directories: The directories of this CloudJobCreateParams.  # noqa: E501
        :type: list[str]
        """

        self._directories = directories

    @property
    def expiration_date(self):
        """Gets the expiration_date of this CloudJobCreateParams.  # noqa: E501

        The new expiration date in seconds  # noqa: E501

        :return: The expiration_date of this CloudJobCreateParams.  # noqa: E501
        :rtype: int
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date):
        """Sets the expiration_date of this CloudJobCreateParams.

        The new expiration date in seconds  # noqa: E501

        :param expiration_date: The expiration_date of this CloudJobCreateParams.  # noqa: E501
        :type: int
        """

        self._expiration_date = expiration_date

    @property
    def file_matching_pattern(self):
        """Gets the file_matching_pattern of this CloudJobCreateParams.  # noqa: E501

        The file filtering logic to find files for this job. (Only applicable for 'recall' jobs)  # noqa: E501

        :return: The file_matching_pattern of this CloudJobCreateParams.  # noqa: E501
        :rtype: Empty
        """
        return self._file_matching_pattern

    @file_matching_pattern.setter
    def file_matching_pattern(self, file_matching_pattern):
        """Sets the file_matching_pattern of this CloudJobCreateParams.

        The file filtering logic to find files for this job. (Only applicable for 'recall' jobs)  # noqa: E501

        :param file_matching_pattern: The file_matching_pattern of this CloudJobCreateParams.  # noqa: E501
        :type: Empty
        """

        self._file_matching_pattern = file_matching_pattern

    @property
    def files(self):
        """Gets the files of this CloudJobCreateParams.  # noqa: E501

        Filenames addressed by this job  # noqa: E501

        :return: The files of this CloudJobCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this CloudJobCreateParams.

        Filenames addressed by this job  # noqa: E501

        :param files: The files of this CloudJobCreateParams.  # noqa: E501
        :type: list[str]
        """

        self._files = files

    @property
    def policy(self):
        """Gets the policy of this CloudJobCreateParams.  # noqa: E501

        The name of an existing cloudpool policy to apply to this job. (Only applicable for 'archive' jobs)  # noqa: E501

        :return: The policy of this CloudJobCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._policy

    @policy.setter
    def policy(self, policy):
        """Sets the policy of this CloudJobCreateParams.

        The name of an existing cloudpool policy to apply to this job. (Only applicable for 'archive' jobs)  # noqa: E501

        :param policy: The policy of this CloudJobCreateParams.  # noqa: E501
        :type: str
        """

        self._policy = policy

    @property
    def type(self):
        """Gets the type of this CloudJobCreateParams.  # noqa: E501

        The type of cloud action to be performed by this job.  # noqa: E501

        :return: The type of this CloudJobCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CloudJobCreateParams.

        The type of cloud action to be performed by this job.  # noqa: E501

        :param type: The type of this CloudJobCreateParams.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["archive", "recall", "local-garbage-collection", "cloud-garbage-collection", "cache-writeback", "cache-on-access", "cache-invalidation", "restore-coi", "upgrade-monitor", "cache-pre-populate", "snapshot-writeback", "smartlink-upgrade"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CloudJobCreateParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
