# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_2_0.api_client import ApiClient


class NetworkGroupnetsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_groupnet_subnet(self, groupnet_subnet, groupnet, **kwargs):  # noqa: E501
        """create_groupnet_subnet  # noqa: E501

        Create a new subnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_groupnet_subnet(groupnet_subnet, groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupnetSubnetCreateParams groupnet_subnet: (required)
        :param str groupnet: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_groupnet_subnet_with_http_info(groupnet_subnet, groupnet, **kwargs)  # noqa: E501
        else:
            (data) = self.create_groupnet_subnet_with_http_info(groupnet_subnet, groupnet, **kwargs)  # noqa: E501
            return data

    def create_groupnet_subnet_with_http_info(self, groupnet_subnet, groupnet, **kwargs):  # noqa: E501
        """create_groupnet_subnet  # noqa: E501

        Create a new subnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_groupnet_subnet_with_http_info(groupnet_subnet, groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupnetSubnetCreateParams groupnet_subnet: (required)
        :param str groupnet: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet_subnet', 'groupnet']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_groupnet_subnet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'groupnet_subnet' is set
        if ('groupnet_subnet' not in params or
                params['groupnet_subnet'] is None):
            raise ValueError("Missing the required parameter `groupnet_subnet` when calling `create_groupnet_subnet`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `create_groupnet_subnet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'groupnet_subnet' in params:
            body_params = params['groupnet_subnet']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subnets_subnet_pool(self, subnets_subnet_pool, groupnet, subnet, **kwargs):  # noqa: E501
        """create_subnets_subnet_pool  # noqa: E501

        Create a new pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subnets_subnet_pool(subnets_subnet_pool, groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubnetsSubnetPoolCreateParams subnets_subnet_pool: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param bool force: Force creating this pool even if it causes an MTU conflict.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_subnets_subnet_pool_with_http_info(subnets_subnet_pool, groupnet, subnet, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subnets_subnet_pool_with_http_info(subnets_subnet_pool, groupnet, subnet, **kwargs)  # noqa: E501
            return data

    def create_subnets_subnet_pool_with_http_info(self, subnets_subnet_pool, groupnet, subnet, **kwargs):  # noqa: E501
        """create_subnets_subnet_pool  # noqa: E501

        Create a new pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_subnets_subnet_pool_with_http_info(subnets_subnet_pool, groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubnetsSubnetPoolCreateParams subnets_subnet_pool: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param bool force: Force creating this pool even if it causes an MTU conflict.
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subnets_subnet_pool', 'groupnet', 'subnet', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subnets_subnet_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subnets_subnet_pool' is set
        if ('subnets_subnet_pool' not in params or
                params['subnets_subnet_pool'] is None):
            raise ValueError("Missing the required parameter `subnets_subnet_pool` when calling `create_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `create_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `create_subnets_subnet_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'subnets_subnet_pool' in params:
            body_params = params['subnets_subnet_pool']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets/{Subnet}/pools', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_groupnet_subnet(self, groupnet_subnet_id, groupnet, **kwargs):  # noqa: E501
        """delete_groupnet_subnet  # noqa: E501

        Delete a network subnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_groupnet_subnet(groupnet_subnet_id, groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet_subnet_id: Delete a network subnet. (required)
        :param str groupnet: (required)
        :param bool force: Force deleting this subnet even if pools in other subnets rely on this subnet's SC VIP.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_groupnet_subnet_with_http_info(groupnet_subnet_id, groupnet, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_groupnet_subnet_with_http_info(groupnet_subnet_id, groupnet, **kwargs)  # noqa: E501
            return data

    def delete_groupnet_subnet_with_http_info(self, groupnet_subnet_id, groupnet, **kwargs):  # noqa: E501
        """delete_groupnet_subnet  # noqa: E501

        Delete a network subnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_groupnet_subnet_with_http_info(groupnet_subnet_id, groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet_subnet_id: Delete a network subnet. (required)
        :param str groupnet: (required)
        :param bool force: Force deleting this subnet even if pools in other subnets rely on this subnet's SC VIP.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet_subnet_id', 'groupnet', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_groupnet_subnet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'groupnet_subnet_id' is set
        if ('groupnet_subnet_id' not in params or
                params['groupnet_subnet_id'] is None):
            raise ValueError("Missing the required parameter `groupnet_subnet_id` when calling `delete_groupnet_subnet`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `delete_groupnet_subnet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet_subnet_id' in params:
            path_params['GroupnetSubnetId'] = params['groupnet_subnet_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets/{GroupnetSubnetId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subnets_subnet_pool(self, subnets_subnet_pool_id, groupnet, subnet, **kwargs):  # noqa: E501
        """delete_subnets_subnet_pool  # noqa: E501

        Delete a network pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_subnets_subnet_pool(subnets_subnet_pool_id, groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subnets_subnet_pool_id: Delete a network pool. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_subnets_subnet_pool_with_http_info(subnets_subnet_pool_id, groupnet, subnet, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subnets_subnet_pool_with_http_info(subnets_subnet_pool_id, groupnet, subnet, **kwargs)  # noqa: E501
            return data

    def delete_subnets_subnet_pool_with_http_info(self, subnets_subnet_pool_id, groupnet, subnet, **kwargs):  # noqa: E501
        """delete_subnets_subnet_pool  # noqa: E501

        Delete a network pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_subnets_subnet_pool_with_http_info(subnets_subnet_pool_id, groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subnets_subnet_pool_id: Delete a network pool. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subnets_subnet_pool_id', 'groupnet', 'subnet']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subnets_subnet_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subnets_subnet_pool_id' is set
        if ('subnets_subnet_pool_id' not in params or
                params['subnets_subnet_pool_id'] is None):
            raise ValueError("Missing the required parameter `subnets_subnet_pool_id` when calling `delete_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `delete_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `delete_subnets_subnet_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subnets_subnet_pool_id' in params:
            path_params['SubnetsSubnetPoolId'] = params['subnets_subnet_pool_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{SubnetsSubnetPoolId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_groupnet_subnet(self, groupnet_subnet_id, groupnet, **kwargs):  # noqa: E501
        """get_groupnet_subnet  # noqa: E501

        View a network subnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_groupnet_subnet(groupnet_subnet_id, groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet_subnet_id: View a network subnet. (required)
        :param str groupnet: (required)
        :return: GroupnetSubnets
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_groupnet_subnet_with_http_info(groupnet_subnet_id, groupnet, **kwargs)  # noqa: E501
        else:
            (data) = self.get_groupnet_subnet_with_http_info(groupnet_subnet_id, groupnet, **kwargs)  # noqa: E501
            return data

    def get_groupnet_subnet_with_http_info(self, groupnet_subnet_id, groupnet, **kwargs):  # noqa: E501
        """get_groupnet_subnet  # noqa: E501

        View a network subnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_groupnet_subnet_with_http_info(groupnet_subnet_id, groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet_subnet_id: View a network subnet. (required)
        :param str groupnet: (required)
        :return: GroupnetSubnets
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet_subnet_id', 'groupnet']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_groupnet_subnet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'groupnet_subnet_id' is set
        if ('groupnet_subnet_id' not in params or
                params['groupnet_subnet_id'] is None):
            raise ValueError("Missing the required parameter `groupnet_subnet_id` when calling `get_groupnet_subnet`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `get_groupnet_subnet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet_subnet_id' in params:
            path_params['GroupnetSubnetId'] = params['groupnet_subnet_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets/{GroupnetSubnetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupnetSubnets',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subnets_subnet_pool(self, subnets_subnet_pool_id, groupnet, subnet, **kwargs):  # noqa: E501
        """get_subnets_subnet_pool  # noqa: E501

        View a single network pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subnets_subnet_pool(subnets_subnet_pool_id, groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subnets_subnet_pool_id: View a single network pool. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :return: SubnetsSubnetPools
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_subnets_subnet_pool_with_http_info(subnets_subnet_pool_id, groupnet, subnet, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subnets_subnet_pool_with_http_info(subnets_subnet_pool_id, groupnet, subnet, **kwargs)  # noqa: E501
            return data

    def get_subnets_subnet_pool_with_http_info(self, subnets_subnet_pool_id, groupnet, subnet, **kwargs):  # noqa: E501
        """get_subnets_subnet_pool  # noqa: E501

        View a single network pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_subnets_subnet_pool_with_http_info(subnets_subnet_pool_id, groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str subnets_subnet_pool_id: View a single network pool. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :return: SubnetsSubnetPools
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subnets_subnet_pool_id', 'groupnet', 'subnet']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subnets_subnet_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subnets_subnet_pool_id' is set
        if ('subnets_subnet_pool_id' not in params or
                params['subnets_subnet_pool_id'] is None):
            raise ValueError("Missing the required parameter `subnets_subnet_pool_id` when calling `get_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `get_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `get_subnets_subnet_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subnets_subnet_pool_id' in params:
            path_params['SubnetsSubnetPoolId'] = params['subnets_subnet_pool_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{SubnetsSubnetPoolId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubnetsSubnetPools',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_groupnet_subnets(self, groupnet, **kwargs):  # noqa: E501
        """list_groupnet_subnets  # noqa: E501

        Get a list of subnets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_groupnet_subnets(groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: GroupnetSubnetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_groupnet_subnets_with_http_info(groupnet, **kwargs)  # noqa: E501
        else:
            (data) = self.list_groupnet_subnets_with_http_info(groupnet, **kwargs)  # noqa: E501
            return data

    def list_groupnet_subnets_with_http_info(self, groupnet, **kwargs):  # noqa: E501
        """list_groupnet_subnets  # noqa: E501

        Get a list of subnets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_groupnet_subnets_with_http_info(groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: GroupnetSubnetsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet', 'dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_groupnet_subnets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `list_groupnet_subnets`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_groupnet_subnets`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_groupnet_subnets`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_groupnet_subnets`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_groupnet_subnets`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_groupnet_subnets`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_groupnet_subnets`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_groupnet_subnets`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupnetSubnetsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_subnets_subnet_pools(self, groupnet, subnet, **kwargs):  # noqa: E501
        """list_subnets_subnet_pools  # noqa: E501

        Get a list of network pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_subnets_subnet_pools(groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str access_zone: If specified, only pools with this zone name will be returned.
        :param str alloc_method: If specified, only pools with this allocation type will be returned.
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: SubnetsSubnetPoolsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_subnets_subnet_pools_with_http_info(groupnet, subnet, **kwargs)  # noqa: E501
        else:
            (data) = self.list_subnets_subnet_pools_with_http_info(groupnet, subnet, **kwargs)  # noqa: E501
            return data

    def list_subnets_subnet_pools_with_http_info(self, groupnet, subnet, **kwargs):  # noqa: E501
        """list_subnets_subnet_pools  # noqa: E501

        Get a list of network pools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_subnets_subnet_pools_with_http_info(groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str access_zone: If specified, only pools with this zone name will be returned.
        :param str alloc_method: If specified, only pools with this allocation type will be returned.
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: SubnetsSubnetPoolsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet', 'subnet', 'access_zone', 'alloc_method', 'dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_subnets_subnet_pools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `list_subnets_subnet_pools`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `list_subnets_subnet_pools`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_subnets_subnet_pools`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_subnets_subnet_pools`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_subnets_subnet_pools`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_subnets_subnet_pools`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_subnets_subnet_pools`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_subnets_subnet_pools`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_subnets_subnet_pools`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501

        query_params = []
        if 'access_zone' in params:
            query_params.append(('access_zone', params['access_zone']))  # noqa: E501
        if 'alloc_method' in params:
            query_params.append(('alloc_method', params['alloc_method']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets/{Subnet}/pools', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SubnetsSubnetPoolsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_groupnet_subnet(self, groupnet_subnet, groupnet_subnet_id, groupnet, **kwargs):  # noqa: E501
        """update_groupnet_subnet  # noqa: E501

        Modify a network subnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_groupnet_subnet(groupnet_subnet, groupnet_subnet_id, groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupnetSubnet groupnet_subnet: (required)
        :param str groupnet_subnet_id: Modify a network subnet. (required)
        :param str groupnet: (required)
        :param bool force: Force modifying this subnet even if it causes an MTU conflict.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_groupnet_subnet_with_http_info(groupnet_subnet, groupnet_subnet_id, groupnet, **kwargs)  # noqa: E501
        else:
            (data) = self.update_groupnet_subnet_with_http_info(groupnet_subnet, groupnet_subnet_id, groupnet, **kwargs)  # noqa: E501
            return data

    def update_groupnet_subnet_with_http_info(self, groupnet_subnet, groupnet_subnet_id, groupnet, **kwargs):  # noqa: E501
        """update_groupnet_subnet  # noqa: E501

        Modify a network subnet.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_groupnet_subnet_with_http_info(groupnet_subnet, groupnet_subnet_id, groupnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupnetSubnet groupnet_subnet: (required)
        :param str groupnet_subnet_id: Modify a network subnet. (required)
        :param str groupnet: (required)
        :param bool force: Force modifying this subnet even if it causes an MTU conflict.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet_subnet', 'groupnet_subnet_id', 'groupnet', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_groupnet_subnet" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'groupnet_subnet' is set
        if ('groupnet_subnet' not in params or
                params['groupnet_subnet'] is None):
            raise ValueError("Missing the required parameter `groupnet_subnet` when calling `update_groupnet_subnet`")  # noqa: E501
        # verify the required parameter 'groupnet_subnet_id' is set
        if ('groupnet_subnet_id' not in params or
                params['groupnet_subnet_id'] is None):
            raise ValueError("Missing the required parameter `groupnet_subnet_id` when calling `update_groupnet_subnet`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `update_groupnet_subnet`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet_subnet_id' in params:
            path_params['GroupnetSubnetId'] = params['groupnet_subnet_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'groupnet_subnet' in params:
            body_params = params['groupnet_subnet']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets/{GroupnetSubnetId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_subnets_subnet_pool(self, subnets_subnet_pool, subnets_subnet_pool_id, groupnet, subnet, **kwargs):  # noqa: E501
        """update_subnets_subnet_pool  # noqa: E501

        Modify a network pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_subnets_subnet_pool(subnets_subnet_pool, subnets_subnet_pool_id, groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubnetsSubnetPool subnets_subnet_pool: (required)
        :param str subnets_subnet_pool_id: Modify a network pool. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param bool force: Force creating this pool even if it causes an MTU conflict.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_subnets_subnet_pool_with_http_info(subnets_subnet_pool, subnets_subnet_pool_id, groupnet, subnet, **kwargs)  # noqa: E501
        else:
            (data) = self.update_subnets_subnet_pool_with_http_info(subnets_subnet_pool, subnets_subnet_pool_id, groupnet, subnet, **kwargs)  # noqa: E501
            return data

    def update_subnets_subnet_pool_with_http_info(self, subnets_subnet_pool, subnets_subnet_pool_id, groupnet, subnet, **kwargs):  # noqa: E501
        """update_subnets_subnet_pool  # noqa: E501

        Modify a network pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_subnets_subnet_pool_with_http_info(subnets_subnet_pool, subnets_subnet_pool_id, groupnet, subnet, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SubnetsSubnetPool subnets_subnet_pool: (required)
        :param str subnets_subnet_pool_id: Modify a network pool. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param bool force: Force creating this pool even if it causes an MTU conflict.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['subnets_subnet_pool', 'subnets_subnet_pool_id', 'groupnet', 'subnet', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_subnets_subnet_pool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'subnets_subnet_pool' is set
        if ('subnets_subnet_pool' not in params or
                params['subnets_subnet_pool'] is None):
            raise ValueError("Missing the required parameter `subnets_subnet_pool` when calling `update_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'subnets_subnet_pool_id' is set
        if ('subnets_subnet_pool_id' not in params or
                params['subnets_subnet_pool_id'] is None):
            raise ValueError("Missing the required parameter `subnets_subnet_pool_id` when calling `update_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `update_subnets_subnet_pool`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `update_subnets_subnet_pool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'subnets_subnet_pool_id' in params:
            path_params['SubnetsSubnetPoolId'] = params['subnets_subnet_pool_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'subnets_subnet_pool' in params:
            body_params = params['subnets_subnet_pool']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/12/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{SubnetsSubnetPoolId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
