# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_2_0.api_client import ApiClient


class LicenseApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_license_activation_item(self, license_activation_item, **kwargs):  # noqa: E501
        """create_license_activation_item  # noqa: E501

        Start or cancel an activation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_license_activation_item(license_activation_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LicenseActivationItem license_activation_item: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_license_activation_item_with_http_info(license_activation_item, **kwargs)  # noqa: E501
        else:
            (data) = self.create_license_activation_item_with_http_info(license_activation_item, **kwargs)  # noqa: E501
            return data

    def create_license_activation_item_with_http_info(self, license_activation_item, **kwargs):  # noqa: E501
        """create_license_activation_item  # noqa: E501

        Start or cancel an activation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_license_activation_item_with_http_info(license_activation_item, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LicenseActivationItem license_activation_item: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['license_activation_item']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_license_activation_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'license_activation_item' is set
        if ('license_activation_item' not in params or
                params['license_activation_item'] is None):
            raise ValueError("Missing the required parameter `license_activation_item` when calling `create_license_activation_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'license_activation_item' in params:
            body_params = params['license_activation_item']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/license/activation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_license_license(self, license_license, **kwargs):  # noqa: E501
        """create_license_license  # noqa: E501

        Install a new license file and/or activate evaluation licenses.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_license_license(license_license, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LicenseLicenseCreateParams license_license: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_license_license_with_http_info(license_license, **kwargs)  # noqa: E501
        else:
            (data) = self.create_license_license_with_http_info(license_license, **kwargs)  # noqa: E501
            return data

    def create_license_license_with_http_info(self, license_license, **kwargs):  # noqa: E501
        """create_license_license  # noqa: E501

        Install a new license file and/or activate evaluation licenses.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_license_license_with_http_info(license_license, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LicenseLicenseCreateParams license_license: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['license_license']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_license_license" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'license_license' is set
        if ('license_license' not in params or
                params['license_license'] is None):
            raise ValueError("Missing the required parameter `license_license` when calling `create_license_license`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'license_license' in params:
            body_params = params['license_license']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/license/licenses', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_license_generate(self, **kwargs):  # noqa: E501
        """get_license_generate  # noqa: E501

        Generate license activation file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_license_generate(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: enum: license_list_only (default), generate_activation, download_activation. Generate an activation file or return a list of activated licenses. If generating an activation file and no licenses are specified, the default configuration is to generate an activation file with the current set of licensed features. download_activation returns HTTP headers and the same XML content as seen in the response activation.
        :param str licenses_to_exclude: Licenses to omit from activation file.
        :param str licenses_to_include: Licenses to include in activation file.
        :param str only_these_licenses: Activate only the defined licenses. This setting overrides all other license activation settings.
        :return: LicenseGenerate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_license_generate_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_license_generate_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_license_generate_with_http_info(self, **kwargs):  # noqa: E501
        """get_license_generate  # noqa: E501

        Generate license activation file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_license_generate_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: enum: license_list_only (default), generate_activation, download_activation. Generate an activation file or return a list of activated licenses. If generating an activation file and no licenses are specified, the default configuration is to generate an activation file with the current set of licensed features. download_activation returns HTTP headers and the same XML content as seen in the response activation.
        :param str licenses_to_exclude: Licenses to omit from activation file.
        :param str licenses_to_include: Licenses to include in activation file.
        :param str only_these_licenses: Activate only the defined licenses. This setting overrides all other license activation settings.
        :return: LicenseGenerate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action', 'licenses_to_exclude', 'licenses_to_include', 'only_these_licenses']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_license_generate" % key
                )
            params[key] = val
        del params['kwargs']

        if ('action' in params and
                len(params['action']) < 0):
            raise ValueError("Invalid value for parameter `action` when calling `get_license_generate`, length must be greater than or equal to `0`")  # noqa: E501
        if ('licenses_to_exclude' in params and
                len(params['licenses_to_exclude']) > 2500):
            raise ValueError("Invalid value for parameter `licenses_to_exclude` when calling `get_license_generate`, length must be less than or equal to `2500`")  # noqa: E501
        if ('licenses_to_exclude' in params and
                len(params['licenses_to_exclude']) < 1):
            raise ValueError("Invalid value for parameter `licenses_to_exclude` when calling `get_license_generate`, length must be greater than or equal to `1`")  # noqa: E501
        if 'licenses_to_exclude' in params and not re.search('.+', params['licenses_to_exclude']):  # noqa: E501
            raise ValueError("Invalid value for parameter `licenses_to_exclude` when calling `get_license_generate`, must conform to the pattern `/.+/`")  # noqa: E501
        if ('licenses_to_include' in params and
                len(params['licenses_to_include']) > 2500):
            raise ValueError("Invalid value for parameter `licenses_to_include` when calling `get_license_generate`, length must be less than or equal to `2500`")  # noqa: E501
        if ('licenses_to_include' in params and
                len(params['licenses_to_include']) < 1):
            raise ValueError("Invalid value for parameter `licenses_to_include` when calling `get_license_generate`, length must be greater than or equal to `1`")  # noqa: E501
        if 'licenses_to_include' in params and not re.search('.+', params['licenses_to_include']):  # noqa: E501
            raise ValueError("Invalid value for parameter `licenses_to_include` when calling `get_license_generate`, must conform to the pattern `/.+/`")  # noqa: E501
        if ('only_these_licenses' in params and
                len(params['only_these_licenses']) > 2500):
            raise ValueError("Invalid value for parameter `only_these_licenses` when calling `get_license_generate`, length must be less than or equal to `2500`")  # noqa: E501
        if ('only_these_licenses' in params and
                len(params['only_these_licenses']) < 1):
            raise ValueError("Invalid value for parameter `only_these_licenses` when calling `get_license_generate`, length must be greater than or equal to `1`")  # noqa: E501
        if 'only_these_licenses' in params and not re.search('.+', params['only_these_licenses']):  # noqa: E501
            raise ValueError("Invalid value for parameter `only_these_licenses` when calling `get_license_generate`, must conform to the pattern `/.+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'licenses_to_exclude' in params:
            query_params.append(('licenses_to_exclude', params['licenses_to_exclude']))  # noqa: E501
        if 'licenses_to_include' in params:
            query_params.append(('licenses_to_include', params['licenses_to_include']))  # noqa: E501
        if 'only_these_licenses' in params:
            query_params.append(('only_these_licenses', params['only_these_licenses']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/license/generate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseGenerate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_license_license(self, license_license_id, **kwargs):  # noqa: E501
        """get_license_license  # noqa: E501

        Retrieve license information for the feature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_license_license(license_license_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str license_license_id: Retrieve license information for the feature. (required)
        :return: LicenseLicenses
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_license_license_with_http_info(license_license_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_license_license_with_http_info(license_license_id, **kwargs)  # noqa: E501
            return data

    def get_license_license_with_http_info(self, license_license_id, **kwargs):  # noqa: E501
        """get_license_license  # noqa: E501

        Retrieve license information for the feature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_license_license_with_http_info(license_license_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str license_license_id: Retrieve license information for the feature. (required)
        :return: LicenseLicenses
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['license_license_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_license_license" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'license_license_id' is set
        if ('license_license_id' not in params or
                params['license_license_id'] is None):
            raise ValueError("Missing the required parameter `license_license_id` when calling `get_license_license`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'license_license_id' in params:
            path_params['LicenseLicenseId'] = params['license_license_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/license/licenses/{LicenseLicenseId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseLicenses',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_license_activation(self, **kwargs):  # noqa: E501
        """list_license_activation  # noqa: E501

        Return the current the current phase of the activation process.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_license_activation(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LicenseActivation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_license_activation_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_license_activation_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_license_activation_with_http_info(self, **kwargs):  # noqa: E501
        """list_license_activation  # noqa: E501

        Return the current the current phase of the activation process.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_license_activation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: LicenseActivation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_license_activation" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/license/activation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseActivation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_license_licenses(self, **kwargs):  # noqa: E501
        """list_license_licenses  # noqa: E501

        Retrieve license information for all licensable products.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_license_licenses(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: LicenseLicensesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_license_licenses_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_license_licenses_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_license_licenses_with_http_info(self, **kwargs):  # noqa: E501
        """list_license_licenses  # noqa: E501

        Retrieve license information for all licensable products.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_license_licenses_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: LicenseLicensesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_license_licenses" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_license_licenses`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_license_licenses`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_license_licenses`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_license_licenses`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_license_licenses`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_license_licenses`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_license_licenses`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/5/license/licenses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LicenseLicensesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
