# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_2_0.api_client import ApiClient


class HealthcheckApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_healthcheck_evaluation(self, healthcheck_evaluation, **kwargs):  # noqa: E501
        """create_healthcheck_evaluation  # noqa: E501

        Request an evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_healthcheck_evaluation(healthcheck_evaluation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckEvaluationCreateParams healthcheck_evaluation: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_healthcheck_evaluation_with_http_info(healthcheck_evaluation, **kwargs)  # noqa: E501
        else:
            (data) = self.create_healthcheck_evaluation_with_http_info(healthcheck_evaluation, **kwargs)  # noqa: E501
            return data

    def create_healthcheck_evaluation_with_http_info(self, healthcheck_evaluation, **kwargs):  # noqa: E501
        """create_healthcheck_evaluation  # noqa: E501

        Request an evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_healthcheck_evaluation_with_http_info(healthcheck_evaluation, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckEvaluationCreateParams healthcheck_evaluation: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_evaluation']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_healthcheck_evaluation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_evaluation' is set
        if ('healthcheck_evaluation' not in params or
                params['healthcheck_evaluation'] is None):
            raise ValueError("Missing the required parameter `healthcheck_evaluation` when calling `create_healthcheck_evaluation`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'healthcheck_evaluation' in params:
            body_params = params['healthcheck_evaluation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/evaluations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_healthcheck_parameter(self, healthcheck_parameter, **kwargs):  # noqa: E501
        """create_healthcheck_parameter  # noqa: E501

        Create a parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_healthcheck_parameter(healthcheck_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckParameterCreateParams healthcheck_parameter: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_healthcheck_parameter_with_http_info(healthcheck_parameter, **kwargs)  # noqa: E501
        else:
            (data) = self.create_healthcheck_parameter_with_http_info(healthcheck_parameter, **kwargs)  # noqa: E501
            return data

    def create_healthcheck_parameter_with_http_info(self, healthcheck_parameter, **kwargs):  # noqa: E501
        """create_healthcheck_parameter  # noqa: E501

        Create a parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_healthcheck_parameter_with_http_info(healthcheck_parameter, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckParameterCreateParams healthcheck_parameter: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_parameter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_healthcheck_parameter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_parameter' is set
        if ('healthcheck_parameter' not in params or
                params['healthcheck_parameter'] is None):
            raise ValueError("Missing the required parameter `healthcheck_parameter` when calling `create_healthcheck_parameter`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'healthcheck_parameter' in params:
            body_params = params['healthcheck_parameter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/healthcheck/parameters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_healthcheck_schedule(self, healthcheck_schedule, **kwargs):  # noqa: E501
        """create_healthcheck_schedule  # noqa: E501

        Create a schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_healthcheck_schedule(healthcheck_schedule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckScheduleCreateParams healthcheck_schedule: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_healthcheck_schedule_with_http_info(healthcheck_schedule, **kwargs)  # noqa: E501
        else:
            (data) = self.create_healthcheck_schedule_with_http_info(healthcheck_schedule, **kwargs)  # noqa: E501
            return data

    def create_healthcheck_schedule_with_http_info(self, healthcheck_schedule, **kwargs):  # noqa: E501
        """create_healthcheck_schedule  # noqa: E501

        Create a schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_healthcheck_schedule_with_http_info(healthcheck_schedule, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckScheduleCreateParams healthcheck_schedule: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_schedule']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_healthcheck_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_schedule' is set
        if ('healthcheck_schedule' not in params or
                params['healthcheck_schedule'] is None):
            raise ValueError("Missing the required parameter `healthcheck_schedule` when calling `create_healthcheck_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'healthcheck_schedule' in params:
            body_params = params['healthcheck_schedule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/schedules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_healthcheck_evaluation(self, healthcheck_evaluation_id, **kwargs):  # noqa: E501
        """delete_healthcheck_evaluation  # noqa: E501

        Cancel an evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_healthcheck_evaluation(healthcheck_evaluation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_evaluation_id: Cancel an evaluation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_healthcheck_evaluation_with_http_info(healthcheck_evaluation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_healthcheck_evaluation_with_http_info(healthcheck_evaluation_id, **kwargs)  # noqa: E501
            return data

    def delete_healthcheck_evaluation_with_http_info(self, healthcheck_evaluation_id, **kwargs):  # noqa: E501
        """delete_healthcheck_evaluation  # noqa: E501

        Cancel an evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_healthcheck_evaluation_with_http_info(healthcheck_evaluation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_evaluation_id: Cancel an evaluation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_evaluation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_healthcheck_evaluation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_evaluation_id' is set
        if ('healthcheck_evaluation_id' not in params or
                params['healthcheck_evaluation_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_evaluation_id` when calling `delete_healthcheck_evaluation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_evaluation_id' in params:
            path_params['HealthcheckEvaluationId'] = params['healthcheck_evaluation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/evaluations/{HealthcheckEvaluationId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_healthcheck_parameter(self, healthcheck_parameter_id, **kwargs):  # noqa: E501
        """delete_healthcheck_parameter  # noqa: E501

        Delete a parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_healthcheck_parameter(healthcheck_parameter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_parameter_id: Delete a parameter. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_healthcheck_parameter_with_http_info(healthcheck_parameter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_healthcheck_parameter_with_http_info(healthcheck_parameter_id, **kwargs)  # noqa: E501
            return data

    def delete_healthcheck_parameter_with_http_info(self, healthcheck_parameter_id, **kwargs):  # noqa: E501
        """delete_healthcheck_parameter  # noqa: E501

        Delete a parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_healthcheck_parameter_with_http_info(healthcheck_parameter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_parameter_id: Delete a parameter. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_parameter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_healthcheck_parameter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_parameter_id' is set
        if ('healthcheck_parameter_id' not in params or
                params['healthcheck_parameter_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_parameter_id` when calling `delete_healthcheck_parameter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_parameter_id' in params:
            path_params['HealthcheckParameterId'] = params['healthcheck_parameter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/healthcheck/parameters/{HealthcheckParameterId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_healthcheck_schedule(self, healthcheck_schedule_id, **kwargs):  # noqa: E501
        """delete_healthcheck_schedule  # noqa: E501

        Delete a schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_healthcheck_schedule(healthcheck_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_schedule_id: Delete a schedule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_healthcheck_schedule_with_http_info(healthcheck_schedule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_healthcheck_schedule_with_http_info(healthcheck_schedule_id, **kwargs)  # noqa: E501
            return data

    def delete_healthcheck_schedule_with_http_info(self, healthcheck_schedule_id, **kwargs):  # noqa: E501
        """delete_healthcheck_schedule  # noqa: E501

        Delete a schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_healthcheck_schedule_with_http_info(healthcheck_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_schedule_id: Delete a schedule. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_schedule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_healthcheck_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_schedule_id' is set
        if ('healthcheck_schedule_id' not in params or
                params['healthcheck_schedule_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_schedule_id` when calling `delete_healthcheck_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_schedule_id' in params:
            path_params['HealthcheckScheduleId'] = params['healthcheck_schedule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/schedules/{HealthcheckScheduleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_healthcheck_checklist(self, healthcheck_checklist_id, **kwargs):  # noqa: E501
        """get_healthcheck_checklist  # noqa: E501

        Retrieve a checklist definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_checklist(healthcheck_checklist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_checklist_id: Retrieve a checklist definition. (required)
        :return: HealthcheckChecklists
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_healthcheck_checklist_with_http_info(healthcheck_checklist_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_healthcheck_checklist_with_http_info(healthcheck_checklist_id, **kwargs)  # noqa: E501
            return data

    def get_healthcheck_checklist_with_http_info(self, healthcheck_checklist_id, **kwargs):  # noqa: E501
        """get_healthcheck_checklist  # noqa: E501

        Retrieve a checklist definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_checklist_with_http_info(healthcheck_checklist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_checklist_id: Retrieve a checklist definition. (required)
        :return: HealthcheckChecklists
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_checklist_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_healthcheck_checklist" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_checklist_id' is set
        if ('healthcheck_checklist_id' not in params or
                params['healthcheck_checklist_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_checklist_id` when calling `get_healthcheck_checklist`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_checklist_id' in params:
            path_params['HealthcheckChecklistId'] = params['healthcheck_checklist_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/checklists/{HealthcheckChecklistId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckChecklists',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_healthcheck_checklists(self, **kwargs):  # noqa: E501
        """get_healthcheck_checklists  # noqa: E501

        List checklists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_checklists(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckChecklistsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_healthcheck_checklists_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_healthcheck_checklists_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_healthcheck_checklists_with_http_info(self, **kwargs):  # noqa: E501
        """get_healthcheck_checklists  # noqa: E501

        List checklists.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_checklists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckChecklistsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_healthcheck_checklists" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_healthcheck_checklists`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_healthcheck_checklists`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_healthcheck_checklists`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_healthcheck_checklists`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/checklists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckChecklistsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_healthcheck_evaluation(self, healthcheck_evaluation_id, **kwargs):  # noqa: E501
        """get_healthcheck_evaluation  # noqa: E501

        Retrieve individual evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_evaluation(healthcheck_evaluation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_evaluation_id: Retrieve individual evaluation. (required)
        :param bool detailed: Also return details for items that pass
        :return: HealthcheckEvaluations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_healthcheck_evaluation_with_http_info(healthcheck_evaluation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_healthcheck_evaluation_with_http_info(healthcheck_evaluation_id, **kwargs)  # noqa: E501
            return data

    def get_healthcheck_evaluation_with_http_info(self, healthcheck_evaluation_id, **kwargs):  # noqa: E501
        """get_healthcheck_evaluation  # noqa: E501

        Retrieve individual evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_evaluation_with_http_info(healthcheck_evaluation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_evaluation_id: Retrieve individual evaluation. (required)
        :param bool detailed: Also return details for items that pass
        :return: HealthcheckEvaluations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_evaluation_id', 'detailed']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_healthcheck_evaluation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_evaluation_id' is set
        if ('healthcheck_evaluation_id' not in params or
                params['healthcheck_evaluation_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_evaluation_id` when calling `get_healthcheck_evaluation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_evaluation_id' in params:
            path_params['HealthcheckEvaluationId'] = params['healthcheck_evaluation_id']  # noqa: E501

        query_params = []
        if 'detailed' in params:
            query_params.append(('detailed', params['detailed']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/evaluations/{HealthcheckEvaluationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckEvaluations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_healthcheck_item(self, healthcheck_item_id, **kwargs):  # noqa: E501
        """get_healthcheck_item  # noqa: E501

        Retrieve an item definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_item(healthcheck_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_item_id: Retrieve an item definition. (required)
        :return: HealthcheckItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_healthcheck_item_with_http_info(healthcheck_item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_healthcheck_item_with_http_info(healthcheck_item_id, **kwargs)  # noqa: E501
            return data

    def get_healthcheck_item_with_http_info(self, healthcheck_item_id, **kwargs):  # noqa: E501
        """get_healthcheck_item  # noqa: E501

        Retrieve an item definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_item_with_http_info(healthcheck_item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_item_id: Retrieve an item definition. (required)
        :return: HealthcheckItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_item_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_healthcheck_item" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_item_id' is set
        if ('healthcheck_item_id' not in params or
                params['healthcheck_item_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_item_id` when calling `get_healthcheck_item`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_item_id' in params:
            path_params['HealthcheckItemId'] = params['healthcheck_item_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/healthcheck/items/{HealthcheckItemId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckItems',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_healthcheck_items(self, **kwargs):  # noqa: E501
        """get_healthcheck_items  # noqa: E501

        List items.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_items(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckItemsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_healthcheck_items_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_healthcheck_items_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_healthcheck_items_with_http_info(self, **kwargs):  # noqa: E501
        """get_healthcheck_items  # noqa: E501

        List items.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_items_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckItemsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_healthcheck_items" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_healthcheck_items`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_healthcheck_items`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_healthcheck_items`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_healthcheck_items`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/healthcheck/items', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckItemsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_healthcheck_parameter(self, healthcheck_parameter_id, **kwargs):  # noqa: E501
        """get_healthcheck_parameter  # noqa: E501

        Retrieve individual parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_parameter(healthcheck_parameter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_parameter_id: Retrieve individual parameter. (required)
        :return: HealthcheckParameters
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_healthcheck_parameter_with_http_info(healthcheck_parameter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_healthcheck_parameter_with_http_info(healthcheck_parameter_id, **kwargs)  # noqa: E501
            return data

    def get_healthcheck_parameter_with_http_info(self, healthcheck_parameter_id, **kwargs):  # noqa: E501
        """get_healthcheck_parameter  # noqa: E501

        Retrieve individual parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_parameter_with_http_info(healthcheck_parameter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_parameter_id: Retrieve individual parameter. (required)
        :return: HealthcheckParameters
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_parameter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_healthcheck_parameter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_parameter_id' is set
        if ('healthcheck_parameter_id' not in params or
                params['healthcheck_parameter_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_parameter_id` when calling `get_healthcheck_parameter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_parameter_id' in params:
            path_params['HealthcheckParameterId'] = params['healthcheck_parameter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/healthcheck/parameters/{HealthcheckParameterId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckParameters',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_healthcheck_schedule(self, healthcheck_schedule_id, **kwargs):  # noqa: E501
        """get_healthcheck_schedule  # noqa: E501

        Retrieve individual schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_schedule(healthcheck_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_schedule_id: Retrieve individual schedule. (required)
        :return: HealthcheckSchedules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_healthcheck_schedule_with_http_info(healthcheck_schedule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_healthcheck_schedule_with_http_info(healthcheck_schedule_id, **kwargs)  # noqa: E501
            return data

    def get_healthcheck_schedule_with_http_info(self, healthcheck_schedule_id, **kwargs):  # noqa: E501
        """get_healthcheck_schedule  # noqa: E501

        Retrieve individual schedule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_healthcheck_schedule_with_http_info(healthcheck_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str healthcheck_schedule_id: Retrieve individual schedule. (required)
        :return: HealthcheckSchedules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_schedule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_healthcheck_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_schedule_id' is set
        if ('healthcheck_schedule_id' not in params or
                params['healthcheck_schedule_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_schedule_id` when calling `get_healthcheck_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_schedule_id' in params:
            path_params['HealthcheckScheduleId'] = params['healthcheck_schedule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/schedules/{HealthcheckScheduleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckSchedules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_healthcheck_evaluations(self, **kwargs):  # noqa: E501
        """list_healthcheck_evaluations  # noqa: E501

        List evaluations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_healthcheck_evaluations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool detailed: Also return details for items that pass
        :param str level: Content detail level
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckEvaluationsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_healthcheck_evaluations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_healthcheck_evaluations_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_healthcheck_evaluations_with_http_info(self, **kwargs):  # noqa: E501
        """list_healthcheck_evaluations  # noqa: E501

        List evaluations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_healthcheck_evaluations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool detailed: Also return details for items that pass
        :param str level: Content detail level
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckEvaluationsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['detailed', 'level', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_healthcheck_evaluations" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_healthcheck_evaluations`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_healthcheck_evaluations`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_healthcheck_evaluations`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_healthcheck_evaluations`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'detailed' in params:
            query_params.append(('detailed', params['detailed']))  # noqa: E501
        if 'level' in params:
            query_params.append(('level', params['level']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/evaluations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckEvaluationsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_healthcheck_parameters(self, **kwargs):  # noqa: E501
        """list_healthcheck_parameters  # noqa: E501

        List parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_healthcheck_parameters(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckParametersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_healthcheck_parameters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_healthcheck_parameters_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_healthcheck_parameters_with_http_info(self, **kwargs):  # noqa: E501
        """list_healthcheck_parameters  # noqa: E501

        List parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_healthcheck_parameters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckParametersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_healthcheck_parameters" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_healthcheck_parameters`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_healthcheck_parameters`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_healthcheck_parameters`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_healthcheck_parameters`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/healthcheck/parameters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckParametersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_healthcheck_schedules(self, **kwargs):  # noqa: E501
        """list_healthcheck_schedules  # noqa: E501

        List schedules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_healthcheck_schedules(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckSchedulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_healthcheck_schedules_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_healthcheck_schedules_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_healthcheck_schedules_with_http_info(self, **kwargs):  # noqa: E501
        """list_healthcheck_schedules  # noqa: E501

        List schedules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_healthcheck_schedules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: HealthcheckSchedulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_healthcheck_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_healthcheck_schedules`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_healthcheck_schedules`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_healthcheck_schedules`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_healthcheck_schedules`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/schedules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HealthcheckSchedulesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_healthcheck_checklist(self, healthcheck_checklist, healthcheck_checklist_id, **kwargs):  # noqa: E501
        """update_healthcheck_checklist  # noqa: E501

        Modify checklist default delivery.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_healthcheck_checklist(healthcheck_checklist, healthcheck_checklist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckChecklist healthcheck_checklist: (required)
        :param str healthcheck_checklist_id: Modify checklist default delivery. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_healthcheck_checklist_with_http_info(healthcheck_checklist, healthcheck_checklist_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_healthcheck_checklist_with_http_info(healthcheck_checklist, healthcheck_checklist_id, **kwargs)  # noqa: E501
            return data

    def update_healthcheck_checklist_with_http_info(self, healthcheck_checklist, healthcheck_checklist_id, **kwargs):  # noqa: E501
        """update_healthcheck_checklist  # noqa: E501

        Modify checklist default delivery.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_healthcheck_checklist_with_http_info(healthcheck_checklist, healthcheck_checklist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckChecklist healthcheck_checklist: (required)
        :param str healthcheck_checklist_id: Modify checklist default delivery. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_checklist', 'healthcheck_checklist_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_healthcheck_checklist" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_checklist' is set
        if ('healthcheck_checklist' not in params or
                params['healthcheck_checklist'] is None):
            raise ValueError("Missing the required parameter `healthcheck_checklist` when calling `update_healthcheck_checklist`")  # noqa: E501
        # verify the required parameter 'healthcheck_checklist_id' is set
        if ('healthcheck_checklist_id' not in params or
                params['healthcheck_checklist_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_checklist_id` when calling `update_healthcheck_checklist`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_checklist_id' in params:
            path_params['HealthcheckChecklistId'] = params['healthcheck_checklist_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'healthcheck_checklist' in params:
            body_params = params['healthcheck_checklist']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/checklists/{HealthcheckChecklistId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_healthcheck_evaluation(self, healthcheck_evaluation, healthcheck_evaluation_id, **kwargs):  # noqa: E501
        """update_healthcheck_evaluation  # noqa: E501

        Pause or resume an evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_healthcheck_evaluation(healthcheck_evaluation, healthcheck_evaluation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckEvaluation healthcheck_evaluation: (required)
        :param str healthcheck_evaluation_id: Pause or resume an evaluation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_healthcheck_evaluation_with_http_info(healthcheck_evaluation, healthcheck_evaluation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_healthcheck_evaluation_with_http_info(healthcheck_evaluation, healthcheck_evaluation_id, **kwargs)  # noqa: E501
            return data

    def update_healthcheck_evaluation_with_http_info(self, healthcheck_evaluation, healthcheck_evaluation_id, **kwargs):  # noqa: E501
        """update_healthcheck_evaluation  # noqa: E501

        Pause or resume an evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_healthcheck_evaluation_with_http_info(healthcheck_evaluation, healthcheck_evaluation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckEvaluation healthcheck_evaluation: (required)
        :param str healthcheck_evaluation_id: Pause or resume an evaluation. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_evaluation', 'healthcheck_evaluation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_healthcheck_evaluation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_evaluation' is set
        if ('healthcheck_evaluation' not in params or
                params['healthcheck_evaluation'] is None):
            raise ValueError("Missing the required parameter `healthcheck_evaluation` when calling `update_healthcheck_evaluation`")  # noqa: E501
        # verify the required parameter 'healthcheck_evaluation_id' is set
        if ('healthcheck_evaluation_id' not in params or
                params['healthcheck_evaluation_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_evaluation_id` when calling `update_healthcheck_evaluation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_evaluation_id' in params:
            path_params['HealthcheckEvaluationId'] = params['healthcheck_evaluation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'healthcheck_evaluation' in params:
            body_params = params['healthcheck_evaluation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/evaluations/{HealthcheckEvaluationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_healthcheck_parameter(self, healthcheck_parameter, healthcheck_parameter_id, **kwargs):  # noqa: E501
        """update_healthcheck_parameter  # noqa: E501

        Modify a parameter value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_healthcheck_parameter(healthcheck_parameter, healthcheck_parameter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckParameter healthcheck_parameter: (required)
        :param str healthcheck_parameter_id: Modify a parameter value. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_healthcheck_parameter_with_http_info(healthcheck_parameter, healthcheck_parameter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_healthcheck_parameter_with_http_info(healthcheck_parameter, healthcheck_parameter_id, **kwargs)  # noqa: E501
            return data

    def update_healthcheck_parameter_with_http_info(self, healthcheck_parameter, healthcheck_parameter_id, **kwargs):  # noqa: E501
        """update_healthcheck_parameter  # noqa: E501

        Modify a parameter value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_healthcheck_parameter_with_http_info(healthcheck_parameter, healthcheck_parameter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckParameter healthcheck_parameter: (required)
        :param str healthcheck_parameter_id: Modify a parameter value. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_parameter', 'healthcheck_parameter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_healthcheck_parameter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_parameter' is set
        if ('healthcheck_parameter' not in params or
                params['healthcheck_parameter'] is None):
            raise ValueError("Missing the required parameter `healthcheck_parameter` when calling `update_healthcheck_parameter`")  # noqa: E501
        # verify the required parameter 'healthcheck_parameter_id' is set
        if ('healthcheck_parameter_id' not in params or
                params['healthcheck_parameter_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_parameter_id` when calling `update_healthcheck_parameter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_parameter_id' in params:
            path_params['HealthcheckParameterId'] = params['healthcheck_parameter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'healthcheck_parameter' in params:
            body_params = params['healthcheck_parameter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/healthcheck/parameters/{HealthcheckParameterId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_healthcheck_schedule(self, healthcheck_schedule, healthcheck_schedule_id, **kwargs):  # noqa: E501
        """update_healthcheck_schedule  # noqa: E501

        Modify a schedule value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_healthcheck_schedule(healthcheck_schedule, healthcheck_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckSchedule healthcheck_schedule: (required)
        :param str healthcheck_schedule_id: Modify a schedule value. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_healthcheck_schedule_with_http_info(healthcheck_schedule, healthcheck_schedule_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_healthcheck_schedule_with_http_info(healthcheck_schedule, healthcheck_schedule_id, **kwargs)  # noqa: E501
            return data

    def update_healthcheck_schedule_with_http_info(self, healthcheck_schedule, healthcheck_schedule_id, **kwargs):  # noqa: E501
        """update_healthcheck_schedule  # noqa: E501

        Modify a schedule value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_healthcheck_schedule_with_http_info(healthcheck_schedule, healthcheck_schedule_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HealthcheckSchedule healthcheck_schedule: (required)
        :param str healthcheck_schedule_id: Modify a schedule value. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['healthcheck_schedule', 'healthcheck_schedule_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_healthcheck_schedule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'healthcheck_schedule' is set
        if ('healthcheck_schedule' not in params or
                params['healthcheck_schedule'] is None):
            raise ValueError("Missing the required parameter `healthcheck_schedule` when calling `update_healthcheck_schedule`")  # noqa: E501
        # verify the required parameter 'healthcheck_schedule_id' is set
        if ('healthcheck_schedule_id' not in params or
                params['healthcheck_schedule_id'] is None):
            raise ValueError("Missing the required parameter `healthcheck_schedule_id` when calling `update_healthcheck_schedule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'healthcheck_schedule_id' in params:
            path_params['HealthcheckScheduleId'] = params['healthcheck_schedule_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'healthcheck_schedule' in params:
            body_params = params['healthcheck_schedule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/healthcheck/schedules/{HealthcheckScheduleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
