# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_2_0.api_client import ApiClient


class FsaResultsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_histogram_stat_by(self, id, stat, **kwargs):  # noqa: E501
        """get_histogram_stat_by  # noqa: E501

        This resource retrieves a histogram breakout for an individual FSA result set. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_histogram_stat_by(id, stat, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str stat: (required)
        :return: HistogramStatBy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_histogram_stat_by_with_http_info(id, stat, **kwargs)  # noqa: E501
        else:
            (data) = self.get_histogram_stat_by_with_http_info(id, stat, **kwargs)  # noqa: E501
            return data

    def get_histogram_stat_by_with_http_info(self, id, stat, **kwargs):  # noqa: E501
        """get_histogram_stat_by  # noqa: E501

        This resource retrieves a histogram breakout for an individual FSA result set. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_histogram_stat_by_with_http_info(id, stat, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str stat: (required)
        :return: HistogramStatBy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'stat']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_histogram_stat_by" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_histogram_stat_by`")  # noqa: E501
        # verify the required parameter 'stat' is set
        if ('stat' not in params or
                params['stat'] is None):
            raise ValueError("Missing the required parameter `stat` when calling `get_histogram_stat_by`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501
        if 'stat' in params:
            path_params['Stat'] = params['stat']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/histogram/{Stat}/by', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistogramStatBy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_histogram_stat_by_breakout(self, histogram_stat_by_breakout, id, stat, **kwargs):  # noqa: E501
        """get_histogram_stat_by_breakout  # noqa: E501

        This resource retrieves a histogram breakout for an individual FSA result set. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_histogram_stat_by_breakout(histogram_stat_by_breakout, id, stat, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str histogram_stat_by_breakout: This resource retrieves a histogram breakout for an individual FSA result set. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param str stat: (required)
        :param int atime_filter: Filter according to file accessed time, where the filter value specifies a negative number of seconds representing a time before the begin time of the report. The list of valid atime filter values may be found by performing a histogram breakout by atime and viewing the resulting key values.
        :param str attribute_filter: Filter according to the name of a file user attribute.
        :param int comp_report: Result set identifier for comparison of database results.
        :param int ctime_filter: Filter according to file modified time, where the filter value specifies a negative number of seconds representing a time before the begin time of the report. The list of valid ctime filter values may be found by performing a histogram breakout by ctime and viewing the resulting key values.
        :param str directory_filter: Filter according to a specific directory, which includes all of its subdirectories.
        :param str disk_pool_filter: Filter according to the name of a disk pool, which is a set of drives that represent an independent failure domain.
        :param int limit: Limit the number of breakout results.
        :param int log_size_filter: Filter according to file logical size, where the filter value specifies the lower bound in bytes to a set of files that have been grouped by logical size. The list of valid log_size filter values may be found by performing a histogram breakout by log_size and viewing the resulting key values.
        :param str node_pool_filter: Filter according to the name of a node pool, which is a set of disk pools that belong to nodes of the same equivalence class.
        :param str path_ext_filter: Filter according to the name of a single file extension.
        :param int phys_size_filter: Filter according to file physical size, where the filter value specifies the lower bound in bytes to a set of files that have been grouped by physical size. The list of valid phys_size filter values may be found by performing a histogram breakout by phys_size and viewing the resulting key values.
        :param str tier_filter: Filter according to the name of a storage tier, which is a user-created set of node pools.
        :return: HistogramStatBy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_histogram_stat_by_breakout_with_http_info(histogram_stat_by_breakout, id, stat, **kwargs)  # noqa: E501
        else:
            (data) = self.get_histogram_stat_by_breakout_with_http_info(histogram_stat_by_breakout, id, stat, **kwargs)  # noqa: E501
            return data

    def get_histogram_stat_by_breakout_with_http_info(self, histogram_stat_by_breakout, id, stat, **kwargs):  # noqa: E501
        """get_histogram_stat_by_breakout  # noqa: E501

        This resource retrieves a histogram breakout for an individual FSA result set. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_histogram_stat_by_breakout_with_http_info(histogram_stat_by_breakout, id, stat, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str histogram_stat_by_breakout: This resource retrieves a histogram breakout for an individual FSA result set. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param str stat: (required)
        :param int atime_filter: Filter according to file accessed time, where the filter value specifies a negative number of seconds representing a time before the begin time of the report. The list of valid atime filter values may be found by performing a histogram breakout by atime and viewing the resulting key values.
        :param str attribute_filter: Filter according to the name of a file user attribute.
        :param int comp_report: Result set identifier for comparison of database results.
        :param int ctime_filter: Filter according to file modified time, where the filter value specifies a negative number of seconds representing a time before the begin time of the report. The list of valid ctime filter values may be found by performing a histogram breakout by ctime and viewing the resulting key values.
        :param str directory_filter: Filter according to a specific directory, which includes all of its subdirectories.
        :param str disk_pool_filter: Filter according to the name of a disk pool, which is a set of drives that represent an independent failure domain.
        :param int limit: Limit the number of breakout results.
        :param int log_size_filter: Filter according to file logical size, where the filter value specifies the lower bound in bytes to a set of files that have been grouped by logical size. The list of valid log_size filter values may be found by performing a histogram breakout by log_size and viewing the resulting key values.
        :param str node_pool_filter: Filter according to the name of a node pool, which is a set of disk pools that belong to nodes of the same equivalence class.
        :param str path_ext_filter: Filter according to the name of a single file extension.
        :param int phys_size_filter: Filter according to file physical size, where the filter value specifies the lower bound in bytes to a set of files that have been grouped by physical size. The list of valid phys_size filter values may be found by performing a histogram breakout by phys_size and viewing the resulting key values.
        :param str tier_filter: Filter according to the name of a storage tier, which is a user-created set of node pools.
        :return: HistogramStatBy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['histogram_stat_by_breakout', 'id', 'stat', 'atime_filter', 'attribute_filter', 'comp_report', 'ctime_filter', 'directory_filter', 'disk_pool_filter', 'limit', 'log_size_filter', 'node_pool_filter', 'path_ext_filter', 'phys_size_filter', 'tier_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_histogram_stat_by_breakout" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'histogram_stat_by_breakout' is set
        if ('histogram_stat_by_breakout' not in params or
                params['histogram_stat_by_breakout'] is None):
            raise ValueError("Missing the required parameter `histogram_stat_by_breakout` when calling `get_histogram_stat_by_breakout`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_histogram_stat_by_breakout`")  # noqa: E501
        # verify the required parameter 'stat' is set
        if ('stat' not in params or
                params['stat'] is None):
            raise ValueError("Missing the required parameter `stat` when calling `get_histogram_stat_by_breakout`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'histogram_stat_by_breakout' in params:
            path_params['HistogramStatByBreakout'] = params['histogram_stat_by_breakout']  # noqa: E501
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501
        if 'stat' in params:
            path_params['Stat'] = params['stat']  # noqa: E501

        query_params = []
        if 'atime_filter' in params:
            query_params.append(('atime_filter', params['atime_filter']))  # noqa: E501
        if 'attribute_filter' in params:
            query_params.append(('attribute_filter', params['attribute_filter']))  # noqa: E501
        if 'comp_report' in params:
            query_params.append(('comp_report', params['comp_report']))  # noqa: E501
        if 'ctime_filter' in params:
            query_params.append(('ctime_filter', params['ctime_filter']))  # noqa: E501
        if 'directory_filter' in params:
            query_params.append(('directory_filter', params['directory_filter']))  # noqa: E501
        if 'disk_pool_filter' in params:
            query_params.append(('disk_pool_filter', params['disk_pool_filter']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'log_size_filter' in params:
            query_params.append(('log_size_filter', params['log_size_filter']))  # noqa: E501
        if 'node_pool_filter' in params:
            query_params.append(('node_pool_filter', params['node_pool_filter']))  # noqa: E501
        if 'path_ext_filter' in params:
            query_params.append(('path_ext_filter', params['path_ext_filter']))  # noqa: E501
        if 'phys_size_filter' in params:
            query_params.append(('phys_size_filter', params['phys_size_filter']))  # noqa: E501
        if 'tier_filter' in params:
            query_params.append(('tier_filter', params['tier_filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/histogram/{Stat}/by/{HistogramStatByBreakout}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistogramStatBy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_dir_pools_usage(self, id, **kwargs):  # noqa: E501
        """get_result_dir_pools_usage  # noqa: E501

         View pool usage information of a directory, classified by storage pools in response \"usage_data\". The storage pool type can be specified by query parameter \"storage_pool_type\". The directory is \"path\" query parameter. The response \"dir_usage\" is total disk usage of directory, over all pools at a given storage pool level. When path cannot be found within result, status code 404 and error message will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_dir_pools_usage(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str path:  Directory absolute path to report usage information. Path should be UTF8 percent encoded, should be within \"/ifs\". Defaults to \"/ifs\".
        :param str storage_pool_type: The type of the storage pool.
        :return: ResultDirPoolsUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_dir_pools_usage_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_dir_pools_usage_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_result_dir_pools_usage_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_result_dir_pools_usage  # noqa: E501

         View pool usage information of a directory, classified by storage pools in response \"usage_data\". The storage pool type can be specified by query parameter \"storage_pool_type\". The directory is \"path\" query parameter. The response \"dir_usage\" is total disk usage of directory, over all pools at a given storage pool level. When path cannot be found within result, status code 404 and error message will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_dir_pools_usage_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str path:  Directory absolute path to report usage information. Path should be UTF8 percent encoded, should be within \"/ifs\". Defaults to \"/ifs\".
        :param str storage_pool_type: The type of the storage pool.
        :return: ResultDirPoolsUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'comp_report', 'path', 'storage_pool_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_dir_pools_usage" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_dir_pools_usage`")  # noqa: E501

        if ('path' in params and
                len(params['path']) > 4096):
            raise ValueError("Invalid value for parameter `path` when calling `get_result_dir_pools_usage`, length must be less than or equal to `4096`")  # noqa: E501
        if ('path' in params and
                len(params['path']) < 4):
            raise ValueError("Invalid value for parameter `path` when calling `get_result_dir_pools_usage`, length must be greater than or equal to `4`")  # noqa: E501
        if 'path' in params and not re.search('^\/ifs$|^\/ifs\/', params['path']):  # noqa: E501
            raise ValueError("Invalid value for parameter `path` when calling `get_result_dir_pools_usage`, must conform to the pattern `/^\/ifs$|^\/ifs\//`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []
        if 'comp_report' in params:
            query_params.append(('comp_report', params['comp_report']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'storage_pool_type' in params:
            query_params.append(('storage_pool_type', params['storage_pool_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/fsa/results/{Id}/dir_pools_usage', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultDirPoolsUsage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_dir_pools_usage_lin(self, result_dir_pools_usage_lin, id, **kwargs):  # noqa: E501
        """get_result_dir_pools_usage_lin  # noqa: E501

         View pool usage information of a directory, classified by storage pools in response \"usage_data\". The storage pool type can be specified by query parameter \"storage_pool_type\". The directory is LIN token of URI. The response \"dir_usage\" is total disk usage of directory, over all pools at a given storage pool level. When LIN cannot be found within result, status code 404 and error message will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_dir_pools_usage_lin(result_dir_pools_usage_lin, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int result_dir_pools_usage_lin:  View pool usage information of a directory, classified by storage pools in response \"usage_data\". The storage pool type can be specified by query parameter \"storage_pool_type\". The directory is LIN token of URI. The response \"dir_usage\" is total disk usage of directory, over all pools at a given storage pool level. When LIN cannot be found within result, status code 404 and error message will be returned. (required)
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str storage_pool_type: The type of the storage pool.
        :return: ResultDirPoolsUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_dir_pools_usage_lin_with_http_info(result_dir_pools_usage_lin, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_dir_pools_usage_lin_with_http_info(result_dir_pools_usage_lin, id, **kwargs)  # noqa: E501
            return data

    def get_result_dir_pools_usage_lin_with_http_info(self, result_dir_pools_usage_lin, id, **kwargs):  # noqa: E501
        """get_result_dir_pools_usage_lin  # noqa: E501

         View pool usage information of a directory, classified by storage pools in response \"usage_data\". The storage pool type can be specified by query parameter \"storage_pool_type\". The directory is LIN token of URI. The response \"dir_usage\" is total disk usage of directory, over all pools at a given storage pool level. When LIN cannot be found within result, status code 404 and error message will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_dir_pools_usage_lin_with_http_info(result_dir_pools_usage_lin, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int result_dir_pools_usage_lin:  View pool usage information of a directory, classified by storage pools in response \"usage_data\". The storage pool type can be specified by query parameter \"storage_pool_type\". The directory is LIN token of URI. The response \"dir_usage\" is total disk usage of directory, over all pools at a given storage pool level. When LIN cannot be found within result, status code 404 and error message will be returned. (required)
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str storage_pool_type: The type of the storage pool.
        :return: ResultDirPoolsUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['result_dir_pools_usage_lin', 'id', 'comp_report', 'storage_pool_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_dir_pools_usage_lin" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'result_dir_pools_usage_lin' is set
        if ('result_dir_pools_usage_lin' not in params or
                params['result_dir_pools_usage_lin'] is None):
            raise ValueError("Missing the required parameter `result_dir_pools_usage_lin` when calling `get_result_dir_pools_usage_lin`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_dir_pools_usage_lin`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'result_dir_pools_usage_lin' in params:
            path_params['ResultDirPoolsUsageLin'] = params['result_dir_pools_usage_lin']  # noqa: E501
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []
        if 'comp_report' in params:
            query_params.append(('comp_report', params['comp_report']))  # noqa: E501
        if 'storage_pool_type' in params:
            query_params.append(('storage_pool_type', params['storage_pool_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/fsa/results/{Id}/dir_pools_usage/{ResultDirPoolsUsageLin}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultDirPoolsUsage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_directories(self, id, **kwargs):  # noqa: E501
        """get_result_directories  # noqa: E501

        This resource retrieves directory information. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_directories(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str dir: The direction of the sort.
        :param int limit: Limit the number of reported subdirectories.
        :param str path: Primary directory path to report usage information, which may be specified instead of a LIN.
        :param str sort: The field that will be used for sorting.
        :return: ResultDirectoriesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_directories_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_directories_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_result_directories_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_result_directories  # noqa: E501

        This resource retrieves directory information. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_directories_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str dir: The direction of the sort.
        :param int limit: Limit the number of reported subdirectories.
        :param str path: Primary directory path to report usage information, which may be specified instead of a LIN.
        :param str sort: The field that will be used for sorting.
        :return: ResultDirectoriesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'comp_report', 'dir', 'limit', 'path', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_directories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_directories`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_result_directories`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_result_directories`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_result_directories`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []
        if 'comp_report' in params:
            query_params.append(('comp_report', params['comp_report']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'path' in params:
            query_params.append(('path', params['path']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/directories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultDirectoriesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_directory(self, result_directory_id, id, **kwargs):  # noqa: E501
        """get_result_directory  # noqa: E501

        This resource retrieves directory information. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_directory(result_directory_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int result_directory_id: This resource retrieves directory information. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str dir: The direction of the sort.
        :param int limit: Limit the number of reported subdirectories.
        :param str sort: The field that will be used for sorting.
        :return: ResultDirectories
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_directory_with_http_info(result_directory_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_directory_with_http_info(result_directory_id, id, **kwargs)  # noqa: E501
            return data

    def get_result_directory_with_http_info(self, result_directory_id, id, **kwargs):  # noqa: E501
        """get_result_directory  # noqa: E501

        This resource retrieves directory information. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_directory_with_http_info(result_directory_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int result_directory_id: This resource retrieves directory information. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str dir: The direction of the sort.
        :param int limit: Limit the number of reported subdirectories.
        :param str sort: The field that will be used for sorting.
        :return: ResultDirectories
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['result_directory_id', 'id', 'comp_report', 'dir', 'limit', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_directory" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'result_directory_id' is set
        if ('result_directory_id' not in params or
                params['result_directory_id'] is None):
            raise ValueError("Missing the required parameter `result_directory_id` when calling `get_result_directory`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_directory`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_result_directory`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_result_directory`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_result_directory`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'result_directory_id' in params:
            path_params['ResultDirectoryId'] = params['result_directory_id']  # noqa: E501
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []
        if 'comp_report' in params:
            query_params.append(('comp_report', params['comp_report']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/directories/{ResultDirectoryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultDirectories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_histogram(self, id, **kwargs):  # noqa: E501
        """get_result_histogram  # noqa: E501

        This resource retrieves a histogram of file counts for an individual FSA result set. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_histogram(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ResultHistogram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_histogram_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_histogram_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_result_histogram_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_result_histogram  # noqa: E501

        This resource retrieves a histogram of file counts for an individual FSA result set. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_histogram_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ResultHistogram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_histogram" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_histogram`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/histogram', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultHistogram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_histogram_stat(self, result_histogram_stat, id, **kwargs):  # noqa: E501
        """get_result_histogram_stat  # noqa: E501

        This resource retrieves a histogram of file counts for an individual FSA result set. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_histogram_stat(result_histogram_stat, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str result_histogram_stat: This resource retrieves a histogram of file counts for an individual FSA result set. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param int atime_filter: Filter according to file accessed time, where the filter value specifies a negative number of seconds representing a time before the begin time of the report. The list of valid atime filter values may be found by performing a histogram breakout by atime and viewing the resulting key values.
        :param str attribute_filter: Filter according to the name of a file user attribute.
        :param int comp_report: Result set identifier for comparison of database results.
        :param int ctime_filter: Filter according to file modified time, where the filter value specifies a negative number of seconds representing a time before the begin time of the report. The list of valid ctime filter values may be found by performing a histogram breakout by ctime and viewing the resulting key values.
        :param str directory_filter: Filter according to a specific directory, which includes all of its subdirectories.
        :param str disk_pool_filter: Filter according to the name of a disk pool, which is a set of drives that represent an independent failure domain.
        :param int log_size_filter: Filter according to file logical size, where the filter value specifies the lower bound in bytes to a set of files that have been grouped by logical size. The list of valid log_size filter values may be found by performing a histogram breakout by log_size and viewing the resulting key values.
        :param str node_pool_filter: Filter according to the name of a node pool, which is a set of disk pools that belong to nodes of the same equivalence class.
        :param str path_ext_filter: Filter according to the name of a single file extension.
        :param int phys_size_filter: Filter according to file physical size, where the filter value specifies the lower bound in bytes to a set of files that have been grouped by physical size. The list of valid phys_size filter values may be found by performing a histogram breakout by phys_size and viewing the resulting key values.
        :param str tier_filter: Filter according to the name of a storage tier, which is a user-created set of node pools.
        :return: ResultHistogram
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_histogram_stat_with_http_info(result_histogram_stat, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_histogram_stat_with_http_info(result_histogram_stat, id, **kwargs)  # noqa: E501
            return data

    def get_result_histogram_stat_with_http_info(self, result_histogram_stat, id, **kwargs):  # noqa: E501
        """get_result_histogram_stat  # noqa: E501

        This resource retrieves a histogram of file counts for an individual FSA result set. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_histogram_stat_with_http_info(result_histogram_stat, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str result_histogram_stat: This resource retrieves a histogram of file counts for an individual FSA result set. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param int atime_filter: Filter according to file accessed time, where the filter value specifies a negative number of seconds representing a time before the begin time of the report. The list of valid atime filter values may be found by performing a histogram breakout by atime and viewing the resulting key values.
        :param str attribute_filter: Filter according to the name of a file user attribute.
        :param int comp_report: Result set identifier for comparison of database results.
        :param int ctime_filter: Filter according to file modified time, where the filter value specifies a negative number of seconds representing a time before the begin time of the report. The list of valid ctime filter values may be found by performing a histogram breakout by ctime and viewing the resulting key values.
        :param str directory_filter: Filter according to a specific directory, which includes all of its subdirectories.
        :param str disk_pool_filter: Filter according to the name of a disk pool, which is a set of drives that represent an independent failure domain.
        :param int log_size_filter: Filter according to file logical size, where the filter value specifies the lower bound in bytes to a set of files that have been grouped by logical size. The list of valid log_size filter values may be found by performing a histogram breakout by log_size and viewing the resulting key values.
        :param str node_pool_filter: Filter according to the name of a node pool, which is a set of disk pools that belong to nodes of the same equivalence class.
        :param str path_ext_filter: Filter according to the name of a single file extension.
        :param int phys_size_filter: Filter according to file physical size, where the filter value specifies the lower bound in bytes to a set of files that have been grouped by physical size. The list of valid phys_size filter values may be found by performing a histogram breakout by phys_size and viewing the resulting key values.
        :param str tier_filter: Filter according to the name of a storage tier, which is a user-created set of node pools.
        :return: ResultHistogram
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['result_histogram_stat', 'id', 'atime_filter', 'attribute_filter', 'comp_report', 'ctime_filter', 'directory_filter', 'disk_pool_filter', 'log_size_filter', 'node_pool_filter', 'path_ext_filter', 'phys_size_filter', 'tier_filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_histogram_stat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'result_histogram_stat' is set
        if ('result_histogram_stat' not in params or
                params['result_histogram_stat'] is None):
            raise ValueError("Missing the required parameter `result_histogram_stat` when calling `get_result_histogram_stat`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_histogram_stat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'result_histogram_stat' in params:
            path_params['ResultHistogramStat'] = params['result_histogram_stat']  # noqa: E501
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []
        if 'atime_filter' in params:
            query_params.append(('atime_filter', params['atime_filter']))  # noqa: E501
        if 'attribute_filter' in params:
            query_params.append(('attribute_filter', params['attribute_filter']))  # noqa: E501
        if 'comp_report' in params:
            query_params.append(('comp_report', params['comp_report']))  # noqa: E501
        if 'ctime_filter' in params:
            query_params.append(('ctime_filter', params['ctime_filter']))  # noqa: E501
        if 'directory_filter' in params:
            query_params.append(('directory_filter', params['directory_filter']))  # noqa: E501
        if 'disk_pool_filter' in params:
            query_params.append(('disk_pool_filter', params['disk_pool_filter']))  # noqa: E501
        if 'log_size_filter' in params:
            query_params.append(('log_size_filter', params['log_size_filter']))  # noqa: E501
        if 'node_pool_filter' in params:
            query_params.append(('node_pool_filter', params['node_pool_filter']))  # noqa: E501
        if 'path_ext_filter' in params:
            query_params.append(('path_ext_filter', params['path_ext_filter']))  # noqa: E501
        if 'phys_size_filter' in params:
            query_params.append(('phys_size_filter', params['phys_size_filter']))  # noqa: E501
        if 'tier_filter' in params:
            query_params.append(('tier_filter', params['tier_filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/histogram/{ResultHistogramStat}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultHistogram',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_top_dir(self, result_top_dir_id, id, **kwargs):  # noqa: E501
        """get_result_top_dir  # noqa: E501

        This resource retrieves the top directories. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_top_dir(result_top_dir_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str result_top_dir_id: This resource retrieves the top directories. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str dir: The direction of the sort.
        :param int limit: Number of results from start index. Default value of 1000.
        :param str sort: The field that will be used for sorting.
        :param int start: Starting index for results. Default value of 0.
        :return: ResultTopDirs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_top_dir_with_http_info(result_top_dir_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_top_dir_with_http_info(result_top_dir_id, id, **kwargs)  # noqa: E501
            return data

    def get_result_top_dir_with_http_info(self, result_top_dir_id, id, **kwargs):  # noqa: E501
        """get_result_top_dir  # noqa: E501

        This resource retrieves the top directories. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_top_dir_with_http_info(result_top_dir_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str result_top_dir_id: This resource retrieves the top directories. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str dir: The direction of the sort.
        :param int limit: Number of results from start index. Default value of 1000.
        :param str sort: The field that will be used for sorting.
        :param int start: Starting index for results. Default value of 0.
        :return: ResultTopDirs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['result_top_dir_id', 'id', 'comp_report', 'dir', 'limit', 'sort', 'start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_top_dir" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'result_top_dir_id' is set
        if ('result_top_dir_id' not in params or
                params['result_top_dir_id'] is None):
            raise ValueError("Missing the required parameter `result_top_dir_id` when calling `get_result_top_dir`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_top_dir`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_result_top_dir`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_result_top_dir`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_result_top_dir`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'result_top_dir_id' in params:
            path_params['ResultTopDirId'] = params['result_top_dir_id']  # noqa: E501
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []
        if 'comp_report' in params:
            query_params.append(('comp_report', params['comp_report']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/top-dirs/{ResultTopDirId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultTopDirs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_top_dirs(self, id, **kwargs):  # noqa: E501
        """get_result_top_dirs  # noqa: E501

        This resource retrieves the top directories. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_top_dirs(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ResultTopDirs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_top_dirs_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_top_dirs_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_result_top_dirs_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_result_top_dirs  # noqa: E501

        This resource retrieves the top directories. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_top_dirs_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ResultTopDirs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_top_dirs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_top_dirs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/top-dirs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultTopDirs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_top_file(self, result_top_file_id, id, **kwargs):  # noqa: E501
        """get_result_top_file  # noqa: E501

        This resource retrieves the top files. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_top_file(result_top_file_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str result_top_file_id: This resource retrieves the top files. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str dir: The direction of the sort.
        :param int limit: Number of results from start index. Default value of 1000.
        :param str sort: The field that will be used for sorting.
        :param int start: Starting index for results. Default value of 0.
        :return: ResultTopFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_top_file_with_http_info(result_top_file_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_top_file_with_http_info(result_top_file_id, id, **kwargs)  # noqa: E501
            return data

    def get_result_top_file_with_http_info(self, result_top_file_id, id, **kwargs):  # noqa: E501
        """get_result_top_file  # noqa: E501

        This resource retrieves the top files. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_top_file_with_http_info(result_top_file_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str result_top_file_id: This resource retrieves the top files. ID in the resource path is the result set ID. (required)
        :param str id: (required)
        :param int comp_report: Result set identifier for comparison of database results.
        :param str dir: The direction of the sort.
        :param int limit: Number of results from start index. Default value of 1000.
        :param str sort: The field that will be used for sorting.
        :param int start: Starting index for results. Default value of 0.
        :return: ResultTopFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['result_top_file_id', 'id', 'comp_report', 'dir', 'limit', 'sort', 'start']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_top_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'result_top_file_id' is set
        if ('result_top_file_id' not in params or
                params['result_top_file_id'] is None):
            raise ValueError("Missing the required parameter `result_top_file_id` when calling `get_result_top_file`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_top_file`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_result_top_file`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_result_top_file`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_result_top_file`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'result_top_file_id' in params:
            path_params['ResultTopFileId'] = params['result_top_file_id']  # noqa: E501
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []
        if 'comp_report' in params:
            query_params.append(('comp_report', params['comp_report']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/top-files/{ResultTopFileId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultTopFiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_result_top_files(self, id, **kwargs):  # noqa: E501
        """get_result_top_files  # noqa: E501

        This resource retrieves the top files. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_top_files(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ResultTopFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_result_top_files_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_result_top_files_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_result_top_files_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_result_top_files  # noqa: E501

        This resource retrieves the top files. ID in the resource path is the result set ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_result_top_files_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: ResultTopFiles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_result_top_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_result_top_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/fsa/results/{Id}/top-files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResultTopFiles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
