# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 12
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_2_0.api_client import ApiClient


class AuditApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_audit_topic(self, audit_topic, **kwargs):  # noqa: E501
        """create_audit_topic  # noqa: E501

        Create a new audit topic.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_audit_topic(audit_topic, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuditTopicCreateParams audit_topic: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_audit_topic_with_http_info(audit_topic, **kwargs)  # noqa: E501
        else:
            (data) = self.create_audit_topic_with_http_info(audit_topic, **kwargs)  # noqa: E501
            return data

    def create_audit_topic_with_http_info(self, audit_topic, **kwargs):  # noqa: E501
        """create_audit_topic  # noqa: E501

        Create a new audit topic.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_audit_topic_with_http_info(audit_topic, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuditTopicCreateParams audit_topic: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['audit_topic']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_audit_topic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'audit_topic' is set
        if ('audit_topic' not in params or
                params['audit_topic'] is None):
            raise ValueError("Missing the required parameter `audit_topic` when calling `create_audit_topic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'audit_topic' in params:
            body_params = params['audit_topic']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/audit/topics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_audit_logs(self, before, **kwargs):  # noqa: E501
        """delete_audit_logs  # noqa: E501

        Manually delete audit log files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_audit_logs(before, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int before: The timestamp before which logs will be deleted. (required)
        :param bool force: Do not ask for confirmation.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_audit_logs_with_http_info(before, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_audit_logs_with_http_info(before, **kwargs)  # noqa: E501
            return data

    def delete_audit_logs_with_http_info(self, before, **kwargs):  # noqa: E501
        """delete_audit_logs  # noqa: E501

        Manually delete audit log files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_audit_logs_with_http_info(before, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int before: The timestamp before which logs will be deleted. (required)
        :param bool force: Do not ask for confirmation.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_audit_logs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'before' is set
        if ('before' not in params or
                params['before'] is None):
            raise ValueError("Missing the required parameter `before` when calling `delete_audit_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'before' in params:
            query_params.append(('before', params['before']))  # noqa: E501
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/audit/logs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_audit_topic(self, audit_topic_id, **kwargs):  # noqa: E501
        """delete_audit_topic  # noqa: E501

        Delete the audit topic.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_audit_topic(audit_topic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str audit_topic_id: Delete the audit topic. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_audit_topic_with_http_info(audit_topic_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_audit_topic_with_http_info(audit_topic_id, **kwargs)  # noqa: E501
            return data

    def delete_audit_topic_with_http_info(self, audit_topic_id, **kwargs):  # noqa: E501
        """delete_audit_topic  # noqa: E501

        Delete the audit topic.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_audit_topic_with_http_info(audit_topic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str audit_topic_id: Delete the audit topic. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['audit_topic_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_audit_topic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'audit_topic_id' is set
        if ('audit_topic_id' not in params or
                params['audit_topic_id'] is None):
            raise ValueError("Missing the required parameter `audit_topic_id` when calling `delete_audit_topic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'audit_topic_id' in params:
            path_params['AuditTopicId'] = params['audit_topic_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/audit/topics/{AuditTopicId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_logs(self, **kwargs):  # noqa: E501
        """get_audit_logs  # noqa: E501

        Get the manual deletion status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuditLogs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_logs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_logs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_audit_logs_with_http_info(self, **kwargs):  # noqa: E501
        """get_audit_logs  # noqa: E501

        Get the manual deletion status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuditLogs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_logs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/audit/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditLogs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_progress(self, **kwargs):  # noqa: E501
        """get_audit_progress  # noqa: E501

        View current audit log time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_progress(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: lnn of the node.
        :return: AuditProgress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_progress_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_progress_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_audit_progress_with_http_info(self, **kwargs):  # noqa: E501
        """get_audit_progress  # noqa: E501

        View current audit log time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_progress_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int lnn: lnn of the node.
        :return: AuditProgress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lnn']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_progress" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'lnn' in params:
            query_params.append(('lnn', params['lnn']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/audit/progress', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditProgress',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_settings(self, **kwargs):  # noqa: E501
        """get_audit_settings  # noqa: E501

        View per-Access Zone Audit settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains audit settings.
        :return: AuditSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_audit_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_audit_settings  # noqa: E501

        View per-Access Zone Audit settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zone: Access zone which contains audit settings.
        :return: AuditSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/audit/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_audit_topic(self, audit_topic_id, **kwargs):  # noqa: E501
        """get_audit_topic  # noqa: E501

        Retrieve the audit topic information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_topic(audit_topic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str audit_topic_id: Retrieve the audit topic information. (required)
        :return: AuditTopics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_audit_topic_with_http_info(audit_topic_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_audit_topic_with_http_info(audit_topic_id, **kwargs)  # noqa: E501
            return data

    def get_audit_topic_with_http_info(self, audit_topic_id, **kwargs):  # noqa: E501
        """get_audit_topic  # noqa: E501

        Retrieve the audit topic information.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_audit_topic_with_http_info(audit_topic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str audit_topic_id: Retrieve the audit topic information. (required)
        :return: AuditTopics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['audit_topic_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_audit_topic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'audit_topic_id' is set
        if ('audit_topic_id' not in params or
                params['audit_topic_id'] is None):
            raise ValueError("Missing the required parameter `audit_topic_id` when calling `get_audit_topic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'audit_topic_id' in params:
            path_params['AuditTopicId'] = params['audit_topic_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/audit/topics/{AuditTopicId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditTopics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_progress_global(self, **kwargs):  # noqa: E501
        """get_progress_global  # noqa: E501

        View the global audit log time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_progress_global(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ProgressGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_progress_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_progress_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_progress_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_progress_global  # noqa: E501

        View the global audit log time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_progress_global_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ProgressGlobal
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_progress_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/audit/progress/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProgressGlobal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_settings_global(self, **kwargs):  # noqa: E501
        """get_settings_global  # noqa: E501

        View global audit settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_global(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsGlobalExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_settings_global_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_settings_global_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_settings_global_with_http_info(self, **kwargs):  # noqa: E501
        """get_settings_global  # noqa: E501

        View global audit settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_settings_global_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SettingsGlobalExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_settings_global" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/audit/settings/global', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SettingsGlobalExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_audit_topics(self, **kwargs):  # noqa: E501
        """list_audit_topics  # noqa: E501

        Retrieve a list of audit topics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_audit_topics(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuditTopics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_audit_topics_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_audit_topics_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_audit_topics_with_http_info(self, **kwargs):  # noqa: E501
        """list_audit_topics  # noqa: E501

        Retrieve a list of audit topics.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_audit_topics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuditTopics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_audit_topics" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/audit/topics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditTopics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_audit_settings(self, audit_settings, **kwargs):  # noqa: E501
        """update_audit_settings  # noqa: E501

        Modify per-Access Zone Audit settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_audit_settings(audit_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuditSettingsSettings audit_settings: (required)
        :param str zone: Access zone which contains audit settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_audit_settings_with_http_info(audit_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_audit_settings_with_http_info(audit_settings, **kwargs)  # noqa: E501
            return data

    def update_audit_settings_with_http_info(self, audit_settings, **kwargs):  # noqa: E501
        """update_audit_settings  # noqa: E501

        Modify per-Access Zone Audit settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_audit_settings_with_http_info(audit_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuditSettingsSettings audit_settings: (required)
        :param str zone: Access zone which contains audit settings.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['audit_settings', 'zone']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_audit_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'audit_settings' is set
        if ('audit_settings' not in params or
                params['audit_settings'] is None):
            raise ValueError("Missing the required parameter `audit_settings` when calling `update_audit_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zone' in params:
            query_params.append(('zone', params['zone']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'audit_settings' in params:
            body_params = params['audit_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/audit/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_audit_topic(self, audit_topic, audit_topic_id, **kwargs):  # noqa: E501
        """update_audit_topic  # noqa: E501

        Modify the audit topic.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_audit_topic(audit_topic, audit_topic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuditTopic audit_topic: (required)
        :param str audit_topic_id: Modify the audit topic. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_audit_topic_with_http_info(audit_topic, audit_topic_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_audit_topic_with_http_info(audit_topic, audit_topic_id, **kwargs)  # noqa: E501
            return data

    def update_audit_topic_with_http_info(self, audit_topic, audit_topic_id, **kwargs):  # noqa: E501
        """update_audit_topic  # noqa: E501

        Modify the audit topic.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_audit_topic_with_http_info(audit_topic, audit_topic_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AuditTopic audit_topic: (required)
        :param str audit_topic_id: Modify the audit topic. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['audit_topic', 'audit_topic_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_audit_topic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'audit_topic' is set
        if ('audit_topic' not in params or
                params['audit_topic'] is None):
            raise ValueError("Missing the required parameter `audit_topic` when calling `update_audit_topic`")  # noqa: E501
        # verify the required parameter 'audit_topic_id' is set
        if ('audit_topic_id' not in params or
                params['audit_topic_id'] is None):
            raise ValueError("Missing the required parameter `audit_topic_id` when calling `update_audit_topic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'audit_topic_id' in params:
            path_params['AuditTopicId'] = params['audit_topic_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'audit_topic' in params:
            body_params = params['audit_topic']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/audit/topics/{AuditTopicId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_settings_global(self, settings_global, **kwargs):  # noqa: E501
        """update_settings_global  # noqa: E501

        Modify global audit settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_global(settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsGlobalSettings settings_global: (required)
        :param bool force: Do not ask for confirmation.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_settings_global_with_http_info(settings_global, **kwargs)  # noqa: E501
        else:
            (data) = self.update_settings_global_with_http_info(settings_global, **kwargs)  # noqa: E501
            return data

    def update_settings_global_with_http_info(self, settings_global, **kwargs):  # noqa: E501
        """update_settings_global  # noqa: E501

        Modify global audit settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_settings_global_with_http_info(settings_global, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SettingsGlobalSettings settings_global: (required)
        :param bool force: Do not ask for confirmation.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_global', 'force']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_settings_global" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'settings_global' is set
        if ('settings_global' not in params or
                params['settings_global'] is None):
            raise ValueError("Missing the required parameter `settings_global` when calling `update_settings_global`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'force' in params:
            query_params.append(('force', params['force']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'settings_global' in params:
            body_params = params['settings_global']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/audit/settings/global', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
