# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 11
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_1_0.api_client import ApiClient


class StatisticsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_statistics_current(self, **kwargs):  # noqa: E501
        """get_statistics_current  # noqa: E501

        Retrieve stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_current(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool degraded: If true, try to continue even if some stats are unavailable. In this case, errors will be present in the per-key returned data.
        :param list[str] devid: Node devid to query. Either an <integer> or \"all\". Can be used more than one time to query multiple nodes. \"all\" queries all up nodes. 0 means query the local node. For \"cluster\" scoped keys, in any devid including 0 can be used.
        :param list[str] key: One key name. Can be used more than one time to query multiple keys. Also works with 'keys' arguments.
        :param list[str] keys: Multiple key names. Can be a comma separated list, or can be used more than one time to make queries for multiple keys. May be used in conjunction with 'substr'. Also works with 'key' arguments.
        :param list[str] nodes: Specify node(s) for which statistics should be reported. One or more comma separated <integer(s)> specifying which node(s) to query, or \"all\". Specifying more than one node may have unspecified results for keys that begin with \"cluster\".
        :param bool raw: Causes the output to be in hex format. For internal use only, please do not use this.
        :param bool show_nodes: Shows the logical node number or LNN in addition to the devid.
        :param bool stale: For internal use only, please do not use this.
        :param bool substr: Used in conjunction with the 'keys' argument, alters the behavior of keys. Makes the 'keys' arg perform a partial match. Defaults to false.
        :param int timeout: Time in seconds to wait for results from remote nodes.
        :param bool type_info: The type ID is used by internal services. For internal use only, please do not use this.
        :return: StatisticsCurrent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_statistics_current_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_current_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_current_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_current  # noqa: E501

        Retrieve stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_current_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool degraded: If true, try to continue even if some stats are unavailable. In this case, errors will be present in the per-key returned data.
        :param list[str] devid: Node devid to query. Either an <integer> or \"all\". Can be used more than one time to query multiple nodes. \"all\" queries all up nodes. 0 means query the local node. For \"cluster\" scoped keys, in any devid including 0 can be used.
        :param list[str] key: One key name. Can be used more than one time to query multiple keys. Also works with 'keys' arguments.
        :param list[str] keys: Multiple key names. Can be a comma separated list, or can be used more than one time to make queries for multiple keys. May be used in conjunction with 'substr'. Also works with 'key' arguments.
        :param list[str] nodes: Specify node(s) for which statistics should be reported. One or more comma separated <integer(s)> specifying which node(s) to query, or \"all\". Specifying more than one node may have unspecified results for keys that begin with \"cluster\".
        :param bool raw: Causes the output to be in hex format. For internal use only, please do not use this.
        :param bool show_nodes: Shows the logical node number or LNN in addition to the devid.
        :param bool stale: For internal use only, please do not use this.
        :param bool substr: Used in conjunction with the 'keys' argument, alters the behavior of keys. Makes the 'keys' arg perform a partial match. Defaults to false.
        :param int timeout: Time in seconds to wait for results from remote nodes.
        :param bool type_info: The type ID is used by internal services. For internal use only, please do not use this.
        :return: StatisticsCurrent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['degraded', 'devid', 'key', 'keys', 'nodes', 'raw', 'show_nodes', 'stale', 'substr', 'timeout', 'type_info']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_current" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'devid' in params:
            query_params.append(('devid', params['devid']))  # noqa: E501
            collection_formats['devid'] = 'csv'  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
            collection_formats['key'] = 'csv'  # noqa: E501
        if 'keys' in params:
            query_params.append(('keys', params['keys']))  # noqa: E501
            collection_formats['keys'] = 'csv'  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
            collection_formats['nodes'] = 'csv'  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'show_nodes' in params:
            query_params.append(('show_nodes', params['show_nodes']))  # noqa: E501
        if 'stale' in params:
            query_params.append(('stale', params['stale']))  # noqa: E501
        if 'substr' in params:
            query_params.append(('substr', params['substr']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'type_info' in params:
            query_params.append(('type_info', params['type_info']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/current', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsCurrent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_history(self, **kwargs):  # noqa: E501
        """get_statistics_history  # noqa: E501

        Retrieve stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_history(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Earliest time (Unix epoch seconds) of interest. Negative times are interpreted as relative (before) now.
        :param bool degraded: If true, try to continue even if some stats are unavailable. In this case, errors will be present in the per-key returned data.
        :param list[str] devid: Node devid to query. Either an <integer> or \"all\". Can be used more than one time to query multiple nodes. \"all\" queries all up nodes. 0 means query the local node. For \"cluster\" scoped keys, in any devid including 0 can be used.
        :param int end: Latest time (Unix epoch seconds) of interest. Negative times are interpreted as relative (before) now. If not supplied, use now as the end time.
        :param int interval: Minimum sampling interval time in seconds. If native statistics are higher resolution, data will be down-sampled.
        :param list[str] key: One key name. Can be used more than one time to query multiple keys. Also works with 'keys' arguments.
        :param list[str] keys: Multiple key names. Can be a comma separated list, or can be used more than one time to make queries for multiple keys. May be used in conjunction with 'substr'. Also works with 'key' arguments.
        :param bool memory_only: Only use statistics sources that reside in memory (faster, but with less retention).
        :param list[str] nodes: Specify node(s) for which statistics should be reported. One or more comma separated <integer(s)> specifying which node(s) to query, or \"all\". Specifying more than one node may have unspecified results for keys that begin with \"cluster\".
        :param bool raw: Causes the output to be in hex format. For internal use only, please do not use this.
        :param int resolution: Synonymous with 'interval', if supplied supersedes interval.
        :param bool show_nodes: Shows the logical node number or LNN in addition to the devid.
        :param bool stale: For internal use only, please do not use this.
        :param bool substr: Used in conjunction with the 'keys' argument, alters the behavior of keys. Makes the 'keys' arg perform a partial match. Defaults to false.
        :param int timeout: Time in seconds to wait for results from remote nodes.
        :param bool type_info: The type ID is used by internal services. For internal use only, please do not use this.
        :return: StatisticsHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_statistics_history_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_history_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_history_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_history  # noqa: E501

        Retrieve stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_history_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Earliest time (Unix epoch seconds) of interest. Negative times are interpreted as relative (before) now.
        :param bool degraded: If true, try to continue even if some stats are unavailable. In this case, errors will be present in the per-key returned data.
        :param list[str] devid: Node devid to query. Either an <integer> or \"all\". Can be used more than one time to query multiple nodes. \"all\" queries all up nodes. 0 means query the local node. For \"cluster\" scoped keys, in any devid including 0 can be used.
        :param int end: Latest time (Unix epoch seconds) of interest. Negative times are interpreted as relative (before) now. If not supplied, use now as the end time.
        :param int interval: Minimum sampling interval time in seconds. If native statistics are higher resolution, data will be down-sampled.
        :param list[str] key: One key name. Can be used more than one time to query multiple keys. Also works with 'keys' arguments.
        :param list[str] keys: Multiple key names. Can be a comma separated list, or can be used more than one time to make queries for multiple keys. May be used in conjunction with 'substr'. Also works with 'key' arguments.
        :param bool memory_only: Only use statistics sources that reside in memory (faster, but with less retention).
        :param list[str] nodes: Specify node(s) for which statistics should be reported. One or more comma separated <integer(s)> specifying which node(s) to query, or \"all\". Specifying more than one node may have unspecified results for keys that begin with \"cluster\".
        :param bool raw: Causes the output to be in hex format. For internal use only, please do not use this.
        :param int resolution: Synonymous with 'interval', if supplied supersedes interval.
        :param bool show_nodes: Shows the logical node number or LNN in addition to the devid.
        :param bool stale: For internal use only, please do not use this.
        :param bool substr: Used in conjunction with the 'keys' argument, alters the behavior of keys. Makes the 'keys' arg perform a partial match. Defaults to false.
        :param int timeout: Time in seconds to wait for results from remote nodes.
        :param bool type_info: The type ID is used by internal services. For internal use only, please do not use this.
        :return: StatisticsHistory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'degraded', 'devid', 'end', 'interval', 'key', 'keys', 'memory_only', 'nodes', 'raw', 'resolution', 'show_nodes', 'stale', 'substr', 'timeout', 'type_info']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_history" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'devid' in params:
            query_params.append(('devid', params['devid']))  # noqa: E501
            collection_formats['devid'] = 'csv'  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
            collection_formats['key'] = 'csv'  # noqa: E501
        if 'keys' in params:
            query_params.append(('keys', params['keys']))  # noqa: E501
            collection_formats['keys'] = 'csv'  # noqa: E501
        if 'memory_only' in params:
            query_params.append(('memory_only', params['memory_only']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
            collection_formats['nodes'] = 'csv'  # noqa: E501
        if 'raw' in params:
            query_params.append(('raw', params['raw']))  # noqa: E501
        if 'resolution' in params:
            query_params.append(('resolution', params['resolution']))  # noqa: E501
        if 'show_nodes' in params:
            query_params.append(('show_nodes', params['show_nodes']))  # noqa: E501
        if 'stale' in params:
            query_params.append(('stale', params['stale']))  # noqa: E501
        if 'substr' in params:
            query_params.append(('substr', params['substr']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'type_info' in params:
            query_params.append(('type_info', params['type_info']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsHistory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_key(self, statistics_key_id, **kwargs):  # noqa: E501
        """get_statistics_key  # noqa: E501

        List key meta-data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_key(statistics_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str statistics_key_id: List key meta-data. (required)
        :return: StatisticsKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_statistics_key_with_http_info(statistics_key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_key_with_http_info(statistics_key_id, **kwargs)  # noqa: E501
            return data

    def get_statistics_key_with_http_info(self, statistics_key_id, **kwargs):  # noqa: E501
        """get_statistics_key  # noqa: E501

        List key meta-data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_key_with_http_info(statistics_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str statistics_key_id: List key meta-data. (required)
        :return: StatisticsKeys
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['statistics_key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'statistics_key_id' is set
        if ('statistics_key_id' not in params or
                params['statistics_key_id'] is None):
            raise ValueError("Missing the required parameter `statistics_key_id` when calling `get_statistics_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'statistics_key_id' in params:
            path_params['StatisticsKeyId'] = params['statistics_key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/keys/{StatisticsKeyId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsKeys',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_keys(self, **kwargs):  # noqa: E501
        """get_statistics_keys  # noqa: E501

        List meta-data for matching keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_keys(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool count: Only count matching keys, do not return meta-data.
        :param int limit: Return no more than this many results at once (see resume).
        :param bool queryable: Only list keys that can/cannot be queries. Default is true.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: StatisticsKeysExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_statistics_keys_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_keys_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_keys_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_keys  # noqa: E501

        List meta-data for matching keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_keys_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool count: Only count matching keys, do not return meta-data.
        :param int limit: Return no more than this many results at once (see resume).
        :param bool queryable: Only list keys that can/cannot be queries. Default is true.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: StatisticsKeysExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['count', 'limit', 'queryable', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_keys" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_statistics_keys`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_statistics_keys`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_statistics_keys`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_statistics_keys`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'count' in params:
            query_params.append(('count', params['count']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'queryable' in params:
            query_params.append(('queryable', params['queryable']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsKeysExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_operations(self, **kwargs):  # noqa: E501
        """get_statistics_operations  # noqa: E501

        Retrieve operations list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_operations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] protocols: A comma separated list. Only report operations for specified protocol(s). Default is all. 
        :return: StatisticsOperations
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_statistics_operations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_operations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_operations_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_operations  # noqa: E501

        Retrieve operations list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_operations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] protocols: A comma separated list. Only report operations for specified protocol(s). Default is all. 
        :return: StatisticsOperations
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['protocols']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_operations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'protocols' in params:
            query_params.append(('protocols', params['protocols']))  # noqa: E501
            collection_formats['protocols'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/operations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsOperations',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_statistics_protocols(self, **kwargs):  # noqa: E501
        """get_statistics_protocols  # noqa: E501

        Retrieve protocol list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_protocols(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: Specifies whether internal, external, or all protocols should be returned.
        :return: StatisticsProtocols
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_statistics_protocols_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_statistics_protocols_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_statistics_protocols_with_http_info(self, **kwargs):  # noqa: E501
        """get_statistics_protocols  # noqa: E501

        Retrieve protocol list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_statistics_protocols_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: Specifies whether internal, external, or all protocols should be returned.
        :return: StatisticsProtocols
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_statistics_protocols" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/1/statistics/protocols', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StatisticsProtocols',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_client(self, **kwargs):  # noqa: E501
        """get_summary_client  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_client(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str classes: A comma separated list. Default is all. (other | write | read | namespace_read | namespace_write)
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str local_addresses: A comma separated list. Only report statistics for operations handled by the local hosts with dotted-quad IP addresses enumerated. 
        :param str local_names: A comma separated list. Only report statistics for operations handled by the local hosts with resolved names enumerated. 
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param bool numeric: Do not resolve hostnames and usernames to their human readable form(s). Default is false. 
        :param str protocols: A comma separated list. Default is all. (nfs3 | smb1 | nlm | ftp | http | siq | smb2 | nfs4 | papi | jobd | irp | lsass_in | lsass_out | hdfs | s3 | internal | external)
        :param str remote_addresses: A comma separated list. Only report statistics for operations requested by the remote clients with dotted-quad IP addresses enumerated. 
        :param str remote_names: A comma separated list. Only report statistics for operations requested by the remote clients with resolved names enumerated. 
        :param str sort: Sort data by the specified comma-separated field(s). (num_operations | operation_rate | in_max | in_min | in | in_avg | out_max | out_min | out | out_avg | time_max | time_min | time_avg | node | protocol | class | user_id | user_name | local_addr | local_name | remote_addr | remote_name) Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str totalby: A comma separated list specifying what should be unique. (node | protocol | class | local_addr | local_name | remote_addr | remote_name | user_id | user_name | devid). Aggregation is performed over all the fields not specified in the list.
        :param str user_ids: A comma separated list. Only report statistics for operations requested by users with numeric UIDs enumerated. 
        :param str user_names: A comma separated list. Only report statistics for operations requested by users with resolved names enumerated. 
        :return: SummaryClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_summary_client_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_client_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_client_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_client  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_client_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str classes: A comma separated list. Default is all. (other | write | read | namespace_read | namespace_write)
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str local_addresses: A comma separated list. Only report statistics for operations handled by the local hosts with dotted-quad IP addresses enumerated. 
        :param str local_names: A comma separated list. Only report statistics for operations handled by the local hosts with resolved names enumerated. 
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param bool numeric: Do not resolve hostnames and usernames to their human readable form(s). Default is false. 
        :param str protocols: A comma separated list. Default is all. (nfs3 | smb1 | nlm | ftp | http | siq | smb2 | nfs4 | papi | jobd | irp | lsass_in | lsass_out | hdfs | s3 | internal | external)
        :param str remote_addresses: A comma separated list. Only report statistics for operations requested by the remote clients with dotted-quad IP addresses enumerated. 
        :param str remote_names: A comma separated list. Only report statistics for operations requested by the remote clients with resolved names enumerated. 
        :param str sort: Sort data by the specified comma-separated field(s). (num_operations | operation_rate | in_max | in_min | in | in_avg | out_max | out_min | out | out_avg | time_max | time_min | time_avg | node | protocol | class | user_id | user_name | local_addr | local_name | remote_addr | remote_name) Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str totalby: A comma separated list specifying what should be unique. (node | protocol | class | local_addr | local_name | remote_addr | remote_name | user_id | user_name | devid). Aggregation is performed over all the fields not specified in the list.
        :param str user_ids: A comma separated list. Only report statistics for operations requested by users with numeric UIDs enumerated. 
        :param str user_names: A comma separated list. Only report statistics for operations requested by users with resolved names enumerated. 
        :return: SummaryClient
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['classes', 'degraded', 'local_addresses', 'local_names', 'nodes', 'numeric', 'protocols', 'remote_addresses', 'remote_names', 'sort', 'timeout', 'totalby', 'user_ids', 'user_names']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_client" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'classes' in params:
            query_params.append(('classes', params['classes']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'local_addresses' in params:
            query_params.append(('local_addresses', params['local_addresses']))  # noqa: E501
        if 'local_names' in params:
            query_params.append(('local_names', params['local_names']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'numeric' in params:
            query_params.append(('numeric', params['numeric']))  # noqa: E501
        if 'protocols' in params:
            query_params.append(('protocols', params['protocols']))  # noqa: E501
        if 'remote_addresses' in params:
            query_params.append(('remote_addresses', params['remote_addresses']))  # noqa: E501
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'totalby' in params:
            query_params.append(('totalby', params['totalby']))  # noqa: E501
        if 'user_ids' in params:
            query_params.append(('user_ids', params['user_ids']))  # noqa: E501
        if 'user_names' in params:
            query_params.append(('user_names', params['user_names']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/client', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_drive(self, **kwargs):  # noqa: E501
        """get_summary_drive  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_drive(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param str sort: Sort data by the specified comma-separated field(s). (drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str type: Specify drive type(s) for which statistics should be reported.
        :return: SummaryDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_summary_drive_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_drive_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_drive_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_drive  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_drive_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param str sort: Sort data by the specified comma-separated field(s). (drive_id | type | xfers_in | bytes_in | xfer_size_in | xfers_out | bytes_out | xfer_size_out | access_latency | access_slow | iosched_latency | iosched_queue | busy | used_bytes_percent | used_inodes). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str type: Specify drive type(s) for which statistics should be reported.
        :return: SummaryDrive
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['degraded', 'nodes', 'sort', 'timeout', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_drive" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/drive', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryDrive',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_heat(self, **kwargs):  # noqa: E501
        """get_summary_heat  # noqa: E501

        File heat map, i.e. rate of file operations, and the type of operation listed by path/lin(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_heat(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str classes: A comma separated list. Default is all. (other | write | read | namespace_read | namespace_write).
        :param bool convertlin: Convert lin to hex. Default is true. 
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str events: A comma separated list. Default is all. Only report specified event types(s). (blocked | contended | deadlocked | getattr | link | lock | lookup | read | rename | setattr | unlink | write).
        :param int maxpath: Maximum bytes allocated for looking up a path. An ASCII character is 1 byte (It may be more for other types of encoding). The default is 1024 bytes. Zero (0) means unlimited (Subject to the system limits.)
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param bool numeric: Do not resolve LINs into filenames. Default is false. 
        :param int pathdepth: Squash paths to this directory depth. Defaults to none, ie. the paths are not limited (Subject to the system limits.)
        :param str sort: Sort data by the specified comma-separated field(s). (operation_rate | node | event_name | class_name | lin | path). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str totalby: A comma separated list specifying what should be unique. (node | event_name | event_class | operation_rate | path | lin). Aggregation is performed over all the fields not specified in the list.
        :return: SummaryHeat
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_summary_heat_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_heat_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_heat_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_heat  # noqa: E501

        File heat map, i.e. rate of file operations, and the type of operation listed by path/lin(s).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_heat_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str classes: A comma separated list. Default is all. (other | write | read | namespace_read | namespace_write).
        :param bool convertlin: Convert lin to hex. Default is true. 
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str events: A comma separated list. Default is all. Only report specified event types(s). (blocked | contended | deadlocked | getattr | link | lock | lookup | read | rename | setattr | unlink | write).
        :param int maxpath: Maximum bytes allocated for looking up a path. An ASCII character is 1 byte (It may be more for other types of encoding). The default is 1024 bytes. Zero (0) means unlimited (Subject to the system limits.)
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param bool numeric: Do not resolve LINs into filenames. Default is false. 
        :param int pathdepth: Squash paths to this directory depth. Defaults to none, ie. the paths are not limited (Subject to the system limits.)
        :param str sort: Sort data by the specified comma-separated field(s). (operation_rate | node | event_name | class_name | lin | path). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str totalby: A comma separated list specifying what should be unique. (node | event_name | event_class | operation_rate | path | lin). Aggregation is performed over all the fields not specified in the list.
        :return: SummaryHeat
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['classes', 'convertlin', 'degraded', 'events', 'maxpath', 'nodes', 'numeric', 'pathdepth', 'sort', 'timeout', 'totalby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_heat" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'classes' in params:
            query_params.append(('classes', params['classes']))  # noqa: E501
        if 'convertlin' in params:
            query_params.append(('convertlin', params['convertlin']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'events' in params:
            query_params.append(('events', params['events']))  # noqa: E501
        if 'maxpath' in params:
            query_params.append(('maxpath', params['maxpath']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'numeric' in params:
            query_params.append(('numeric', params['numeric']))  # noqa: E501
        if 'pathdepth' in params:
            query_params.append(('pathdepth', params['pathdepth']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'totalby' in params:
            query_params.append(('totalby', params['totalby']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/heat', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryHeat',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_protocol(self, **kwargs):  # noqa: E501
        """get_summary_protocol  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_protocol(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str classes: A comma separated list. Default is all. (other | write | read | create | delete | namespace_read | namespace_write | file_state | session_state).
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param str operations: Specify operation(s) for which statistics should be reported (See the cli command: 'isi statistics list operations', for a total list). Default is all. 
        :param str protocols: A comma separated list. Default is all external protocols. (nfs3 | smb1 | nlm | ftp | http | siq | smb2 | nfs4 | papi | jobd | irp | lsass_in | lsass_out | hdfs | s3 | all | internal | external)
        :param str sort: Sort data by the specified comma-separated field(s). (time | operation_count | operation_rate | in_max | in_min | in | in_avg | in_standard_dev | out_max | out_min | out | out_avg | out_standard_dev | time_max | time_min | time_avg | time_standard_dev | node | protocol | class | operation). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str totalby: A comma separated list specifying what should be unique. (node | protocol | class | operation). Aggregation is performed over all the fields not specified in the list.
        :param bool zero: Show table entries with no values.
        :return: SummaryProtocol
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_summary_protocol_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_protocol_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_protocol_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_protocol  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_protocol_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str classes: A comma separated list. Default is all. (other | write | read | create | delete | namespace_read | namespace_write | file_state | session_state).
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param str operations: Specify operation(s) for which statistics should be reported (See the cli command: 'isi statistics list operations', for a total list). Default is all. 
        :param str protocols: A comma separated list. Default is all external protocols. (nfs3 | smb1 | nlm | ftp | http | siq | smb2 | nfs4 | papi | jobd | irp | lsass_in | lsass_out | hdfs | s3 | all | internal | external)
        :param str sort: Sort data by the specified comma-separated field(s). (time | operation_count | operation_rate | in_max | in_min | in | in_avg | in_standard_dev | out_max | out_min | out | out_avg | out_standard_dev | time_max | time_min | time_avg | time_standard_dev | node | protocol | class | operation). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str totalby: A comma separated list specifying what should be unique. (node | protocol | class | operation). Aggregation is performed over all the fields not specified in the list.
        :param bool zero: Show table entries with no values.
        :return: SummaryProtocol
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['classes', 'degraded', 'nodes', 'operations', 'protocols', 'sort', 'timeout', 'totalby', 'zero']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_protocol" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'classes' in params:
            query_params.append(('classes', params['classes']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'operations' in params:
            query_params.append(('operations', params['operations']))  # noqa: E501
        if 'protocols' in params:
            query_params.append(('protocols', params['protocols']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'totalby' in params:
            query_params.append(('totalby', params['totalby']))  # noqa: E501
        if 'zero' in params:
            query_params.append(('zero', params['zero']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/protocol', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryProtocol',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_protocol_stats(self, **kwargs):  # noqa: E501
        """get_summary_protocol_stats  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_protocol_stats(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param str protocol: A single protocol. Default is nfs3. (nfs3 | smb1 | nlm | ftp | http | siq | smb2 | nfs4 | papi | jobd | irp | lsass_in | lsass_out | hdfs | s3)
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummaryProtocolStats
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_summary_protocol_stats_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_protocol_stats_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_protocol_stats_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_protocol_stats  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_protocol_stats_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param str protocol: A single protocol. Default is nfs3. (nfs3 | smb1 | nlm | ftp | http | siq | smb2 | nfs4 | papi | jobd | irp | lsass_in | lsass_out | hdfs | s3)
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummaryProtocolStats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['degraded', 'nodes', 'protocol', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_protocol_stats" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'protocol' in params:
            query_params.append(('protocol', params['protocol']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/protocol-stats', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryProtocolStats',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_system(self, **kwargs):  # noqa: E501
        """get_summary_system  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_system(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param bool oprates: Display protocol operation rate statistics rather than the default throughput statistics.
        :param str sort: Sort data by the specified comma-separated field(s). (time | node | cpu | smb | ftp | http | nfs | hdfs | s3 | total | net_in | net_out | disk_in). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummarySystem
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_summary_system_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_system_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_system_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_system  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_system_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param bool oprates: Display protocol operation rate statistics rather than the default throughput statistics.
        :param str sort: Sort data by the specified comma-separated field(s). (time | node | cpu | smb | ftp | http | nfs | hdfs | s3 | total | net_in | net_out | disk_in). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :return: SummarySystem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['degraded', 'nodes', 'oprates', 'sort', 'timeout']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_system" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'oprates' in params:
            query_params.append(('oprates', params['oprates']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/statistics/summary/system', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummarySystem',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_summary_workload(self, **kwargs):  # noqa: E501
        """get_summary_workload  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_workload(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: Report workload performance metrics for specified dataset. Default is 'System'.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str domain_ids: A comma separated list. Only report statistics for domains specified by id, if configured. 
        :param str export_ids: A comma separated list. Only report statistics for exports specified by id, if configured. 
        :param str group_ids: A comma separated list. Only report statistics for groups specified by numeric GIDs, if configured. 
        :param str group_sids: A comma separated list. Only report statistics for groups specified by Group Security IDs, if configured. 
        :param str groupnames: A comma separated list. Only report statistics for groups specified by resolved names, if configured. 
        :param list[str] job_types: A comma separated list. Only report statistics for job(s) specified by type, if configured. 
        :param str local_addresses: A comma separated list. Only report statistics for local hosts specified by IP addresses, if configured. 
        :param str local_names: A comma separated list. Only report statistics for local hosts specified by resolved names, if configured. 
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param bool numeric: Do not resolve addresses and usernames to their human readable form(s). Default is false. 
        :param str paths: A comma separated list. Only report statistics for paths specified by name, if configured. 
        :param str protocols: A comma separated list. Default is all. (smb1, smb2, nfs3, nfs4 and s3 only at this time.)
        :param str remote_addresses: A comma separated list. Only report statistics for remote clients specified by IP addresses, if configured. 
        :param str remote_names: A comma separated list. Only report statistics for remote clients specified by resolved names, if configured. 
        :param str share_names: A comma separated list. Only report statistics for shares specified by name, if configured. 
        :param str sort: Sort data by the specified comma-separated field(s). ( node | workload_id | system_name | user_id | user_sid | username | group_id | group_sid | groupname | domain_id | path | zone_id | zone_name | export_id | local_addr | local_name | remote_addr | remote_name | protocol | share_name | job_type | cpu | bytes_in | bytes_out | ops | reads | writes | l2 | l3 | latency_read | latency_write | latency_other | error). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param str system_names: A comma separated list. Only report statistics for systems specified by resolved names, if configured. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str totalby: A comma separated list specifying what should be unique. (node | system_name | user_id | user_sid | username | zone_id | zone_name | local_addr | local_name | remote_addr | remote_name | group_id | group_sid | groupname | domain_id | path | export_id | protocol | share_name | job_type). Aggregation is performed over all the fields not specified in the list.
        :param str user_ids: A comma separated list. Only report statistics for users specified by numeric UIDs, if configured. 
        :param str user_sids: A comma separated list. Only report statistics for users specified by Security IDs, if configured. 
        :param str usernames: A comma separated list. Only report statistics for users specified by resolved names, if configured. 
        :param str zone_ids: A comma separated list. Only report statistics for users in zone specified by id, if configured. 
        :param str zone_names: A comma separated list. Only report statistics for users in zone specified by name, if configured. 
        :return: SummaryWorkload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_summary_workload_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_summary_workload_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_summary_workload_with_http_info(self, **kwargs):  # noqa: E501
        """get_summary_workload  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_summary_workload_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset: Report workload performance metrics for specified dataset. Default is 'System'.
        :param bool degraded: Continue to report if some nodes do not respond.
        :param str domain_ids: A comma separated list. Only report statistics for domains specified by id, if configured. 
        :param str export_ids: A comma separated list. Only report statistics for exports specified by id, if configured. 
        :param str group_ids: A comma separated list. Only report statistics for groups specified by numeric GIDs, if configured. 
        :param str group_sids: A comma separated list. Only report statistics for groups specified by Group Security IDs, if configured. 
        :param str groupnames: A comma separated list. Only report statistics for groups specified by resolved names, if configured. 
        :param list[str] job_types: A comma separated list. Only report statistics for job(s) specified by type, if configured. 
        :param str local_addresses: A comma separated list. Only report statistics for local hosts specified by IP addresses, if configured. 
        :param str local_names: A comma separated list. Only report statistics for local hosts specified by resolved names, if configured. 
        :param str nodes: A comma separated list. Specify node(s) for which statistics should be reported. Default is all. Zero (0) should be passed in as the sole argument to indicate local.
        :param bool numeric: Do not resolve addresses and usernames to their human readable form(s). Default is false. 
        :param str paths: A comma separated list. Only report statistics for paths specified by name, if configured. 
        :param str protocols: A comma separated list. Default is all. (smb1, smb2, nfs3, nfs4 and s3 only at this time.)
        :param str remote_addresses: A comma separated list. Only report statistics for remote clients specified by IP addresses, if configured. 
        :param str remote_names: A comma separated list. Only report statistics for remote clients specified by resolved names, if configured. 
        :param str share_names: A comma separated list. Only report statistics for shares specified by name, if configured. 
        :param str sort: Sort data by the specified comma-separated field(s). ( node | workload_id | system_name | user_id | user_sid | username | group_id | group_sid | groupname | domain_id | path | zone_id | zone_name | export_id | local_addr | local_name | remote_addr | remote_name | protocol | share_name | job_type | cpu | bytes_in | bytes_out | ops | reads | writes | l2 | l3 | latency_read | latency_write | latency_other | error). Prepend 'asc:' or 'desc:' to a field to change the sort direction. 
        :param str system_names: A comma separated list. Only report statistics for systems specified by resolved names, if configured. 
        :param int timeout: Timeout remote commands after NUM seconds, where NUM is the integer passed to the argument.
        :param str totalby: A comma separated list specifying what should be unique. (node | system_name | user_id | user_sid | username | zone_id | zone_name | local_addr | local_name | remote_addr | remote_name | group_id | group_sid | groupname | domain_id | path | export_id | protocol | share_name | job_type). Aggregation is performed over all the fields not specified in the list.
        :param str user_ids: A comma separated list. Only report statistics for users specified by numeric UIDs, if configured. 
        :param str user_sids: A comma separated list. Only report statistics for users specified by Security IDs, if configured. 
        :param str usernames: A comma separated list. Only report statistics for users specified by resolved names, if configured. 
        :param str zone_ids: A comma separated list. Only report statistics for users in zone specified by id, if configured. 
        :param str zone_names: A comma separated list. Only report statistics for users in zone specified by name, if configured. 
        :return: SummaryWorkload
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset', 'degraded', 'domain_ids', 'export_ids', 'group_ids', 'group_sids', 'groupnames', 'job_types', 'local_addresses', 'local_names', 'nodes', 'numeric', 'paths', 'protocols', 'remote_addresses', 'remote_names', 'share_names', 'sort', 'system_names', 'timeout', 'totalby', 'user_ids', 'user_sids', 'usernames', 'zone_ids', 'zone_names']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_summary_workload" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dataset' in params:
            query_params.append(('dataset', params['dataset']))  # noqa: E501
        if 'degraded' in params:
            query_params.append(('degraded', params['degraded']))  # noqa: E501
        if 'domain_ids' in params:
            query_params.append(('domain_ids', params['domain_ids']))  # noqa: E501
        if 'export_ids' in params:
            query_params.append(('export_ids', params['export_ids']))  # noqa: E501
        if 'group_ids' in params:
            query_params.append(('group_ids', params['group_ids']))  # noqa: E501
        if 'group_sids' in params:
            query_params.append(('group_sids', params['group_sids']))  # noqa: E501
        if 'groupnames' in params:
            query_params.append(('groupnames', params['groupnames']))  # noqa: E501
        if 'job_types' in params:
            query_params.append(('job_types', params['job_types']))  # noqa: E501
            collection_formats['job_types'] = 'csv'  # noqa: E501
        if 'local_addresses' in params:
            query_params.append(('local_addresses', params['local_addresses']))  # noqa: E501
        if 'local_names' in params:
            query_params.append(('local_names', params['local_names']))  # noqa: E501
        if 'nodes' in params:
            query_params.append(('nodes', params['nodes']))  # noqa: E501
        if 'numeric' in params:
            query_params.append(('numeric', params['numeric']))  # noqa: E501
        if 'paths' in params:
            query_params.append(('paths', params['paths']))  # noqa: E501
        if 'protocols' in params:
            query_params.append(('protocols', params['protocols']))  # noqa: E501
        if 'remote_addresses' in params:
            query_params.append(('remote_addresses', params['remote_addresses']))  # noqa: E501
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))  # noqa: E501
        if 'share_names' in params:
            query_params.append(('share_names', params['share_names']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'system_names' in params:
            query_params.append(('system_names', params['system_names']))  # noqa: E501
        if 'timeout' in params:
            query_params.append(('timeout', params['timeout']))  # noqa: E501
        if 'totalby' in params:
            query_params.append(('totalby', params['totalby']))  # noqa: E501
        if 'user_ids' in params:
            query_params.append(('user_ids', params['user_ids']))  # noqa: E501
        if 'user_sids' in params:
            query_params.append(('user_sids', params['user_sids']))  # noqa: E501
        if 'usernames' in params:
            query_params.append(('usernames', params['usernames']))  # noqa: E501
        if 'zone_ids' in params:
            query_params.append(('zone_ids', params['zone_ids']))  # noqa: E501
        if 'zone_names' in params:
            query_params.append(('zone_names', params['zone_names']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/statistics/summary/workload', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SummaryWorkload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
