# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 11
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_1_0.api_client import ApiClient


class IpmiApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_config_feature(self, config_feature_id, **kwargs):  # noqa: E501
        """get_config_feature  # noqa: E501

        Retrieve the Remote IPMI Management feature configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_feature(config_feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str config_feature_id: Retrieve the Remote IPMI Management feature configuration. (required)
        :return: ConfigFeatures
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_feature_with_http_info(config_feature_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_config_feature_with_http_info(config_feature_id, **kwargs)  # noqa: E501
            return data

    def get_config_feature_with_http_info(self, config_feature_id, **kwargs):  # noqa: E501
        """get_config_feature  # noqa: E501

        Retrieve the Remote IPMI Management feature configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_feature_with_http_info(config_feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str config_feature_id: Retrieve the Remote IPMI Management feature configuration. (required)
        :return: ConfigFeatures
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_feature_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_feature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_feature_id' is set
        if ('config_feature_id' not in params or
                params['config_feature_id'] is None):
            raise ValueError("Missing the required parameter `config_feature_id` when calling `get_config_feature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_feature_id' in params:
            path_params['ConfigFeatureId'] = params['config_feature_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/features/{ConfigFeatureId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigFeatures',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config_features(self, **kwargs):  # noqa: E501
        """get_config_features  # noqa: E501

        Get detailed information for all remote IPMI features.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_features(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigFeaturesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_features_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_config_features_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_config_features_with_http_info(self, **kwargs):  # noqa: E501
        """get_config_features  # noqa: E501

        Get detailed information for all remote IPMI features.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_features_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigFeaturesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_features" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/features', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigFeaturesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config_network(self, **kwargs):  # noqa: E501
        """get_config_network  # noqa: E501

        Retrieve the Remote IPMI Management static network configuration settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_network(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigNetwork
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_network_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_config_network_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_config_network_with_http_info(self, **kwargs):  # noqa: E501
        """get_config_network  # noqa: E501

        Retrieve the Remote IPMI Management static network configuration settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_network_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigNetwork
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_network" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/network', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigNetwork',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config_node(self, config_node_id, **kwargs):  # noqa: E501
        """get_config_node  # noqa: E501

        Retrieve the Remote IPMI Management node configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_node(config_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int config_node_id: Retrieve the Remote IPMI Management node configuration. (required)
        :return: ConfigNodes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_node_with_http_info(config_node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_config_node_with_http_info(config_node_id, **kwargs)  # noqa: E501
            return data

    def get_config_node_with_http_info(self, config_node_id, **kwargs):  # noqa: E501
        """get_config_node  # noqa: E501

        Retrieve the Remote IPMI Management node configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_node_with_http_info(config_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int config_node_id: Retrieve the Remote IPMI Management node configuration. (required)
        :return: ConfigNodes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_node_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_node_id' is set
        if ('config_node_id' not in params or
                params['config_node_id'] is None):
            raise ValueError("Missing the required parameter `config_node_id` when calling `get_config_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_node_id' in params:
            path_params['ConfigNodeId'] = params['config_node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/nodes/{ConfigNodeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigNodes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config_nodes(self, **kwargs):  # noqa: E501
        """get_config_nodes  # noqa: E501

        Retrieve the Remote IPMI Management nodes configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_nodes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigNodesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_nodes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_config_nodes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_config_nodes_with_http_info(self, **kwargs):  # noqa: E501
        """get_config_nodes  # noqa: E501

        Retrieve the Remote IPMI Management nodes configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_nodes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigNodesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_nodes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/nodes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigNodesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config_settings(self, **kwargs):  # noqa: E501
        """get_config_settings  # noqa: E501

        View the Remote IPMI Management configuration settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_config_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_config_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_config_settings  # noqa: E501

        View the Remote IPMI Management configuration settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config_user(self, **kwargs):  # noqa: E501
        """get_config_user  # noqa: E501

        View the Remote IPMI Management user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_config_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_config_user_with_http_info(self, **kwargs):  # noqa: E501
        """get_config_user  # noqa: E501

        View the Remote IPMI Management user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config_user" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/user', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_config_feature(self, config_feature, config_feature_id, **kwargs):  # noqa: E501
        """update_config_feature  # noqa: E501

        Modify remote IPMI Management feature settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_config_feature(config_feature, config_feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigFeature config_feature: (required)
        :param str config_feature_id: Modify remote IPMI Management feature settings (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_config_feature_with_http_info(config_feature, config_feature_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_config_feature_with_http_info(config_feature, config_feature_id, **kwargs)  # noqa: E501
            return data

    def update_config_feature_with_http_info(self, config_feature, config_feature_id, **kwargs):  # noqa: E501
        """update_config_feature  # noqa: E501

        Modify remote IPMI Management feature settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_config_feature_with_http_info(config_feature, config_feature_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigFeature config_feature: (required)
        :param str config_feature_id: Modify remote IPMI Management feature settings (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_feature', 'config_feature_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_config_feature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_feature' is set
        if ('config_feature' not in params or
                params['config_feature'] is None):
            raise ValueError("Missing the required parameter `config_feature` when calling `update_config_feature`")  # noqa: E501
        # verify the required parameter 'config_feature_id' is set
        if ('config_feature_id' not in params or
                params['config_feature_id'] is None):
            raise ValueError("Missing the required parameter `config_feature_id` when calling `update_config_feature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_feature_id' in params:
            path_params['ConfigFeatureId'] = params['config_feature_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_feature' in params:
            body_params = params['config_feature']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/features/{ConfigFeatureId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_config_network(self, config_network, **kwargs):  # noqa: E501
        """update_config_network  # noqa: E501

        Modify the remote IPMI Management static network configuration settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_config_network(config_network, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigNetworkExtended config_network: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_config_network_with_http_info(config_network, **kwargs)  # noqa: E501
        else:
            (data) = self.update_config_network_with_http_info(config_network, **kwargs)  # noqa: E501
            return data

    def update_config_network_with_http_info(self, config_network, **kwargs):  # noqa: E501
        """update_config_network  # noqa: E501

        Modify the remote IPMI Management static network configuration settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_config_network_with_http_info(config_network, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigNetworkExtended config_network: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_network']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_config_network" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_network' is set
        if ('config_network' not in params or
                params['config_network'] is None):
            raise ValueError("Missing the required parameter `config_network` when calling `update_config_network`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_network' in params:
            body_params = params['config_network']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/network', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_config_settings(self, config_settings, **kwargs):  # noqa: E501
        """update_config_settings  # noqa: E501

        Modify remote IPMI Management configuration settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_config_settings(config_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigSettingsSettings config_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_config_settings_with_http_info(config_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_config_settings_with_http_info(config_settings, **kwargs)  # noqa: E501
            return data

    def update_config_settings_with_http_info(self, config_settings, **kwargs):  # noqa: E501
        """update_config_settings  # noqa: E501

        Modify remote IPMI Management configuration settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_config_settings_with_http_info(config_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigSettingsSettings config_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_config_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_settings' is set
        if ('config_settings' not in params or
                params['config_settings'] is None):
            raise ValueError("Missing the required parameter `config_settings` when calling `update_config_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_settings' in params:
            body_params = params['config_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_config_user(self, config_user, **kwargs):  # noqa: E501
        """update_config_user  # noqa: E501

        Modify remote IPMI Management user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_config_user(config_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigUserUser config_user: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_config_user_with_http_info(config_user, **kwargs)  # noqa: E501
        else:
            (data) = self.update_config_user_with_http_info(config_user, **kwargs)  # noqa: E501
            return data

    def update_config_user_with_http_info(self, config_user, **kwargs):  # noqa: E501
        """update_config_user  # noqa: E501

        Modify remote IPMI Management user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_config_user_with_http_info(config_user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigUserUser config_user: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_user']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_config_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_user' is set
        if ('config_user' not in params or
                params['config_user'] is None):
            raise ValueError("Missing the required parameter `config_user` when calling `update_config_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config_user' in params:
            body_params = params['config_user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/10/ipmi/config/user', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
