# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 11
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_1_0.api_client import ApiClient


class AvscanApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_avscan_job(self, avscan_job, **kwargs):  # noqa: E501
        """create_avscan_job  # noqa: E501

        Create new antivirus jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_avscan_job(avscan_job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanJobCreateParams avscan_job: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_avscan_job_with_http_info(avscan_job, **kwargs)  # noqa: E501
        else:
            (data) = self.create_avscan_job_with_http_info(avscan_job, **kwargs)  # noqa: E501
            return data

    def create_avscan_job_with_http_info(self, avscan_job, **kwargs):  # noqa: E501
        """create_avscan_job  # noqa: E501

        Create new antivirus jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_avscan_job_with_http_info(avscan_job, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanJobCreateParams avscan_job: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_job']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_avscan_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_job' is set
        if ('avscan_job' not in params or
                params['avscan_job'] is None):
            raise ValueError("Missing the required parameter `avscan_job` when calling `create_avscan_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'avscan_job' in params:
            body_params = params['avscan_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/jobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_avscan_server(self, avscan_server, **kwargs):  # noqa: E501
        """create_avscan_server  # noqa: E501

        Create new antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_avscan_server(avscan_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanServerCreateParams avscan_server: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_avscan_server_with_http_info(avscan_server, **kwargs)  # noqa: E501
        else:
            (data) = self.create_avscan_server_with_http_info(avscan_server, **kwargs)  # noqa: E501
            return data

    def create_avscan_server_with_http_info(self, avscan_server, **kwargs):  # noqa: E501
        """create_avscan_server  # noqa: E501

        Create new antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_avscan_server_with_http_info(avscan_server, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanServerCreateParams avscan_server: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_server']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_avscan_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_server' is set
        if ('avscan_server' not in params or
                params['avscan_server'] is None):
            raise ValueError("Missing the required parameter `avscan_server` when calling `create_avscan_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'avscan_server' in params:
            body_params = params['avscan_server']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/servers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_avscan_job(self, avscan_job_id, **kwargs):  # noqa: E501
        """delete_avscan_job  # noqa: E501

        Delete an antivirus job entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_avscan_job(avscan_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str avscan_job_id: Delete an antivirus job entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_avscan_job_with_http_info(avscan_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_avscan_job_with_http_info(avscan_job_id, **kwargs)  # noqa: E501
            return data

    def delete_avscan_job_with_http_info(self, avscan_job_id, **kwargs):  # noqa: E501
        """delete_avscan_job  # noqa: E501

        Delete an antivirus job entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_avscan_job_with_http_info(avscan_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str avscan_job_id: Delete an antivirus job entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_avscan_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_job_id' is set
        if ('avscan_job_id' not in params or
                params['avscan_job_id'] is None):
            raise ValueError("Missing the required parameter `avscan_job_id` when calling `delete_avscan_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'avscan_job_id' in params:
            path_params['AvscanJobId'] = params['avscan_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/jobs/{AvscanJobId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_avscan_jobs(self, **kwargs):  # noqa: E501
        """delete_avscan_jobs  # noqa: E501

        Delete all antivirus jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_avscan_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_avscan_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_avscan_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_avscan_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """delete_avscan_jobs  # noqa: E501

        Delete all antivirus jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_avscan_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_avscan_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/jobs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_avscan_server(self, avscan_server_id, **kwargs):  # noqa: E501
        """delete_avscan_server  # noqa: E501

        Delete an antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_avscan_server(avscan_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str avscan_server_id: Delete an antivirus server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_avscan_server_with_http_info(avscan_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_avscan_server_with_http_info(avscan_server_id, **kwargs)  # noqa: E501
            return data

    def delete_avscan_server_with_http_info(self, avscan_server_id, **kwargs):  # noqa: E501
        """delete_avscan_server  # noqa: E501

        Delete an antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_avscan_server_with_http_info(avscan_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str avscan_server_id: Delete an antivirus server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_avscan_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_server_id' is set
        if ('avscan_server_id' not in params or
                params['avscan_server_id'] is None):
            raise ValueError("Missing the required parameter `avscan_server_id` when calling `delete_avscan_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'avscan_server_id' in params:
            path_params['AvscanServerId'] = params['avscan_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/servers/{AvscanServerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_avscan_servers(self, **kwargs):  # noqa: E501
        """delete_avscan_servers  # noqa: E501

        Delete all antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_avscan_servers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_avscan_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_avscan_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_avscan_servers_with_http_info(self, **kwargs):  # noqa: E501
        """delete_avscan_servers  # noqa: E501

        Delete all antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_avscan_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_avscan_servers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/servers', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_avscan_filter(self, avscan_filter_id, **kwargs):  # noqa: E501
        """get_avscan_filter  # noqa: E501

        Retrieve one antivirus filter setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_filter(avscan_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int avscan_filter_id: Retrieve one antivirus filter setting. (required)
        :return: AvscanFilters
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_avscan_filter_with_http_info(avscan_filter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_avscan_filter_with_http_info(avscan_filter_id, **kwargs)  # noqa: E501
            return data

    def get_avscan_filter_with_http_info(self, avscan_filter_id, **kwargs):  # noqa: E501
        """get_avscan_filter  # noqa: E501

        Retrieve one antivirus filter setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_filter_with_http_info(avscan_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int avscan_filter_id: Retrieve one antivirus filter setting. (required)
        :return: AvscanFilters
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_filter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_avscan_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_filter_id' is set
        if ('avscan_filter_id' not in params or
                params['avscan_filter_id'] is None):
            raise ValueError("Missing the required parameter `avscan_filter_id` when calling `get_avscan_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'avscan_filter_id' in params:
            path_params['AvscanFilterId'] = params['avscan_filter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/filters/{AvscanFilterId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvscanFilters',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_avscan_filters(self, **kwargs):  # noqa: E501
        """get_avscan_filters  # noqa: E501

        List Antivirus filters for zones.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_filters(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: AvscanFiltersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_avscan_filters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_avscan_filters_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_avscan_filters_with_http_info(self, **kwargs):  # noqa: E501
        """get_avscan_filters  # noqa: E501

        List Antivirus filters for zones.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_filters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: AvscanFiltersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_avscan_filters" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_avscan_filters`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_avscan_filters`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_avscan_filters`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_avscan_filters`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_avscan_filters`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_avscan_filters`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_avscan_filters`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/filters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvscanFiltersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_avscan_job(self, avscan_job_id, **kwargs):  # noqa: E501
        """get_avscan_job  # noqa: E501

        Retrieve one antivirus job entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_job(avscan_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str avscan_job_id: Retrieve one antivirus job entry. (required)
        :return: AvscanJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_avscan_job_with_http_info(avscan_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_avscan_job_with_http_info(avscan_job_id, **kwargs)  # noqa: E501
            return data

    def get_avscan_job_with_http_info(self, avscan_job_id, **kwargs):  # noqa: E501
        """get_avscan_job  # noqa: E501

        Retrieve one antivirus job entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_job_with_http_info(avscan_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str avscan_job_id: Retrieve one antivirus job entry. (required)
        :return: AvscanJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_avscan_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_job_id' is set
        if ('avscan_job_id' not in params or
                params['avscan_job_id'] is None):
            raise ValueError("Missing the required parameter `avscan_job_id` when calling `get_avscan_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'avscan_job_id' in params:
            path_params['AvscanJobId'] = params['avscan_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/jobs/{AvscanJobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvscanJobs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_avscan_server(self, avscan_server_id, **kwargs):  # noqa: E501
        """get_avscan_server  # noqa: E501

        Retrieve one antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_server(avscan_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str avscan_server_id: Retrieve one antivirus server entry. (required)
        :return: AvscanServers
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_avscan_server_with_http_info(avscan_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_avscan_server_with_http_info(avscan_server_id, **kwargs)  # noqa: E501
            return data

    def get_avscan_server_with_http_info(self, avscan_server_id, **kwargs):  # noqa: E501
        """get_avscan_server  # noqa: E501

        Retrieve one antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_server_with_http_info(avscan_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str avscan_server_id: Retrieve one antivirus server entry. (required)
        :return: AvscanServers
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_avscan_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_server_id' is set
        if ('avscan_server_id' not in params or
                params['avscan_server_id'] is None):
            raise ValueError("Missing the required parameter `avscan_server_id` when calling `get_avscan_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'avscan_server_id' in params:
            path_params['AvscanServerId'] = params['avscan_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/servers/{AvscanServerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvscanServers',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_avscan_settings(self, **kwargs):  # noqa: E501
        """get_avscan_settings  # noqa: E501

        View Antivirus settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AvscanSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_avscan_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_avscan_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_avscan_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_avscan_settings  # noqa: E501

        View Antivirus settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_avscan_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AvscanSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_avscan_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvscanSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_avscan_jobs(self, **kwargs):  # noqa: E501
        """list_avscan_jobs  # noqa: E501

        List Antivirus jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_avscan_jobs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: AvscanJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_avscan_jobs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_avscan_jobs_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_avscan_jobs_with_http_info(self, **kwargs):  # noqa: E501
        """list_avscan_jobs  # noqa: E501

        List Antivirus jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_avscan_jobs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: AvscanJobsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_avscan_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_avscan_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_avscan_jobs`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_avscan_jobs`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_avscan_jobs`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_avscan_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_avscan_jobs`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_avscan_jobs`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/jobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvscanJobsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_avscan_servers(self, **kwargs):  # noqa: E501
        """list_avscan_servers  # noqa: E501

        List Antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_avscan_servers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: AvscanServersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_avscan_servers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_avscan_servers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_avscan_servers_with_http_info(self, **kwargs):  # noqa: E501
        """list_avscan_servers  # noqa: E501

        List Antivirus servers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_avscan_servers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: AvscanServersExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_avscan_servers" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_avscan_servers`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_avscan_servers`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_avscan_servers`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_avscan_servers`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_avscan_servers`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_avscan_servers`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_avscan_servers`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/servers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvscanServersExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_avscan_filter(self, avscan_filter, avscan_filter_id, **kwargs):  # noqa: E501
        """update_avscan_filter  # noqa: E501

        Modify an antivirus filter setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_avscan_filter(avscan_filter, avscan_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanFilter avscan_filter: (required)
        :param int avscan_filter_id: Modify an antivirus filter setting. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_avscan_filter_with_http_info(avscan_filter, avscan_filter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_avscan_filter_with_http_info(avscan_filter, avscan_filter_id, **kwargs)  # noqa: E501
            return data

    def update_avscan_filter_with_http_info(self, avscan_filter, avscan_filter_id, **kwargs):  # noqa: E501
        """update_avscan_filter  # noqa: E501

        Modify an antivirus filter setting.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_avscan_filter_with_http_info(avscan_filter, avscan_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanFilter avscan_filter: (required)
        :param int avscan_filter_id: Modify an antivirus filter setting. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_filter', 'avscan_filter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_avscan_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_filter' is set
        if ('avscan_filter' not in params or
                params['avscan_filter'] is None):
            raise ValueError("Missing the required parameter `avscan_filter` when calling `update_avscan_filter`")  # noqa: E501
        # verify the required parameter 'avscan_filter_id' is set
        if ('avscan_filter_id' not in params or
                params['avscan_filter_id'] is None):
            raise ValueError("Missing the required parameter `avscan_filter_id` when calling `update_avscan_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'avscan_filter_id' in params:
            path_params['AvscanFilterId'] = params['avscan_filter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'avscan_filter' in params:
            body_params = params['avscan_filter']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/filters/{AvscanFilterId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_avscan_job(self, avscan_job, avscan_job_id, **kwargs):  # noqa: E501
        """update_avscan_job  # noqa: E501

        Modify an antivirus job entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_avscan_job(avscan_job, avscan_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanJob avscan_job: (required)
        :param str avscan_job_id: Modify an antivirus job entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_avscan_job_with_http_info(avscan_job, avscan_job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_avscan_job_with_http_info(avscan_job, avscan_job_id, **kwargs)  # noqa: E501
            return data

    def update_avscan_job_with_http_info(self, avscan_job, avscan_job_id, **kwargs):  # noqa: E501
        """update_avscan_job  # noqa: E501

        Modify an antivirus job entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_avscan_job_with_http_info(avscan_job, avscan_job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanJob avscan_job: (required)
        :param str avscan_job_id: Modify an antivirus job entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_job', 'avscan_job_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_avscan_job" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_job' is set
        if ('avscan_job' not in params or
                params['avscan_job'] is None):
            raise ValueError("Missing the required parameter `avscan_job` when calling `update_avscan_job`")  # noqa: E501
        # verify the required parameter 'avscan_job_id' is set
        if ('avscan_job_id' not in params or
                params['avscan_job_id'] is None):
            raise ValueError("Missing the required parameter `avscan_job_id` when calling `update_avscan_job`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'avscan_job_id' in params:
            path_params['AvscanJobId'] = params['avscan_job_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'avscan_job' in params:
            body_params = params['avscan_job']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/jobs/{AvscanJobId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_avscan_server(self, avscan_server, avscan_server_id, **kwargs):  # noqa: E501
        """update_avscan_server  # noqa: E501

        Modify an antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_avscan_server(avscan_server, avscan_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanServer avscan_server: (required)
        :param str avscan_server_id: Modify an antivirus server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_avscan_server_with_http_info(avscan_server, avscan_server_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_avscan_server_with_http_info(avscan_server, avscan_server_id, **kwargs)  # noqa: E501
            return data

    def update_avscan_server_with_http_info(self, avscan_server, avscan_server_id, **kwargs):  # noqa: E501
        """update_avscan_server  # noqa: E501

        Modify an antivirus server entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_avscan_server_with_http_info(avscan_server, avscan_server_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanServer avscan_server: (required)
        :param str avscan_server_id: Modify an antivirus server entry. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_server', 'avscan_server_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_avscan_server" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_server' is set
        if ('avscan_server' not in params or
                params['avscan_server'] is None):
            raise ValueError("Missing the required parameter `avscan_server` when calling `update_avscan_server`")  # noqa: E501
        # verify the required parameter 'avscan_server_id' is set
        if ('avscan_server_id' not in params or
                params['avscan_server_id'] is None):
            raise ValueError("Missing the required parameter `avscan_server_id` when calling `update_avscan_server`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'avscan_server_id' in params:
            path_params['AvscanServerId'] = params['avscan_server_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'avscan_server' in params:
            body_params = params['avscan_server']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/servers/{AvscanServerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_avscan_settings(self, avscan_settings, **kwargs):  # noqa: E501
        """update_avscan_settings  # noqa: E501

        Modify Antivirus settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_avscan_settings(avscan_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanSettingsSettings avscan_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_avscan_settings_with_http_info(avscan_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_avscan_settings_with_http_info(avscan_settings, **kwargs)  # noqa: E501
            return data

    def update_avscan_settings_with_http_info(self, avscan_settings, **kwargs):  # noqa: E501
        """update_avscan_settings  # noqa: E501

        Modify Antivirus settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_avscan_settings_with_http_info(avscan_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AvscanSettingsSettings avscan_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['avscan_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_avscan_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'avscan_settings' is set
        if ('avscan_settings' not in params or
                params['avscan_settings'] is None):
            raise ValueError("Missing the required parameter `avscan_settings` when calling `update_avscan_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'avscan_settings' in params:
            body_params = params['avscan_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/11/avscan/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
